<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Identifiant StructType
 * @subpackage Structs
 */
class Identifiant extends AbstractStructBase
{
    /**
     * The handle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $handle;
    /**
     * The identifiant
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $identifiant;
    /**
     * Constructor method for Identifiant
     * @uses Identifiant::setHandle()
     * @uses Identifiant::setIdentifiant()
     * @param string $handle
     * @param string $identifiant
     */
    public function __construct($handle = null, $identifiant = null)
    {
        $this
            ->setHandle($handle)
            ->setIdentifiant($identifiant);
    }
    /**
     * Get handle value
     * @return string|null
     */
    public function getHandle()
    {
        return $this->handle;
    }
    /**
     * Set handle value
     * @param string $handle
     * @return \StructType\Identifiant
     */
    public function setHandle($handle = null)
    {
        // validation for constraint: string
        if (!is_null($handle) && !is_string($handle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($handle, true), gettype($handle)), __LINE__);
        }
        $this->handle = $handle;
        return $this;
    }
    /**
     * Get identifiant value
     * @return string|null
     */
    public function getIdentifiant()
    {
        return $this->identifiant;
    }
    /**
     * Set identifiant value
     * @param string $identifiant
     * @return \StructType\Identifiant
     */
    public function setIdentifiant($identifiant = null)
    {
        // validation for constraint: string
        if (!is_null($identifiant) && !is_string($identifiant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifiant, true), gettype($identifiant)), __LINE__);
        }
        $this->identifiant = $identifiant;
        return $this;
    }
}
