<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The errorId
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $errorId;
    /**
     * The errorMsg
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $errorMsg;
    /**
     * Constructor method for Error
     * @uses Error::setErrorId()
     * @uses Error::setErrorMsg()
     * @param string $errorId
     * @param string $errorMsg
     */
    public function __construct($errorId = null, $errorMsg = null)
    {
        $this
            ->setErrorId($errorId)
            ->setErrorMsg($errorMsg);
    }
    /**
     * Get errorId value
     * @return string|null
     */
    public function getErrorId()
    {
        return $this->errorId;
    }
    /**
     * Set errorId value
     * @param string $errorId
     * @return \StructType\Error
     */
    public function setErrorId($errorId = null)
    {
        // validation for constraint: string
        if (!is_null($errorId) && !is_string($errorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorId, true), gettype($errorId)), __LINE__);
        }
        $this->errorId = $errorId;
        return $this;
    }
    /**
     * Get errorMsg value
     * @return string|null
     */
    public function getErrorMsg()
    {
        return $this->errorMsg;
    }
    /**
     * Set errorMsg value
     * @param string $errorMsg
     * @return \StructType\Error
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        $this->errorMsg = $errorMsg;
        return $this;
    }
}
