<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomaineDns StructType
 * @subpackage Structs
 */
class DomaineDns extends AbstractStructBase
{
    /**
     * The dns
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Dns
     */
    public $dns;
    /**
     * The num
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $num;
    /**
     * Constructor method for DomaineDns
     * @uses DomaineDns::setDns()
     * @uses DomaineDns::setNum()
     * @param \StructType\Dns $dns
     * @param int $num
     */
    public function __construct(\StructType\Dns $dns = null, $num = null)
    {
        $this
            ->setDns($dns)
            ->setNum($num);
    }
    /**
     * Get dns value
     * @return \StructType\Dns|null
     */
    public function getDns()
    {
        return $this->dns;
    }
    /**
     * Set dns value
     * @param \StructType\Dns $dns
     * @return \StructType\DomaineDns
     */
    public function setDns(\StructType\Dns $dns = null)
    {
        $this->dns = $dns;
        return $this;
    }
    /**
     * Get num value
     * @return int|null
     */
    public function getNum()
    {
        return $this->num;
    }
    /**
     * Set num value
     * @param int $num
     * @return \StructType\DomaineDns
     */
    public function setNum($num = null)
    {
        // validation for constraint: int
        if (!is_null($num) && !(is_int($num) || ctype_digit($num))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($num, true), gettype($num)), __LINE__);
        }
        $this->num = $num;
        return $this;
    }
}
