<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomaineContact StructType
 * @subpackage Structs
 */
class DomaineContact extends AbstractStructBase
{
    /**
     * The contact
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Contact
     */
    public $contact;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $type;
    /**
     * The num
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $num;
    /**
     * The visible
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $visible;
    /**
     * Constructor method for DomaineContact
     * @uses DomaineContact::setContact()
     * @uses DomaineContact::setType()
     * @uses DomaineContact::setNum()
     * @uses DomaineContact::setVisible()
     * @param \StructType\Contact $contact
     * @param string $type
     * @param int $num
     * @param bool $visible
     */
    public function __construct(\StructType\Contact $contact = null, $type = null, $num = null, $visible = null)
    {
        $this
            ->setContact($contact)
            ->setType($type)
            ->setNum($num)
            ->setVisible($visible);
    }
    /**
     * Get contact value
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return $this->contact;
    }
    /**
     * Set contact value
     * @param \StructType\Contact $contact
     * @return \StructType\DomaineContact
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        $this->contact = $contact;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\TypeContact::valueIsValid()
     * @uses \EnumType\TypeContact::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DomaineContact
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TypeContact::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TypeContact', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\TypeContact::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get num value
     * @return int|null
     */
    public function getNum()
    {
        return $this->num;
    }
    /**
     * Set num value
     * @param int $num
     * @return \StructType\DomaineContact
     */
    public function setNum($num = null)
    {
        // validation for constraint: int
        if (!is_null($num) && !(is_int($num) || ctype_digit($num))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($num, true), gettype($num)), __LINE__);
        }
        $this->num = $num;
        return $this;
    }
    /**
     * Get visible value
     * @return bool|null
     */
    public function getVisible()
    {
        return $this->visible;
    }
    /**
     * Set visible value
     * @param bool $visible
     * @return \StructType\DomaineContact
     */
    public function setVisible($visible = null)
    {
        // validation for constraint: boolean
        if (!is_null($visible) && !is_bool($visible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visible, true), gettype($visible)), __LINE__);
        }
        $this->visible = $visible;
        return $this;
    }
}
