<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DomaineCheck StructType
 * @subpackage Structs
 */
class DomaineCheck extends AbstractStructBase
{
    /**
     * The domaine
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $domaine;
    /**
     * The avaliable
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $avaliable;
    /**
     * The raison
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $raison;
    /**
     * Constructor method for DomaineCheck
     * @uses DomaineCheck::setDomaine()
     * @uses DomaineCheck::setAvaliable()
     * @uses DomaineCheck::setRaison()
     * @param string $domaine
     * @param bool $avaliable
     * @param string $raison
     */
    public function __construct($domaine = null, $avaliable = null, $raison = null)
    {
        $this
            ->setDomaine($domaine)
            ->setAvaliable($avaliable)
            ->setRaison($raison);
    }
    /**
     * Get domaine value
     * @return string|null
     */
    public function getDomaine()
    {
        return $this->domaine;
    }
    /**
     * Set domaine value
     * @param string $domaine
     * @return \StructType\DomaineCheck
     */
    public function setDomaine($domaine = null)
    {
        // validation for constraint: string
        if (!is_null($domaine) && !is_string($domaine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domaine, true), gettype($domaine)), __LINE__);
        }
        $this->domaine = $domaine;
        return $this;
    }
    /**
     * Get avaliable value
     * @return bool|null
     */
    public function getAvaliable()
    {
        return $this->avaliable;
    }
    /**
     * Set avaliable value
     * @param bool $avaliable
     * @return \StructType\DomaineCheck
     */
    public function setAvaliable($avaliable = null)
    {
        // validation for constraint: boolean
        if (!is_null($avaliable) && !is_bool($avaliable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($avaliable, true), gettype($avaliable)), __LINE__);
        }
        $this->avaliable = $avaliable;
        return $this;
    }
    /**
     * Get raison value
     * @return string|null
     */
    public function getRaison()
    {
        return $this->raison;
    }
    /**
     * Set raison value
     * @param string $raison
     * @return \StructType\DomaineCheck
     */
    public function setRaison($raison = null)
    {
        // validation for constraint: string
        if (!is_null($raison) && !is_string($raison)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($raison, true), gettype($raison)), __LINE__);
        }
        $this->raison = $raison;
        return $this;
    }
}
