<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Domaine StructType
 * @subpackage Structs
 */
class Domaine extends AbstractStructBase
{
    /**
     * The domaine
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $domaine;
    /**
     * The etat
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $etat;
    /**
     * The pwd
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $pwd;
    /**
     * The createDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $createDate;
    /**
     * The updatedDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $updatedDate;
    /**
     * The dueDate
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dueDate;
    /**
     * The hold
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $hold;
    /**
     * The lock
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $lock;
    /**
     * The norenew
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $norenew;
    /**
     * The litige
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var bool
     */
    public $litige;
    /**
     * The domaineContact
     * Meta information extracted from the WSDL
     * - arrayType: tns1:DomaineContact[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var \StructType\DomaineContact[]
     */
    public $domaineContact;
    /**
     * The domaineDns
     * Meta information extracted from the WSDL
     * - arrayType: tns1:DomaineDns[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var \StructType\DomaineDns[]
     */
    public $domaineDns;
    /**
     * The host
     * Meta information extracted from the WSDL
     * - arrayType: tns1:Dns[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var \StructType\Dns[]
     */
    public $host;
    /**
     * The aholder
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $aholder;
    /**
     * The alocker
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $alocker;
    /**
     * The asupprimer
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $asupprimer;
    /**
     * The checkdata
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $checkdata;
    /**
     * The renewauto
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $renewauto;
    /**
     * The metadata
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $metadata;
    /**
     * Constructor method for Domaine
     * @uses Domaine::setDomaine()
     * @uses Domaine::setEtat()
     * @uses Domaine::setPwd()
     * @uses Domaine::setCreateDate()
     * @uses Domaine::setUpdatedDate()
     * @uses Domaine::setDueDate()
     * @uses Domaine::setHold()
     * @uses Domaine::setLock()
     * @uses Domaine::setNorenew()
     * @uses Domaine::setLitige()
     * @uses Domaine::setDomaineContact()
     * @uses Domaine::setDomaineDns()
     * @uses Domaine::setHost()
     * @uses Domaine::setAholder()
     * @uses Domaine::setAlocker()
     * @uses Domaine::setAsupprimer()
     * @uses Domaine::setCheckdata()
     * @uses Domaine::setRenewauto()
     * @uses Domaine::setMetadata()
     * @param string $domaine
     * @param string $etat
     * @param string $pwd
     * @param string $createDate
     * @param string $updatedDate
     * @param string $dueDate
     * @param bool $hold
     * @param bool $lock
     * @param bool $norenew
     * @param bool $litige
     * @param \StructType\DomaineContact[] $domaineContact
     * @param \StructType\DomaineDns[] $domaineDns
     * @param \StructType\Dns[] $host
     * @param string $aholder
     * @param string $alocker
     * @param string $asupprimer
     * @param string $checkdata
     * @param string $renewauto
     * @param string $metadata
     */
    public function __construct($domaine = null, $etat = null, $pwd = null, $createDate = null, $updatedDate = null, $dueDate = null, $hold = null, $lock = null, $norenew = null, $litige = null, array $domaineContact = array(), array $domaineDns = array(), array $host = array(), $aholder = null, $alocker = null, $asupprimer = null, $checkdata = null, $renewauto = null, $metadata = null)
    {
        $this
            ->setDomaine($domaine)
            ->setEtat($etat)
            ->setPwd($pwd)
            ->setCreateDate($createDate)
            ->setUpdatedDate($updatedDate)
            ->setDueDate($dueDate)
            ->setHold($hold)
            ->setLock($lock)
            ->setNorenew($norenew)
            ->setLitige($litige)
            ->setDomaineContact($domaineContact)
            ->setDomaineDns($domaineDns)
            ->setHost($host)
            ->setAholder($aholder)
            ->setAlocker($alocker)
            ->setAsupprimer($asupprimer)
            ->setCheckdata($checkdata)
            ->setRenewauto($renewauto)
            ->setMetadata($metadata);
    }
    /**
     * Get domaine value
     * @return string|null
     */
    public function getDomaine()
    {
        return $this->domaine;
    }
    /**
     * Set domaine value
     * @param string $domaine
     * @return \StructType\Domaine
     */
    public function setDomaine($domaine = null)
    {
        // validation for constraint: string
        if (!is_null($domaine) && !is_string($domaine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($domaine, true), gettype($domaine)), __LINE__);
        }
        $this->domaine = $domaine;
        return $this;
    }
    /**
     * Get etat value
     * @return string|null
     */
    public function getEtat()
    {
        return $this->etat;
    }
    /**
     * Set etat value
     * @uses \EnumType\EtatDomaine::valueIsValid()
     * @uses \EnumType\EtatDomaine::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $etat
     * @return \StructType\Domaine
     */
    public function setEtat($etat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EtatDomaine::valueIsValid($etat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EtatDomaine', is_array($etat) ? implode(', ', $etat) : var_export($etat, true), implode(', ', \EnumType\EtatDomaine::getValidValues())), __LINE__);
        }
        $this->etat = $etat;
        return $this;
    }
    /**
     * Get pwd value
     * @return string|null
     */
    public function getPwd()
    {
        return $this->pwd;
    }
    /**
     * Set pwd value
     * @param string $pwd
     * @return \StructType\Domaine
     */
    public function setPwd($pwd = null)
    {
        // validation for constraint: string
        if (!is_null($pwd) && !is_string($pwd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pwd, true), gettype($pwd)), __LINE__);
        }
        $this->pwd = $pwd;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\Domaine
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get updatedDate value
     * @return string|null
     */
    public function getUpdatedDate()
    {
        return $this->updatedDate;
    }
    /**
     * Set updatedDate value
     * @param string $updatedDate
     * @return \StructType\Domaine
     */
    public function setUpdatedDate($updatedDate = null)
    {
        // validation for constraint: string
        if (!is_null($updatedDate) && !is_string($updatedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updatedDate, true), gettype($updatedDate)), __LINE__);
        }
        $this->updatedDate = $updatedDate;
        return $this;
    }
    /**
     * Get dueDate value
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->dueDate;
    }
    /**
     * Set dueDate value
     * @param string $dueDate
     * @return \StructType\Domaine
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        $this->dueDate = $dueDate;
        return $this;
    }
    /**
     * Get hold value
     * @return bool|null
     */
    public function getHold()
    {
        return $this->hold;
    }
    /**
     * Set hold value
     * @param bool $hold
     * @return \StructType\Domaine
     */
    public function setHold($hold = null)
    {
        // validation for constraint: boolean
        if (!is_null($hold) && !is_bool($hold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hold, true), gettype($hold)), __LINE__);
        }
        $this->hold = $hold;
        return $this;
    }
    /**
     * Get lock value
     * @return bool|null
     */
    public function getLock()
    {
        return $this->lock;
    }
    /**
     * Set lock value
     * @param bool $lock
     * @return \StructType\Domaine
     */
    public function setLock($lock = null)
    {
        // validation for constraint: boolean
        if (!is_null($lock) && !is_bool($lock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($lock, true), gettype($lock)), __LINE__);
        }
        $this->lock = $lock;
        return $this;
    }
    /**
     * Get norenew value
     * @return bool|null
     */
    public function getNorenew()
    {
        return $this->norenew;
    }
    /**
     * Set norenew value
     * @param bool $norenew
     * @return \StructType\Domaine
     */
    public function setNorenew($norenew = null)
    {
        // validation for constraint: boolean
        if (!is_null($norenew) && !is_bool($norenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($norenew, true), gettype($norenew)), __LINE__);
        }
        $this->norenew = $norenew;
        return $this;
    }
    /**
     * Get litige value
     * @return bool|null
     */
    public function getLitige()
    {
        return $this->litige;
    }
    /**
     * Set litige value
     * @param bool $litige
     * @return \StructType\Domaine
     */
    public function setLitige($litige = null)
    {
        // validation for constraint: boolean
        if (!is_null($litige) && !is_bool($litige)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($litige, true), gettype($litige)), __LINE__);
        }
        $this->litige = $litige;
        return $this;
    }
    /**
     * Get domaineContact value
     * @return \StructType\DomaineContact[]|null
     */
    public function getDomaineContact()
    {
        return $this->domaineContact;
    }
    /**
     * This method is responsible for validating the values passed to the setDomaineContact method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDomaineContact method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDomaineContactForArrayConstraintsFromSetDomaineContact(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $domaineDomaineContactItem) {
            // validation for constraint: itemType
            if (!$domaineDomaineContactItem instanceof \StructType\DomaineContact) {
                $invalidValues[] = is_object($domaineDomaineContactItem) ? get_class($domaineDomaineContactItem) : sprintf('%s(%s)', gettype($domaineDomaineContactItem), var_export($domaineDomaineContactItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The domaineContact property can only contain items of type \StructType\DomaineContact, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set domaineContact value
     * @throws \InvalidArgumentException
     * @param \StructType\DomaineContact[] $domaineContact
     * @return \StructType\Domaine
     */
    public function setDomaineContact(array $domaineContact = array())
    {
        // validation for constraint: array
        if ('' !== ($domaineContactArrayErrorMessage = self::validateDomaineContactForArrayConstraintsFromSetDomaineContact($domaineContact))) {
            throw new \InvalidArgumentException($domaineContactArrayErrorMessage, __LINE__);
        }
        $this->domaineContact = $domaineContact;
        return $this;
    }
    /**
     * Add item to domaineContact value
     * @throws \InvalidArgumentException
     * @param \StructType\DomaineContact $item
     * @return \StructType\Domaine
     */
    public function addToDomaineContact(\StructType\DomaineContact $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DomaineContact) {
            throw new \InvalidArgumentException(sprintf('The domaineContact property can only contain items of type \StructType\DomaineContact, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->domaineContact[] = $item;
        return $this;
    }
    /**
     * Get domaineDns value
     * @return \StructType\DomaineDns[]|null
     */
    public function getDomaineDns()
    {
        return $this->domaineDns;
    }
    /**
     * This method is responsible for validating the values passed to the setDomaineDns method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDomaineDns method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDomaineDnsForArrayConstraintsFromSetDomaineDns(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $domaineDomaineDnsItem) {
            // validation for constraint: itemType
            if (!$domaineDomaineDnsItem instanceof \StructType\DomaineDns) {
                $invalidValues[] = is_object($domaineDomaineDnsItem) ? get_class($domaineDomaineDnsItem) : sprintf('%s(%s)', gettype($domaineDomaineDnsItem), var_export($domaineDomaineDnsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The domaineDns property can only contain items of type \StructType\DomaineDns, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set domaineDns value
     * @throws \InvalidArgumentException
     * @param \StructType\DomaineDns[] $domaineDns
     * @return \StructType\Domaine
     */
    public function setDomaineDns(array $domaineDns = array())
    {
        // validation for constraint: array
        if ('' !== ($domaineDnsArrayErrorMessage = self::validateDomaineDnsForArrayConstraintsFromSetDomaineDns($domaineDns))) {
            throw new \InvalidArgumentException($domaineDnsArrayErrorMessage, __LINE__);
        }
        $this->domaineDns = $domaineDns;
        return $this;
    }
    /**
     * Add item to domaineDns value
     * @throws \InvalidArgumentException
     * @param \StructType\DomaineDns $item
     * @return \StructType\Domaine
     */
    public function addToDomaineDns(\StructType\DomaineDns $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DomaineDns) {
            throw new \InvalidArgumentException(sprintf('The domaineDns property can only contain items of type \StructType\DomaineDns, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->domaineDns[] = $item;
        return $this;
    }
    /**
     * Get host value
     * @return \StructType\Dns[]|null
     */
    public function getHost()
    {
        return $this->host;
    }
    /**
     * This method is responsible for validating the values passed to the setHost method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHost method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHostForArrayConstraintsFromSetHost(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $domaineHostItem) {
            // validation for constraint: itemType
            if (!$domaineHostItem instanceof \StructType\Dns) {
                $invalidValues[] = is_object($domaineHostItem) ? get_class($domaineHostItem) : sprintf('%s(%s)', gettype($domaineHostItem), var_export($domaineHostItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The host property can only contain items of type \StructType\Dns, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set host value
     * @throws \InvalidArgumentException
     * @param \StructType\Dns[] $host
     * @return \StructType\Domaine
     */
    public function setHost(array $host = array())
    {
        // validation for constraint: array
        if ('' !== ($hostArrayErrorMessage = self::validateHostForArrayConstraintsFromSetHost($host))) {
            throw new \InvalidArgumentException($hostArrayErrorMessage, __LINE__);
        }
        $this->host = $host;
        return $this;
    }
    /**
     * Add item to host value
     * @throws \InvalidArgumentException
     * @param \StructType\Dns $item
     * @return \StructType\Domaine
     */
    public function addToHost(\StructType\Dns $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dns) {
            throw new \InvalidArgumentException(sprintf('The host property can only contain items of type \StructType\Dns, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->host[] = $item;
        return $this;
    }
    /**
     * Get aholder value
     * @return string|null
     */
    public function getAholder()
    {
        return $this->aholder;
    }
    /**
     * Set aholder value
     * @param string $aholder
     * @return \StructType\Domaine
     */
    public function setAholder($aholder = null)
    {
        // validation for constraint: string
        if (!is_null($aholder) && !is_string($aholder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aholder, true), gettype($aholder)), __LINE__);
        }
        $this->aholder = $aholder;
        return $this;
    }
    /**
     * Get alocker value
     * @return string|null
     */
    public function getAlocker()
    {
        return $this->alocker;
    }
    /**
     * Set alocker value
     * @param string $alocker
     * @return \StructType\Domaine
     */
    public function setAlocker($alocker = null)
    {
        // validation for constraint: string
        if (!is_null($alocker) && !is_string($alocker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($alocker, true), gettype($alocker)), __LINE__);
        }
        $this->alocker = $alocker;
        return $this;
    }
    /**
     * Get asupprimer value
     * @return string|null
     */
    public function getAsupprimer()
    {
        return $this->asupprimer;
    }
    /**
     * Set asupprimer value
     * @param string $asupprimer
     * @return \StructType\Domaine
     */
    public function setAsupprimer($asupprimer = null)
    {
        // validation for constraint: string
        if (!is_null($asupprimer) && !is_string($asupprimer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asupprimer, true), gettype($asupprimer)), __LINE__);
        }
        $this->asupprimer = $asupprimer;
        return $this;
    }
    /**
     * Get checkdata value
     * @return string|null
     */
    public function getCheckdata()
    {
        return $this->checkdata;
    }
    /**
     * Set checkdata value
     * @param string $checkdata
     * @return \StructType\Domaine
     */
    public function setCheckdata($checkdata = null)
    {
        // validation for constraint: string
        if (!is_null($checkdata) && !is_string($checkdata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkdata, true), gettype($checkdata)), __LINE__);
        }
        $this->checkdata = $checkdata;
        return $this;
    }
    /**
     * Get renewauto value
     * @return string|null
     */
    public function getRenewauto()
    {
        return $this->renewauto;
    }
    /**
     * Set renewauto value
     * @param string $renewauto
     * @return \StructType\Domaine
     */
    public function setRenewauto($renewauto = null)
    {
        // validation for constraint: string
        if (!is_null($renewauto) && !is_string($renewauto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewauto, true), gettype($renewauto)), __LINE__);
        }
        $this->renewauto = $renewauto;
        return $this;
    }
    /**
     * Get metadata value
     * @return string|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }
    /**
     * Set metadata value
     * @param string $metadata
     * @return \StructType\Domaine
     */
    public function setMetadata($metadata = null)
    {
        // validation for constraint: string
        if (!is_null($metadata) && !is_string($metadata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metadata, true), gettype($metadata)), __LINE__);
        }
        $this->metadata = $metadata;
        return $this;
    }
}
