<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DnsIp StructType
 * @subpackage Structs
 */
class DnsIp extends AbstractStructBase
{
    /**
     * The ip
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ip;
    /**
     * The type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $type;
    /**
     * Constructor method for DnsIp
     * @uses DnsIp::setIp()
     * @uses DnsIp::setType()
     * @param string $ip
     * @param string $type
     */
    public function __construct($ip = null, $type = null)
    {
        $this
            ->setIp($ip)
            ->setType($type);
    }
    /**
     * Get ip value
     * @return string|null
     */
    public function getIp()
    {
        return $this->ip;
    }
    /**
     * Set ip value
     * @param string $ip
     * @return \StructType\DnsIp
     */
    public function setIp($ip = null)
    {
        // validation for constraint: string
        if (!is_null($ip) && !is_string($ip)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ip, true), gettype($ip)), __LINE__);
        }
        $this->ip = $ip;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\DnsIpType::valueIsValid()
     * @uses \EnumType\DnsIpType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\DnsIp
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DnsIpType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DnsIpType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\DnsIpType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
}
