<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dns StructType
 * @subpackage Structs
 */
class Dns extends AbstractStructBase
{
    /**
     * The name
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $name;
    /**
     * The techandle
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $techandle;
    /**
     * The dnsIP
     * Meta information extracted from the WSDL
     * - arrayType: tns1:DnsIp[]
     * - base: soapenc:Array
     * - nillable: true
     * - ref: soapenc:arrayType
     * @var \StructType\DnsIp[]
     */
    public $dnsIP;
    /**
     * The metadata
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $metadata;
    /**
     * Constructor method for Dns
     * @uses Dns::setName()
     * @uses Dns::setTechandle()
     * @uses Dns::setDnsIP()
     * @uses Dns::setMetadata()
     * @param string $name
     * @param string $techandle
     * @param \StructType\DnsIp[] $dnsIP
     * @param string $metadata
     */
    public function __construct($name = null, $techandle = null, array $dnsIP = array(), $metadata = null)
    {
        $this
            ->setName($name)
            ->setTechandle($techandle)
            ->setDnsIP($dnsIP)
            ->setMetadata($metadata);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Dns
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get techandle value
     * @return string|null
     */
    public function getTechandle()
    {
        return $this->techandle;
    }
    /**
     * Set techandle value
     * @param string $techandle
     * @return \StructType\Dns
     */
    public function setTechandle($techandle = null)
    {
        // validation for constraint: string
        if (!is_null($techandle) && !is_string($techandle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($techandle, true), gettype($techandle)), __LINE__);
        }
        $this->techandle = $techandle;
        return $this;
    }
    /**
     * Get dnsIP value
     * @return \StructType\DnsIp[]|null
     */
    public function getDnsIP()
    {
        return $this->dnsIP;
    }
    /**
     * This method is responsible for validating the values passed to the setDnsIP method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDnsIP method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDnsIPForArrayConstraintsFromSetDnsIP(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $dnsDnsIPItem) {
            // validation for constraint: itemType
            if (!$dnsDnsIPItem instanceof \StructType\DnsIp) {
                $invalidValues[] = is_object($dnsDnsIPItem) ? get_class($dnsDnsIPItem) : sprintf('%s(%s)', gettype($dnsDnsIPItem), var_export($dnsDnsIPItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The dnsIP property can only contain items of type \StructType\DnsIp, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set dnsIP value
     * @throws \InvalidArgumentException
     * @param \StructType\DnsIp[] $dnsIP
     * @return \StructType\Dns
     */
    public function setDnsIP(array $dnsIP = array())
    {
        // validation for constraint: array
        if ('' !== ($dnsIPArrayErrorMessage = self::validateDnsIPForArrayConstraintsFromSetDnsIP($dnsIP))) {
            throw new \InvalidArgumentException($dnsIPArrayErrorMessage, __LINE__);
        }
        $this->dnsIP = $dnsIP;
        return $this;
    }
    /**
     * Add item to dnsIP value
     * @throws \InvalidArgumentException
     * @param \StructType\DnsIp $item
     * @return \StructType\Dns
     */
    public function addToDnsIP(\StructType\DnsIp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DnsIp) {
            throw new \InvalidArgumentException(sprintf('The dnsIP property can only contain items of type \StructType\DnsIp, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->dnsIP[] = $item;
        return $this;
    }
    /**
     * Get metadata value
     * @return string|null
     */
    public function getMetadata()
    {
        return $this->metadata;
    }
    /**
     * Set metadata value
     * @param string $metadata
     * @return \StructType\Dns
     */
    public function setMetadata($metadata = null)
    {
        // validation for constraint: string
        if (!is_null($metadata) && !is_string($metadata)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metadata, true), gettype($metadata)), __LINE__);
        }
        $this->metadata = $metadata;
        return $this;
    }
}
