<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ticket ServiceType
 * @subpackage Services
 */
class Ticket extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ticketQuery
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @param string $borneInf
     * @param string $nbDomaine
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseVectorSimpleTicket|bool
     */
    public function ticketQuery(\StructType\Client $client, $domaine, $borneInf, $nbDomaine, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->ticketQuery($client, $domaine, $borneInf, $nbDomaine, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseVectorSimpleTicket
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
