<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Status ServiceType
 * @subpackage Services
 */
class Status extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named statusTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $ticket
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseTicket|bool
     */
    public function statusTicket(\StructType\Client $client, $ticket, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->statusTicket($client, $ticket, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseTicket
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
