<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Search ServiceType
 * @subpackage Services
 */
class Search extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named search
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param \StructType\Domaine $domaine
     * @param string $methode
     * @param string $borneInf
     * @param string $nbDomaine
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseVectorSimpleDomaine|bool
     */
    public function search(\StructType\Client $client, \StructType\Domaine $domaine, $methode, $borneInf, $nbDomaine, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->search($client, $domaine, $methode, $borneInf, $nbDomaine, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseVectorSimpleDomaine
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
