<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Repondre ServiceType
 * @subpackage Services
 */
class Repondre extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named repondreNotification
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $md5
     * @param string $rep
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseNotification|bool
     */
    public function repondreNotification(\StructType\Client $client, $md5, $rep, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->repondreNotification($client, $md5, $rep, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseNotification
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
