<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Read ServiceType
 * @subpackage Services
 */
class Read extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named readMessageFromTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $ticket
     * @param \StructType\Identifiant $identifiant
     * @param string $borneInf
     * @param string $nbMessage
     * @return \StructType\ResponseVectorMessage|bool
     */
    public function readMessageFromTicket(\StructType\Client $client, $ticket, \StructType\Identifiant $identifiant, $borneInf, $nbMessage)
    {
        try {
            $this->setResult($this->getSoapClient()->readMessageFromTicket($client, $ticket, $identifiant, $borneInf, $nbMessage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named readUnreadMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param \StructType\Identifiant $identifiant
     * @param string $borneInf
     * @param string $nbMessage
     * @return \StructType\ResponseVectorMessage|bool
     */
    public function readUnreadMessage(\StructType\Client $client, \StructType\Identifiant $identifiant, $borneInf, $nbMessage)
    {
        try {
            $this->setResult($this->getSoapClient()->readUnreadMessage($client, $identifiant, $borneInf, $nbMessage));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseVectorMessage
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
