<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lock ServiceType
 * @subpackage Services
 */
class Lock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named lockDomaine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function lockDomaine(\StructType\Client $client, $domaine, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->lockDomaine($client, $domaine, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseTicket
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
