<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Domaine ServiceType
 * @subpackage Services
 */
class Domaine extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named domaineCheck
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param \StructType\Vector $domaines
     * @return \StructType\ResponseVectorDomaineCheck|bool
     */
    public function domaineCheck(\StructType\Client $client, \StructType\Vector $domaines)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineCheck($client, $domaines));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseDomaine|bool
     */
    public function domaineInfo(\StructType\Client $client, $domaine, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineInfo($client, $domaine, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineCreate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param \StructType\Domaine $domaine
     * @param string $periode
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineCreate(\StructType\Client $client, \StructType\Domaine $domaine, $periode, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineCreate($client, $domaine, $periode, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @param string $periode
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineRenew(\StructType\Client $client, $domaine, $periode, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineRenew($client, $domaine, $periode, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineUpdate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param \StructType\Domaine $domaine
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineUpdate(\StructType\Client $client, \StructType\Domaine $domaine, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineUpdate($client, $domaine, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param \StructType\Domaine $domaine
     * @param string $password
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineTransfer(\StructType\Client $client, \StructType\Domaine $domaine, $password, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineTransfer($client, $domaine, $password, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineDelete
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineDelete(\StructType\Client $client, $domaine, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineDelete($client, $domaine, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineWhois
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @return \StructType\ResponseDomaine|bool
     */
    public function domaineWhois(\StructType\Client $client, $domaine)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineWhois($client, $domaine));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineWhoisTexte
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @return \StructType\ResponseString|bool
     */
    public function domaineWhoisTexte(\StructType\Client $client, $domaine)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineWhoisTexte($client, $domaine));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineSetNoRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineSetNoRenew(\StructType\Client $client, $domaine, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineSetNoRenew($client, $domaine, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineRemoveNoRenew
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $domaine
     * @param \StructType\Identifiant $identifiant
     * @param string $trackId
     * @param \StructType\AskBy $askBy
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineRemoveNoRenew(\StructType\Client $client, $domaine, \StructType\Identifiant $identifiant, $trackId, \StructType\AskBy $askBy)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineRemoveNoRenew($client, $domaine, $identifiant, $trackId, $askBy));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named domaineTransferUpdateAuthcod
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $ticket
     * @param string $domaine
     * @param string $password
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseTicket|bool
     */
    public function domaineTransferUpdateAuthcod(\StructType\Client $client, $ticket, $domaine, $password, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->domaineTransferUpdateAuthcod($client, $ticket, $domaine, $password, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseDomaine|\StructType\ResponseString|\StructType\ResponseTicket|\StructType\ResponseVectorDomaineCheck
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
