<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Convert ServiceType
 * @subpackage Services
 */
class Convert extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named convertTicketToDomaine
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $ticket
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseDomaine|bool
     */
    public function convertTicketToDomaine(\StructType\Client $client, $ticket, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->convertTicketToDomaine($client, $ticket, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named convertErrorToText
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $error
     * @param string $langue
     * @return \StructType\ResponseString|bool
     */
    public function convertErrorToText(\StructType\Client $client, $error, $langue)
    {
        try {
            $this->setResult($this->getSoapClient()->convertErrorToText($client, $error, $langue));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseDomaine|\StructType\ResponseString
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
