<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Annuler ServiceType
 * @subpackage Services
 */
class Annuler extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named annulerTicket
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param string $ticket
     * @param string $domaine
     * @param string $message
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseTicket|bool
     */
    public function annulerTicket(\StructType\Client $client, $ticket, $domaine, $message, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->annulerTicket($client, $ticket, $domaine, $message, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseTicket
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
