<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Acount ServiceType
 * @subpackage Services
 */
class Acount extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named acountBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseInteger|bool
     */
    public function acountBalance(\StructType\Client $client, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->acountBalance($client, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseInteger
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
