<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ack ServiceType
 * @subpackage Services
 */
class Ack extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ackMessage
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Client $client
     * @param int[] $idMessages
     * @param \StructType\Identifiant $identifiant
     * @return \StructType\ResponseBoolean|bool
     */
    public function ackMessage(\StructType\Client $client, array $idMessages, \StructType\Identifiant $identifiant)
    {
        try {
            $this->setResult($this->getSoapClient()->ackMessage($client, $idMessages, $identifiant));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResponseBoolean
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
