<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalOUTCotizacionHogarOrden StructType
 * @subpackage Structs
 */
class DocCanalOUTCotizacionHogarOrden extends AbstractStructBase
{
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The FamiliaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FamiliaID;
    /**
     * The SociedadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SociedadID;
    /**
     * The PlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PlanID;
    /**
     * The EsRenovacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EsRenovacion;
    /**
     * The PorcPGP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PorcPGP;
    /**
     * The PorcRecargoFinanciero
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PorcRecargoFinanciero;
    /**
     * The Comision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Comision;
    /**
     * The BonificacionComercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionComercial;
    /**
     * The BonificacionComision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BonificacionComision;
    /**
     * The BonificacionViacobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionViacobro;
    /**
     * The FechaVigenciaDesde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaDesde;
    /**
     * The FechaVigenciaHasta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaHasta;
    /**
     * The CantidadDias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CantidadDias;
    /**
     * The CantidadCuotas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CantidadCuotas;
    /**
     * The AniosSinSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AniosSinSiniestro;
    /**
     * The TieneAgrupamiento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $TieneAgrupamiento;
    /**
     * The CUIT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CUIT;
    /**
     * The AjusteSuma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AjusteSuma;
    /**
     * The BonficacionComercialMaxima
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BonficacionComercialMaxima;
    /**
     * The CompaniaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CompaniaID;
    /**
     * The IDRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRiesgo;
    /**
     * The IDTipoPoliza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPoliza;
    /**
     * The IDTipoPersona
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersona;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The IDViaCobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDViaCobro;
    /**
     * The IDPlanPago
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPlanPago;
    /**
     * The IDMoneda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDMoneda;
    /**
     * The IDProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProducto;
    /**
     * The IDSegmento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDSegmento;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The TipoPlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoPlanID;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItem
     */
    public $Items;
    /**
     * The Costos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto
     */
    public $Costos;
    /**
     * Constructor method for DocCanalOUTCotizacionHogarOrden
     * @uses DocCanalOUTCotizacionHogarOrden::setOrdenID()
     * @uses DocCanalOUTCotizacionHogarOrden::setFamiliaID()
     * @uses DocCanalOUTCotizacionHogarOrden::setSociedadID()
     * @uses DocCanalOUTCotizacionHogarOrden::setPlanID()
     * @uses DocCanalOUTCotizacionHogarOrden::setEsRenovacion()
     * @uses DocCanalOUTCotizacionHogarOrden::setPorcPGP()
     * @uses DocCanalOUTCotizacionHogarOrden::setPorcRecargoFinanciero()
     * @uses DocCanalOUTCotizacionHogarOrden::setComision()
     * @uses DocCanalOUTCotizacionHogarOrden::setBonificacionComercial()
     * @uses DocCanalOUTCotizacionHogarOrden::setBonificacionComision()
     * @uses DocCanalOUTCotizacionHogarOrden::setBonificacionViacobro()
     * @uses DocCanalOUTCotizacionHogarOrden::setFechaVigenciaDesde()
     * @uses DocCanalOUTCotizacionHogarOrden::setFechaVigenciaHasta()
     * @uses DocCanalOUTCotizacionHogarOrden::setCantidadDias()
     * @uses DocCanalOUTCotizacionHogarOrden::setCantidadCuotas()
     * @uses DocCanalOUTCotizacionHogarOrden::setAniosSinSiniestro()
     * @uses DocCanalOUTCotizacionHogarOrden::setTieneAgrupamiento()
     * @uses DocCanalOUTCotizacionHogarOrden::setCUIT()
     * @uses DocCanalOUTCotizacionHogarOrden::setAjusteSuma()
     * @uses DocCanalOUTCotizacionHogarOrden::setBonficacionComercialMaxima()
     * @uses DocCanalOUTCotizacionHogarOrden::setCompaniaID()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDRiesgo()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDTipoPoliza()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDTipoPersona()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDCondicionIVA()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDViaCobro()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDPlanPago()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDMoneda()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDProducto()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDSegmento()
     * @uses DocCanalOUTCotizacionHogarOrden::setIDProvincia()
     * @uses DocCanalOUTCotizacionHogarOrden::setTipoPlanID()
     * @uses DocCanalOUTCotizacionHogarOrden::setItems()
     * @uses DocCanalOUTCotizacionHogarOrden::setCostos()
     * @param int $ordenID
     * @param int $familiaID
     * @param int $sociedadID
     * @param int $planID
     * @param bool $esRenovacion
     * @param float $porcPGP
     * @param float $porcRecargoFinanciero
     * @param float $comision
     * @param float $bonificacionComercial
     * @param float $bonificacionComision
     * @param float $bonificacionViacobro
     * @param string $fechaVigenciaDesde
     * @param string $fechaVigenciaHasta
     * @param int $cantidadDias
     * @param int $cantidadCuotas
     * @param int $aniosSinSiniestro
     * @param bool $tieneAgrupamiento
     * @param float $cUIT
     * @param int $ajusteSuma
     * @param float $bonficacionComercialMaxima
     * @param int $companiaID
     * @param string $iDRiesgo
     * @param string $iDTipoPoliza
     * @param string $iDTipoPersona
     * @param string $iDCondicionIVA
     * @param string $iDViaCobro
     * @param string $iDPlanPago
     * @param string $iDMoneda
     * @param string $iDProducto
     * @param string $iDSegmento
     * @param string $iDProvincia
     * @param string $tipoPlanID
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItem $items
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos
     */
    public function __construct($ordenID = null, $familiaID = null, $sociedadID = null, $planID = null, $esRenovacion = null, $porcPGP = null, $porcRecargoFinanciero = null, $comision = null, $bonificacionComercial = null, $bonificacionComision = null, $bonificacionViacobro = null, $fechaVigenciaDesde = null, $fechaVigenciaHasta = null, $cantidadDias = null, $cantidadCuotas = null, $aniosSinSiniestro = null, $tieneAgrupamiento = null, $cUIT = null, $ajusteSuma = null, $bonficacionComercialMaxima = null, $companiaID = null, $iDRiesgo = null, $iDTipoPoliza = null, $iDTipoPersona = null, $iDCondicionIVA = null, $iDViaCobro = null, $iDPlanPago = null, $iDMoneda = null, $iDProducto = null, $iDSegmento = null, $iDProvincia = null, $tipoPlanID = null, \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItem $items = null, \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos = null)
    {
        $this
            ->setOrdenID($ordenID)
            ->setFamiliaID($familiaID)
            ->setSociedadID($sociedadID)
            ->setPlanID($planID)
            ->setEsRenovacion($esRenovacion)
            ->setPorcPGP($porcPGP)
            ->setPorcRecargoFinanciero($porcRecargoFinanciero)
            ->setComision($comision)
            ->setBonificacionComercial($bonificacionComercial)
            ->setBonificacionComision($bonificacionComision)
            ->setBonificacionViacobro($bonificacionViacobro)
            ->setFechaVigenciaDesde($fechaVigenciaDesde)
            ->setFechaVigenciaHasta($fechaVigenciaHasta)
            ->setCantidadDias($cantidadDias)
            ->setCantidadCuotas($cantidadCuotas)
            ->setAniosSinSiniestro($aniosSinSiniestro)
            ->setTieneAgrupamiento($tieneAgrupamiento)
            ->setCUIT($cUIT)
            ->setAjusteSuma($ajusteSuma)
            ->setBonficacionComercialMaxima($bonficacionComercialMaxima)
            ->setCompaniaID($companiaID)
            ->setIDRiesgo($iDRiesgo)
            ->setIDTipoPoliza($iDTipoPoliza)
            ->setIDTipoPersona($iDTipoPersona)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setIDViaCobro($iDViaCobro)
            ->setIDPlanPago($iDPlanPago)
            ->setIDMoneda($iDMoneda)
            ->setIDProducto($iDProducto)
            ->setIDSegmento($iDSegmento)
            ->setIDProvincia($iDProvincia)
            ->setTipoPlanID($tipoPlanID)
            ->setItems($items)
            ->setCostos($costos);
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get FamiliaID value
     * @return int
     */
    public function getFamiliaID()
    {
        return $this->FamiliaID;
    }
    /**
     * Set FamiliaID value
     * @param int $familiaID
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setFamiliaID($familiaID = null)
    {
        // validation for constraint: int
        if (!is_null($familiaID) && !(is_int($familiaID) || ctype_digit($familiaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($familiaID, true), gettype($familiaID)), __LINE__);
        }
        $this->FamiliaID = $familiaID;
        return $this;
    }
    /**
     * Get SociedadID value
     * @return int
     */
    public function getSociedadID()
    {
        return $this->SociedadID;
    }
    /**
     * Set SociedadID value
     * @param int $sociedadID
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setSociedadID($sociedadID = null)
    {
        // validation for constraint: int
        if (!is_null($sociedadID) && !(is_int($sociedadID) || ctype_digit($sociedadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sociedadID, true), gettype($sociedadID)), __LINE__);
        }
        $this->SociedadID = $sociedadID;
        return $this;
    }
    /**
     * Get PlanID value
     * @return int
     */
    public function getPlanID()
    {
        return $this->PlanID;
    }
    /**
     * Set PlanID value
     * @param int $planID
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setPlanID($planID = null)
    {
        // validation for constraint: int
        if (!is_null($planID) && !(is_int($planID) || ctype_digit($planID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($planID, true), gettype($planID)), __LINE__);
        }
        $this->PlanID = $planID;
        return $this;
    }
    /**
     * Get EsRenovacion value
     * @return bool
     */
    public function getEsRenovacion()
    {
        return $this->EsRenovacion;
    }
    /**
     * Set EsRenovacion value
     * @param bool $esRenovacion
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setEsRenovacion($esRenovacion = null)
    {
        // validation for constraint: boolean
        if (!is_null($esRenovacion) && !is_bool($esRenovacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esRenovacion, true), gettype($esRenovacion)), __LINE__);
        }
        $this->EsRenovacion = $esRenovacion;
        return $this;
    }
    /**
     * Get PorcPGP value
     * @return float
     */
    public function getPorcPGP()
    {
        return $this->PorcPGP;
    }
    /**
     * Set PorcPGP value
     * @param float $porcPGP
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setPorcPGP($porcPGP = null)
    {
        // validation for constraint: float
        if (!is_null($porcPGP) && !(is_float($porcPGP) || is_numeric($porcPGP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($porcPGP, true), gettype($porcPGP)), __LINE__);
        }
        $this->PorcPGP = $porcPGP;
        return $this;
    }
    /**
     * Get PorcRecargoFinanciero value
     * @return float
     */
    public function getPorcRecargoFinanciero()
    {
        return $this->PorcRecargoFinanciero;
    }
    /**
     * Set PorcRecargoFinanciero value
     * @param float $porcRecargoFinanciero
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setPorcRecargoFinanciero($porcRecargoFinanciero = null)
    {
        // validation for constraint: float
        if (!is_null($porcRecargoFinanciero) && !(is_float($porcRecargoFinanciero) || is_numeric($porcRecargoFinanciero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($porcRecargoFinanciero, true), gettype($porcRecargoFinanciero)), __LINE__);
        }
        $this->PorcRecargoFinanciero = $porcRecargoFinanciero;
        return $this;
    }
    /**
     * Get Comision value
     * @return float
     */
    public function getComision()
    {
        return $this->Comision;
    }
    /**
     * Set Comision value
     * @param float $comision
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setComision($comision = null)
    {
        // validation for constraint: float
        if (!is_null($comision) && !(is_float($comision) || is_numeric($comision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($comision, true), gettype($comision)), __LINE__);
        }
        $this->Comision = $comision;
        return $this;
    }
    /**
     * Get BonificacionComercial value
     * @return float
     */
    public function getBonificacionComercial()
    {
        return $this->BonificacionComercial;
    }
    /**
     * Set BonificacionComercial value
     * @param float $bonificacionComercial
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setBonificacionComercial($bonificacionComercial = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComercial) && !(is_float($bonificacionComercial) || is_numeric($bonificacionComercial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComercial, true), gettype($bonificacionComercial)), __LINE__);
        }
        $this->BonificacionComercial = $bonificacionComercial;
        return $this;
    }
    /**
     * Get BonificacionComision value
     * @return float
     */
    public function getBonificacionComision()
    {
        return $this->BonificacionComision;
    }
    /**
     * Set BonificacionComision value
     * @param float $bonificacionComision
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setBonificacionComision($bonificacionComision = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComision) && !(is_float($bonificacionComision) || is_numeric($bonificacionComision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComision, true), gettype($bonificacionComision)), __LINE__);
        }
        $this->BonificacionComision = $bonificacionComision;
        return $this;
    }
    /**
     * Get BonificacionViacobro value
     * @return float
     */
    public function getBonificacionViacobro()
    {
        return $this->BonificacionViacobro;
    }
    /**
     * Set BonificacionViacobro value
     * @param float $bonificacionViacobro
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setBonificacionViacobro($bonificacionViacobro = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionViacobro) && !(is_float($bonificacionViacobro) || is_numeric($bonificacionViacobro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionViacobro, true), gettype($bonificacionViacobro)), __LINE__);
        }
        $this->BonificacionViacobro = $bonificacionViacobro;
        return $this;
    }
    /**
     * Get FechaVigenciaDesde value
     * @return string
     */
    public function getFechaVigenciaDesde()
    {
        return $this->FechaVigenciaDesde;
    }
    /**
     * Set FechaVigenciaDesde value
     * @param string $fechaVigenciaDesde
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setFechaVigenciaDesde($fechaVigenciaDesde = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaDesde) && !is_string($fechaVigenciaDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaDesde, true), gettype($fechaVigenciaDesde)), __LINE__);
        }
        $this->FechaVigenciaDesde = $fechaVigenciaDesde;
        return $this;
    }
    /**
     * Get FechaVigenciaHasta value
     * @return string
     */
    public function getFechaVigenciaHasta()
    {
        return $this->FechaVigenciaHasta;
    }
    /**
     * Set FechaVigenciaHasta value
     * @param string $fechaVigenciaHasta
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setFechaVigenciaHasta($fechaVigenciaHasta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaHasta) && !is_string($fechaVigenciaHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaHasta, true), gettype($fechaVigenciaHasta)), __LINE__);
        }
        $this->FechaVigenciaHasta = $fechaVigenciaHasta;
        return $this;
    }
    /**
     * Get CantidadDias value
     * @return int
     */
    public function getCantidadDias()
    {
        return $this->CantidadDias;
    }
    /**
     * Set CantidadDias value
     * @param int $cantidadDias
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setCantidadDias($cantidadDias = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadDias) && !(is_int($cantidadDias) || ctype_digit($cantidadDias))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadDias, true), gettype($cantidadDias)), __LINE__);
        }
        $this->CantidadDias = $cantidadDias;
        return $this;
    }
    /**
     * Get CantidadCuotas value
     * @return int
     */
    public function getCantidadCuotas()
    {
        return $this->CantidadCuotas;
    }
    /**
     * Set CantidadCuotas value
     * @param int $cantidadCuotas
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setCantidadCuotas($cantidadCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadCuotas) && !(is_int($cantidadCuotas) || ctype_digit($cantidadCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadCuotas, true), gettype($cantidadCuotas)), __LINE__);
        }
        $this->CantidadCuotas = $cantidadCuotas;
        return $this;
    }
    /**
     * Get AniosSinSiniestro value
     * @return int
     */
    public function getAniosSinSiniestro()
    {
        return $this->AniosSinSiniestro;
    }
    /**
     * Set AniosSinSiniestro value
     * @param int $aniosSinSiniestro
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setAniosSinSiniestro($aniosSinSiniestro = null)
    {
        // validation for constraint: int
        if (!is_null($aniosSinSiniestro) && !(is_int($aniosSinSiniestro) || ctype_digit($aniosSinSiniestro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aniosSinSiniestro, true), gettype($aniosSinSiniestro)), __LINE__);
        }
        $this->AniosSinSiniestro = $aniosSinSiniestro;
        return $this;
    }
    /**
     * Get TieneAgrupamiento value
     * @return bool
     */
    public function getTieneAgrupamiento()
    {
        return $this->TieneAgrupamiento;
    }
    /**
     * Set TieneAgrupamiento value
     * @param bool $tieneAgrupamiento
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setTieneAgrupamiento($tieneAgrupamiento = null)
    {
        // validation for constraint: boolean
        if (!is_null($tieneAgrupamiento) && !is_bool($tieneAgrupamiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tieneAgrupamiento, true), gettype($tieneAgrupamiento)), __LINE__);
        }
        $this->TieneAgrupamiento = $tieneAgrupamiento;
        return $this;
    }
    /**
     * Get CUIT value
     * @return float
     */
    public function getCUIT()
    {
        return $this->CUIT;
    }
    /**
     * Set CUIT value
     * @param float $cUIT
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setCUIT($cUIT = null)
    {
        // validation for constraint: float
        if (!is_null($cUIT) && !(is_float($cUIT) || is_numeric($cUIT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cUIT, true), gettype($cUIT)), __LINE__);
        }
        $this->CUIT = $cUIT;
        return $this;
    }
    /**
     * Get AjusteSuma value
     * @return int
     */
    public function getAjusteSuma()
    {
        return $this->AjusteSuma;
    }
    /**
     * Set AjusteSuma value
     * @param int $ajusteSuma
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setAjusteSuma($ajusteSuma = null)
    {
        // validation for constraint: int
        if (!is_null($ajusteSuma) && !(is_int($ajusteSuma) || ctype_digit($ajusteSuma))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ajusteSuma, true), gettype($ajusteSuma)), __LINE__);
        }
        $this->AjusteSuma = $ajusteSuma;
        return $this;
    }
    /**
     * Get BonficacionComercialMaxima value
     * @return float
     */
    public function getBonficacionComercialMaxima()
    {
        return $this->BonficacionComercialMaxima;
    }
    /**
     * Set BonficacionComercialMaxima value
     * @param float $bonficacionComercialMaxima
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setBonficacionComercialMaxima($bonficacionComercialMaxima = null)
    {
        // validation for constraint: float
        if (!is_null($bonficacionComercialMaxima) && !(is_float($bonficacionComercialMaxima) || is_numeric($bonficacionComercialMaxima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonficacionComercialMaxima, true), gettype($bonficacionComercialMaxima)), __LINE__);
        }
        $this->BonficacionComercialMaxima = $bonficacionComercialMaxima;
        return $this;
    }
    /**
     * Get CompaniaID value
     * @return int
     */
    public function getCompaniaID()
    {
        return $this->CompaniaID;
    }
    /**
     * Set CompaniaID value
     * @param int $companiaID
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setCompaniaID($companiaID = null)
    {
        // validation for constraint: int
        if (!is_null($companiaID) && !(is_int($companiaID) || ctype_digit($companiaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companiaID, true), gettype($companiaID)), __LINE__);
        }
        $this->CompaniaID = $companiaID;
        return $this;
    }
    /**
     * Get IDRiesgo value
     * @return string|null
     */
    public function getIDRiesgo()
    {
        return $this->IDRiesgo;
    }
    /**
     * Set IDRiesgo value
     * @param string $iDRiesgo
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDRiesgo($iDRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDRiesgo) && !is_string($iDRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRiesgo, true), gettype($iDRiesgo)), __LINE__);
        }
        $this->IDRiesgo = $iDRiesgo;
        return $this;
    }
    /**
     * Get IDTipoPoliza value
     * @return string|null
     */
    public function getIDTipoPoliza()
    {
        return $this->IDTipoPoliza;
    }
    /**
     * Set IDTipoPoliza value
     * @param string $iDTipoPoliza
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDTipoPoliza($iDTipoPoliza = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPoliza) && !is_string($iDTipoPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPoliza, true), gettype($iDTipoPoliza)), __LINE__);
        }
        $this->IDTipoPoliza = $iDTipoPoliza;
        return $this;
    }
    /**
     * Get IDTipoPersona value
     * @return string|null
     */
    public function getIDTipoPersona()
    {
        return $this->IDTipoPersona;
    }
    /**
     * Set IDTipoPersona value
     * @param string $iDTipoPersona
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDTipoPersona($iDTipoPersona = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersona) && !is_string($iDTipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersona, true), gettype($iDTipoPersona)), __LINE__);
        }
        $this->IDTipoPersona = $iDTipoPersona;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get IDViaCobro value
     * @return string|null
     */
    public function getIDViaCobro()
    {
        return $this->IDViaCobro;
    }
    /**
     * Set IDViaCobro value
     * @param string $iDViaCobro
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDViaCobro($iDViaCobro = null)
    {
        // validation for constraint: string
        if (!is_null($iDViaCobro) && !is_string($iDViaCobro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDViaCobro, true), gettype($iDViaCobro)), __LINE__);
        }
        $this->IDViaCobro = $iDViaCobro;
        return $this;
    }
    /**
     * Get IDPlanPago value
     * @return string|null
     */
    public function getIDPlanPago()
    {
        return $this->IDPlanPago;
    }
    /**
     * Set IDPlanPago value
     * @param string $iDPlanPago
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDPlanPago($iDPlanPago = null)
    {
        // validation for constraint: string
        if (!is_null($iDPlanPago) && !is_string($iDPlanPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPlanPago, true), gettype($iDPlanPago)), __LINE__);
        }
        $this->IDPlanPago = $iDPlanPago;
        return $this;
    }
    /**
     * Get IDMoneda value
     * @return string|null
     */
    public function getIDMoneda()
    {
        return $this->IDMoneda;
    }
    /**
     * Set IDMoneda value
     * @param string $iDMoneda
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDMoneda($iDMoneda = null)
    {
        // validation for constraint: string
        if (!is_null($iDMoneda) && !is_string($iDMoneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDMoneda, true), gettype($iDMoneda)), __LINE__);
        }
        $this->IDMoneda = $iDMoneda;
        return $this;
    }
    /**
     * Get IDProducto value
     * @return string|null
     */
    public function getIDProducto()
    {
        return $this->IDProducto;
    }
    /**
     * Set IDProducto value
     * @param string $iDProducto
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDProducto($iDProducto = null)
    {
        // validation for constraint: string
        if (!is_null($iDProducto) && !is_string($iDProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProducto, true), gettype($iDProducto)), __LINE__);
        }
        $this->IDProducto = $iDProducto;
        return $this;
    }
    /**
     * Get IDSegmento value
     * @return string|null
     */
    public function getIDSegmento()
    {
        return $this->IDSegmento;
    }
    /**
     * Set IDSegmento value
     * @param string $iDSegmento
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDSegmento($iDSegmento = null)
    {
        // validation for constraint: string
        if (!is_null($iDSegmento) && !is_string($iDSegmento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSegmento, true), gettype($iDSegmento)), __LINE__);
        }
        $this->IDSegmento = $iDSegmento;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get TipoPlanID value
     * @return string|null
     */
    public function getTipoPlanID()
    {
        return $this->TipoPlanID;
    }
    /**
     * Set TipoPlanID value
     * @param string $tipoPlanID
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setTipoPlanID($tipoPlanID = null)
    {
        // validation for constraint: string
        if (!is_null($tipoPlanID) && !is_string($tipoPlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoPlanID, true), gettype($tipoPlanID)), __LINE__);
        }
        $this->TipoPlanID = $tipoPlanID;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItem $items
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setItems(\ArrayType\ArrayOfDocCanalOUTCotizacionHogarItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get Costos value
     * @return \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto|null
     */
    public function getCostos()
    {
        return $this->Costos;
    }
    /**
     * Set Costos value
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos
     * @return \StructType\DocCanalOUTCotizacionHogarOrden
     */
    public function setCostos(\ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos = null)
    {
        $this->Costos = $costos;
        return $this;
    }
}
