<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for TipoEndoso EnumType
 * @subpackage Enumerations
 */
class TipoEndoso extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NoAplica'
     * @return string 'NoAplica'
     */
    const VALUE_NO_APLICA = 'NoAplica';
    /**
     * Constant for value 'AnulacPolizaCliente'
     * @return string 'AnulacPolizaCliente'
     */
    const VALUE_ANULAC_POLIZA_CLIENTE = 'AnulacPolizaCliente';
    /**
     * Constant for value 'AnulacPolizaCompania'
     * @return string 'AnulacPolizaCompania'
     */
    const VALUE_ANULAC_POLIZA_COMPANIA = 'AnulacPolizaCompania';
    /**
     * Constant for value 'AumentoDePremio'
     * @return string 'AumentoDePremio'
     */
    const VALUE_AUMENTO_DE_PREMIO = 'AumentoDePremio';
    /**
     * Constant for value 'AumentoDeVigencia'
     * @return string 'AumentoDeVigencia'
     */
    const VALUE_AUMENTO_DE_VIGENCIA = 'AumentoDeVigencia';
    /**
     * Constant for value 'CancelPolizaCliente'
     * @return string 'CancelPolizaCliente'
     */
    const VALUE_CANCEL_POLIZA_CLIENTE = 'CancelPolizaCliente';
    /**
     * Constant for value 'CancelPolizaCompania'
     * @return string 'CancelPolizaCompania'
     */
    const VALUE_CANCEL_POLIZA_COMPANIA = 'CancelPolizaCompania';
    /**
     * Constant for value 'CancelSaldoPoliza'
     * @return string 'CancelSaldoPoliza'
     */
    const VALUE_CANCEL_SALDO_POLIZA = 'CancelSaldoPoliza';
    /**
     * Constant for value 'DismDeVigencia'
     * @return string 'DismDeVigencia'
     */
    const VALUE_DISM_DE_VIGENCIA = 'DismDeVigencia';
    /**
     * Constant for value 'DismDePremio'
     * @return string 'DismDePremio'
     */
    const VALUE_DISM_DE_PREMIO = 'DismDePremio';
    /**
     * Constant for value 'EndosoDeAumento'
     * @return string 'EndosoDeAumento'
     */
    const VALUE_ENDOSO_DE_AUMENTO = 'EndosoDeAumento';
    /**
     * Constant for value 'EndosoDeDisminucion'
     * @return string 'EndosoDeDisminucion'
     */
    const VALUE_ENDOSO_DE_DISMINUCION = 'EndosoDeDisminucion';
    /**
     * Constant for value 'EndosoDeModificacion'
     * @return string 'EndosoDeModificacion'
     */
    const VALUE_ENDOSO_DE_MODIFICACION = 'EndosoDeModificacion';
    /**
     * Constant for value 'HabilitacionDePoliza'
     * @return string 'HabilitacionDePoliza'
     */
    const VALUE_HABILITACION_DE_POLIZA = 'HabilitacionDePoliza';
    /**
     * Constant for value 'Poliza'
     * @return string 'Poliza'
     */
    const VALUE_POLIZA = 'Poliza';
    /**
     * Constant for value 'Refacturacion'
     * @return string 'Refacturacion'
     */
    const VALUE_REFACTURACION = 'Refacturacion';
    /**
     * Constant for value 'RenovacionDePoliza'
     * @return string 'RenovacionDePoliza'
     */
    const VALUE_RENOVACION_DE_POLIZA = 'RenovacionDePoliza';
    /**
     * Return allowed values
     * @uses self::VALUE_NO_APLICA
     * @uses self::VALUE_ANULAC_POLIZA_CLIENTE
     * @uses self::VALUE_ANULAC_POLIZA_COMPANIA
     * @uses self::VALUE_AUMENTO_DE_PREMIO
     * @uses self::VALUE_AUMENTO_DE_VIGENCIA
     * @uses self::VALUE_CANCEL_POLIZA_CLIENTE
     * @uses self::VALUE_CANCEL_POLIZA_COMPANIA
     * @uses self::VALUE_CANCEL_SALDO_POLIZA
     * @uses self::VALUE_DISM_DE_VIGENCIA
     * @uses self::VALUE_DISM_DE_PREMIO
     * @uses self::VALUE_ENDOSO_DE_AUMENTO
     * @uses self::VALUE_ENDOSO_DE_DISMINUCION
     * @uses self::VALUE_ENDOSO_DE_MODIFICACION
     * @uses self::VALUE_HABILITACION_DE_POLIZA
     * @uses self::VALUE_POLIZA
     * @uses self::VALUE_REFACTURACION
     * @uses self::VALUE_RENOVACION_DE_POLIZA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_APLICA,
            self::VALUE_ANULAC_POLIZA_CLIENTE,
            self::VALUE_ANULAC_POLIZA_COMPANIA,
            self::VALUE_AUMENTO_DE_PREMIO,
            self::VALUE_AUMENTO_DE_VIGENCIA,
            self::VALUE_CANCEL_POLIZA_CLIENTE,
            self::VALUE_CANCEL_POLIZA_COMPANIA,
            self::VALUE_CANCEL_SALDO_POLIZA,
            self::VALUE_DISM_DE_VIGENCIA,
            self::VALUE_DISM_DE_PREMIO,
            self::VALUE_ENDOSO_DE_AUMENTO,
            self::VALUE_ENDOSO_DE_DISMINUCION,
            self::VALUE_ENDOSO_DE_MODIFICACION,
            self::VALUE_HABILITACION_DE_POLIZA,
            self::VALUE_POLIZA,
            self::VALUE_REFACTURACION,
            self::VALUE_RENOVACION_DE_POLIZA,
        );
    }
}
