<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VEHICULO StructType
 * @subpackage Structs
 */
class VEHICULO extends AbstractStructBase
{
    /**
     * The MARCA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MARCA;
    /**
     * The MODELO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MODELO;
    /**
     * The ANO
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ANO;
    /**
     * The PATENTE
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PATENTE;
    /**
     * The CHASIS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CHASIS;
    /**
     * The MOTOR
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MOTOR;
    /**
     * The GNC
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GNC[]
     */
    public $GNC;
    /**
     * Constructor method for VEHICULO
     * @uses VEHICULO::setMARCA()
     * @uses VEHICULO::setMODELO()
     * @uses VEHICULO::setANO()
     * @uses VEHICULO::setPATENTE()
     * @uses VEHICULO::setCHASIS()
     * @uses VEHICULO::setMOTOR()
     * @uses VEHICULO::setGNC()
     * @param string $mARCA
     * @param string $mODELO
     * @param string $aNO
     * @param string $pATENTE
     * @param string $cHASIS
     * @param string $mOTOR
     * @param \StructType\GNC[] $gNC
     */
    public function __construct($mARCA = null, $mODELO = null, $aNO = null, $pATENTE = null, $cHASIS = null, $mOTOR = null, array $gNC = array())
    {
        $this
            ->setMARCA($mARCA)
            ->setMODELO($mODELO)
            ->setANO($aNO)
            ->setPATENTE($pATENTE)
            ->setCHASIS($cHASIS)
            ->setMOTOR($mOTOR)
            ->setGNC($gNC);
    }
    /**
     * Get MARCA value
     * @return string|null
     */
    public function getMARCA()
    {
        return $this->MARCA;
    }
    /**
     * Set MARCA value
     * @param string $mARCA
     * @return \StructType\VEHICULO
     */
    public function setMARCA($mARCA = null)
    {
        // validation for constraint: string
        if (!is_null($mARCA) && !is_string($mARCA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mARCA, true), gettype($mARCA)), __LINE__);
        }
        $this->MARCA = $mARCA;
        return $this;
    }
    /**
     * Get MODELO value
     * @return string|null
     */
    public function getMODELO()
    {
        return $this->MODELO;
    }
    /**
     * Set MODELO value
     * @param string $mODELO
     * @return \StructType\VEHICULO
     */
    public function setMODELO($mODELO = null)
    {
        // validation for constraint: string
        if (!is_null($mODELO) && !is_string($mODELO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mODELO, true), gettype($mODELO)), __LINE__);
        }
        $this->MODELO = $mODELO;
        return $this;
    }
    /**
     * Get ANO value
     * @return string|null
     */
    public function getANO()
    {
        return $this->ANO;
    }
    /**
     * Set ANO value
     * @param string $aNO
     * @return \StructType\VEHICULO
     */
    public function setANO($aNO = null)
    {
        // validation for constraint: string
        if (!is_null($aNO) && !is_string($aNO)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aNO, true), gettype($aNO)), __LINE__);
        }
        $this->ANO = $aNO;
        return $this;
    }
    /**
     * Get PATENTE value
     * @return string|null
     */
    public function getPATENTE()
    {
        return $this->PATENTE;
    }
    /**
     * Set PATENTE value
     * @param string $pATENTE
     * @return \StructType\VEHICULO
     */
    public function setPATENTE($pATENTE = null)
    {
        // validation for constraint: string
        if (!is_null($pATENTE) && !is_string($pATENTE)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pATENTE, true), gettype($pATENTE)), __LINE__);
        }
        $this->PATENTE = $pATENTE;
        return $this;
    }
    /**
     * Get CHASIS value
     * @return string|null
     */
    public function getCHASIS()
    {
        return $this->CHASIS;
    }
    /**
     * Set CHASIS value
     * @param string $cHASIS
     * @return \StructType\VEHICULO
     */
    public function setCHASIS($cHASIS = null)
    {
        // validation for constraint: string
        if (!is_null($cHASIS) && !is_string($cHASIS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cHASIS, true), gettype($cHASIS)), __LINE__);
        }
        $this->CHASIS = $cHASIS;
        return $this;
    }
    /**
     * Get MOTOR value
     * @return string|null
     */
    public function getMOTOR()
    {
        return $this->MOTOR;
    }
    /**
     * Set MOTOR value
     * @param string $mOTOR
     * @return \StructType\VEHICULO
     */
    public function setMOTOR($mOTOR = null)
    {
        // validation for constraint: string
        if (!is_null($mOTOR) && !is_string($mOTOR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mOTOR, true), gettype($mOTOR)), __LINE__);
        }
        $this->MOTOR = $mOTOR;
        return $this;
    }
    /**
     * Get GNC value
     * @return \StructType\GNC[]|null
     */
    public function getGNC()
    {
        return $this->GNC;
    }
    /**
     * This method is responsible for validating the values passed to the setGNC method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGNC method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGNCForArrayConstraintsFromSetGNC(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vEHICULOGNCItem) {
            // validation for constraint: itemType
            if (!$vEHICULOGNCItem instanceof \StructType\GNC) {
                $invalidValues[] = is_object($vEHICULOGNCItem) ? get_class($vEHICULOGNCItem) : sprintf('%s(%s)', gettype($vEHICULOGNCItem), var_export($vEHICULOGNCItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GNC property can only contain items of type \StructType\GNC, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GNC value
     * @throws \InvalidArgumentException
     * @param \StructType\GNC[] $gNC
     * @return \StructType\VEHICULO
     */
    public function setGNC(array $gNC = array())
    {
        // validation for constraint: array
        if ('' !== ($gNCArrayErrorMessage = self::validateGNCForArrayConstraintsFromSetGNC($gNC))) {
            throw new \InvalidArgumentException($gNCArrayErrorMessage, __LINE__);
        }
        $this->GNC = $gNC;
        return $this;
    }
    /**
     * Add item to GNC value
     * @throws \InvalidArgumentException
     * @param \StructType\GNC $item
     * @return \StructType\VEHICULO
     */
    public function addToGNC(\StructType\GNC $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GNC) {
            throw new \InvalidArgumentException(sprintf('The GNC property can only contain items of type \StructType\GNC, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GNC[] = $item;
        return $this;
    }
}
