<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalOUTCotizacionMotorItem StructType
 * @subpackage Structs
 */
class DocCanalOUTCotizacionMotorItem extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The Orden
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Orden;
    /**
     * The PaqueteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaqueteID;
    /**
     * The AniosSinSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AniosSinSiniestro;
    /**
     * The ActividadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ActividadID;
    /**
     * The FechaNacAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaNacAsegurado;
    /**
     * The ValorVehiculo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorVehiculo;
    /**
     * The MesAnioFacturacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MesAnioFacturacion;
    /**
     * The Es0km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Es0km;
    /**
     * The Anio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Anio;
    /**
     * The TotalAccesorios
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalAccesorios;
    /**
     * The TotalCobertAdicionales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalCobertAdicionales;
    /**
     * The EdadAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EdadAsegurado;
    /**
     * The PaqueteIDAS400
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PaqueteIDAS400;
    /**
     * The PerteneceDesglose
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $PerteneceDesglose;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The IDLocalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDLocalidad;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The AsistenciaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AsistenciaID;
    /**
     * The CodigoInfoauto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoInfoauto;
    /**
     * The IDTipoCombustible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoCombustible;
    /**
     * The IDProcedencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProcedencia;
    /**
     * The IDTipoVehiculo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoVehiculo;
    /**
     * The IDAutoCaracteristica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDAutoCaracteristica;
    /**
     * The ModeloCodigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloCodigo;
    /**
     * The MarcaCodigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaCodigo;
    /**
     * The IDClausula
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDClausula;
    /**
     * The IDRastreoVehicular
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRastreoVehicular;
    /**
     * The IDUso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDUso;
    /**
     * The IDZonaRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDZonaRiesgo;
    /**
     * The IDTipoCombustibleOriginal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoCombustibleOriginal;
    /**
     * The IDSexoAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDSexoAsegurado;
    /**
     * The IDEstadoCivilAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDEstadoCivilAsegurado;
    /**
     * The Cobertura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTCotizacionMotorItemCobertura
     */
    public $Cobertura;
    /**
     * The OrdenCosto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTCotizacionMotorOrdenCosto
     */
    public $OrdenCosto;
    /**
     * Constructor method for DocCanalOUTCotizacionMotorItem
     * @uses DocCanalOUTCotizacionMotorItem::setItemID()
     * @uses DocCanalOUTCotizacionMotorItem::setOrdenID()
     * @uses DocCanalOUTCotizacionMotorItem::setOrden()
     * @uses DocCanalOUTCotizacionMotorItem::setPaqueteID()
     * @uses DocCanalOUTCotizacionMotorItem::setAniosSinSiniestro()
     * @uses DocCanalOUTCotizacionMotorItem::setActividadID()
     * @uses DocCanalOUTCotizacionMotorItem::setFechaNacAsegurado()
     * @uses DocCanalOUTCotizacionMotorItem::setValorVehiculo()
     * @uses DocCanalOUTCotizacionMotorItem::setMesAnioFacturacion()
     * @uses DocCanalOUTCotizacionMotorItem::setEs0km()
     * @uses DocCanalOUTCotizacionMotorItem::setAnio()
     * @uses DocCanalOUTCotizacionMotorItem::setTotalAccesorios()
     * @uses DocCanalOUTCotizacionMotorItem::setTotalCobertAdicionales()
     * @uses DocCanalOUTCotizacionMotorItem::setEdadAsegurado()
     * @uses DocCanalOUTCotizacionMotorItem::setPaqueteIDAS400()
     * @uses DocCanalOUTCotizacionMotorItem::setPerteneceDesglose()
     * @uses DocCanalOUTCotizacionMotorItem::setIDProvincia()
     * @uses DocCanalOUTCotizacionMotorItem::setIDLocalidad()
     * @uses DocCanalOUTCotizacionMotorItem::setCodigoPostal()
     * @uses DocCanalOUTCotizacionMotorItem::setAsistenciaID()
     * @uses DocCanalOUTCotizacionMotorItem::setCodigoInfoauto()
     * @uses DocCanalOUTCotizacionMotorItem::setIDTipoCombustible()
     * @uses DocCanalOUTCotizacionMotorItem::setIDProcedencia()
     * @uses DocCanalOUTCotizacionMotorItem::setIDTipoVehiculo()
     * @uses DocCanalOUTCotizacionMotorItem::setIDAutoCaracteristica()
     * @uses DocCanalOUTCotizacionMotorItem::setModeloCodigo()
     * @uses DocCanalOUTCotizacionMotorItem::setMarcaCodigo()
     * @uses DocCanalOUTCotizacionMotorItem::setIDClausula()
     * @uses DocCanalOUTCotizacionMotorItem::setIDRastreoVehicular()
     * @uses DocCanalOUTCotizacionMotorItem::setIDUso()
     * @uses DocCanalOUTCotizacionMotorItem::setIDZonaRiesgo()
     * @uses DocCanalOUTCotizacionMotorItem::setIDTipoCombustibleOriginal()
     * @uses DocCanalOUTCotizacionMotorItem::setIDSexoAsegurado()
     * @uses DocCanalOUTCotizacionMotorItem::setIDEstadoCivilAsegurado()
     * @uses DocCanalOUTCotizacionMotorItem::setCobertura()
     * @uses DocCanalOUTCotizacionMotorItem::setOrdenCosto()
     * @param int $itemID
     * @param int $ordenID
     * @param int $orden
     * @param int $paqueteID
     * @param int $aniosSinSiniestro
     * @param int $actividadID
     * @param string $fechaNacAsegurado
     * @param float $valorVehiculo
     * @param string $mesAnioFacturacion
     * @param bool $es0km
     * @param int $anio
     * @param float $totalAccesorios
     * @param float $totalCobertAdicionales
     * @param int $edadAsegurado
     * @param int $paqueteIDAS400
     * @param bool $perteneceDesglose
     * @param string $iDProvincia
     * @param string $iDLocalidad
     * @param string $codigoPostal
     * @param string $asistenciaID
     * @param string $codigoInfoauto
     * @param string $iDTipoCombustible
     * @param string $iDProcedencia
     * @param string $iDTipoVehiculo
     * @param string $iDAutoCaracteristica
     * @param string $modeloCodigo
     * @param string $marcaCodigo
     * @param string $iDClausula
     * @param string $iDRastreoVehicular
     * @param string $iDUso
     * @param string $iDZonaRiesgo
     * @param string $iDTipoCombustibleOriginal
     * @param string $iDSexoAsegurado
     * @param string $iDEstadoCivilAsegurado
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionMotorItemCobertura $cobertura
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionMotorOrdenCosto $ordenCosto
     */
    public function __construct($itemID = null, $ordenID = null, $orden = null, $paqueteID = null, $aniosSinSiniestro = null, $actividadID = null, $fechaNacAsegurado = null, $valorVehiculo = null, $mesAnioFacturacion = null, $es0km = null, $anio = null, $totalAccesorios = null, $totalCobertAdicionales = null, $edadAsegurado = null, $paqueteIDAS400 = null, $perteneceDesglose = null, $iDProvincia = null, $iDLocalidad = null, $codigoPostal = null, $asistenciaID = null, $codigoInfoauto = null, $iDTipoCombustible = null, $iDProcedencia = null, $iDTipoVehiculo = null, $iDAutoCaracteristica = null, $modeloCodigo = null, $marcaCodigo = null, $iDClausula = null, $iDRastreoVehicular = null, $iDUso = null, $iDZonaRiesgo = null, $iDTipoCombustibleOriginal = null, $iDSexoAsegurado = null, $iDEstadoCivilAsegurado = null, \ArrayType\ArrayOfDocCanalOUTCotizacionMotorItemCobertura $cobertura = null, \ArrayType\ArrayOfDocCanalOUTCotizacionMotorOrdenCosto $ordenCosto = null)
    {
        $this
            ->setItemID($itemID)
            ->setOrdenID($ordenID)
            ->setOrden($orden)
            ->setPaqueteID($paqueteID)
            ->setAniosSinSiniestro($aniosSinSiniestro)
            ->setActividadID($actividadID)
            ->setFechaNacAsegurado($fechaNacAsegurado)
            ->setValorVehiculo($valorVehiculo)
            ->setMesAnioFacturacion($mesAnioFacturacion)
            ->setEs0km($es0km)
            ->setAnio($anio)
            ->setTotalAccesorios($totalAccesorios)
            ->setTotalCobertAdicionales($totalCobertAdicionales)
            ->setEdadAsegurado($edadAsegurado)
            ->setPaqueteIDAS400($paqueteIDAS400)
            ->setPerteneceDesglose($perteneceDesglose)
            ->setIDProvincia($iDProvincia)
            ->setIDLocalidad($iDLocalidad)
            ->setCodigoPostal($codigoPostal)
            ->setAsistenciaID($asistenciaID)
            ->setCodigoInfoauto($codigoInfoauto)
            ->setIDTipoCombustible($iDTipoCombustible)
            ->setIDProcedencia($iDProcedencia)
            ->setIDTipoVehiculo($iDTipoVehiculo)
            ->setIDAutoCaracteristica($iDAutoCaracteristica)
            ->setModeloCodigo($modeloCodigo)
            ->setMarcaCodigo($marcaCodigo)
            ->setIDClausula($iDClausula)
            ->setIDRastreoVehicular($iDRastreoVehicular)
            ->setIDUso($iDUso)
            ->setIDZonaRiesgo($iDZonaRiesgo)
            ->setIDTipoCombustibleOriginal($iDTipoCombustibleOriginal)
            ->setIDSexoAsegurado($iDSexoAsegurado)
            ->setIDEstadoCivilAsegurado($iDEstadoCivilAsegurado)
            ->setCobertura($cobertura)
            ->setOrdenCosto($ordenCosto);
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get Orden value
     * @return int
     */
    public function getOrden()
    {
        return $this->Orden;
    }
    /**
     * Set Orden value
     * @param int $orden
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setOrden($orden = null)
    {
        // validation for constraint: int
        if (!is_null($orden) && !(is_int($orden) || ctype_digit($orden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orden, true), gettype($orden)), __LINE__);
        }
        $this->Orden = $orden;
        return $this;
    }
    /**
     * Get PaqueteID value
     * @return int
     */
    public function getPaqueteID()
    {
        return $this->PaqueteID;
    }
    /**
     * Set PaqueteID value
     * @param int $paqueteID
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setPaqueteID($paqueteID = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteID) && !(is_int($paqueteID) || ctype_digit($paqueteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteID, true), gettype($paqueteID)), __LINE__);
        }
        $this->PaqueteID = $paqueteID;
        return $this;
    }
    /**
     * Get AniosSinSiniestro value
     * @return int
     */
    public function getAniosSinSiniestro()
    {
        return $this->AniosSinSiniestro;
    }
    /**
     * Set AniosSinSiniestro value
     * @param int $aniosSinSiniestro
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setAniosSinSiniestro($aniosSinSiniestro = null)
    {
        // validation for constraint: int
        if (!is_null($aniosSinSiniestro) && !(is_int($aniosSinSiniestro) || ctype_digit($aniosSinSiniestro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aniosSinSiniestro, true), gettype($aniosSinSiniestro)), __LINE__);
        }
        $this->AniosSinSiniestro = $aniosSinSiniestro;
        return $this;
    }
    /**
     * Get ActividadID value
     * @return int
     */
    public function getActividadID()
    {
        return $this->ActividadID;
    }
    /**
     * Set ActividadID value
     * @param int $actividadID
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setActividadID($actividadID = null)
    {
        // validation for constraint: int
        if (!is_null($actividadID) && !(is_int($actividadID) || ctype_digit($actividadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actividadID, true), gettype($actividadID)), __LINE__);
        }
        $this->ActividadID = $actividadID;
        return $this;
    }
    /**
     * Get FechaNacAsegurado value
     * @return string
     */
    public function getFechaNacAsegurado()
    {
        return $this->FechaNacAsegurado;
    }
    /**
     * Set FechaNacAsegurado value
     * @param string $fechaNacAsegurado
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setFechaNacAsegurado($fechaNacAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($fechaNacAsegurado) && !is_string($fechaNacAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaNacAsegurado, true), gettype($fechaNacAsegurado)), __LINE__);
        }
        $this->FechaNacAsegurado = $fechaNacAsegurado;
        return $this;
    }
    /**
     * Get ValorVehiculo value
     * @return float
     */
    public function getValorVehiculo()
    {
        return $this->ValorVehiculo;
    }
    /**
     * Set ValorVehiculo value
     * @param float $valorVehiculo
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setValorVehiculo($valorVehiculo = null)
    {
        // validation for constraint: float
        if (!is_null($valorVehiculo) && !(is_float($valorVehiculo) || is_numeric($valorVehiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorVehiculo, true), gettype($valorVehiculo)), __LINE__);
        }
        $this->ValorVehiculo = $valorVehiculo;
        return $this;
    }
    /**
     * Get MesAnioFacturacion value
     * @return string
     */
    public function getMesAnioFacturacion()
    {
        return $this->MesAnioFacturacion;
    }
    /**
     * Set MesAnioFacturacion value
     * @param string $mesAnioFacturacion
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setMesAnioFacturacion($mesAnioFacturacion = null)
    {
        // validation for constraint: string
        if (!is_null($mesAnioFacturacion) && !is_string($mesAnioFacturacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mesAnioFacturacion, true), gettype($mesAnioFacturacion)), __LINE__);
        }
        $this->MesAnioFacturacion = $mesAnioFacturacion;
        return $this;
    }
    /**
     * Get Es0km value
     * @return bool
     */
    public function getEs0km()
    {
        return $this->Es0km;
    }
    /**
     * Set Es0km value
     * @param bool $es0km
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setEs0km($es0km = null)
    {
        // validation for constraint: boolean
        if (!is_null($es0km) && !is_bool($es0km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($es0km, true), gettype($es0km)), __LINE__);
        }
        $this->Es0km = $es0km;
        return $this;
    }
    /**
     * Get Anio value
     * @return int
     */
    public function getAnio()
    {
        return $this->Anio;
    }
    /**
     * Set Anio value
     * @param int $anio
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setAnio($anio = null)
    {
        // validation for constraint: int
        if (!is_null($anio) && !(is_int($anio) || ctype_digit($anio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anio, true), gettype($anio)), __LINE__);
        }
        $this->Anio = $anio;
        return $this;
    }
    /**
     * Get TotalAccesorios value
     * @return float
     */
    public function getTotalAccesorios()
    {
        return $this->TotalAccesorios;
    }
    /**
     * Set TotalAccesorios value
     * @param float $totalAccesorios
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setTotalAccesorios($totalAccesorios = null)
    {
        // validation for constraint: float
        if (!is_null($totalAccesorios) && !(is_float($totalAccesorios) || is_numeric($totalAccesorios))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAccesorios, true), gettype($totalAccesorios)), __LINE__);
        }
        $this->TotalAccesorios = $totalAccesorios;
        return $this;
    }
    /**
     * Get TotalCobertAdicionales value
     * @return float
     */
    public function getTotalCobertAdicionales()
    {
        return $this->TotalCobertAdicionales;
    }
    /**
     * Set TotalCobertAdicionales value
     * @param float $totalCobertAdicionales
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setTotalCobertAdicionales($totalCobertAdicionales = null)
    {
        // validation for constraint: float
        if (!is_null($totalCobertAdicionales) && !(is_float($totalCobertAdicionales) || is_numeric($totalCobertAdicionales))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCobertAdicionales, true), gettype($totalCobertAdicionales)), __LINE__);
        }
        $this->TotalCobertAdicionales = $totalCobertAdicionales;
        return $this;
    }
    /**
     * Get EdadAsegurado value
     * @return int
     */
    public function getEdadAsegurado()
    {
        return $this->EdadAsegurado;
    }
    /**
     * Set EdadAsegurado value
     * @param int $edadAsegurado
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setEdadAsegurado($edadAsegurado = null)
    {
        // validation for constraint: int
        if (!is_null($edadAsegurado) && !(is_int($edadAsegurado) || ctype_digit($edadAsegurado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($edadAsegurado, true), gettype($edadAsegurado)), __LINE__);
        }
        $this->EdadAsegurado = $edadAsegurado;
        return $this;
    }
    /**
     * Get PaqueteIDAS400 value
     * @return int
     */
    public function getPaqueteIDAS400()
    {
        return $this->PaqueteIDAS400;
    }
    /**
     * Set PaqueteIDAS400 value
     * @param int $paqueteIDAS400
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setPaqueteIDAS400($paqueteIDAS400 = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteIDAS400) && !(is_int($paqueteIDAS400) || ctype_digit($paqueteIDAS400))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteIDAS400, true), gettype($paqueteIDAS400)), __LINE__);
        }
        $this->PaqueteIDAS400 = $paqueteIDAS400;
        return $this;
    }
    /**
     * Get PerteneceDesglose value
     * @return bool
     */
    public function getPerteneceDesglose()
    {
        return $this->PerteneceDesglose;
    }
    /**
     * Set PerteneceDesglose value
     * @param bool $perteneceDesglose
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setPerteneceDesglose($perteneceDesglose = null)
    {
        // validation for constraint: boolean
        if (!is_null($perteneceDesglose) && !is_bool($perteneceDesglose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($perteneceDesglose, true), gettype($perteneceDesglose)), __LINE__);
        }
        $this->PerteneceDesglose = $perteneceDesglose;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get IDLocalidad value
     * @return string|null
     */
    public function getIDLocalidad()
    {
        return $this->IDLocalidad;
    }
    /**
     * Set IDLocalidad value
     * @param string $iDLocalidad
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDLocalidad($iDLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($iDLocalidad) && !is_string($iDLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDLocalidad, true), gettype($iDLocalidad)), __LINE__);
        }
        $this->IDLocalidad = $iDLocalidad;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get AsistenciaID value
     * @return string|null
     */
    public function getAsistenciaID()
    {
        return $this->AsistenciaID;
    }
    /**
     * Set AsistenciaID value
     * @param string $asistenciaID
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setAsistenciaID($asistenciaID = null)
    {
        // validation for constraint: string
        if (!is_null($asistenciaID) && !is_string($asistenciaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asistenciaID, true), gettype($asistenciaID)), __LINE__);
        }
        $this->AsistenciaID = $asistenciaID;
        return $this;
    }
    /**
     * Get CodigoInfoauto value
     * @return string|null
     */
    public function getCodigoInfoauto()
    {
        return $this->CodigoInfoauto;
    }
    /**
     * Set CodigoInfoauto value
     * @param string $codigoInfoauto
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setCodigoInfoauto($codigoInfoauto = null)
    {
        // validation for constraint: string
        if (!is_null($codigoInfoauto) && !is_string($codigoInfoauto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoInfoauto, true), gettype($codigoInfoauto)), __LINE__);
        }
        $this->CodigoInfoauto = $codigoInfoauto;
        return $this;
    }
    /**
     * Get IDTipoCombustible value
     * @return string|null
     */
    public function getIDTipoCombustible()
    {
        return $this->IDTipoCombustible;
    }
    /**
     * Set IDTipoCombustible value
     * @param string $iDTipoCombustible
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDTipoCombustible($iDTipoCombustible = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoCombustible) && !is_string($iDTipoCombustible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoCombustible, true), gettype($iDTipoCombustible)), __LINE__);
        }
        $this->IDTipoCombustible = $iDTipoCombustible;
        return $this;
    }
    /**
     * Get IDProcedencia value
     * @return string|null
     */
    public function getIDProcedencia()
    {
        return $this->IDProcedencia;
    }
    /**
     * Set IDProcedencia value
     * @param string $iDProcedencia
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDProcedencia($iDProcedencia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProcedencia) && !is_string($iDProcedencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProcedencia, true), gettype($iDProcedencia)), __LINE__);
        }
        $this->IDProcedencia = $iDProcedencia;
        return $this;
    }
    /**
     * Get IDTipoVehiculo value
     * @return string|null
     */
    public function getIDTipoVehiculo()
    {
        return $this->IDTipoVehiculo;
    }
    /**
     * Set IDTipoVehiculo value
     * @param string $iDTipoVehiculo
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDTipoVehiculo($iDTipoVehiculo = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoVehiculo) && !is_string($iDTipoVehiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoVehiculo, true), gettype($iDTipoVehiculo)), __LINE__);
        }
        $this->IDTipoVehiculo = $iDTipoVehiculo;
        return $this;
    }
    /**
     * Get IDAutoCaracteristica value
     * @return string|null
     */
    public function getIDAutoCaracteristica()
    {
        return $this->IDAutoCaracteristica;
    }
    /**
     * Set IDAutoCaracteristica value
     * @param string $iDAutoCaracteristica
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDAutoCaracteristica($iDAutoCaracteristica = null)
    {
        // validation for constraint: string
        if (!is_null($iDAutoCaracteristica) && !is_string($iDAutoCaracteristica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDAutoCaracteristica, true), gettype($iDAutoCaracteristica)), __LINE__);
        }
        $this->IDAutoCaracteristica = $iDAutoCaracteristica;
        return $this;
    }
    /**
     * Get ModeloCodigo value
     * @return string|null
     */
    public function getModeloCodigo()
    {
        return $this->ModeloCodigo;
    }
    /**
     * Set ModeloCodigo value
     * @param string $modeloCodigo
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setModeloCodigo($modeloCodigo = null)
    {
        // validation for constraint: string
        if (!is_null($modeloCodigo) && !is_string($modeloCodigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloCodigo, true), gettype($modeloCodigo)), __LINE__);
        }
        $this->ModeloCodigo = $modeloCodigo;
        return $this;
    }
    /**
     * Get MarcaCodigo value
     * @return string|null
     */
    public function getMarcaCodigo()
    {
        return $this->MarcaCodigo;
    }
    /**
     * Set MarcaCodigo value
     * @param string $marcaCodigo
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setMarcaCodigo($marcaCodigo = null)
    {
        // validation for constraint: string
        if (!is_null($marcaCodigo) && !is_string($marcaCodigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaCodigo, true), gettype($marcaCodigo)), __LINE__);
        }
        $this->MarcaCodigo = $marcaCodigo;
        return $this;
    }
    /**
     * Get IDClausula value
     * @return string|null
     */
    public function getIDClausula()
    {
        return $this->IDClausula;
    }
    /**
     * Set IDClausula value
     * @param string $iDClausula
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDClausula($iDClausula = null)
    {
        // validation for constraint: string
        if (!is_null($iDClausula) && !is_string($iDClausula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDClausula, true), gettype($iDClausula)), __LINE__);
        }
        $this->IDClausula = $iDClausula;
        return $this;
    }
    /**
     * Get IDRastreoVehicular value
     * @return string|null
     */
    public function getIDRastreoVehicular()
    {
        return $this->IDRastreoVehicular;
    }
    /**
     * Set IDRastreoVehicular value
     * @param string $iDRastreoVehicular
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDRastreoVehicular($iDRastreoVehicular = null)
    {
        // validation for constraint: string
        if (!is_null($iDRastreoVehicular) && !is_string($iDRastreoVehicular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRastreoVehicular, true), gettype($iDRastreoVehicular)), __LINE__);
        }
        $this->IDRastreoVehicular = $iDRastreoVehicular;
        return $this;
    }
    /**
     * Get IDUso value
     * @return string|null
     */
    public function getIDUso()
    {
        return $this->IDUso;
    }
    /**
     * Set IDUso value
     * @param string $iDUso
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDUso($iDUso = null)
    {
        // validation for constraint: string
        if (!is_null($iDUso) && !is_string($iDUso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDUso, true), gettype($iDUso)), __LINE__);
        }
        $this->IDUso = $iDUso;
        return $this;
    }
    /**
     * Get IDZonaRiesgo value
     * @return string|null
     */
    public function getIDZonaRiesgo()
    {
        return $this->IDZonaRiesgo;
    }
    /**
     * Set IDZonaRiesgo value
     * @param string $iDZonaRiesgo
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDZonaRiesgo($iDZonaRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDZonaRiesgo) && !is_string($iDZonaRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDZonaRiesgo, true), gettype($iDZonaRiesgo)), __LINE__);
        }
        $this->IDZonaRiesgo = $iDZonaRiesgo;
        return $this;
    }
    /**
     * Get IDTipoCombustibleOriginal value
     * @return string|null
     */
    public function getIDTipoCombustibleOriginal()
    {
        return $this->IDTipoCombustibleOriginal;
    }
    /**
     * Set IDTipoCombustibleOriginal value
     * @param string $iDTipoCombustibleOriginal
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDTipoCombustibleOriginal($iDTipoCombustibleOriginal = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoCombustibleOriginal) && !is_string($iDTipoCombustibleOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoCombustibleOriginal, true), gettype($iDTipoCombustibleOriginal)), __LINE__);
        }
        $this->IDTipoCombustibleOriginal = $iDTipoCombustibleOriginal;
        return $this;
    }
    /**
     * Get IDSexoAsegurado value
     * @return string|null
     */
    public function getIDSexoAsegurado()
    {
        return $this->IDSexoAsegurado;
    }
    /**
     * Set IDSexoAsegurado value
     * @param string $iDSexoAsegurado
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDSexoAsegurado($iDSexoAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDSexoAsegurado) && !is_string($iDSexoAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSexoAsegurado, true), gettype($iDSexoAsegurado)), __LINE__);
        }
        $this->IDSexoAsegurado = $iDSexoAsegurado;
        return $this;
    }
    /**
     * Get IDEstadoCivilAsegurado value
     * @return string|null
     */
    public function getIDEstadoCivilAsegurado()
    {
        return $this->IDEstadoCivilAsegurado;
    }
    /**
     * Set IDEstadoCivilAsegurado value
     * @param string $iDEstadoCivilAsegurado
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setIDEstadoCivilAsegurado($iDEstadoCivilAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDEstadoCivilAsegurado) && !is_string($iDEstadoCivilAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDEstadoCivilAsegurado, true), gettype($iDEstadoCivilAsegurado)), __LINE__);
        }
        $this->IDEstadoCivilAsegurado = $iDEstadoCivilAsegurado;
        return $this;
    }
    /**
     * Get Cobertura value
     * @return \ArrayType\ArrayOfDocCanalOUTCotizacionMotorItemCobertura|null
     */
    public function getCobertura()
    {
        return $this->Cobertura;
    }
    /**
     * Set Cobertura value
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionMotorItemCobertura $cobertura
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setCobertura(\ArrayType\ArrayOfDocCanalOUTCotizacionMotorItemCobertura $cobertura = null)
    {
        $this->Cobertura = $cobertura;
        return $this;
    }
    /**
     * Get OrdenCosto value
     * @return \ArrayType\ArrayOfDocCanalOUTCotizacionMotorOrdenCosto|null
     */
    public function getOrdenCosto()
    {
        return $this->OrdenCosto;
    }
    /**
     * Set OrdenCosto value
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionMotorOrdenCosto $ordenCosto
     * @return \StructType\DocCanalOUTCotizacionMotorItem
     */
    public function setOrdenCosto(\ArrayType\ArrayOfDocCanalOUTCotizacionMotorOrdenCosto $ordenCosto = null)
    {
        $this->OrdenCosto = $ordenCosto;
        return $this;
    }
}
