<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalINCotizacionMotorOrden StructType
 * @subpackage Structs
 */
class DocCanalINCotizacionMotorOrden extends AbstractStructBase
{
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The FamiliaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FamiliaID;
    /**
     * The SociedadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SociedadID;
    /**
     * The PlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PlanID;
    /**
     * The EsRenovacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EsRenovacion;
    /**
     * The Comision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Comision;
    /**
     * The BonificacionComercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionComercial;
    /**
     * The BonificacionViacobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionViacobro;
    /**
     * The FechaVigenciaDesde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaDesde;
    /**
     * The FechaVigenciaHasta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaHasta;
    /**
     * The AdmiteExcepciones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $AdmiteExcepciones;
    /**
     * The IDBeneficio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDBeneficio;
    /**
     * The IDRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRiesgo;
    /**
     * The IDTipoPoliza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPoliza;
    /**
     * The IDTipoPersona
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersona;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The IDViaCobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDViaCobro;
    /**
     * The IDPlanPago
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPlanPago;
    /**
     * The IDProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProducto;
    /**
     * The IDSegmento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDSegmento;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The CantItem
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CantItem;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINCotizacionMotorItem
     */
    public $Items;
    /**
     * Constructor method for DocCanalINCotizacionMotorOrden
     * @uses DocCanalINCotizacionMotorOrden::setOrdenID()
     * @uses DocCanalINCotizacionMotorOrden::setFamiliaID()
     * @uses DocCanalINCotizacionMotorOrden::setSociedadID()
     * @uses DocCanalINCotizacionMotorOrden::setPlanID()
     * @uses DocCanalINCotizacionMotorOrden::setEsRenovacion()
     * @uses DocCanalINCotizacionMotorOrden::setComision()
     * @uses DocCanalINCotizacionMotorOrden::setBonificacionComercial()
     * @uses DocCanalINCotizacionMotorOrden::setBonificacionViacobro()
     * @uses DocCanalINCotizacionMotorOrden::setFechaVigenciaDesde()
     * @uses DocCanalINCotizacionMotorOrden::setFechaVigenciaHasta()
     * @uses DocCanalINCotizacionMotorOrden::setAdmiteExcepciones()
     * @uses DocCanalINCotizacionMotorOrden::setIDBeneficio()
     * @uses DocCanalINCotizacionMotorOrden::setIDRiesgo()
     * @uses DocCanalINCotizacionMotorOrden::setIDTipoPoliza()
     * @uses DocCanalINCotizacionMotorOrden::setIDTipoPersona()
     * @uses DocCanalINCotizacionMotorOrden::setIDCondicionIVA()
     * @uses DocCanalINCotizacionMotorOrden::setIDViaCobro()
     * @uses DocCanalINCotizacionMotorOrden::setIDPlanPago()
     * @uses DocCanalINCotizacionMotorOrden::setIDProducto()
     * @uses DocCanalINCotizacionMotorOrden::setIDSegmento()
     * @uses DocCanalINCotizacionMotorOrden::setIDProvincia()
     * @uses DocCanalINCotizacionMotorOrden::setCantItem()
     * @uses DocCanalINCotizacionMotorOrden::setItems()
     * @param int $ordenID
     * @param int $familiaID
     * @param int $sociedadID
     * @param int $planID
     * @param bool $esRenovacion
     * @param float $comision
     * @param float $bonificacionComercial
     * @param float $bonificacionViacobro
     * @param string $fechaVigenciaDesde
     * @param string $fechaVigenciaHasta
     * @param bool $admiteExcepciones
     * @param int $iDBeneficio
     * @param string $iDRiesgo
     * @param string $iDTipoPoliza
     * @param string $iDTipoPersona
     * @param string $iDCondicionIVA
     * @param string $iDViaCobro
     * @param string $iDPlanPago
     * @param string $iDProducto
     * @param string $iDSegmento
     * @param string $iDProvincia
     * @param int $cantItem
     * @param \ArrayType\ArrayOfDocCanalINCotizacionMotorItem $items
     */
    public function __construct($ordenID = null, $familiaID = null, $sociedadID = null, $planID = null, $esRenovacion = null, $comision = null, $bonificacionComercial = null, $bonificacionViacobro = null, $fechaVigenciaDesde = null, $fechaVigenciaHasta = null, $admiteExcepciones = null, $iDBeneficio = null, $iDRiesgo = null, $iDTipoPoliza = null, $iDTipoPersona = null, $iDCondicionIVA = null, $iDViaCobro = null, $iDPlanPago = null, $iDProducto = null, $iDSegmento = null, $iDProvincia = null, $cantItem = 0, \ArrayType\ArrayOfDocCanalINCotizacionMotorItem $items = null)
    {
        $this
            ->setOrdenID($ordenID)
            ->setFamiliaID($familiaID)
            ->setSociedadID($sociedadID)
            ->setPlanID($planID)
            ->setEsRenovacion($esRenovacion)
            ->setComision($comision)
            ->setBonificacionComercial($bonificacionComercial)
            ->setBonificacionViacobro($bonificacionViacobro)
            ->setFechaVigenciaDesde($fechaVigenciaDesde)
            ->setFechaVigenciaHasta($fechaVigenciaHasta)
            ->setAdmiteExcepciones($admiteExcepciones)
            ->setIDBeneficio($iDBeneficio)
            ->setIDRiesgo($iDRiesgo)
            ->setIDTipoPoliza($iDTipoPoliza)
            ->setIDTipoPersona($iDTipoPersona)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setIDViaCobro($iDViaCobro)
            ->setIDPlanPago($iDPlanPago)
            ->setIDProducto($iDProducto)
            ->setIDSegmento($iDSegmento)
            ->setIDProvincia($iDProvincia)
            ->setCantItem($cantItem)
            ->setItems($items);
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get FamiliaID value
     * @return int
     */
    public function getFamiliaID()
    {
        return $this->FamiliaID;
    }
    /**
     * Set FamiliaID value
     * @param int $familiaID
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setFamiliaID($familiaID = null)
    {
        // validation for constraint: int
        if (!is_null($familiaID) && !(is_int($familiaID) || ctype_digit($familiaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($familiaID, true), gettype($familiaID)), __LINE__);
        }
        $this->FamiliaID = $familiaID;
        return $this;
    }
    /**
     * Get SociedadID value
     * @return int
     */
    public function getSociedadID()
    {
        return $this->SociedadID;
    }
    /**
     * Set SociedadID value
     * @param int $sociedadID
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setSociedadID($sociedadID = null)
    {
        // validation for constraint: int
        if (!is_null($sociedadID) && !(is_int($sociedadID) || ctype_digit($sociedadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sociedadID, true), gettype($sociedadID)), __LINE__);
        }
        $this->SociedadID = $sociedadID;
        return $this;
    }
    /**
     * Get PlanID value
     * @return int
     */
    public function getPlanID()
    {
        return $this->PlanID;
    }
    /**
     * Set PlanID value
     * @param int $planID
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setPlanID($planID = null)
    {
        // validation for constraint: int
        if (!is_null($planID) && !(is_int($planID) || ctype_digit($planID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($planID, true), gettype($planID)), __LINE__);
        }
        $this->PlanID = $planID;
        return $this;
    }
    /**
     * Get EsRenovacion value
     * @return bool
     */
    public function getEsRenovacion()
    {
        return $this->EsRenovacion;
    }
    /**
     * Set EsRenovacion value
     * @param bool $esRenovacion
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setEsRenovacion($esRenovacion = null)
    {
        // validation for constraint: boolean
        if (!is_null($esRenovacion) && !is_bool($esRenovacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esRenovacion, true), gettype($esRenovacion)), __LINE__);
        }
        $this->EsRenovacion = $esRenovacion;
        return $this;
    }
    /**
     * Get Comision value
     * @return float
     */
    public function getComision()
    {
        return $this->Comision;
    }
    /**
     * Set Comision value
     * @param float $comision
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setComision($comision = null)
    {
        // validation for constraint: float
        if (!is_null($comision) && !(is_float($comision) || is_numeric($comision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($comision, true), gettype($comision)), __LINE__);
        }
        $this->Comision = $comision;
        return $this;
    }
    /**
     * Get BonificacionComercial value
     * @return float
     */
    public function getBonificacionComercial()
    {
        return $this->BonificacionComercial;
    }
    /**
     * Set BonificacionComercial value
     * @param float $bonificacionComercial
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setBonificacionComercial($bonificacionComercial = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComercial) && !(is_float($bonificacionComercial) || is_numeric($bonificacionComercial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComercial, true), gettype($bonificacionComercial)), __LINE__);
        }
        $this->BonificacionComercial = $bonificacionComercial;
        return $this;
    }
    /**
     * Get BonificacionViacobro value
     * @return float
     */
    public function getBonificacionViacobro()
    {
        return $this->BonificacionViacobro;
    }
    /**
     * Set BonificacionViacobro value
     * @param float $bonificacionViacobro
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setBonificacionViacobro($bonificacionViacobro = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionViacobro) && !(is_float($bonificacionViacobro) || is_numeric($bonificacionViacobro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionViacobro, true), gettype($bonificacionViacobro)), __LINE__);
        }
        $this->BonificacionViacobro = $bonificacionViacobro;
        return $this;
    }
    /**
     * Get FechaVigenciaDesde value
     * @return string
     */
    public function getFechaVigenciaDesde()
    {
        return $this->FechaVigenciaDesde;
    }
    /**
     * Set FechaVigenciaDesde value
     * @param string $fechaVigenciaDesde
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setFechaVigenciaDesde($fechaVigenciaDesde = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaDesde) && !is_string($fechaVigenciaDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaDesde, true), gettype($fechaVigenciaDesde)), __LINE__);
        }
        $this->FechaVigenciaDesde = $fechaVigenciaDesde;
        return $this;
    }
    /**
     * Get FechaVigenciaHasta value
     * @return string
     */
    public function getFechaVigenciaHasta()
    {
        return $this->FechaVigenciaHasta;
    }
    /**
     * Set FechaVigenciaHasta value
     * @param string $fechaVigenciaHasta
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setFechaVigenciaHasta($fechaVigenciaHasta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaHasta) && !is_string($fechaVigenciaHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaHasta, true), gettype($fechaVigenciaHasta)), __LINE__);
        }
        $this->FechaVigenciaHasta = $fechaVigenciaHasta;
        return $this;
    }
    /**
     * Get AdmiteExcepciones value
     * @return bool
     */
    public function getAdmiteExcepciones()
    {
        return $this->AdmiteExcepciones;
    }
    /**
     * Set AdmiteExcepciones value
     * @param bool $admiteExcepciones
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setAdmiteExcepciones($admiteExcepciones = null)
    {
        // validation for constraint: boolean
        if (!is_null($admiteExcepciones) && !is_bool($admiteExcepciones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($admiteExcepciones, true), gettype($admiteExcepciones)), __LINE__);
        }
        $this->AdmiteExcepciones = $admiteExcepciones;
        return $this;
    }
    /**
     * Get IDBeneficio value
     * @return int
     */
    public function getIDBeneficio()
    {
        return $this->IDBeneficio;
    }
    /**
     * Set IDBeneficio value
     * @param int $iDBeneficio
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDBeneficio($iDBeneficio = null)
    {
        // validation for constraint: int
        if (!is_null($iDBeneficio) && !(is_int($iDBeneficio) || ctype_digit($iDBeneficio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDBeneficio, true), gettype($iDBeneficio)), __LINE__);
        }
        $this->IDBeneficio = $iDBeneficio;
        return $this;
    }
    /**
     * Get IDRiesgo value
     * @return string|null
     */
    public function getIDRiesgo()
    {
        return $this->IDRiesgo;
    }
    /**
     * Set IDRiesgo value
     * @param string $iDRiesgo
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDRiesgo($iDRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDRiesgo) && !is_string($iDRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRiesgo, true), gettype($iDRiesgo)), __LINE__);
        }
        $this->IDRiesgo = $iDRiesgo;
        return $this;
    }
    /**
     * Get IDTipoPoliza value
     * @return string|null
     */
    public function getIDTipoPoliza()
    {
        return $this->IDTipoPoliza;
    }
    /**
     * Set IDTipoPoliza value
     * @param string $iDTipoPoliza
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDTipoPoliza($iDTipoPoliza = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPoliza) && !is_string($iDTipoPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPoliza, true), gettype($iDTipoPoliza)), __LINE__);
        }
        $this->IDTipoPoliza = $iDTipoPoliza;
        return $this;
    }
    /**
     * Get IDTipoPersona value
     * @return string|null
     */
    public function getIDTipoPersona()
    {
        return $this->IDTipoPersona;
    }
    /**
     * Set IDTipoPersona value
     * @param string $iDTipoPersona
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDTipoPersona($iDTipoPersona = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersona) && !is_string($iDTipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersona, true), gettype($iDTipoPersona)), __LINE__);
        }
        $this->IDTipoPersona = $iDTipoPersona;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get IDViaCobro value
     * @return string|null
     */
    public function getIDViaCobro()
    {
        return $this->IDViaCobro;
    }
    /**
     * Set IDViaCobro value
     * @param string $iDViaCobro
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDViaCobro($iDViaCobro = null)
    {
        // validation for constraint: string
        if (!is_null($iDViaCobro) && !is_string($iDViaCobro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDViaCobro, true), gettype($iDViaCobro)), __LINE__);
        }
        $this->IDViaCobro = $iDViaCobro;
        return $this;
    }
    /**
     * Get IDPlanPago value
     * @return string|null
     */
    public function getIDPlanPago()
    {
        return $this->IDPlanPago;
    }
    /**
     * Set IDPlanPago value
     * @param string $iDPlanPago
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDPlanPago($iDPlanPago = null)
    {
        // validation for constraint: string
        if (!is_null($iDPlanPago) && !is_string($iDPlanPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPlanPago, true), gettype($iDPlanPago)), __LINE__);
        }
        $this->IDPlanPago = $iDPlanPago;
        return $this;
    }
    /**
     * Get IDProducto value
     * @return string|null
     */
    public function getIDProducto()
    {
        return $this->IDProducto;
    }
    /**
     * Set IDProducto value
     * @param string $iDProducto
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDProducto($iDProducto = null)
    {
        // validation for constraint: string
        if (!is_null($iDProducto) && !is_string($iDProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProducto, true), gettype($iDProducto)), __LINE__);
        }
        $this->IDProducto = $iDProducto;
        return $this;
    }
    /**
     * Get IDSegmento value
     * @return string|null
     */
    public function getIDSegmento()
    {
        return $this->IDSegmento;
    }
    /**
     * Set IDSegmento value
     * @param string $iDSegmento
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDSegmento($iDSegmento = null)
    {
        // validation for constraint: string
        if (!is_null($iDSegmento) && !is_string($iDSegmento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSegmento, true), gettype($iDSegmento)), __LINE__);
        }
        $this->IDSegmento = $iDSegmento;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get CantItem value
     * @return int|null
     */
    public function getCantItem()
    {
        return $this->CantItem;
    }
    /**
     * Set CantItem value
     * @param int $cantItem
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setCantItem($cantItem = 0)
    {
        // validation for constraint: int
        if (!is_null($cantItem) && !(is_int($cantItem) || ctype_digit($cantItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantItem, true), gettype($cantItem)), __LINE__);
        }
        $this->CantItem = $cantItem;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfDocCanalINCotizacionMotorItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfDocCanalINCotizacionMotorItem $items
     * @return \StructType\DocCanalINCotizacionMotorOrden
     */
    public function setItems(\ArrayType\ArrayOfDocCanalINCotizacionMotorItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
}
