<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusquedaInspeccionesOut StructType
 * @subpackage Structs
 */
class BusquedaInspeccionesOut extends AbstractStructBase
{
    /**
     * The CodigoRta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CodigoRta;
    /**
     * The Datos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Datos[]
     */
    public $Datos;
    /**
     * The MensajeRta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MensajeRta;
    /**
     * Constructor method for BusquedaInspeccionesOut
     * @uses BusquedaInspeccionesOut::setCodigoRta()
     * @uses BusquedaInspeccionesOut::setDatos()
     * @uses BusquedaInspeccionesOut::setMensajeRta()
     * @param int $codigoRta
     * @param \StructType\Datos[] $datos
     * @param string $mensajeRta
     */
    public function __construct($codigoRta = null, array $datos = array(), $mensajeRta = null)
    {
        $this
            ->setCodigoRta($codigoRta)
            ->setDatos($datos)
            ->setMensajeRta($mensajeRta);
    }
    /**
     * Get CodigoRta value
     * @return int
     */
    public function getCodigoRta()
    {
        return $this->CodigoRta;
    }
    /**
     * Set CodigoRta value
     * @param int $codigoRta
     * @return \StructType\BusquedaInspeccionesOut
     */
    public function setCodigoRta($codigoRta = null)
    {
        // validation for constraint: int
        if (!is_null($codigoRta) && !(is_int($codigoRta) || ctype_digit($codigoRta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoRta, true), gettype($codigoRta)), __LINE__);
        }
        $this->CodigoRta = $codigoRta;
        return $this;
    }
    /**
     * Get Datos value
     * @return \StructType\Datos[]|null
     */
    public function getDatos()
    {
        return $this->Datos;
    }
    /**
     * This method is responsible for validating the values passed to the setDatos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatosForArrayConstraintsFromSetDatos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $busquedaInspeccionesOutDatosItem) {
            // validation for constraint: itemType
            if (!$busquedaInspeccionesOutDatosItem instanceof \StructType\Datos) {
                $invalidValues[] = is_object($busquedaInspeccionesOutDatosItem) ? get_class($busquedaInspeccionesOutDatosItem) : sprintf('%s(%s)', gettype($busquedaInspeccionesOutDatosItem), var_export($busquedaInspeccionesOutDatosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Datos property can only contain items of type \StructType\Datos, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Datos value
     * @throws \InvalidArgumentException
     * @param \StructType\Datos[] $datos
     * @return \StructType\BusquedaInspeccionesOut
     */
    public function setDatos(array $datos = array())
    {
        // validation for constraint: array
        if ('' !== ($datosArrayErrorMessage = self::validateDatosForArrayConstraintsFromSetDatos($datos))) {
            throw new \InvalidArgumentException($datosArrayErrorMessage, __LINE__);
        }
        $this->Datos = $datos;
        return $this;
    }
    /**
     * Add item to Datos value
     * @throws \InvalidArgumentException
     * @param \StructType\Datos $item
     * @return \StructType\BusquedaInspeccionesOut
     */
    public function addToDatos(\StructType\Datos $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Datos) {
            throw new \InvalidArgumentException(sprintf('The Datos property can only contain items of type \StructType\Datos, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Datos[] = $item;
        return $this;
    }
    /**
     * Get MensajeRta value
     * @return string|null
     */
    public function getMensajeRta()
    {
        return $this->MensajeRta;
    }
    /**
     * Set MensajeRta value
     * @param string $mensajeRta
     * @return \StructType\BusquedaInspeccionesOut
     */
    public function setMensajeRta($mensajeRta = null)
    {
        // validation for constraint: string
        if (!is_null($mensajeRta) && !is_string($mensajeRta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensajeRta, true), gettype($mensajeRta)), __LINE__);
        }
        $this->MensajeRta = $mensajeRta;
        return $this;
    }
}
