<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmisionMotorsSalidaOrdenCosto StructType
 * @subpackage Structs
 */
class EmisionMotorsSalidaOrdenCosto extends AbstractStructBase
{
    /**
     * The OrdenCostoID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenCostoID;
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ItemID;
    /**
     * The Tasa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Tasa;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Valor;
    /**
     * The IDConcepto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDConcepto;
    /**
     * The Vigencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vigencia;
    /**
     * Constructor method for EmisionMotorsSalidaOrdenCosto
     * @uses EmisionMotorsSalidaOrdenCosto::setOrdenCostoID()
     * @uses EmisionMotorsSalidaOrdenCosto::setOrdenID()
     * @uses EmisionMotorsSalidaOrdenCosto::setItemID()
     * @uses EmisionMotorsSalidaOrdenCosto::setTasa()
     * @uses EmisionMotorsSalidaOrdenCosto::setValor()
     * @uses EmisionMotorsSalidaOrdenCosto::setIDConcepto()
     * @uses EmisionMotorsSalidaOrdenCosto::setVigencia()
     * @param int $ordenCostoID
     * @param int $ordenID
     * @param float $itemID
     * @param float $tasa
     * @param float $valor
     * @param string $iDConcepto
     * @param string $vigencia
     */
    public function __construct($ordenCostoID = null, $ordenID = null, $itemID = null, $tasa = null, $valor = null, $iDConcepto = null, $vigencia = null)
    {
        $this
            ->setOrdenCostoID($ordenCostoID)
            ->setOrdenID($ordenID)
            ->setItemID($itemID)
            ->setTasa($tasa)
            ->setValor($valor)
            ->setIDConcepto($iDConcepto)
            ->setVigencia($vigencia);
    }
    /**
     * Get OrdenCostoID value
     * @return int
     */
    public function getOrdenCostoID()
    {
        return $this->OrdenCostoID;
    }
    /**
     * Set OrdenCostoID value
     * @param int $ordenCostoID
     * @return \StructType\EmisionMotorsSalidaOrdenCosto
     */
    public function setOrdenCostoID($ordenCostoID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenCostoID) && !(is_int($ordenCostoID) || ctype_digit($ordenCostoID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenCostoID, true), gettype($ordenCostoID)), __LINE__);
        }
        $this->OrdenCostoID = $ordenCostoID;
        return $this;
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\EmisionMotorsSalidaOrdenCosto
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get ItemID value
     * @return float
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param float $itemID
     * @return \StructType\EmisionMotorsSalidaOrdenCosto
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: float
        if (!is_null($itemID) && !(is_float($itemID) || is_numeric($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get Tasa value
     * @return float
     */
    public function getTasa()
    {
        return $this->Tasa;
    }
    /**
     * Set Tasa value
     * @param float $tasa
     * @return \StructType\EmisionMotorsSalidaOrdenCosto
     */
    public function setTasa($tasa = null)
    {
        // validation for constraint: float
        if (!is_null($tasa) && !(is_float($tasa) || is_numeric($tasa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($tasa, true), gettype($tasa)), __LINE__);
        }
        $this->Tasa = $tasa;
        return $this;
    }
    /**
     * Get Valor value
     * @return float
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\EmisionMotorsSalidaOrdenCosto
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get IDConcepto value
     * @return string|null
     */
    public function getIDConcepto()
    {
        return $this->IDConcepto;
    }
    /**
     * Set IDConcepto value
     * @param string $iDConcepto
     * @return \StructType\EmisionMotorsSalidaOrdenCosto
     */
    public function setIDConcepto($iDConcepto = null)
    {
        // validation for constraint: string
        if (!is_null($iDConcepto) && !is_string($iDConcepto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDConcepto, true), gettype($iDConcepto)), __LINE__);
        }
        $this->IDConcepto = $iDConcepto;
        return $this;
    }
    /**
     * Get Vigencia value
     * @return string|null
     */
    public function getVigencia()
    {
        return $this->Vigencia;
    }
    /**
     * Set Vigencia value
     * @param string $vigencia
     * @return \StructType\EmisionMotorsSalidaOrdenCosto
     */
    public function setVigencia($vigencia = null)
    {
        // validation for constraint: string
        if (!is_null($vigencia) && !is_string($vigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vigencia, true), gettype($vigencia)), __LINE__);
        }
        $this->Vigencia = $vigencia;
        return $this;
    }
}
