<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Imprimir ServiceType
 * @subpackage Services
 */
class Imprimir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImprimirDocumentacion
     * Meta information extracted from the WSDL
     * - documentation: Devuelve toda la documentación disponible
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImprimirDocumentacion $parameters
     * @return \StructType\ImprimirDocumentacionResponse|bool
     */
    public function ImprimirDocumentacion(\StructType\ImprimirDocumentacion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImprimirDocumentacion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImprimirDocumentacionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
