<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consulta ServiceType
 * @subpackage Services
 */
class Consulta extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultaDocumentacionDenuncia
     * Meta information extracted from the WSDL
     * - documentation: Permite Consulta Documentacion de una Denuncia | Permite Consulta Documentacion de una Denuncia | Permite Consulta Documentacion de una Denuncia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultaDocumentacionDenuncia $parameters
     * @return \StructType\ConsultaDocumentacionDenunciaResponse|bool
     */
    public function ConsultaDocumentacionDenuncia(\StructType\ConsultaDocumentacionDenuncia $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultaDocumentacionDenuncia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultaDocumentacionDenunciaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
