<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for InsSubAreaEnum EnumType
 * @subpackage Enumerations
 */
class InsSubAreaEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Certificado de Retencion'
     * @return string 'Certificado de Retencion'
     */
    const VALUE_CERTIFICADO_DE_RETENCION = 'Certificado de Retencion';
    /**
     * Constant for value 'Informe de Cobranzas'
     * @return string 'Informe de Cobranzas'
     */
    const VALUE_INFORME_DE_COBRANZAS = 'Informe de Cobranzas';
    /**
     * Constant for value 'Detalle de Comisiones'
     * @return string 'Detalle de Comisiones'
     */
    const VALUE_DETALLE_DE_COMISIONES = 'Detalle de Comisiones';
    /**
     * Constant for value 'Deuda Vencida a mas de 90 dias'
     * @return string 'Deuda Vencida a mas de 90 dias'
     */
    const VALUE_DEUDA_VENCIDA_A_MAS_DE_90_DIAS = 'Deuda Vencida a mas de 90 dias';
    /**
     * Constant for value 'Deuda Vencida hasta 30 dias'
     * @return string 'Deuda Vencida hasta 30 dias'
     */
    const VALUE_DEUDA_VENCIDA_HASTA_30_DIAS = 'Deuda Vencida hasta 30 dias';
    /**
     * Constant for value 'Deuda Vencida hasta 90 dias'
     * @return string 'Deuda Vencida hasta 90 dias'
     */
    const VALUE_DEUDA_VENCIDA_HASTA_90_DIAS = 'Deuda Vencida hasta 90 dias';
    /**
     * Constant for value 'Deuda a Vencer Total'
     * @return string 'Deuda a Vencer Total'
     */
    const VALUE_DEUDA_A_VENCER_TOTAL = 'Deuda a Vencer Total';
    /**
     * Constant for value 'Deuda a Vencer en 30 dias'
     * @return string 'Deuda a Vencer en 30 dias'
     */
    const VALUE_DEUDA_A_VENCER_EN_30_DIAS = 'Deuda a Vencer en 30 dias';
    /**
     * Constant for value 'Mes anterior (Endosos)'
     * @return string 'Mes anterior (Endosos)'
     */
    const VALUE_MES_ANTERIOR_ENDOSOS = 'Mes anterior (Endosos)';
    /**
     * Constant for value 'Mes en curso (Endosos)'
     * @return string 'Mes en curso (Endosos)'
     */
    const VALUE_MES_EN_CURSO_ENDOSOS = 'Mes en curso (Endosos)';
    /**
     * Constant for value 'Ultimos 12 meses (Endosos)'
     * @return string 'Ultimos 12 meses (Endosos)'
     */
    const VALUE_ULTIMOS_12_MESES_ENDOSOS = 'Ultimos 12 meses (Endosos)';
    /**
     * Constant for value 'Ultimos 24 meses (Endosos)'
     * @return string 'Ultimos 24 meses (Endosos)'
     */
    const VALUE_ULTIMOS_24_MESES_ENDOSOS = 'Ultimos 24 meses (Endosos)';
    /**
     * Constant for value 'Ultimos 3 meses (Endosos)'
     * @return string 'Ultimos 3 meses (Endosos)'
     */
    const VALUE_ULTIMOS_3_MESES_ENDOSOS = 'Ultimos 3 meses (Endosos)';
    /**
     * Constant for value 'Ultimos 6 meses (Endosos)'
     * @return string 'Ultimos 6 meses (Endosos)'
     */
    const VALUE_ULTIMOS_6_MESES_ENDOSOS = 'Ultimos 6 meses (Endosos)';
    /**
     * Constant for value 'Anteultimo mes'
     * @return string 'Anteultimo mes'
     */
    const VALUE_ANTEULTIMO_MES = 'Anteultimo mes';
    /**
     * Constant for value 'Resumen al dia de la fecha'
     * @return string 'Resumen al dia de la fecha'
     */
    const VALUE_RESUMEN_AL_DIA_DE_LA_FECHA = 'Resumen al dia de la fecha';
    /**
     * Constant for value 'Ultimo mes'
     * @return string 'Ultimo mes'
     */
    const VALUE_ULTIMO_MES = 'Ultimo mes';
    /**
     * Constant for value 'Informe Pagos Realizados'
     * @return string 'Informe Pagos Realizados'
     */
    const VALUE_INFORME_PAGOS_REALIZADOS = 'Informe Pagos Realizados';
    /**
     * Constant for value 'Cartera Vigente (Produccion)'
     * @return string 'Cartera Vigente (Produccion)'
     */
    const VALUE_CARTERA_VIGENTE_PRODUCCION = 'Cartera Vigente (Produccion)';
    /**
     * Constant for value 'Mes anterior (Produccion)'
     * @return string 'Mes anterior (Produccion)'
     */
    const VALUE_MES_ANTERIOR_PRODUCCION = 'Mes anterior (Produccion)';
    /**
     * Constant for value 'Mes en curso (Produccion)'
     * @return string 'Mes en curso (Produccion)'
     */
    const VALUE_MES_EN_CURSO_PRODUCCION = 'Mes en curso (Produccion)';
    /**
     * Constant for value 'Ultimos 12 meses (Produccion)'
     * @return string 'Ultimos 12 meses (Produccion)'
     */
    const VALUE_ULTIMOS_12_MESES_PRODUCCION = 'Ultimos 12 meses (Produccion)';
    /**
     * Constant for value 'Ultimos 3 meses (Produccion)'
     * @return string 'Ultimos 3 meses (Produccion)'
     */
    const VALUE_ULTIMOS_3_MESES_PRODUCCION = 'Ultimos 3 meses (Produccion)';
    /**
     * Constant for value 'Ultimos 6 meses (Produccion)'
     * @return string 'Ultimos 6 meses (Produccion)'
     */
    const VALUE_ULTIMOS_6_MESES_PRODUCCION = 'Ultimos 6 meses (Produccion)';
    /**
     * Constant for value 'Mes anterior (PVAI)'
     * @return string 'Mes anterior (PVAI)'
     */
    const VALUE_MES_ANTERIOR_PVAI = 'Mes anterior (PVAI)';
    /**
     * Constant for value 'Mes en curso (PVAI)'
     * @return string 'Mes en curso (PVAI)'
     */
    const VALUE_MES_EN_CURSO_PVAI = 'Mes en curso (PVAI)';
    /**
     * Constant for value 'Mes en curso y anterior (PVAI)'
     * @return string 'Mes en curso y anterior (PVAI)'
     */
    const VALUE_MES_EN_CURSO_Y_ANTERIOR_PVAI = 'Mes en curso y anterior (PVAI)';
    /**
     * Constant for value 'Ultimos 12 meses (PVAI)'
     * @return string 'Ultimos 12 meses (PVAI)'
     */
    const VALUE_ULTIMOS_12_MESES_PVAI = 'Ultimos 12 meses (PVAI)';
    /**
     * Constant for value 'Ultimos 24 meses (PVAI)'
     * @return string 'Ultimos 24 meses (PVAI)'
     */
    const VALUE_ULTIMOS_24_MESES_PVAI = 'Ultimos 24 meses (PVAI)';
    /**
     * Constant for value 'Ultimos 3 meses (PVAI)'
     * @return string 'Ultimos 3 meses (PVAI)'
     */
    const VALUE_ULTIMOS_3_MESES_PVAI = 'Ultimos 3 meses (PVAI)';
    /**
     * Constant for value 'Ultimos 6 meses (PVAI)'
     * @return string 'Ultimos 6 meses (PVAI)'
     */
    const VALUE_ULTIMOS_6_MESES_PVAI = 'Ultimos 6 meses (PVAI)';
    /**
     * Constant for value 'Liquidacion Pend. Facturar'
     * @return string 'Liquidacion Pend. Facturar'
     */
    const VALUE_LIQUIDACION_PEND_FACTURAR = 'Liquidacion Pend. Facturar';
    /**
     * Constant for value 'Mes anterior'
     * @return string 'Mes anterior'
     */
    const VALUE_MES_ANTERIOR = 'Mes anterior';
    /**
     * Constant for value 'Mes en curso'
     * @return string 'Mes en curso'
     */
    const VALUE_MES_EN_CURSO = 'Mes en curso';
    /**
     * Constant for value 'Ultimos 3 Meses'
     * @return string 'Ultimos 3 Meses'
     */
    const VALUE_ULTIMOS_3_MESES = 'Ultimos 3 Meses';
    /**
     * Constant for value 'Mes anterior (PAFP)'
     * @return string 'Mes anterior (PAFP)'
     */
    const VALUE_MES_ANTERIOR_PAFP = 'Mes anterior (PAFP)';
    /**
     * Constant for value 'Mes en curso (PAFP)'
     * @return string 'Mes en curso (PAFP)'
     */
    const VALUE_MES_EN_CURSO_PAFP = 'Mes en curso (PAFP)';
    /**
     * Constant for value 'Ultimos 12 meses (PAFP)'
     * @return string 'Ultimos 12 meses (PAFP)'
     */
    const VALUE_ULTIMOS_12_MESES_PAFP = 'Ultimos 12 meses (PAFP)';
    /**
     * Constant for value 'Ultimos 24 meses (PAFP)'
     * @return string 'Ultimos 24 meses (PAFP)'
     */
    const VALUE_ULTIMOS_24_MESES_PAFP = 'Ultimos 24 meses (PAFP)';
    /**
     * Constant for value 'Ultimos 3 meses (PAFP)'
     * @return string 'Ultimos 3 meses (PAFP)'
     */
    const VALUE_ULTIMOS_3_MESES_PAFP = 'Ultimos 3 meses (PAFP)';
    /**
     * Constant for value 'Ultimos 6 meses (PAFP)'
     * @return string 'Ultimos 6 meses (PAFP)'
     */
    const VALUE_ULTIMOS_6_MESES_PAFP = 'Ultimos 6 meses (PAFP)';
    /**
     * Constant for value 'Mes anterior (No Renovadas)'
     * @return string 'Mes anterior (No Renovadas)'
     */
    const VALUE_MES_ANTERIOR_NO_RENOVADAS = 'Mes anterior (No Renovadas)';
    /**
     * Constant for value 'Mes en curso (No Renovadas)'
     * @return string 'Mes en curso (No Renovadas)'
     */
    const VALUE_MES_EN_CURSO_NO_RENOVADAS = 'Mes en curso (No Renovadas)';
    /**
     * Constant for value 'Ultimos 3 meses (No Renovadas)'
     * @return string 'Ultimos 3 meses (No Renovadas)'
     */
    const VALUE_ULTIMOS_3_MESES_NO_RENOVADAS = 'Ultimos 3 meses (No Renovadas)';
    /**
     * Constant for value 'Ultimos 6 meses (No Renovadas)'
     * @return string 'Ultimos 6 meses (No Renovadas)'
     */
    const VALUE_ULTIMOS_6_MESES_NO_RENOVADAS = 'Ultimos 6 meses (No Renovadas)';
    /**
     * Constant for value 'Mes anterior (PV)'
     * @return string 'Mes anterior (PV)'
     */
    const VALUE_MES_ANTERIOR_PV = 'Mes anterior (PV)';
    /**
     * Constant for value 'Mes en curso (PV)'
     * @return string 'Mes en curso (PV)'
     */
    const VALUE_MES_EN_CURSO_PV = 'Mes en curso (PV)';
    /**
     * Constant for value 'Ultimos 12 meses (PV)'
     * @return string 'Ultimos 12 meses (PV)'
     */
    const VALUE_ULTIMOS_12_MESES_PV = 'Ultimos 12 meses (PV)';
    /**
     * Constant for value 'Ultimos 24 meses(PV)'
     * @return string 'Ultimos 24 meses(PV)'
     */
    const VALUE_ULTIMOS_24_MESES_PV = 'Ultimos 24 meses(PV)';
    /**
     * Constant for value 'Ultimos 3 meses (PV)'
     * @return string 'Ultimos 3 meses (PV)'
     */
    const VALUE_ULTIMOS_3_MESES_PV = 'Ultimos 3 meses (PV)';
    /**
     * Constant for value 'Ultimos 6 meses (PV)'
     * @return string 'Ultimos 6 meses (PV)'
     */
    const VALUE_ULTIMOS_6_MESES_PV = 'Ultimos 6 meses (PV)';
    /**
     * Constant for value 'Ultimos 12 meses (R)'
     * @return string 'Ultimos 12 meses (R)'
     */
    const VALUE_ULTIMOS_12_MESES_R = 'Ultimos 12 meses (R)';
    /**
     * Constant for value 'Ultimos 24 meses (R)'
     * @return string 'Ultimos 24 meses (R)'
     */
    const VALUE_ULTIMOS_24_MESES_R = 'Ultimos 24 meses (R)';
    /**
     * Constant for value 'Ultimos 3 meses (R)'
     * @return string 'Ultimos 3 meses (R)'
     */
    const VALUE_ULTIMOS_3_MESES_R = 'Ultimos 3 meses (R)';
    /**
     * Constant for value 'Ultimos 30 dias (R)'
     * @return string 'Ultimos 30 dias (R)'
     */
    const VALUE_ULTIMOS_30_DIAS_R = 'Ultimos 30 dias (R)';
    /**
     * Constant for value 'Ultimos 6 meses (R)'
     * @return string 'Ultimos 6 meses (R)'
     */
    const VALUE_ULTIMOS_6_MESES_R = 'Ultimos 6 meses (R)';
    /**
     * Constant for value 'Automatica'
     * @return string 'Automatica'
     */
    const VALUE_AUTOMATICA = 'Automatica';
    /**
     * Constant for value 'Automatica Cuatrimestral'
     * @return string 'Automatica Cuatrimestral'
     */
    const VALUE_AUTOMATICA_CUATRIMESTRAL = 'Automatica Cuatrimestral';
    /**
     * Constant for value 'Manual'
     * @return string 'Manual'
     */
    const VALUE_MANUAL = 'Manual';
    /**
     * Constant for value 'Seguimiento de Boleta de Pago'
     * @return string 'Seguimiento de Boleta de Pago'
     */
    const VALUE_SEGUIMIENTO_DE_BOLETA_DE_PAGO = 'Seguimiento de Boleta de Pago';
    /**
     * Constant for value 'Mes anterior (S)'
     * @return string 'Mes anterior (S)'
     */
    const VALUE_MES_ANTERIOR_S = 'Mes anterior (S)';
    /**
     * Constant for value 'Mes en curso (S)'
     * @return string 'Mes en curso (S)'
     */
    const VALUE_MES_EN_CURSO_S = 'Mes en curso (S)';
    /**
     * Constant for value 'Ultimos 12 Meses (S)'
     * @return string 'Ultimos 12 Meses (S)'
     */
    const VALUE_ULTIMOS_12_MESES_S = 'Ultimos 12 Meses (S)';
    /**
     * Constant for value 'Ultimos 24 meses (S)'
     * @return string 'Ultimos 24 meses (S)'
     */
    const VALUE_ULTIMOS_24_MESES_S = 'Ultimos 24 meses (S)';
    /**
     * Constant for value 'Ultimos 3 Meses (S)'
     * @return string 'Ultimos 3 Meses (S)'
     */
    const VALUE_ULTIMOS_3_MESES_S = 'Ultimos 3 Meses (S)';
    /**
     * Constant for value 'Ultimos 6 Meses (S)'
     * @return string 'Ultimos 6 Meses (S)'
     */
    const VALUE_ULTIMOS_6_MESES_S = 'Ultimos 6 Meses (S)';
    /**
     * Constant for value 'Totales cuenta corriente'
     * @return string 'Totales cuenta corriente'
     */
    const VALUE_TOTALES_CUENTA_CORRIENTE = 'Totales cuenta corriente';
    /**
     * Return allowed values
     * @uses self::VALUE_CERTIFICADO_DE_RETENCION
     * @uses self::VALUE_INFORME_DE_COBRANZAS
     * @uses self::VALUE_DETALLE_DE_COMISIONES
     * @uses self::VALUE_DEUDA_VENCIDA_A_MAS_DE_90_DIAS
     * @uses self::VALUE_DEUDA_VENCIDA_HASTA_30_DIAS
     * @uses self::VALUE_DEUDA_VENCIDA_HASTA_90_DIAS
     * @uses self::VALUE_DEUDA_A_VENCER_TOTAL
     * @uses self::VALUE_DEUDA_A_VENCER_EN_30_DIAS
     * @uses self::VALUE_MES_ANTERIOR_ENDOSOS
     * @uses self::VALUE_MES_EN_CURSO_ENDOSOS
     * @uses self::VALUE_ULTIMOS_12_MESES_ENDOSOS
     * @uses self::VALUE_ULTIMOS_24_MESES_ENDOSOS
     * @uses self::VALUE_ULTIMOS_3_MESES_ENDOSOS
     * @uses self::VALUE_ULTIMOS_6_MESES_ENDOSOS
     * @uses self::VALUE_ANTEULTIMO_MES
     * @uses self::VALUE_RESUMEN_AL_DIA_DE_LA_FECHA
     * @uses self::VALUE_ULTIMO_MES
     * @uses self::VALUE_INFORME_PAGOS_REALIZADOS
     * @uses self::VALUE_CARTERA_VIGENTE_PRODUCCION
     * @uses self::VALUE_MES_ANTERIOR_PRODUCCION
     * @uses self::VALUE_MES_EN_CURSO_PRODUCCION
     * @uses self::VALUE_ULTIMOS_12_MESES_PRODUCCION
     * @uses self::VALUE_ULTIMOS_3_MESES_PRODUCCION
     * @uses self::VALUE_ULTIMOS_6_MESES_PRODUCCION
     * @uses self::VALUE_MES_ANTERIOR_PVAI
     * @uses self::VALUE_MES_EN_CURSO_PVAI
     * @uses self::VALUE_MES_EN_CURSO_Y_ANTERIOR_PVAI
     * @uses self::VALUE_ULTIMOS_12_MESES_PVAI
     * @uses self::VALUE_ULTIMOS_24_MESES_PVAI
     * @uses self::VALUE_ULTIMOS_3_MESES_PVAI
     * @uses self::VALUE_ULTIMOS_6_MESES_PVAI
     * @uses self::VALUE_LIQUIDACION_PEND_FACTURAR
     * @uses self::VALUE_MES_ANTERIOR
     * @uses self::VALUE_MES_EN_CURSO
     * @uses self::VALUE_ULTIMOS_3_MESES
     * @uses self::VALUE_MES_ANTERIOR_PAFP
     * @uses self::VALUE_MES_EN_CURSO_PAFP
     * @uses self::VALUE_ULTIMOS_12_MESES_PAFP
     * @uses self::VALUE_ULTIMOS_24_MESES_PAFP
     * @uses self::VALUE_ULTIMOS_3_MESES_PAFP
     * @uses self::VALUE_ULTIMOS_6_MESES_PAFP
     * @uses self::VALUE_MES_ANTERIOR_NO_RENOVADAS
     * @uses self::VALUE_MES_EN_CURSO_NO_RENOVADAS
     * @uses self::VALUE_ULTIMOS_3_MESES_NO_RENOVADAS
     * @uses self::VALUE_ULTIMOS_6_MESES_NO_RENOVADAS
     * @uses self::VALUE_MES_ANTERIOR_PV
     * @uses self::VALUE_MES_EN_CURSO_PV
     * @uses self::VALUE_ULTIMOS_12_MESES_PV
     * @uses self::VALUE_ULTIMOS_24_MESES_PV
     * @uses self::VALUE_ULTIMOS_3_MESES_PV
     * @uses self::VALUE_ULTIMOS_6_MESES_PV
     * @uses self::VALUE_ULTIMOS_12_MESES_R
     * @uses self::VALUE_ULTIMOS_24_MESES_R
     * @uses self::VALUE_ULTIMOS_3_MESES_R
     * @uses self::VALUE_ULTIMOS_30_DIAS_R
     * @uses self::VALUE_ULTIMOS_6_MESES_R
     * @uses self::VALUE_AUTOMATICA
     * @uses self::VALUE_AUTOMATICA_CUATRIMESTRAL
     * @uses self::VALUE_MANUAL
     * @uses self::VALUE_SEGUIMIENTO_DE_BOLETA_DE_PAGO
     * @uses self::VALUE_MES_ANTERIOR_S
     * @uses self::VALUE_MES_EN_CURSO_S
     * @uses self::VALUE_ULTIMOS_12_MESES_S
     * @uses self::VALUE_ULTIMOS_24_MESES_S
     * @uses self::VALUE_ULTIMOS_3_MESES_S
     * @uses self::VALUE_ULTIMOS_6_MESES_S
     * @uses self::VALUE_TOTALES_CUENTA_CORRIENTE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERTIFICADO_DE_RETENCION,
            self::VALUE_INFORME_DE_COBRANZAS,
            self::VALUE_DETALLE_DE_COMISIONES,
            self::VALUE_DEUDA_VENCIDA_A_MAS_DE_90_DIAS,
            self::VALUE_DEUDA_VENCIDA_HASTA_30_DIAS,
            self::VALUE_DEUDA_VENCIDA_HASTA_90_DIAS,
            self::VALUE_DEUDA_A_VENCER_TOTAL,
            self::VALUE_DEUDA_A_VENCER_EN_30_DIAS,
            self::VALUE_MES_ANTERIOR_ENDOSOS,
            self::VALUE_MES_EN_CURSO_ENDOSOS,
            self::VALUE_ULTIMOS_12_MESES_ENDOSOS,
            self::VALUE_ULTIMOS_24_MESES_ENDOSOS,
            self::VALUE_ULTIMOS_3_MESES_ENDOSOS,
            self::VALUE_ULTIMOS_6_MESES_ENDOSOS,
            self::VALUE_ANTEULTIMO_MES,
            self::VALUE_RESUMEN_AL_DIA_DE_LA_FECHA,
            self::VALUE_ULTIMO_MES,
            self::VALUE_INFORME_PAGOS_REALIZADOS,
            self::VALUE_CARTERA_VIGENTE_PRODUCCION,
            self::VALUE_MES_ANTERIOR_PRODUCCION,
            self::VALUE_MES_EN_CURSO_PRODUCCION,
            self::VALUE_ULTIMOS_12_MESES_PRODUCCION,
            self::VALUE_ULTIMOS_3_MESES_PRODUCCION,
            self::VALUE_ULTIMOS_6_MESES_PRODUCCION,
            self::VALUE_MES_ANTERIOR_PVAI,
            self::VALUE_MES_EN_CURSO_PVAI,
            self::VALUE_MES_EN_CURSO_Y_ANTERIOR_PVAI,
            self::VALUE_ULTIMOS_12_MESES_PVAI,
            self::VALUE_ULTIMOS_24_MESES_PVAI,
            self::VALUE_ULTIMOS_3_MESES_PVAI,
            self::VALUE_ULTIMOS_6_MESES_PVAI,
            self::VALUE_LIQUIDACION_PEND_FACTURAR,
            self::VALUE_MES_ANTERIOR,
            self::VALUE_MES_EN_CURSO,
            self::VALUE_ULTIMOS_3_MESES,
            self::VALUE_MES_ANTERIOR_PAFP,
            self::VALUE_MES_EN_CURSO_PAFP,
            self::VALUE_ULTIMOS_12_MESES_PAFP,
            self::VALUE_ULTIMOS_24_MESES_PAFP,
            self::VALUE_ULTIMOS_3_MESES_PAFP,
            self::VALUE_ULTIMOS_6_MESES_PAFP,
            self::VALUE_MES_ANTERIOR_NO_RENOVADAS,
            self::VALUE_MES_EN_CURSO_NO_RENOVADAS,
            self::VALUE_ULTIMOS_3_MESES_NO_RENOVADAS,
            self::VALUE_ULTIMOS_6_MESES_NO_RENOVADAS,
            self::VALUE_MES_ANTERIOR_PV,
            self::VALUE_MES_EN_CURSO_PV,
            self::VALUE_ULTIMOS_12_MESES_PV,
            self::VALUE_ULTIMOS_24_MESES_PV,
            self::VALUE_ULTIMOS_3_MESES_PV,
            self::VALUE_ULTIMOS_6_MESES_PV,
            self::VALUE_ULTIMOS_12_MESES_R,
            self::VALUE_ULTIMOS_24_MESES_R,
            self::VALUE_ULTIMOS_3_MESES_R,
            self::VALUE_ULTIMOS_30_DIAS_R,
            self::VALUE_ULTIMOS_6_MESES_R,
            self::VALUE_AUTOMATICA,
            self::VALUE_AUTOMATICA_CUATRIMESTRAL,
            self::VALUE_MANUAL,
            self::VALUE_SEGUIMIENTO_DE_BOLETA_DE_PAGO,
            self::VALUE_MES_ANTERIOR_S,
            self::VALUE_MES_EN_CURSO_S,
            self::VALUE_ULTIMOS_12_MESES_S,
            self::VALUE_ULTIMOS_24_MESES_S,
            self::VALUE_ULTIMOS_3_MESES_S,
            self::VALUE_ULTIMOS_6_MESES_S,
            self::VALUE_TOTALES_CUENTA_CORRIENTE,
        );
    }
}
