<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalOUTCotizacionHogarItem StructType
 * @subpackage Structs
 */
class DocCanalOUTCotizacionHogarItem extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The Orden
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Orden;
    /**
     * The AsistenciaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AsistenciaID;
    /**
     * The PaqueteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PaqueteID;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The IDLocalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDLocalidad;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The Costos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto
     */
    public $Costos;
    /**
     * The Coberturas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemCobertura
     */
    public $Coberturas;
    /**
     * The TipoScoringValores
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemTiposcoringvalor
     */
    public $TipoScoringValores;
    /**
     * Constructor method for DocCanalOUTCotizacionHogarItem
     * @uses DocCanalOUTCotizacionHogarItem::setItemID()
     * @uses DocCanalOUTCotizacionHogarItem::setOrdenID()
     * @uses DocCanalOUTCotizacionHogarItem::setOrden()
     * @uses DocCanalOUTCotizacionHogarItem::setAsistenciaID()
     * @uses DocCanalOUTCotizacionHogarItem::setPaqueteID()
     * @uses DocCanalOUTCotizacionHogarItem::setIDProvincia()
     * @uses DocCanalOUTCotizacionHogarItem::setIDLocalidad()
     * @uses DocCanalOUTCotizacionHogarItem::setCodigoPostal()
     * @uses DocCanalOUTCotizacionHogarItem::setIDCondicionIVA()
     * @uses DocCanalOUTCotizacionHogarItem::setCostos()
     * @uses DocCanalOUTCotizacionHogarItem::setCoberturas()
     * @uses DocCanalOUTCotizacionHogarItem::setTipoScoringValores()
     * @param int $itemID
     * @param int $ordenID
     * @param int $orden
     * @param int $asistenciaID
     * @param int $paqueteID
     * @param string $iDProvincia
     * @param string $iDLocalidad
     * @param string $codigoPostal
     * @param string $iDCondicionIVA
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemCobertura $coberturas
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemTiposcoringvalor $tipoScoringValores
     */
    public function __construct($itemID = null, $ordenID = null, $orden = null, $asistenciaID = null, $paqueteID = null, $iDProvincia = null, $iDLocalidad = null, $codigoPostal = null, $iDCondicionIVA = null, \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos = null, \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemCobertura $coberturas = null, \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemTiposcoringvalor $tipoScoringValores = null)
    {
        $this
            ->setItemID($itemID)
            ->setOrdenID($ordenID)
            ->setOrden($orden)
            ->setAsistenciaID($asistenciaID)
            ->setPaqueteID($paqueteID)
            ->setIDProvincia($iDProvincia)
            ->setIDLocalidad($iDLocalidad)
            ->setCodigoPostal($codigoPostal)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setCostos($costos)
            ->setCoberturas($coberturas)
            ->setTipoScoringValores($tipoScoringValores);
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get Orden value
     * @return int
     */
    public function getOrden()
    {
        return $this->Orden;
    }
    /**
     * Set Orden value
     * @param int $orden
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setOrden($orden = null)
    {
        // validation for constraint: int
        if (!is_null($orden) && !(is_int($orden) || ctype_digit($orden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orden, true), gettype($orden)), __LINE__);
        }
        $this->Orden = $orden;
        return $this;
    }
    /**
     * Get AsistenciaID value
     * @return int
     */
    public function getAsistenciaID()
    {
        return $this->AsistenciaID;
    }
    /**
     * Set AsistenciaID value
     * @param int $asistenciaID
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setAsistenciaID($asistenciaID = null)
    {
        // validation for constraint: int
        if (!is_null($asistenciaID) && !(is_int($asistenciaID) || ctype_digit($asistenciaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asistenciaID, true), gettype($asistenciaID)), __LINE__);
        }
        $this->AsistenciaID = $asistenciaID;
        return $this;
    }
    /**
     * Get PaqueteID value
     * @return int
     */
    public function getPaqueteID()
    {
        return $this->PaqueteID;
    }
    /**
     * Set PaqueteID value
     * @param int $paqueteID
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setPaqueteID($paqueteID = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteID) && !(is_int($paqueteID) || ctype_digit($paqueteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteID, true), gettype($paqueteID)), __LINE__);
        }
        $this->PaqueteID = $paqueteID;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get IDLocalidad value
     * @return string|null
     */
    public function getIDLocalidad()
    {
        return $this->IDLocalidad;
    }
    /**
     * Set IDLocalidad value
     * @param string $iDLocalidad
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setIDLocalidad($iDLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($iDLocalidad) && !is_string($iDLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDLocalidad, true), gettype($iDLocalidad)), __LINE__);
        }
        $this->IDLocalidad = $iDLocalidad;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get Costos value
     * @return \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto|null
     */
    public function getCostos()
    {
        return $this->Costos;
    }
    /**
     * Set Costos value
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setCostos(\ArrayType\ArrayOfDocCanalOUTCotizacionHogarOrdenCosto $costos = null)
    {
        $this->Costos = $costos;
        return $this;
    }
    /**
     * Get Coberturas value
     * @return \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemCobertura|null
     */
    public function getCoberturas()
    {
        return $this->Coberturas;
    }
    /**
     * Set Coberturas value
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemCobertura $coberturas
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setCoberturas(\ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemCobertura $coberturas = null)
    {
        $this->Coberturas = $coberturas;
        return $this;
    }
    /**
     * Get TipoScoringValores value
     * @return \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemTiposcoringvalor|null
     */
    public function getTipoScoringValores()
    {
        return $this->TipoScoringValores;
    }
    /**
     * Set TipoScoringValores value
     * @param \ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemTiposcoringvalor $tipoScoringValores
     * @return \StructType\DocCanalOUTCotizacionHogarItem
     */
    public function setTipoScoringValores(\ArrayType\ArrayOfDocCanalOUTCotizacionHogarItemTiposcoringvalor $tipoScoringValores = null)
    {
        $this->TipoScoringValores = $tipoScoringValores;
        return $this;
    }
}
