<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalINGrabadoPresupuestoMotorOrden StructType
 * @subpackage Structs
 */
class DocCanalINGrabadoPresupuestoMotorOrden extends AbstractStructBase
{
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The FamiliaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FamiliaID;
    /**
     * The SociedadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SociedadID;
    /**
     * The PlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PlanID;
    /**
     * The EsRenovacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $EsRenovacion;
    /**
     * The Comision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Comision;
    /**
     * The BonificacionComercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionComercial;
    /**
     * The BonificacionViacobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionViacobro;
    /**
     * The FechaVigenciaDesde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaDesde;
    /**
     * The FechaVigenciaHasta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaHasta;
    /**
     * The DistribucionComisionOrganizador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistribucionComisionOrganizador;
    /**
     * The DistribucionComisionProductor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistribucionComisionProductor;
    /**
     * The RecibePolizaElectronica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RecibePolizaElectronica;
    /**
     * The RecibeDocumentacionElectronica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RecibeDocumentacionElectronica;
    /**
     * The IDBeneficio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDBeneficio;
    /**
     * The IDRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRiesgo;
    /**
     * The IDTipoPoliza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPoliza;
    /**
     * The IDTipoPersona
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersona;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The NroPolizaAnterior
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NroPolizaAnterior;
    /**
     * The IDPersonaAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaAsegurado;
    /**
     * The IDPersonaTomador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaTomador;
    /**
     * The IDViaCobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDViaCobro;
    /**
     * The IDInstitucionFinanciera
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDInstitucionFinanciera;
    /**
     * The IDPlanPago
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPlanPago;
    /**
     * The IDProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProducto;
    /**
     * The IDSegmento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDSegmento;
    /**
     * The NumeroTarjeta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroTarjeta;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mail;
    /**
     * The CantItem
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CantItem;
    /**
     * The Canales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorOrdenCanal
     */
    public $Canales;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorItem
     */
    public $Items;
    /**
     * The PersonasCanal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorPersonaCanal
     */
    public $PersonasCanal;
    /**
     * The ExcepcionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionItem
     */
    public $ExcepcionItem;
    /**
     * The ExcepcionOrden
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionOrden
     */
    public $ExcepcionOrden;
    /**
     * Constructor method for DocCanalINGrabadoPresupuestoMotorOrden
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setOrdenID()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setFamiliaID()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setSociedadID()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setPlanID()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setEsRenovacion()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setComision()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setBonificacionComercial()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setBonificacionViacobro()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setFechaVigenciaDesde()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setFechaVigenciaHasta()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setDistribucionComisionOrganizador()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setDistribucionComisionProductor()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setRecibePolizaElectronica()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setRecibeDocumentacionElectronica()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDBeneficio()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDRiesgo()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDTipoPoliza()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDTipoPersona()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDCondicionIVA()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setNroPolizaAnterior()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDPersonaAsegurado()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDPersonaTomador()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDViaCobro()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDInstitucionFinanciera()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDPlanPago()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDProducto()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setIDSegmento()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setNumeroTarjeta()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setMail()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setCantItem()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setCanales()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setItems()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setPersonasCanal()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setExcepcionItem()
     * @uses DocCanalINGrabadoPresupuestoMotorOrden::setExcepcionOrden()
     * @param int $ordenID
     * @param int $familiaID
     * @param int $sociedadID
     * @param int $planID
     * @param bool $esRenovacion
     * @param float $comision
     * @param float $bonificacionComercial
     * @param float $bonificacionViacobro
     * @param string $fechaVigenciaDesde
     * @param string $fechaVigenciaHasta
     * @param float $distribucionComisionOrganizador
     * @param float $distribucionComisionProductor
     * @param bool $recibePolizaElectronica
     * @param bool $recibeDocumentacionElectronica
     * @param int $iDBeneficio
     * @param string $iDRiesgo
     * @param string $iDTipoPoliza
     * @param string $iDTipoPersona
     * @param string $iDCondicionIVA
     * @param string $nroPolizaAnterior
     * @param string $iDPersonaAsegurado
     * @param string $iDPersonaTomador
     * @param string $iDViaCobro
     * @param string $iDInstitucionFinanciera
     * @param string $iDPlanPago
     * @param string $iDProducto
     * @param string $iDSegmento
     * @param string $numeroTarjeta
     * @param string $mail
     * @param int $cantItem
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorOrdenCanal $canales
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorItem $items
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorPersonaCanal $personasCanal
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionItem $excepcionItem
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionOrden $excepcionOrden
     */
    public function __construct($ordenID = null, $familiaID = null, $sociedadID = null, $planID = null, $esRenovacion = null, $comision = null, $bonificacionComercial = null, $bonificacionViacobro = null, $fechaVigenciaDesde = null, $fechaVigenciaHasta = null, $distribucionComisionOrganizador = null, $distribucionComisionProductor = null, $recibePolizaElectronica = null, $recibeDocumentacionElectronica = null, $iDBeneficio = null, $iDRiesgo = null, $iDTipoPoliza = null, $iDTipoPersona = null, $iDCondicionIVA = null, $nroPolizaAnterior = null, $iDPersonaAsegurado = null, $iDPersonaTomador = null, $iDViaCobro = null, $iDInstitucionFinanciera = null, $iDPlanPago = null, $iDProducto = null, $iDSegmento = null, $numeroTarjeta = null, $mail = null, $cantItem = 0, \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorOrdenCanal $canales = null, \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorItem $items = null, \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorPersonaCanal $personasCanal = null, \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionItem $excepcionItem = null, \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionOrden $excepcionOrden = null)
    {
        $this
            ->setOrdenID($ordenID)
            ->setFamiliaID($familiaID)
            ->setSociedadID($sociedadID)
            ->setPlanID($planID)
            ->setEsRenovacion($esRenovacion)
            ->setComision($comision)
            ->setBonificacionComercial($bonificacionComercial)
            ->setBonificacionViacobro($bonificacionViacobro)
            ->setFechaVigenciaDesde($fechaVigenciaDesde)
            ->setFechaVigenciaHasta($fechaVigenciaHasta)
            ->setDistribucionComisionOrganizador($distribucionComisionOrganizador)
            ->setDistribucionComisionProductor($distribucionComisionProductor)
            ->setRecibePolizaElectronica($recibePolizaElectronica)
            ->setRecibeDocumentacionElectronica($recibeDocumentacionElectronica)
            ->setIDBeneficio($iDBeneficio)
            ->setIDRiesgo($iDRiesgo)
            ->setIDTipoPoliza($iDTipoPoliza)
            ->setIDTipoPersona($iDTipoPersona)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setNroPolizaAnterior($nroPolizaAnterior)
            ->setIDPersonaAsegurado($iDPersonaAsegurado)
            ->setIDPersonaTomador($iDPersonaTomador)
            ->setIDViaCobro($iDViaCobro)
            ->setIDInstitucionFinanciera($iDInstitucionFinanciera)
            ->setIDPlanPago($iDPlanPago)
            ->setIDProducto($iDProducto)
            ->setIDSegmento($iDSegmento)
            ->setNumeroTarjeta($numeroTarjeta)
            ->setMail($mail)
            ->setCantItem($cantItem)
            ->setCanales($canales)
            ->setItems($items)
            ->setPersonasCanal($personasCanal)
            ->setExcepcionItem($excepcionItem)
            ->setExcepcionOrden($excepcionOrden);
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get FamiliaID value
     * @return int
     */
    public function getFamiliaID()
    {
        return $this->FamiliaID;
    }
    /**
     * Set FamiliaID value
     * @param int $familiaID
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setFamiliaID($familiaID = null)
    {
        // validation for constraint: int
        if (!is_null($familiaID) && !(is_int($familiaID) || ctype_digit($familiaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($familiaID, true), gettype($familiaID)), __LINE__);
        }
        $this->FamiliaID = $familiaID;
        return $this;
    }
    /**
     * Get SociedadID value
     * @return int
     */
    public function getSociedadID()
    {
        return $this->SociedadID;
    }
    /**
     * Set SociedadID value
     * @param int $sociedadID
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setSociedadID($sociedadID = null)
    {
        // validation for constraint: int
        if (!is_null($sociedadID) && !(is_int($sociedadID) || ctype_digit($sociedadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sociedadID, true), gettype($sociedadID)), __LINE__);
        }
        $this->SociedadID = $sociedadID;
        return $this;
    }
    /**
     * Get PlanID value
     * @return int
     */
    public function getPlanID()
    {
        return $this->PlanID;
    }
    /**
     * Set PlanID value
     * @param int $planID
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setPlanID($planID = null)
    {
        // validation for constraint: int
        if (!is_null($planID) && !(is_int($planID) || ctype_digit($planID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($planID, true), gettype($planID)), __LINE__);
        }
        $this->PlanID = $planID;
        return $this;
    }
    /**
     * Get EsRenovacion value
     * @return bool
     */
    public function getEsRenovacion()
    {
        return $this->EsRenovacion;
    }
    /**
     * Set EsRenovacion value
     * @param bool $esRenovacion
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setEsRenovacion($esRenovacion = null)
    {
        // validation for constraint: boolean
        if (!is_null($esRenovacion) && !is_bool($esRenovacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esRenovacion, true), gettype($esRenovacion)), __LINE__);
        }
        $this->EsRenovacion = $esRenovacion;
        return $this;
    }
    /**
     * Get Comision value
     * @return float
     */
    public function getComision()
    {
        return $this->Comision;
    }
    /**
     * Set Comision value
     * @param float $comision
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setComision($comision = null)
    {
        // validation for constraint: float
        if (!is_null($comision) && !(is_float($comision) || is_numeric($comision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($comision, true), gettype($comision)), __LINE__);
        }
        $this->Comision = $comision;
        return $this;
    }
    /**
     * Get BonificacionComercial value
     * @return float
     */
    public function getBonificacionComercial()
    {
        return $this->BonificacionComercial;
    }
    /**
     * Set BonificacionComercial value
     * @param float $bonificacionComercial
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setBonificacionComercial($bonificacionComercial = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComercial) && !(is_float($bonificacionComercial) || is_numeric($bonificacionComercial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComercial, true), gettype($bonificacionComercial)), __LINE__);
        }
        $this->BonificacionComercial = $bonificacionComercial;
        return $this;
    }
    /**
     * Get BonificacionViacobro value
     * @return float
     */
    public function getBonificacionViacobro()
    {
        return $this->BonificacionViacobro;
    }
    /**
     * Set BonificacionViacobro value
     * @param float $bonificacionViacobro
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setBonificacionViacobro($bonificacionViacobro = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionViacobro) && !(is_float($bonificacionViacobro) || is_numeric($bonificacionViacobro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionViacobro, true), gettype($bonificacionViacobro)), __LINE__);
        }
        $this->BonificacionViacobro = $bonificacionViacobro;
        return $this;
    }
    /**
     * Get FechaVigenciaDesde value
     * @return string
     */
    public function getFechaVigenciaDesde()
    {
        return $this->FechaVigenciaDesde;
    }
    /**
     * Set FechaVigenciaDesde value
     * @param string $fechaVigenciaDesde
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setFechaVigenciaDesde($fechaVigenciaDesde = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaDesde) && !is_string($fechaVigenciaDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaDesde, true), gettype($fechaVigenciaDesde)), __LINE__);
        }
        $this->FechaVigenciaDesde = $fechaVigenciaDesde;
        return $this;
    }
    /**
     * Get FechaVigenciaHasta value
     * @return string
     */
    public function getFechaVigenciaHasta()
    {
        return $this->FechaVigenciaHasta;
    }
    /**
     * Set FechaVigenciaHasta value
     * @param string $fechaVigenciaHasta
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setFechaVigenciaHasta($fechaVigenciaHasta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaHasta) && !is_string($fechaVigenciaHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaHasta, true), gettype($fechaVigenciaHasta)), __LINE__);
        }
        $this->FechaVigenciaHasta = $fechaVigenciaHasta;
        return $this;
    }
    /**
     * Get DistribucionComisionOrganizador value
     * @return float
     */
    public function getDistribucionComisionOrganizador()
    {
        return $this->DistribucionComisionOrganizador;
    }
    /**
     * Set DistribucionComisionOrganizador value
     * @param float $distribucionComisionOrganizador
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setDistribucionComisionOrganizador($distribucionComisionOrganizador = null)
    {
        // validation for constraint: float
        if (!is_null($distribucionComisionOrganizador) && !(is_float($distribucionComisionOrganizador) || is_numeric($distribucionComisionOrganizador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distribucionComisionOrganizador, true), gettype($distribucionComisionOrganizador)), __LINE__);
        }
        $this->DistribucionComisionOrganizador = $distribucionComisionOrganizador;
        return $this;
    }
    /**
     * Get DistribucionComisionProductor value
     * @return float
     */
    public function getDistribucionComisionProductor()
    {
        return $this->DistribucionComisionProductor;
    }
    /**
     * Set DistribucionComisionProductor value
     * @param float $distribucionComisionProductor
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setDistribucionComisionProductor($distribucionComisionProductor = null)
    {
        // validation for constraint: float
        if (!is_null($distribucionComisionProductor) && !(is_float($distribucionComisionProductor) || is_numeric($distribucionComisionProductor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distribucionComisionProductor, true), gettype($distribucionComisionProductor)), __LINE__);
        }
        $this->DistribucionComisionProductor = $distribucionComisionProductor;
        return $this;
    }
    /**
     * Get RecibePolizaElectronica value
     * @return bool
     */
    public function getRecibePolizaElectronica()
    {
        return $this->RecibePolizaElectronica;
    }
    /**
     * Set RecibePolizaElectronica value
     * @param bool $recibePolizaElectronica
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setRecibePolizaElectronica($recibePolizaElectronica = null)
    {
        // validation for constraint: boolean
        if (!is_null($recibePolizaElectronica) && !is_bool($recibePolizaElectronica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recibePolizaElectronica, true), gettype($recibePolizaElectronica)), __LINE__);
        }
        $this->RecibePolizaElectronica = $recibePolizaElectronica;
        return $this;
    }
    /**
     * Get RecibeDocumentacionElectronica value
     * @return bool
     */
    public function getRecibeDocumentacionElectronica()
    {
        return $this->RecibeDocumentacionElectronica;
    }
    /**
     * Set RecibeDocumentacionElectronica value
     * @param bool $recibeDocumentacionElectronica
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setRecibeDocumentacionElectronica($recibeDocumentacionElectronica = null)
    {
        // validation for constraint: boolean
        if (!is_null($recibeDocumentacionElectronica) && !is_bool($recibeDocumentacionElectronica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recibeDocumentacionElectronica, true), gettype($recibeDocumentacionElectronica)), __LINE__);
        }
        $this->RecibeDocumentacionElectronica = $recibeDocumentacionElectronica;
        return $this;
    }
    /**
     * Get IDBeneficio value
     * @return int
     */
    public function getIDBeneficio()
    {
        return $this->IDBeneficio;
    }
    /**
     * Set IDBeneficio value
     * @param int $iDBeneficio
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDBeneficio($iDBeneficio = null)
    {
        // validation for constraint: int
        if (!is_null($iDBeneficio) && !(is_int($iDBeneficio) || ctype_digit($iDBeneficio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDBeneficio, true), gettype($iDBeneficio)), __LINE__);
        }
        $this->IDBeneficio = $iDBeneficio;
        return $this;
    }
    /**
     * Get IDRiesgo value
     * @return string|null
     */
    public function getIDRiesgo()
    {
        return $this->IDRiesgo;
    }
    /**
     * Set IDRiesgo value
     * @param string $iDRiesgo
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDRiesgo($iDRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDRiesgo) && !is_string($iDRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRiesgo, true), gettype($iDRiesgo)), __LINE__);
        }
        $this->IDRiesgo = $iDRiesgo;
        return $this;
    }
    /**
     * Get IDTipoPoliza value
     * @return string|null
     */
    public function getIDTipoPoliza()
    {
        return $this->IDTipoPoliza;
    }
    /**
     * Set IDTipoPoliza value
     * @param string $iDTipoPoliza
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDTipoPoliza($iDTipoPoliza = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPoliza) && !is_string($iDTipoPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPoliza, true), gettype($iDTipoPoliza)), __LINE__);
        }
        $this->IDTipoPoliza = $iDTipoPoliza;
        return $this;
    }
    /**
     * Get IDTipoPersona value
     * @return string|null
     */
    public function getIDTipoPersona()
    {
        return $this->IDTipoPersona;
    }
    /**
     * Set IDTipoPersona value
     * @param string $iDTipoPersona
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDTipoPersona($iDTipoPersona = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersona) && !is_string($iDTipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersona, true), gettype($iDTipoPersona)), __LINE__);
        }
        $this->IDTipoPersona = $iDTipoPersona;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get NroPolizaAnterior value
     * @return string|null
     */
    public function getNroPolizaAnterior()
    {
        return $this->NroPolizaAnterior;
    }
    /**
     * Set NroPolizaAnterior value
     * @param string $nroPolizaAnterior
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setNroPolizaAnterior($nroPolizaAnterior = null)
    {
        // validation for constraint: string
        if (!is_null($nroPolizaAnterior) && !is_string($nroPolizaAnterior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nroPolizaAnterior, true), gettype($nroPolizaAnterior)), __LINE__);
        }
        $this->NroPolizaAnterior = $nroPolizaAnterior;
        return $this;
    }
    /**
     * Get IDPersonaAsegurado value
     * @return string|null
     */
    public function getIDPersonaAsegurado()
    {
        return $this->IDPersonaAsegurado;
    }
    /**
     * Set IDPersonaAsegurado value
     * @param string $iDPersonaAsegurado
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDPersonaAsegurado($iDPersonaAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaAsegurado) && !is_string($iDPersonaAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaAsegurado, true), gettype($iDPersonaAsegurado)), __LINE__);
        }
        $this->IDPersonaAsegurado = $iDPersonaAsegurado;
        return $this;
    }
    /**
     * Get IDPersonaTomador value
     * @return string|null
     */
    public function getIDPersonaTomador()
    {
        return $this->IDPersonaTomador;
    }
    /**
     * Set IDPersonaTomador value
     * @param string $iDPersonaTomador
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDPersonaTomador($iDPersonaTomador = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaTomador) && !is_string($iDPersonaTomador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaTomador, true), gettype($iDPersonaTomador)), __LINE__);
        }
        $this->IDPersonaTomador = $iDPersonaTomador;
        return $this;
    }
    /**
     * Get IDViaCobro value
     * @return string|null
     */
    public function getIDViaCobro()
    {
        return $this->IDViaCobro;
    }
    /**
     * Set IDViaCobro value
     * @param string $iDViaCobro
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDViaCobro($iDViaCobro = null)
    {
        // validation for constraint: string
        if (!is_null($iDViaCobro) && !is_string($iDViaCobro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDViaCobro, true), gettype($iDViaCobro)), __LINE__);
        }
        $this->IDViaCobro = $iDViaCobro;
        return $this;
    }
    /**
     * Get IDInstitucionFinanciera value
     * @return string|null
     */
    public function getIDInstitucionFinanciera()
    {
        return $this->IDInstitucionFinanciera;
    }
    /**
     * Set IDInstitucionFinanciera value
     * @param string $iDInstitucionFinanciera
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDInstitucionFinanciera($iDInstitucionFinanciera = null)
    {
        // validation for constraint: string
        if (!is_null($iDInstitucionFinanciera) && !is_string($iDInstitucionFinanciera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDInstitucionFinanciera, true), gettype($iDInstitucionFinanciera)), __LINE__);
        }
        $this->IDInstitucionFinanciera = $iDInstitucionFinanciera;
        return $this;
    }
    /**
     * Get IDPlanPago value
     * @return string|null
     */
    public function getIDPlanPago()
    {
        return $this->IDPlanPago;
    }
    /**
     * Set IDPlanPago value
     * @param string $iDPlanPago
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDPlanPago($iDPlanPago = null)
    {
        // validation for constraint: string
        if (!is_null($iDPlanPago) && !is_string($iDPlanPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPlanPago, true), gettype($iDPlanPago)), __LINE__);
        }
        $this->IDPlanPago = $iDPlanPago;
        return $this;
    }
    /**
     * Get IDProducto value
     * @return string|null
     */
    public function getIDProducto()
    {
        return $this->IDProducto;
    }
    /**
     * Set IDProducto value
     * @param string $iDProducto
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDProducto($iDProducto = null)
    {
        // validation for constraint: string
        if (!is_null($iDProducto) && !is_string($iDProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProducto, true), gettype($iDProducto)), __LINE__);
        }
        $this->IDProducto = $iDProducto;
        return $this;
    }
    /**
     * Get IDSegmento value
     * @return string|null
     */
    public function getIDSegmento()
    {
        return $this->IDSegmento;
    }
    /**
     * Set IDSegmento value
     * @param string $iDSegmento
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setIDSegmento($iDSegmento = null)
    {
        // validation for constraint: string
        if (!is_null($iDSegmento) && !is_string($iDSegmento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSegmento, true), gettype($iDSegmento)), __LINE__);
        }
        $this->IDSegmento = $iDSegmento;
        return $this;
    }
    /**
     * Get NumeroTarjeta value
     * @return string|null
     */
    public function getNumeroTarjeta()
    {
        return $this->NumeroTarjeta;
    }
    /**
     * Set NumeroTarjeta value
     * @param string $numeroTarjeta
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setNumeroTarjeta($numeroTarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($numeroTarjeta) && !is_string($numeroTarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroTarjeta, true), gettype($numeroTarjeta)), __LINE__);
        }
        $this->NumeroTarjeta = $numeroTarjeta;
        return $this;
    }
    /**
     * Get Mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @param string $mail
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Get CantItem value
     * @return int|null
     */
    public function getCantItem()
    {
        return $this->CantItem;
    }
    /**
     * Set CantItem value
     * @param int $cantItem
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setCantItem($cantItem = 0)
    {
        // validation for constraint: int
        if (!is_null($cantItem) && !(is_int($cantItem) || ctype_digit($cantItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantItem, true), gettype($cantItem)), __LINE__);
        }
        $this->CantItem = $cantItem;
        return $this;
    }
    /**
     * Get Canales value
     * @return \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorOrdenCanal|null
     */
    public function getCanales()
    {
        return $this->Canales;
    }
    /**
     * Set Canales value
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorOrdenCanal $canales
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setCanales(\ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorOrdenCanal $canales = null)
    {
        $this->Canales = $canales;
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorItem $items
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setItems(\ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get PersonasCanal value
     * @return \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorPersonaCanal|null
     */
    public function getPersonasCanal()
    {
        return $this->PersonasCanal;
    }
    /**
     * Set PersonasCanal value
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorPersonaCanal $personasCanal
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setPersonasCanal(\ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorPersonaCanal $personasCanal = null)
    {
        $this->PersonasCanal = $personasCanal;
        return $this;
    }
    /**
     * Get ExcepcionItem value
     * @return \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionItem|null
     */
    public function getExcepcionItem()
    {
        return $this->ExcepcionItem;
    }
    /**
     * Set ExcepcionItem value
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionItem $excepcionItem
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setExcepcionItem(\ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionItem $excepcionItem = null)
    {
        $this->ExcepcionItem = $excepcionItem;
        return $this;
    }
    /**
     * Get ExcepcionOrden value
     * @return \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionOrden|null
     */
    public function getExcepcionOrden()
    {
        return $this->ExcepcionOrden;
    }
    /**
     * Set ExcepcionOrden value
     * @param \ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionOrden $excepcionOrden
     * @return \StructType\DocCanalINGrabadoPresupuestoMotorOrden
     */
    public function setExcepcionOrden(\ArrayType\ArrayOfDocCanalINGrabadoPresupuestoMotorExcepcionOrden $excepcionOrden = null)
    {
        $this->ExcepcionOrden = $excepcionOrden;
        return $this;
    }
}
