<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Informe ServiceType
 * @subpackage Services
 */
class Informe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named InformeDeSiniestro
     * Meta information extracted from the WSDL
     * - documentation: Devuelve Informe de Sinietros. | Devuelve Informe de Sinietros. | Devuelve Informe de Sinietros.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InformeDeSiniestro $parameters
     * @return \StructType\InformeDeSiniestroResponse|bool
     */
    public function InformeDeSiniestro(\StructType\InformeDeSiniestro $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InformeDeSiniestro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InformeDeRechazos
     * Meta information extracted from the WSDL
     * - documentation: Devuelve Informe de Rechazos. | Devuelve Informe de Rechazos. | Devuelve Informe de Rechazos.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InformeDeRechazos $parameters
     * @return \StructType\InformeDeRechazosResponse|bool
     */
    public function InformeDeRechazos(\StructType\InformeDeRechazos $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InformeDeRechazos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InformeDeCobranzas
     * Meta information extracted from the WSDL
     * - documentation: Obtiene un informe de cobranzas. Se recomienda no solicitar más de 30 días para evitar timeout.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InformeDeCobranzas $parameters
     * @return \StructType\InformeDeCobranzasResponse|bool
     */
    public function InformeDeCobranzas(\StructType\InformeDeCobranzas $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InformeDeCobranzas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InformeDeNovedadesClientes
     * Meta information extracted from the WSDL
     * - documentation: Obtiene un informe de novedades de clientes. | Obtiene un informe de novedades de clientes. | Obtiene un informe de novedades de clientes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InformeDeNovedadesClientes $parameters
     * @return \StructType\InformeDeNovedadesClientesResponse|bool
     */
    public function InformeDeNovedadesClientes(\StructType\InformeDeNovedadesClientes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InformeDeNovedadesClientes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named InformeDeInspeccion
     * Meta information extracted from the WSDL
     * - documentation: Obtiene un informe de novedades de clientes. | Obtiene un informe de novedades de clientes. | Obtiene un informe de novedades de clientes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\InformeDeInspeccion $parameters
     * @return \StructType\InformeDeInspeccionResponse|bool
     */
    public function InformeDeInspeccion(\StructType\InformeDeInspeccion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->InformeDeInspeccion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\InformeDeCobranzasResponse|\StructType\InformeDeInspeccionResponse|\StructType\InformeDeNovedadesClientesResponse|\StructType\InformeDeRechazosResponse|\StructType\InformeDeSiniestroResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
