<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emitir ServiceType
 * @subpackage Services
 */
class Emitir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EmitirOrdenHogar
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Emision de Orden Hogar.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirOrdenHogar $parameters
     * @return \StructType\EmitirOrdenHogarResponse|bool
     */
    public function EmitirOrdenHogar(\StructType\EmitirOrdenHogar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirOrdenHogar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirOrdenRobo
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Emision de Orden Robo.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirOrdenRobo $parameters
     * @return \StructType\EmitirOrdenRoboResponse|bool
     */
    public function EmitirOrdenRobo(\StructType\EmitirOrdenRobo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirOrdenRobo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmitirOrdenComercio
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Emision de Orden Comercio.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmitirOrdenComercio $parameters
     * @return \StructType\EmitirOrdenComercioResponse|bool
     */
    public function EmitirOrdenComercio(\StructType\EmitirOrdenComercio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmitirOrdenComercio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmitirOrdenComercioResponse|\StructType\EmitirOrdenHogarResponse|\StructType\EmitirOrdenRoboResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
