<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.servicioszurich.com.ar/WS/ServiciosCanales.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://www.servicioszurich.com.ar/WS/ServiciosCanales.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Agro ServiceType
 */
$agro = new \ServiceType\Agro($options);
/**
 * Sample call for AgroConsultarOrden operation/method
 */
if ($agro->AgroConsultarOrden(new \StructType\AgroConsultarOrden()) !== false) {
    print_r($agro->getResult());
} else {
    print_r($agro->getLastError());
}
/**
 * Sample call for AgroCotizar operation/method
 */
if ($agro->AgroCotizar(new \StructType\AgroCotizar()) !== false) {
    print_r($agro->getResult());
} else {
    print_r($agro->getLastError());
}
/**
 * Sample call for AgroGuardarCotizacion operation/method
 */
if ($agro->AgroGuardarCotizacion(new \StructType\AgroGuardarCotizacion()) !== false) {
    print_r($agro->getResult());
} else {
    print_r($agro->getLastError());
}
/**
 * Samples for Cotizar ServiceType
 */
$cotizar = new \ServiceType\Cotizar($options);
/**
 * Sample call for CotizarAutomovil operation/method
 */
if ($cotizar->CotizarAutomovil(new \StructType\CotizarAutomovil()) !== false) {
    print_r($cotizar->getResult());
} else {
    print_r($cotizar->getLastError());
}
/**
 * Sample call for CotizarAutomovilStruct operation/method
 */
if ($cotizar->CotizarAutomovilStruct(new \StructType\CotizarAutomovilStruct()) !== false) {
    print_r($cotizar->getResult());
} else {
    print_r($cotizar->getLastError());
}
/**
 * Sample call for CotizarOrdenHogar operation/method
 */
if ($cotizar->CotizarOrdenHogar(new \StructType\CotizarOrdenHogar()) !== false) {
    print_r($cotizar->getResult());
} else {
    print_r($cotizar->getLastError());
}
/**
 * Sample call for CotizarOrdenRobo operation/method
 */
if ($cotizar->CotizarOrdenRobo(new \StructType\CotizarOrdenRobo()) !== false) {
    print_r($cotizar->getResult());
} else {
    print_r($cotizar->getLastError());
}
/**
 * Sample call for CotizarOrdenComercio operation/method
 */
if ($cotizar->CotizarOrdenComercio(new \StructType\CotizarOrdenComercio()) !== false) {
    print_r($cotizar->getResult());
} else {
    print_r($cotizar->getLastError());
}
/**
 * Samples for Upload ServiceType
 */
$upload = new \ServiceType\Upload($options);
/**
 * Sample call for UploadEndosos operation/method
 */
if ($upload->UploadEndosos(new \StructType\UploadEndosos()) !== false) {
    print_r($upload->getResult());
} else {
    print_r($upload->getLastError());
}
/**
 * Samples for Emision ServiceType
 */
$emision = new \ServiceType\Emision($options);
/**
 * Sample call for EmisionOrden operation/method
 */
if ($emision->EmisionOrden(new \StructType\EmisionOrden()) !== false) {
    print_r($emision->getResult());
} else {
    print_r($emision->getLastError());
}
/**
 * Sample call for EmisionOrdenStruct operation/method
 */
if ($emision->EmisionOrdenStruct(new \StructType\EmisionOrdenStruct()) !== false) {
    print_r($emision->getResult());
} else {
    print_r($emision->getLastError());
}
/**
 * Samples for Informe ServiceType
 */
$informe = new \ServiceType\Informe($options);
/**
 * Sample call for InformeDeSiniestro operation/method
 */
if ($informe->InformeDeSiniestro(new \StructType\InformeDeSiniestro()) !== false) {
    print_r($informe->getResult());
} else {
    print_r($informe->getLastError());
}
/**
 * Sample call for InformeDeRechazos operation/method
 */
if ($informe->InformeDeRechazos(new \StructType\InformeDeRechazos()) !== false) {
    print_r($informe->getResult());
} else {
    print_r($informe->getLastError());
}
/**
 * Sample call for InformeDeCobranzas operation/method
 */
if ($informe->InformeDeCobranzas(new \StructType\InformeDeCobranzas()) !== false) {
    print_r($informe->getResult());
} else {
    print_r($informe->getLastError());
}
/**
 * Sample call for InformeDeNovedadesClientes operation/method
 */
if ($informe->InformeDeNovedadesClientes(new \StructType\InformeDeNovedadesClientes()) !== false) {
    print_r($informe->getResult());
} else {
    print_r($informe->getLastError());
}
/**
 * Sample call for InformeDeInspeccion operation/method
 */
if ($informe->InformeDeInspeccion(new \StructType\InformeDeInspeccion()) !== false) {
    print_r($informe->getResult());
} else {
    print_r($informe->getLastError());
}
/**
 * Samples for Deudores ServiceType
 */
$deudores = new \ServiceType\Deudores($options);
/**
 * Sample call for DeudoresPorPremio operation/method
 */
if ($deudores->DeudoresPorPremio(new \StructType\DeudoresPorPremio()) !== false) {
    print_r($deudores->getResult());
} else {
    print_r($deudores->getLastError());
}
/**
 * Samples for Imprimir ServiceType
 */
$imprimir = new \ServiceType\Imprimir($options);
/**
 * Sample call for ImprimirDocumentacion operation/method
 */
if ($imprimir->ImprimirDocumentacion(new \StructType\ImprimirDocumentacion()) !== false) {
    print_r($imprimir->getResult());
} else {
    print_r($imprimir->getLastError());
}
/**
 * Samples for Ingreso ServiceType
 */
$ingreso = new \ServiceType\Ingreso($options);
/**
 * Sample call for IngresoDeDenuncia operation/method
 */
if ($ingreso->IngresoDeDenuncia(new \StructType\IngresoDeDenuncia()) !== false) {
    print_r($ingreso->getResult());
} else {
    print_r($ingreso->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ServiceType\Consulta($options);
/**
 * Sample call for ConsultaDocumentacionDenuncia operation/method
 */
if ($consulta->ConsultaDocumentacionDenuncia(new \StructType\ConsultaDocumentacionDenuncia()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Samples for Emitir ServiceType
 */
$emitir = new \ServiceType\Emitir($options);
/**
 * Sample call for EmitirOrdenHogar operation/method
 */
if ($emitir->EmitirOrdenHogar(new \StructType\EmitirOrdenHogar()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirOrdenRobo operation/method
 */
if ($emitir->EmitirOrdenRobo(new \StructType\EmitirOrdenRobo()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirOrdenComercio operation/method
 */
if ($emitir->EmitirOrdenComercio(new \StructType\EmitirOrdenComercio()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Samples for Grabar ServiceType
 */
$grabar = new \ServiceType\Grabar($options);
/**
 * Sample call for GrabarPresupuesto operation/method
 */
if ($grabar->GrabarPresupuesto(new \StructType\GrabarPresupuesto()) !== false) {
    print_r($grabar->getResult());
} else {
    print_r($grabar->getLastError());
}
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for ConsultarPresupuesto operation/method
 */
if ($consultar->ConsultarPresupuesto(new \StructType\ConsultarPresupuesto()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
