<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IngresoDeDenunciasDenuncia StructType
 * @subpackage Structs
 */
class IngresoDeDenunciasDenuncia extends AbstractStructBase
{
    /**
     * The NumerodePoliza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumerodePoliza;
    /**
     * The ItemdelaPolizaBeneficio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemdelaPolizaBeneficio;
    /**
     * The NumeroKm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $NumeroKm;
    /**
     * The DenunciaPolicial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DenunciaPolicial;
    /**
     * The Sucursal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sucursal;
    /**
     * The Seccional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Seccional;
    /**
     * The FolioActa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FolioActa;
    /**
     * The InterseccionEntre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $InterseccionEntre;
    /**
     * The FechadelSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FechadelSiniestro;
    /**
     * The FormadeOcurrencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FormadeOcurrencia;
    /**
     * The CalleRutaAvenida
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CalleRutaAvenida;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The Localidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Localidad;
    /**
     * The PaisdeOcurrencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaisdeOcurrencia;
    /**
     * The Provincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provincia;
    /**
     * The TipodeVia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipodeVia;
    /**
     * The NumeroChasis
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroChasis;
    /**
     * The NumerodeMotor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumerodeMotor;
    /**
     * The NumerodePatente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumerodePatente;
    /**
     * The TipodeAccidente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipodeAccidente;
    /**
     * The PropiedaddelAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropiedaddelAsegurado[]
     */
    public $PropiedaddelAsegurado;
    /**
     * The RoldelAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RoldelAsegurado[]
     */
    public $RoldelAsegurado;
    /**
     * The PropiedaddelTercero
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PropiedaddelTercero[]
     */
    public $PropiedaddelTercero;
    /**
     * The Tercero
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tercero[]
     */
    public $Tercero;
    /**
     * The IdAliado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IdAliado;
    /**
     * The CodFuero
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodFuero;
    /**
     * The TipJuzgadoPenal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipJuzgadoPenal;
    /**
     * The JurisdiccionJuzgadoCivil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $JurisdiccionJuzgadoCivil;
    /**
     * The CodJuzgado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodJuzgado;
    /**
     * The SecretariaJuzgado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SecretariaJuzgado;
    /**
     * The CalleSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CalleSiniestro;
    /**
     * The NumeroCalleSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroCalleSiniestro;
    /**
     * The CruceTren
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruceTren;
    /**
     * The Barrera
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Barrera;
    /**
     * The Semaforo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Semaforo;
    /**
     * The EstadoBarrera
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstadoBarrera;
    /**
     * The EstadoSemaforo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstadoSemaforo;
    /**
     * The TipoCamino
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoCamino;
    /**
     * The EstadoCalzada
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstadoCalzada;
    /**
     * The NumeroRuta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroRuta;
    /**
     * The Kilometro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kilometro;
    /**
     * The TipoRuta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoRuta;
    /**
     * The CruzaRutaNro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruzaRutaNro;
    /**
     * The CruceSenalizado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CruceSenalizado;
    /**
     * The EstadoClima
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstadoClima;
    /**
     * The ZonaUrbana
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZonaUrbana;
    /**
     * The PideCleas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PideCleas;
    /**
     * The Robo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Robo[]
     */
    public $Robo;
    /**
     * Constructor method for IngresoDeDenunciasDenuncia
     * @uses IngresoDeDenunciasDenuncia::setNumerodePoliza()
     * @uses IngresoDeDenunciasDenuncia::setItemdelaPolizaBeneficio()
     * @uses IngresoDeDenunciasDenuncia::setNumeroKm()
     * @uses IngresoDeDenunciasDenuncia::setDenunciaPolicial()
     * @uses IngresoDeDenunciasDenuncia::setSucursal()
     * @uses IngresoDeDenunciasDenuncia::setSeccional()
     * @uses IngresoDeDenunciasDenuncia::setFolioActa()
     * @uses IngresoDeDenunciasDenuncia::setInterseccionEntre()
     * @uses IngresoDeDenunciasDenuncia::setFechadelSiniestro()
     * @uses IngresoDeDenunciasDenuncia::setFormadeOcurrencia()
     * @uses IngresoDeDenunciasDenuncia::setCalleRutaAvenida()
     * @uses IngresoDeDenunciasDenuncia::setCodigoPostal()
     * @uses IngresoDeDenunciasDenuncia::setLocalidad()
     * @uses IngresoDeDenunciasDenuncia::setPaisdeOcurrencia()
     * @uses IngresoDeDenunciasDenuncia::setProvincia()
     * @uses IngresoDeDenunciasDenuncia::setTipodeVia()
     * @uses IngresoDeDenunciasDenuncia::setNumeroChasis()
     * @uses IngresoDeDenunciasDenuncia::setNumerodeMotor()
     * @uses IngresoDeDenunciasDenuncia::setNumerodePatente()
     * @uses IngresoDeDenunciasDenuncia::setTipodeAccidente()
     * @uses IngresoDeDenunciasDenuncia::setPropiedaddelAsegurado()
     * @uses IngresoDeDenunciasDenuncia::setRoldelAsegurado()
     * @uses IngresoDeDenunciasDenuncia::setPropiedaddelTercero()
     * @uses IngresoDeDenunciasDenuncia::setTercero()
     * @uses IngresoDeDenunciasDenuncia::setIdAliado()
     * @uses IngresoDeDenunciasDenuncia::setCodFuero()
     * @uses IngresoDeDenunciasDenuncia::setTipJuzgadoPenal()
     * @uses IngresoDeDenunciasDenuncia::setJurisdiccionJuzgadoCivil()
     * @uses IngresoDeDenunciasDenuncia::setCodJuzgado()
     * @uses IngresoDeDenunciasDenuncia::setSecretariaJuzgado()
     * @uses IngresoDeDenunciasDenuncia::setCalleSiniestro()
     * @uses IngresoDeDenunciasDenuncia::setNumeroCalleSiniestro()
     * @uses IngresoDeDenunciasDenuncia::setCruceTren()
     * @uses IngresoDeDenunciasDenuncia::setBarrera()
     * @uses IngresoDeDenunciasDenuncia::setSemaforo()
     * @uses IngresoDeDenunciasDenuncia::setEstadoBarrera()
     * @uses IngresoDeDenunciasDenuncia::setEstadoSemaforo()
     * @uses IngresoDeDenunciasDenuncia::setTipoCamino()
     * @uses IngresoDeDenunciasDenuncia::setEstadoCalzada()
     * @uses IngresoDeDenunciasDenuncia::setNumeroRuta()
     * @uses IngresoDeDenunciasDenuncia::setKilometro()
     * @uses IngresoDeDenunciasDenuncia::setTipoRuta()
     * @uses IngresoDeDenunciasDenuncia::setCruzaRutaNro()
     * @uses IngresoDeDenunciasDenuncia::setCruceSenalizado()
     * @uses IngresoDeDenunciasDenuncia::setEstadoClima()
     * @uses IngresoDeDenunciasDenuncia::setZonaUrbana()
     * @uses IngresoDeDenunciasDenuncia::setPideCleas()
     * @uses IngresoDeDenunciasDenuncia::setRobo()
     * @param int $numerodePoliza
     * @param int $itemdelaPolizaBeneficio
     * @param int $numeroKm
     * @param string $denunciaPolicial
     * @param string $sucursal
     * @param string $seccional
     * @param string $folioActa
     * @param string $interseccionEntre
     * @param string $fechadelSiniestro
     * @param string $formadeOcurrencia
     * @param string $calleRutaAvenida
     * @param string $codigoPostal
     * @param string $localidad
     * @param string $paisdeOcurrencia
     * @param string $provincia
     * @param string $tipodeVia
     * @param string $numeroChasis
     * @param string $numerodeMotor
     * @param string $numerodePatente
     * @param string $tipodeAccidente
     * @param \StructType\PropiedaddelAsegurado[] $propiedaddelAsegurado
     * @param \StructType\RoldelAsegurado[] $roldelAsegurado
     * @param \StructType\PropiedaddelTercero[] $propiedaddelTercero
     * @param \StructType\Tercero[] $tercero
     * @param string $idAliado
     * @param string $codFuero
     * @param string $tipJuzgadoPenal
     * @param string $jurisdiccionJuzgadoCivil
     * @param string $codJuzgado
     * @param string $secretariaJuzgado
     * @param string $calleSiniestro
     * @param string $numeroCalleSiniestro
     * @param string $cruceTren
     * @param string $barrera
     * @param string $semaforo
     * @param string $estadoBarrera
     * @param string $estadoSemaforo
     * @param string $tipoCamino
     * @param string $estadoCalzada
     * @param string $numeroRuta
     * @param string $kilometro
     * @param string $tipoRuta
     * @param string $cruzaRutaNro
     * @param string $cruceSenalizado
     * @param string $estadoClima
     * @param string $zonaUrbana
     * @param string $pideCleas
     * @param \StructType\Robo[] $robo
     */
    public function __construct($numerodePoliza = null, $itemdelaPolizaBeneficio = null, $numeroKm = null, $denunciaPolicial = null, $sucursal = null, $seccional = null, $folioActa = null, $interseccionEntre = null, $fechadelSiniestro = null, $formadeOcurrencia = null, $calleRutaAvenida = null, $codigoPostal = null, $localidad = null, $paisdeOcurrencia = null, $provincia = null, $tipodeVia = null, $numeroChasis = null, $numerodeMotor = null, $numerodePatente = null, $tipodeAccidente = null, array $propiedaddelAsegurado = array(), array $roldelAsegurado = array(), array $propiedaddelTercero = array(), array $tercero = array(), $idAliado = null, $codFuero = null, $tipJuzgadoPenal = null, $jurisdiccionJuzgadoCivil = null, $codJuzgado = null, $secretariaJuzgado = null, $calleSiniestro = null, $numeroCalleSiniestro = null, $cruceTren = null, $barrera = null, $semaforo = null, $estadoBarrera = null, $estadoSemaforo = null, $tipoCamino = null, $estadoCalzada = null, $numeroRuta = null, $kilometro = null, $tipoRuta = null, $cruzaRutaNro = null, $cruceSenalizado = null, $estadoClima = null, $zonaUrbana = null, $pideCleas = null, array $robo = array())
    {
        $this
            ->setNumerodePoliza($numerodePoliza)
            ->setItemdelaPolizaBeneficio($itemdelaPolizaBeneficio)
            ->setNumeroKm($numeroKm)
            ->setDenunciaPolicial($denunciaPolicial)
            ->setSucursal($sucursal)
            ->setSeccional($seccional)
            ->setFolioActa($folioActa)
            ->setInterseccionEntre($interseccionEntre)
            ->setFechadelSiniestro($fechadelSiniestro)
            ->setFormadeOcurrencia($formadeOcurrencia)
            ->setCalleRutaAvenida($calleRutaAvenida)
            ->setCodigoPostal($codigoPostal)
            ->setLocalidad($localidad)
            ->setPaisdeOcurrencia($paisdeOcurrencia)
            ->setProvincia($provincia)
            ->setTipodeVia($tipodeVia)
            ->setNumeroChasis($numeroChasis)
            ->setNumerodeMotor($numerodeMotor)
            ->setNumerodePatente($numerodePatente)
            ->setTipodeAccidente($tipodeAccidente)
            ->setPropiedaddelAsegurado($propiedaddelAsegurado)
            ->setRoldelAsegurado($roldelAsegurado)
            ->setPropiedaddelTercero($propiedaddelTercero)
            ->setTercero($tercero)
            ->setIdAliado($idAliado)
            ->setCodFuero($codFuero)
            ->setTipJuzgadoPenal($tipJuzgadoPenal)
            ->setJurisdiccionJuzgadoCivil($jurisdiccionJuzgadoCivil)
            ->setCodJuzgado($codJuzgado)
            ->setSecretariaJuzgado($secretariaJuzgado)
            ->setCalleSiniestro($calleSiniestro)
            ->setNumeroCalleSiniestro($numeroCalleSiniestro)
            ->setCruceTren($cruceTren)
            ->setBarrera($barrera)
            ->setSemaforo($semaforo)
            ->setEstadoBarrera($estadoBarrera)
            ->setEstadoSemaforo($estadoSemaforo)
            ->setTipoCamino($tipoCamino)
            ->setEstadoCalzada($estadoCalzada)
            ->setNumeroRuta($numeroRuta)
            ->setKilometro($kilometro)
            ->setTipoRuta($tipoRuta)
            ->setCruzaRutaNro($cruzaRutaNro)
            ->setCruceSenalizado($cruceSenalizado)
            ->setEstadoClima($estadoClima)
            ->setZonaUrbana($zonaUrbana)
            ->setPideCleas($pideCleas)
            ->setRobo($robo);
    }
    /**
     * Get NumerodePoliza value
     * @return int
     */
    public function getNumerodePoliza()
    {
        return $this->NumerodePoliza;
    }
    /**
     * Set NumerodePoliza value
     * @param int $numerodePoliza
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setNumerodePoliza($numerodePoliza = null)
    {
        // validation for constraint: int
        if (!is_null($numerodePoliza) && !(is_int($numerodePoliza) || ctype_digit($numerodePoliza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerodePoliza, true), gettype($numerodePoliza)), __LINE__);
        }
        $this->NumerodePoliza = $numerodePoliza;
        return $this;
    }
    /**
     * Get ItemdelaPolizaBeneficio value
     * @return int
     */
    public function getItemdelaPolizaBeneficio()
    {
        return $this->ItemdelaPolizaBeneficio;
    }
    /**
     * Set ItemdelaPolizaBeneficio value
     * @param int $itemdelaPolizaBeneficio
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setItemdelaPolizaBeneficio($itemdelaPolizaBeneficio = null)
    {
        // validation for constraint: int
        if (!is_null($itemdelaPolizaBeneficio) && !(is_int($itemdelaPolizaBeneficio) || ctype_digit($itemdelaPolizaBeneficio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemdelaPolizaBeneficio, true), gettype($itemdelaPolizaBeneficio)), __LINE__);
        }
        $this->ItemdelaPolizaBeneficio = $itemdelaPolizaBeneficio;
        return $this;
    }
    /**
     * Get NumeroKm value
     * @return int
     */
    public function getNumeroKm()
    {
        return $this->NumeroKm;
    }
    /**
     * Set NumeroKm value
     * @param int $numeroKm
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setNumeroKm($numeroKm = null)
    {
        // validation for constraint: int
        if (!is_null($numeroKm) && !(is_int($numeroKm) || ctype_digit($numeroKm))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroKm, true), gettype($numeroKm)), __LINE__);
        }
        $this->NumeroKm = $numeroKm;
        return $this;
    }
    /**
     * Get DenunciaPolicial value
     * @return string|null
     */
    public function getDenunciaPolicial()
    {
        return $this->DenunciaPolicial;
    }
    /**
     * Set DenunciaPolicial value
     * @param string $denunciaPolicial
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setDenunciaPolicial($denunciaPolicial = null)
    {
        // validation for constraint: string
        if (!is_null($denunciaPolicial) && !is_string($denunciaPolicial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($denunciaPolicial, true), gettype($denunciaPolicial)), __LINE__);
        }
        $this->DenunciaPolicial = $denunciaPolicial;
        return $this;
    }
    /**
     * Get Sucursal value
     * @return string|null
     */
    public function getSucursal()
    {
        return $this->Sucursal;
    }
    /**
     * Set Sucursal value
     * @param string $sucursal
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setSucursal($sucursal = null)
    {
        // validation for constraint: string
        if (!is_null($sucursal) && !is_string($sucursal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sucursal, true), gettype($sucursal)), __LINE__);
        }
        $this->Sucursal = $sucursal;
        return $this;
    }
    /**
     * Get Seccional value
     * @return string|null
     */
    public function getSeccional()
    {
        return $this->Seccional;
    }
    /**
     * Set Seccional value
     * @param string $seccional
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setSeccional($seccional = null)
    {
        // validation for constraint: string
        if (!is_null($seccional) && !is_string($seccional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seccional, true), gettype($seccional)), __LINE__);
        }
        $this->Seccional = $seccional;
        return $this;
    }
    /**
     * Get FolioActa value
     * @return string|null
     */
    public function getFolioActa()
    {
        return $this->FolioActa;
    }
    /**
     * Set FolioActa value
     * @param string $folioActa
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setFolioActa($folioActa = null)
    {
        // validation for constraint: string
        if (!is_null($folioActa) && !is_string($folioActa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($folioActa, true), gettype($folioActa)), __LINE__);
        }
        $this->FolioActa = $folioActa;
        return $this;
    }
    /**
     * Get InterseccionEntre value
     * @return string|null
     */
    public function getInterseccionEntre()
    {
        return $this->InterseccionEntre;
    }
    /**
     * Set InterseccionEntre value
     * @param string $interseccionEntre
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setInterseccionEntre($interseccionEntre = null)
    {
        // validation for constraint: string
        if (!is_null($interseccionEntre) && !is_string($interseccionEntre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($interseccionEntre, true), gettype($interseccionEntre)), __LINE__);
        }
        $this->InterseccionEntre = $interseccionEntre;
        return $this;
    }
    /**
     * Get FechadelSiniestro value
     * @return string|null
     */
    public function getFechadelSiniestro()
    {
        return $this->FechadelSiniestro;
    }
    /**
     * Set FechadelSiniestro value
     * @param string $fechadelSiniestro
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setFechadelSiniestro($fechadelSiniestro = null)
    {
        // validation for constraint: string
        if (!is_null($fechadelSiniestro) && !is_string($fechadelSiniestro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechadelSiniestro, true), gettype($fechadelSiniestro)), __LINE__);
        }
        $this->FechadelSiniestro = $fechadelSiniestro;
        return $this;
    }
    /**
     * Get FormadeOcurrencia value
     * @return string|null
     */
    public function getFormadeOcurrencia()
    {
        return $this->FormadeOcurrencia;
    }
    /**
     * Set FormadeOcurrencia value
     * @param string $formadeOcurrencia
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setFormadeOcurrencia($formadeOcurrencia = null)
    {
        // validation for constraint: string
        if (!is_null($formadeOcurrencia) && !is_string($formadeOcurrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formadeOcurrencia, true), gettype($formadeOcurrencia)), __LINE__);
        }
        $this->FormadeOcurrencia = $formadeOcurrencia;
        return $this;
    }
    /**
     * Get CalleRutaAvenida value
     * @return string|null
     */
    public function getCalleRutaAvenida()
    {
        return $this->CalleRutaAvenida;
    }
    /**
     * Set CalleRutaAvenida value
     * @param string $calleRutaAvenida
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCalleRutaAvenida($calleRutaAvenida = null)
    {
        // validation for constraint: string
        if (!is_null($calleRutaAvenida) && !is_string($calleRutaAvenida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calleRutaAvenida, true), gettype($calleRutaAvenida)), __LINE__);
        }
        $this->CalleRutaAvenida = $calleRutaAvenida;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get Localidad value
     * @return string|null
     */
    public function getLocalidad()
    {
        return $this->Localidad;
    }
    /**
     * Set Localidad value
     * @param string $localidad
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setLocalidad($localidad = null)
    {
        // validation for constraint: string
        if (!is_null($localidad) && !is_string($localidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localidad, true), gettype($localidad)), __LINE__);
        }
        $this->Localidad = $localidad;
        return $this;
    }
    /**
     * Get PaisdeOcurrencia value
     * @return string|null
     */
    public function getPaisdeOcurrencia()
    {
        return $this->PaisdeOcurrencia;
    }
    /**
     * Set PaisdeOcurrencia value
     * @param string $paisdeOcurrencia
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setPaisdeOcurrencia($paisdeOcurrencia = null)
    {
        // validation for constraint: string
        if (!is_null($paisdeOcurrencia) && !is_string($paisdeOcurrencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paisdeOcurrencia, true), gettype($paisdeOcurrencia)), __LINE__);
        }
        $this->PaisdeOcurrencia = $paisdeOcurrencia;
        return $this;
    }
    /**
     * Get Provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->Provincia;
    }
    /**
     * Set Provincia value
     * @param string $provincia
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->Provincia = $provincia;
        return $this;
    }
    /**
     * Get TipodeVia value
     * @return string|null
     */
    public function getTipodeVia()
    {
        return $this->TipodeVia;
    }
    /**
     * Set TipodeVia value
     * @param string $tipodeVia
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setTipodeVia($tipodeVia = null)
    {
        // validation for constraint: string
        if (!is_null($tipodeVia) && !is_string($tipodeVia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipodeVia, true), gettype($tipodeVia)), __LINE__);
        }
        $this->TipodeVia = $tipodeVia;
        return $this;
    }
    /**
     * Get NumeroChasis value
     * @return string|null
     */
    public function getNumeroChasis()
    {
        return $this->NumeroChasis;
    }
    /**
     * Set NumeroChasis value
     * @param string $numeroChasis
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setNumeroChasis($numeroChasis = null)
    {
        // validation for constraint: string
        if (!is_null($numeroChasis) && !is_string($numeroChasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroChasis, true), gettype($numeroChasis)), __LINE__);
        }
        $this->NumeroChasis = $numeroChasis;
        return $this;
    }
    /**
     * Get NumerodeMotor value
     * @return string|null
     */
    public function getNumerodeMotor()
    {
        return $this->NumerodeMotor;
    }
    /**
     * Set NumerodeMotor value
     * @param string $numerodeMotor
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setNumerodeMotor($numerodeMotor = null)
    {
        // validation for constraint: string
        if (!is_null($numerodeMotor) && !is_string($numerodeMotor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerodeMotor, true), gettype($numerodeMotor)), __LINE__);
        }
        $this->NumerodeMotor = $numerodeMotor;
        return $this;
    }
    /**
     * Get NumerodePatente value
     * @return string|null
     */
    public function getNumerodePatente()
    {
        return $this->NumerodePatente;
    }
    /**
     * Set NumerodePatente value
     * @param string $numerodePatente
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setNumerodePatente($numerodePatente = null)
    {
        // validation for constraint: string
        if (!is_null($numerodePatente) && !is_string($numerodePatente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numerodePatente, true), gettype($numerodePatente)), __LINE__);
        }
        $this->NumerodePatente = $numerodePatente;
        return $this;
    }
    /**
     * Get TipodeAccidente value
     * @return string|null
     */
    public function getTipodeAccidente()
    {
        return $this->TipodeAccidente;
    }
    /**
     * Set TipodeAccidente value
     * @param string $tipodeAccidente
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setTipodeAccidente($tipodeAccidente = null)
    {
        // validation for constraint: string
        if (!is_null($tipodeAccidente) && !is_string($tipodeAccidente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipodeAccidente, true), gettype($tipodeAccidente)), __LINE__);
        }
        $this->TipodeAccidente = $tipodeAccidente;
        return $this;
    }
    /**
     * Get PropiedaddelAsegurado value
     * @return \StructType\PropiedaddelAsegurado[]|null
     */
    public function getPropiedaddelAsegurado()
    {
        return $this->PropiedaddelAsegurado;
    }
    /**
     * This method is responsible for validating the values passed to the setPropiedaddelAsegurado method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropiedaddelAsegurado method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropiedaddelAseguradoForArrayConstraintsFromSetPropiedaddelAsegurado(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ingresoDeDenunciasDenunciaPropiedaddelAseguradoItem) {
            // validation for constraint: itemType
            if (!$ingresoDeDenunciasDenunciaPropiedaddelAseguradoItem instanceof \StructType\PropiedaddelAsegurado) {
                $invalidValues[] = is_object($ingresoDeDenunciasDenunciaPropiedaddelAseguradoItem) ? get_class($ingresoDeDenunciasDenunciaPropiedaddelAseguradoItem) : sprintf('%s(%s)', gettype($ingresoDeDenunciasDenunciaPropiedaddelAseguradoItem), var_export($ingresoDeDenunciasDenunciaPropiedaddelAseguradoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropiedaddelAsegurado property can only contain items of type \StructType\PropiedaddelAsegurado, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropiedaddelAsegurado value
     * @throws \InvalidArgumentException
     * @param \StructType\PropiedaddelAsegurado[] $propiedaddelAsegurado
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setPropiedaddelAsegurado(array $propiedaddelAsegurado = array())
    {
        // validation for constraint: array
        if ('' !== ($propiedaddelAseguradoArrayErrorMessage = self::validatePropiedaddelAseguradoForArrayConstraintsFromSetPropiedaddelAsegurado($propiedaddelAsegurado))) {
            throw new \InvalidArgumentException($propiedaddelAseguradoArrayErrorMessage, __LINE__);
        }
        $this->PropiedaddelAsegurado = $propiedaddelAsegurado;
        return $this;
    }
    /**
     * Add item to PropiedaddelAsegurado value
     * @throws \InvalidArgumentException
     * @param \StructType\PropiedaddelAsegurado $item
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function addToPropiedaddelAsegurado(\StructType\PropiedaddelAsegurado $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropiedaddelAsegurado) {
            throw new \InvalidArgumentException(sprintf('The PropiedaddelAsegurado property can only contain items of type \StructType\PropiedaddelAsegurado, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropiedaddelAsegurado[] = $item;
        return $this;
    }
    /**
     * Get RoldelAsegurado value
     * @return \StructType\RoldelAsegurado[]|null
     */
    public function getRoldelAsegurado()
    {
        return $this->RoldelAsegurado;
    }
    /**
     * This method is responsible for validating the values passed to the setRoldelAsegurado method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRoldelAsegurado method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoldelAseguradoForArrayConstraintsFromSetRoldelAsegurado(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ingresoDeDenunciasDenunciaRoldelAseguradoItem) {
            // validation for constraint: itemType
            if (!$ingresoDeDenunciasDenunciaRoldelAseguradoItem instanceof \StructType\RoldelAsegurado) {
                $invalidValues[] = is_object($ingresoDeDenunciasDenunciaRoldelAseguradoItem) ? get_class($ingresoDeDenunciasDenunciaRoldelAseguradoItem) : sprintf('%s(%s)', gettype($ingresoDeDenunciasDenunciaRoldelAseguradoItem), var_export($ingresoDeDenunciasDenunciaRoldelAseguradoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RoldelAsegurado property can only contain items of type \StructType\RoldelAsegurado, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RoldelAsegurado value
     * @throws \InvalidArgumentException
     * @param \StructType\RoldelAsegurado[] $roldelAsegurado
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setRoldelAsegurado(array $roldelAsegurado = array())
    {
        // validation for constraint: array
        if ('' !== ($roldelAseguradoArrayErrorMessage = self::validateRoldelAseguradoForArrayConstraintsFromSetRoldelAsegurado($roldelAsegurado))) {
            throw new \InvalidArgumentException($roldelAseguradoArrayErrorMessage, __LINE__);
        }
        $this->RoldelAsegurado = $roldelAsegurado;
        return $this;
    }
    /**
     * Add item to RoldelAsegurado value
     * @throws \InvalidArgumentException
     * @param \StructType\RoldelAsegurado $item
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function addToRoldelAsegurado(\StructType\RoldelAsegurado $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RoldelAsegurado) {
            throw new \InvalidArgumentException(sprintf('The RoldelAsegurado property can only contain items of type \StructType\RoldelAsegurado, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RoldelAsegurado[] = $item;
        return $this;
    }
    /**
     * Get PropiedaddelTercero value
     * @return \StructType\PropiedaddelTercero[]|null
     */
    public function getPropiedaddelTercero()
    {
        return $this->PropiedaddelTercero;
    }
    /**
     * This method is responsible for validating the values passed to the setPropiedaddelTercero method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropiedaddelTercero method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropiedaddelTerceroForArrayConstraintsFromSetPropiedaddelTercero(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ingresoDeDenunciasDenunciaPropiedaddelTerceroItem) {
            // validation for constraint: itemType
            if (!$ingresoDeDenunciasDenunciaPropiedaddelTerceroItem instanceof \StructType\PropiedaddelTercero) {
                $invalidValues[] = is_object($ingresoDeDenunciasDenunciaPropiedaddelTerceroItem) ? get_class($ingresoDeDenunciasDenunciaPropiedaddelTerceroItem) : sprintf('%s(%s)', gettype($ingresoDeDenunciasDenunciaPropiedaddelTerceroItem), var_export($ingresoDeDenunciasDenunciaPropiedaddelTerceroItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropiedaddelTercero property can only contain items of type \StructType\PropiedaddelTercero, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropiedaddelTercero value
     * @throws \InvalidArgumentException
     * @param \StructType\PropiedaddelTercero[] $propiedaddelTercero
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setPropiedaddelTercero(array $propiedaddelTercero = array())
    {
        // validation for constraint: array
        if ('' !== ($propiedaddelTerceroArrayErrorMessage = self::validatePropiedaddelTerceroForArrayConstraintsFromSetPropiedaddelTercero($propiedaddelTercero))) {
            throw new \InvalidArgumentException($propiedaddelTerceroArrayErrorMessage, __LINE__);
        }
        $this->PropiedaddelTercero = $propiedaddelTercero;
        return $this;
    }
    /**
     * Add item to PropiedaddelTercero value
     * @throws \InvalidArgumentException
     * @param \StructType\PropiedaddelTercero $item
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function addToPropiedaddelTercero(\StructType\PropiedaddelTercero $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PropiedaddelTercero) {
            throw new \InvalidArgumentException(sprintf('The PropiedaddelTercero property can only contain items of type \StructType\PropiedaddelTercero, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropiedaddelTercero[] = $item;
        return $this;
    }
    /**
     * Get Tercero value
     * @return \StructType\Tercero[]|null
     */
    public function getTercero()
    {
        return $this->Tercero;
    }
    /**
     * This method is responsible for validating the values passed to the setTercero method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTercero method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTerceroForArrayConstraintsFromSetTercero(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ingresoDeDenunciasDenunciaTerceroItem) {
            // validation for constraint: itemType
            if (!$ingresoDeDenunciasDenunciaTerceroItem instanceof \StructType\Tercero) {
                $invalidValues[] = is_object($ingresoDeDenunciasDenunciaTerceroItem) ? get_class($ingresoDeDenunciasDenunciaTerceroItem) : sprintf('%s(%s)', gettype($ingresoDeDenunciasDenunciaTerceroItem), var_export($ingresoDeDenunciasDenunciaTerceroItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tercero property can only contain items of type \StructType\Tercero, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tercero value
     * @throws \InvalidArgumentException
     * @param \StructType\Tercero[] $tercero
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setTercero(array $tercero = array())
    {
        // validation for constraint: array
        if ('' !== ($terceroArrayErrorMessage = self::validateTerceroForArrayConstraintsFromSetTercero($tercero))) {
            throw new \InvalidArgumentException($terceroArrayErrorMessage, __LINE__);
        }
        $this->Tercero = $tercero;
        return $this;
    }
    /**
     * Add item to Tercero value
     * @throws \InvalidArgumentException
     * @param \StructType\Tercero $item
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function addToTercero(\StructType\Tercero $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tercero) {
            throw new \InvalidArgumentException(sprintf('The Tercero property can only contain items of type \StructType\Tercero, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tercero[] = $item;
        return $this;
    }
    /**
     * Get IdAliado value
     * @return string|null
     */
    public function getIdAliado()
    {
        return $this->IdAliado;
    }
    /**
     * Set IdAliado value
     * @param string $idAliado
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setIdAliado($idAliado = null)
    {
        // validation for constraint: string
        if (!is_null($idAliado) && !is_string($idAliado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idAliado, true), gettype($idAliado)), __LINE__);
        }
        $this->IdAliado = $idAliado;
        return $this;
    }
    /**
     * Get CodFuero value
     * @return string|null
     */
    public function getCodFuero()
    {
        return $this->CodFuero;
    }
    /**
     * Set CodFuero value
     * @param string $codFuero
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCodFuero($codFuero = null)
    {
        // validation for constraint: string
        if (!is_null($codFuero) && !is_string($codFuero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codFuero, true), gettype($codFuero)), __LINE__);
        }
        $this->CodFuero = $codFuero;
        return $this;
    }
    /**
     * Get TipJuzgadoPenal value
     * @return string|null
     */
    public function getTipJuzgadoPenal()
    {
        return $this->TipJuzgadoPenal;
    }
    /**
     * Set TipJuzgadoPenal value
     * @param string $tipJuzgadoPenal
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setTipJuzgadoPenal($tipJuzgadoPenal = null)
    {
        // validation for constraint: string
        if (!is_null($tipJuzgadoPenal) && !is_string($tipJuzgadoPenal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipJuzgadoPenal, true), gettype($tipJuzgadoPenal)), __LINE__);
        }
        $this->TipJuzgadoPenal = $tipJuzgadoPenal;
        return $this;
    }
    /**
     * Get JurisdiccionJuzgadoCivil value
     * @return string|null
     */
    public function getJurisdiccionJuzgadoCivil()
    {
        return $this->JurisdiccionJuzgadoCivil;
    }
    /**
     * Set JurisdiccionJuzgadoCivil value
     * @param string $jurisdiccionJuzgadoCivil
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setJurisdiccionJuzgadoCivil($jurisdiccionJuzgadoCivil = null)
    {
        // validation for constraint: string
        if (!is_null($jurisdiccionJuzgadoCivil) && !is_string($jurisdiccionJuzgadoCivil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jurisdiccionJuzgadoCivil, true), gettype($jurisdiccionJuzgadoCivil)), __LINE__);
        }
        $this->JurisdiccionJuzgadoCivil = $jurisdiccionJuzgadoCivil;
        return $this;
    }
    /**
     * Get CodJuzgado value
     * @return string|null
     */
    public function getCodJuzgado()
    {
        return $this->CodJuzgado;
    }
    /**
     * Set CodJuzgado value
     * @param string $codJuzgado
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCodJuzgado($codJuzgado = null)
    {
        // validation for constraint: string
        if (!is_null($codJuzgado) && !is_string($codJuzgado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codJuzgado, true), gettype($codJuzgado)), __LINE__);
        }
        $this->CodJuzgado = $codJuzgado;
        return $this;
    }
    /**
     * Get SecretariaJuzgado value
     * @return string|null
     */
    public function getSecretariaJuzgado()
    {
        return $this->SecretariaJuzgado;
    }
    /**
     * Set SecretariaJuzgado value
     * @param string $secretariaJuzgado
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setSecretariaJuzgado($secretariaJuzgado = null)
    {
        // validation for constraint: string
        if (!is_null($secretariaJuzgado) && !is_string($secretariaJuzgado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($secretariaJuzgado, true), gettype($secretariaJuzgado)), __LINE__);
        }
        $this->SecretariaJuzgado = $secretariaJuzgado;
        return $this;
    }
    /**
     * Get CalleSiniestro value
     * @return string|null
     */
    public function getCalleSiniestro()
    {
        return $this->CalleSiniestro;
    }
    /**
     * Set CalleSiniestro value
     * @param string $calleSiniestro
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCalleSiniestro($calleSiniestro = null)
    {
        // validation for constraint: string
        if (!is_null($calleSiniestro) && !is_string($calleSiniestro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calleSiniestro, true), gettype($calleSiniestro)), __LINE__);
        }
        $this->CalleSiniestro = $calleSiniestro;
        return $this;
    }
    /**
     * Get NumeroCalleSiniestro value
     * @return string|null
     */
    public function getNumeroCalleSiniestro()
    {
        return $this->NumeroCalleSiniestro;
    }
    /**
     * Set NumeroCalleSiniestro value
     * @param string $numeroCalleSiniestro
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setNumeroCalleSiniestro($numeroCalleSiniestro = null)
    {
        // validation for constraint: string
        if (!is_null($numeroCalleSiniestro) && !is_string($numeroCalleSiniestro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroCalleSiniestro, true), gettype($numeroCalleSiniestro)), __LINE__);
        }
        $this->NumeroCalleSiniestro = $numeroCalleSiniestro;
        return $this;
    }
    /**
     * Get CruceTren value
     * @return string|null
     */
    public function getCruceTren()
    {
        return $this->CruceTren;
    }
    /**
     * Set CruceTren value
     * @param string $cruceTren
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCruceTren($cruceTren = null)
    {
        // validation for constraint: string
        if (!is_null($cruceTren) && !is_string($cruceTren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cruceTren, true), gettype($cruceTren)), __LINE__);
        }
        $this->CruceTren = $cruceTren;
        return $this;
    }
    /**
     * Get Barrera value
     * @return string|null
     */
    public function getBarrera()
    {
        return $this->Barrera;
    }
    /**
     * Set Barrera value
     * @param string $barrera
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setBarrera($barrera = null)
    {
        // validation for constraint: string
        if (!is_null($barrera) && !is_string($barrera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barrera, true), gettype($barrera)), __LINE__);
        }
        $this->Barrera = $barrera;
        return $this;
    }
    /**
     * Get Semaforo value
     * @return string|null
     */
    public function getSemaforo()
    {
        return $this->Semaforo;
    }
    /**
     * Set Semaforo value
     * @param string $semaforo
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setSemaforo($semaforo = null)
    {
        // validation for constraint: string
        if (!is_null($semaforo) && !is_string($semaforo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($semaforo, true), gettype($semaforo)), __LINE__);
        }
        $this->Semaforo = $semaforo;
        return $this;
    }
    /**
     * Get EstadoBarrera value
     * @return string|null
     */
    public function getEstadoBarrera()
    {
        return $this->EstadoBarrera;
    }
    /**
     * Set EstadoBarrera value
     * @param string $estadoBarrera
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setEstadoBarrera($estadoBarrera = null)
    {
        // validation for constraint: string
        if (!is_null($estadoBarrera) && !is_string($estadoBarrera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoBarrera, true), gettype($estadoBarrera)), __LINE__);
        }
        $this->EstadoBarrera = $estadoBarrera;
        return $this;
    }
    /**
     * Get EstadoSemaforo value
     * @return string|null
     */
    public function getEstadoSemaforo()
    {
        return $this->EstadoSemaforo;
    }
    /**
     * Set EstadoSemaforo value
     * @param string $estadoSemaforo
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setEstadoSemaforo($estadoSemaforo = null)
    {
        // validation for constraint: string
        if (!is_null($estadoSemaforo) && !is_string($estadoSemaforo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoSemaforo, true), gettype($estadoSemaforo)), __LINE__);
        }
        $this->EstadoSemaforo = $estadoSemaforo;
        return $this;
    }
    /**
     * Get TipoCamino value
     * @return string|null
     */
    public function getTipoCamino()
    {
        return $this->TipoCamino;
    }
    /**
     * Set TipoCamino value
     * @param string $tipoCamino
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setTipoCamino($tipoCamino = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCamino) && !is_string($tipoCamino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoCamino, true), gettype($tipoCamino)), __LINE__);
        }
        $this->TipoCamino = $tipoCamino;
        return $this;
    }
    /**
     * Get EstadoCalzada value
     * @return string|null
     */
    public function getEstadoCalzada()
    {
        return $this->EstadoCalzada;
    }
    /**
     * Set EstadoCalzada value
     * @param string $estadoCalzada
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setEstadoCalzada($estadoCalzada = null)
    {
        // validation for constraint: string
        if (!is_null($estadoCalzada) && !is_string($estadoCalzada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoCalzada, true), gettype($estadoCalzada)), __LINE__);
        }
        $this->EstadoCalzada = $estadoCalzada;
        return $this;
    }
    /**
     * Get NumeroRuta value
     * @return string|null
     */
    public function getNumeroRuta()
    {
        return $this->NumeroRuta;
    }
    /**
     * Set NumeroRuta value
     * @param string $numeroRuta
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setNumeroRuta($numeroRuta = null)
    {
        // validation for constraint: string
        if (!is_null($numeroRuta) && !is_string($numeroRuta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroRuta, true), gettype($numeroRuta)), __LINE__);
        }
        $this->NumeroRuta = $numeroRuta;
        return $this;
    }
    /**
     * Get Kilometro value
     * @return string|null
     */
    public function getKilometro()
    {
        return $this->Kilometro;
    }
    /**
     * Set Kilometro value
     * @param string $kilometro
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setKilometro($kilometro = null)
    {
        // validation for constraint: string
        if (!is_null($kilometro) && !is_string($kilometro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kilometro, true), gettype($kilometro)), __LINE__);
        }
        $this->Kilometro = $kilometro;
        return $this;
    }
    /**
     * Get TipoRuta value
     * @return string|null
     */
    public function getTipoRuta()
    {
        return $this->TipoRuta;
    }
    /**
     * Set TipoRuta value
     * @param string $tipoRuta
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setTipoRuta($tipoRuta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoRuta) && !is_string($tipoRuta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoRuta, true), gettype($tipoRuta)), __LINE__);
        }
        $this->TipoRuta = $tipoRuta;
        return $this;
    }
    /**
     * Get CruzaRutaNro value
     * @return string|null
     */
    public function getCruzaRutaNro()
    {
        return $this->CruzaRutaNro;
    }
    /**
     * Set CruzaRutaNro value
     * @param string $cruzaRutaNro
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCruzaRutaNro($cruzaRutaNro = null)
    {
        // validation for constraint: string
        if (!is_null($cruzaRutaNro) && !is_string($cruzaRutaNro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cruzaRutaNro, true), gettype($cruzaRutaNro)), __LINE__);
        }
        $this->CruzaRutaNro = $cruzaRutaNro;
        return $this;
    }
    /**
     * Get CruceSenalizado value
     * @return string|null
     */
    public function getCruceSenalizado()
    {
        return $this->CruceSenalizado;
    }
    /**
     * Set CruceSenalizado value
     * @param string $cruceSenalizado
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setCruceSenalizado($cruceSenalizado = null)
    {
        // validation for constraint: string
        if (!is_null($cruceSenalizado) && !is_string($cruceSenalizado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cruceSenalizado, true), gettype($cruceSenalizado)), __LINE__);
        }
        $this->CruceSenalizado = $cruceSenalizado;
        return $this;
    }
    /**
     * Get EstadoClima value
     * @return string|null
     */
    public function getEstadoClima()
    {
        return $this->EstadoClima;
    }
    /**
     * Set EstadoClima value
     * @param string $estadoClima
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setEstadoClima($estadoClima = null)
    {
        // validation for constraint: string
        if (!is_null($estadoClima) && !is_string($estadoClima)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoClima, true), gettype($estadoClima)), __LINE__);
        }
        $this->EstadoClima = $estadoClima;
        return $this;
    }
    /**
     * Get ZonaUrbana value
     * @return string|null
     */
    public function getZonaUrbana()
    {
        return $this->ZonaUrbana;
    }
    /**
     * Set ZonaUrbana value
     * @param string $zonaUrbana
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setZonaUrbana($zonaUrbana = null)
    {
        // validation for constraint: string
        if (!is_null($zonaUrbana) && !is_string($zonaUrbana)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zonaUrbana, true), gettype($zonaUrbana)), __LINE__);
        }
        $this->ZonaUrbana = $zonaUrbana;
        return $this;
    }
    /**
     * Get PideCleas value
     * @return string|null
     */
    public function getPideCleas()
    {
        return $this->PideCleas;
    }
    /**
     * Set PideCleas value
     * @param string $pideCleas
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setPideCleas($pideCleas = null)
    {
        // validation for constraint: string
        if (!is_null($pideCleas) && !is_string($pideCleas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pideCleas, true), gettype($pideCleas)), __LINE__);
        }
        $this->PideCleas = $pideCleas;
        return $this;
    }
    /**
     * Get Robo value
     * @return \StructType\Robo[]|null
     */
    public function getRobo()
    {
        return $this->Robo;
    }
    /**
     * This method is responsible for validating the values passed to the setRobo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRobo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRoboForArrayConstraintsFromSetRobo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $ingresoDeDenunciasDenunciaRoboItem) {
            // validation for constraint: itemType
            if (!$ingresoDeDenunciasDenunciaRoboItem instanceof \StructType\Robo) {
                $invalidValues[] = is_object($ingresoDeDenunciasDenunciaRoboItem) ? get_class($ingresoDeDenunciasDenunciaRoboItem) : sprintf('%s(%s)', gettype($ingresoDeDenunciasDenunciaRoboItem), var_export($ingresoDeDenunciasDenunciaRoboItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Robo property can only contain items of type \StructType\Robo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Robo value
     * @throws \InvalidArgumentException
     * @param \StructType\Robo[] $robo
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function setRobo(array $robo = array())
    {
        // validation for constraint: array
        if ('' !== ($roboArrayErrorMessage = self::validateRoboForArrayConstraintsFromSetRobo($robo))) {
            throw new \InvalidArgumentException($roboArrayErrorMessage, __LINE__);
        }
        $this->Robo = $robo;
        return $this;
    }
    /**
     * Add item to Robo value
     * @throws \InvalidArgumentException
     * @param \StructType\Robo $item
     * @return \StructType\IngresoDeDenunciasDenuncia
     */
    public function addToRobo(\StructType\Robo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Robo) {
            throw new \InvalidArgumentException(sprintf('The Robo property can only contain items of type \StructType\Robo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Robo[] = $item;
        return $this;
    }
}
