<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmisionMotorsSalidaPersona StructType
 * @subpackage Structs
 */
class EmisionMotorsSalidaPersona extends AbstractStructBase
{
    /**
     * The NroDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $NroDocumento;
    /**
     * The FechaNacimiento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaNacimiento;
    /**
     * The IDDomicilioCobranza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $IDDomicilioCobranza;
    /**
     * The CUITCUIL
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $CUITCUIL;
    /**
     * The Sociedad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Sociedad;
    /**
     * The GrupoTelemarketer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GrupoTelemarketer;
    /**
     * The BarrioCerrado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $BarrioCerrado;
    /**
     * The Activo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Activo;
    /**
     * The CalleNormalizada
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $CalleNormalizada;
    /**
     * The IdentidadVerificada
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $IdentidadVerificada;
    /**
     * The CodigoCalle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CodigoCalle;
    /**
     * The IDTitulo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDTitulo;
    /**
     * The IDDomicilioComercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $IDDomicilioComercial;
    /**
     * The AgenciaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AgenciaID;
    /**
     * The RecibeCorrespondencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RecibeCorrespondencia;
    /**
     * The IDPersona
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersona;
    /**
     * The Nombre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nombre;
    /**
     * The Apellido
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Apellido;
    /**
     * The Calle
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Calle;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Numero;
    /**
     * The Piso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Piso;
    /**
     * The DeptoOficina
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeptoOficina;
    /**
     * The IDLocalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDLocalidad;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The IDPais
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPais;
    /**
     * The IDTipoDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoDocumento;
    /**
     * The IDUEN
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDUEN;
    /**
     * The IDTipoPersona
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersona;
    /**
     * The AclaracionDomicilio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AclaracionDomicilio;
    /**
     * The Telefono
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Telefono;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The IDSexo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDSexo;
    /**
     * The IDEstadoCivil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDEstadoCivil;
    /**
     * The IDActividad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDActividad;
    /**
     * The IDNacionalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDNacionalidad;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Email;
    /**
     * The IDPersonaEmpresa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaEmpresa;
    /**
     * The IDPersonaConyuge
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaConyuge;
    /**
     * The NombreBanco
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreBanco;
    /**
     * The NombreProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreProvincia;
    /**
     * The NombreLocalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreLocalidad;
    /**
     * The IDRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRiesgo;
    /**
     * The UsuarioCreacionID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsuarioCreacionID;
    /**
     * The PisoDptoAS400
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PisoDptoAS400;
    /**
     * The Domicilio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EmisionMotorsSalidaPersonaDomicilio
     */
    public $Domicilio;
    /**
     * Constructor method for EmisionMotorsSalidaPersona
     * @uses EmisionMotorsSalidaPersona::setNroDocumento()
     * @uses EmisionMotorsSalidaPersona::setFechaNacimiento()
     * @uses EmisionMotorsSalidaPersona::setIDDomicilioCobranza()
     * @uses EmisionMotorsSalidaPersona::setCUITCUIL()
     * @uses EmisionMotorsSalidaPersona::setSociedad()
     * @uses EmisionMotorsSalidaPersona::setGrupoTelemarketer()
     * @uses EmisionMotorsSalidaPersona::setBarrioCerrado()
     * @uses EmisionMotorsSalidaPersona::setActivo()
     * @uses EmisionMotorsSalidaPersona::setCalleNormalizada()
     * @uses EmisionMotorsSalidaPersona::setIdentidadVerificada()
     * @uses EmisionMotorsSalidaPersona::setCodigoCalle()
     * @uses EmisionMotorsSalidaPersona::setIDTitulo()
     * @uses EmisionMotorsSalidaPersona::setIDDomicilioComercial()
     * @uses EmisionMotorsSalidaPersona::setAgenciaID()
     * @uses EmisionMotorsSalidaPersona::setRecibeCorrespondencia()
     * @uses EmisionMotorsSalidaPersona::setIDPersona()
     * @uses EmisionMotorsSalidaPersona::setNombre()
     * @uses EmisionMotorsSalidaPersona::setApellido()
     * @uses EmisionMotorsSalidaPersona::setCalle()
     * @uses EmisionMotorsSalidaPersona::setNumero()
     * @uses EmisionMotorsSalidaPersona::setPiso()
     * @uses EmisionMotorsSalidaPersona::setDeptoOficina()
     * @uses EmisionMotorsSalidaPersona::setIDLocalidad()
     * @uses EmisionMotorsSalidaPersona::setIDProvincia()
     * @uses EmisionMotorsSalidaPersona::setIDPais()
     * @uses EmisionMotorsSalidaPersona::setIDTipoDocumento()
     * @uses EmisionMotorsSalidaPersona::setIDUEN()
     * @uses EmisionMotorsSalidaPersona::setIDTipoPersona()
     * @uses EmisionMotorsSalidaPersona::setAclaracionDomicilio()
     * @uses EmisionMotorsSalidaPersona::setTelefono()
     * @uses EmisionMotorsSalidaPersona::setCodigoPostal()
     * @uses EmisionMotorsSalidaPersona::setIDCondicionIVA()
     * @uses EmisionMotorsSalidaPersona::setIDSexo()
     * @uses EmisionMotorsSalidaPersona::setIDEstadoCivil()
     * @uses EmisionMotorsSalidaPersona::setIDActividad()
     * @uses EmisionMotorsSalidaPersona::setIDNacionalidad()
     * @uses EmisionMotorsSalidaPersona::setEmail()
     * @uses EmisionMotorsSalidaPersona::setIDPersonaEmpresa()
     * @uses EmisionMotorsSalidaPersona::setIDPersonaConyuge()
     * @uses EmisionMotorsSalidaPersona::setNombreBanco()
     * @uses EmisionMotorsSalidaPersona::setNombreProvincia()
     * @uses EmisionMotorsSalidaPersona::setNombreLocalidad()
     * @uses EmisionMotorsSalidaPersona::setIDRiesgo()
     * @uses EmisionMotorsSalidaPersona::setUsuarioCreacionID()
     * @uses EmisionMotorsSalidaPersona::setPisoDptoAS400()
     * @uses EmisionMotorsSalidaPersona::setDomicilio()
     * @param float $nroDocumento
     * @param string $fechaNacimiento
     * @param int $iDDomicilioCobranza
     * @param float $cUITCUIL
     * @param int $sociedad
     * @param int $grupoTelemarketer
     * @param bool $barrioCerrado
     * @param bool $activo
     * @param bool $calleNormalizada
     * @param bool $identidadVerificada
     * @param int $codigoCalle
     * @param int $iDTitulo
     * @param int $iDDomicilioComercial
     * @param int $agenciaID
     * @param bool $recibeCorrespondencia
     * @param string $iDPersona
     * @param string $nombre
     * @param string $apellido
     * @param string $calle
     * @param string $numero
     * @param string $piso
     * @param string $deptoOficina
     * @param string $iDLocalidad
     * @param string $iDProvincia
     * @param string $iDPais
     * @param string $iDTipoDocumento
     * @param string $iDUEN
     * @param string $iDTipoPersona
     * @param string $aclaracionDomicilio
     * @param string $telefono
     * @param string $codigoPostal
     * @param string $iDCondicionIVA
     * @param string $iDSexo
     * @param string $iDEstadoCivil
     * @param string $iDActividad
     * @param string $iDNacionalidad
     * @param string $email
     * @param string $iDPersonaEmpresa
     * @param string $iDPersonaConyuge
     * @param string $nombreBanco
     * @param string $nombreProvincia
     * @param string $nombreLocalidad
     * @param string $iDRiesgo
     * @param string $usuarioCreacionID
     * @param string $pisoDptoAS400
     * @param \StructType\EmisionMotorsSalidaPersonaDomicilio $domicilio
     */
    public function __construct($nroDocumento = null, $fechaNacimiento = null, $iDDomicilioCobranza = null, $cUITCUIL = null, $sociedad = null, $grupoTelemarketer = null, $barrioCerrado = null, $activo = null, $calleNormalizada = null, $identidadVerificada = null, $codigoCalle = null, $iDTitulo = null, $iDDomicilioComercial = null, $agenciaID = null, $recibeCorrespondencia = null, $iDPersona = null, $nombre = null, $apellido = null, $calle = null, $numero = null, $piso = null, $deptoOficina = null, $iDLocalidad = null, $iDProvincia = null, $iDPais = null, $iDTipoDocumento = null, $iDUEN = null, $iDTipoPersona = null, $aclaracionDomicilio = null, $telefono = null, $codigoPostal = null, $iDCondicionIVA = null, $iDSexo = null, $iDEstadoCivil = null, $iDActividad = null, $iDNacionalidad = null, $email = null, $iDPersonaEmpresa = null, $iDPersonaConyuge = null, $nombreBanco = null, $nombreProvincia = null, $nombreLocalidad = null, $iDRiesgo = null, $usuarioCreacionID = null, $pisoDptoAS400 = null, \StructType\EmisionMotorsSalidaPersonaDomicilio $domicilio = null)
    {
        $this
            ->setNroDocumento($nroDocumento)
            ->setFechaNacimiento($fechaNacimiento)
            ->setIDDomicilioCobranza($iDDomicilioCobranza)
            ->setCUITCUIL($cUITCUIL)
            ->setSociedad($sociedad)
            ->setGrupoTelemarketer($grupoTelemarketer)
            ->setBarrioCerrado($barrioCerrado)
            ->setActivo($activo)
            ->setCalleNormalizada($calleNormalizada)
            ->setIdentidadVerificada($identidadVerificada)
            ->setCodigoCalle($codigoCalle)
            ->setIDTitulo($iDTitulo)
            ->setIDDomicilioComercial($iDDomicilioComercial)
            ->setAgenciaID($agenciaID)
            ->setRecibeCorrespondencia($recibeCorrespondencia)
            ->setIDPersona($iDPersona)
            ->setNombre($nombre)
            ->setApellido($apellido)
            ->setCalle($calle)
            ->setNumero($numero)
            ->setPiso($piso)
            ->setDeptoOficina($deptoOficina)
            ->setIDLocalidad($iDLocalidad)
            ->setIDProvincia($iDProvincia)
            ->setIDPais($iDPais)
            ->setIDTipoDocumento($iDTipoDocumento)
            ->setIDUEN($iDUEN)
            ->setIDTipoPersona($iDTipoPersona)
            ->setAclaracionDomicilio($aclaracionDomicilio)
            ->setTelefono($telefono)
            ->setCodigoPostal($codigoPostal)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setIDSexo($iDSexo)
            ->setIDEstadoCivil($iDEstadoCivil)
            ->setIDActividad($iDActividad)
            ->setIDNacionalidad($iDNacionalidad)
            ->setEmail($email)
            ->setIDPersonaEmpresa($iDPersonaEmpresa)
            ->setIDPersonaConyuge($iDPersonaConyuge)
            ->setNombreBanco($nombreBanco)
            ->setNombreProvincia($nombreProvincia)
            ->setNombreLocalidad($nombreLocalidad)
            ->setIDRiesgo($iDRiesgo)
            ->setUsuarioCreacionID($usuarioCreacionID)
            ->setPisoDptoAS400($pisoDptoAS400)
            ->setDomicilio($domicilio);
    }
    /**
     * Get NroDocumento value
     * @return float
     */
    public function getNroDocumento()
    {
        return $this->NroDocumento;
    }
    /**
     * Set NroDocumento value
     * @param float $nroDocumento
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setNroDocumento($nroDocumento = null)
    {
        // validation for constraint: float
        if (!is_null($nroDocumento) && !(is_float($nroDocumento) || is_numeric($nroDocumento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($nroDocumento, true), gettype($nroDocumento)), __LINE__);
        }
        $this->NroDocumento = $nroDocumento;
        return $this;
    }
    /**
     * Get FechaNacimiento value
     * @return string
     */
    public function getFechaNacimiento()
    {
        return $this->FechaNacimiento;
    }
    /**
     * Set FechaNacimiento value
     * @param string $fechaNacimiento
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setFechaNacimiento($fechaNacimiento = null)
    {
        // validation for constraint: string
        if (!is_null($fechaNacimiento) && !is_string($fechaNacimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaNacimiento, true), gettype($fechaNacimiento)), __LINE__);
        }
        $this->FechaNacimiento = $fechaNacimiento;
        return $this;
    }
    /**
     * Get IDDomicilioCobranza value
     * @return int
     */
    public function getIDDomicilioCobranza()
    {
        return $this->IDDomicilioCobranza;
    }
    /**
     * Set IDDomicilioCobranza value
     * @param int $iDDomicilioCobranza
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDDomicilioCobranza($iDDomicilioCobranza = null)
    {
        // validation for constraint: int
        if (!is_null($iDDomicilioCobranza) && !(is_int($iDDomicilioCobranza) || ctype_digit($iDDomicilioCobranza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDomicilioCobranza, true), gettype($iDDomicilioCobranza)), __LINE__);
        }
        $this->IDDomicilioCobranza = $iDDomicilioCobranza;
        return $this;
    }
    /**
     * Get CUITCUIL value
     * @return float
     */
    public function getCUITCUIL()
    {
        return $this->CUITCUIL;
    }
    /**
     * Set CUITCUIL value
     * @param float $cUITCUIL
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setCUITCUIL($cUITCUIL = null)
    {
        // validation for constraint: float
        if (!is_null($cUITCUIL) && !(is_float($cUITCUIL) || is_numeric($cUITCUIL))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cUITCUIL, true), gettype($cUITCUIL)), __LINE__);
        }
        $this->CUITCUIL = $cUITCUIL;
        return $this;
    }
    /**
     * Get Sociedad value
     * @return int
     */
    public function getSociedad()
    {
        return $this->Sociedad;
    }
    /**
     * Set Sociedad value
     * @param int $sociedad
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setSociedad($sociedad = null)
    {
        // validation for constraint: int
        if (!is_null($sociedad) && !(is_int($sociedad) || ctype_digit($sociedad))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sociedad, true), gettype($sociedad)), __LINE__);
        }
        $this->Sociedad = $sociedad;
        return $this;
    }
    /**
     * Get GrupoTelemarketer value
     * @return int
     */
    public function getGrupoTelemarketer()
    {
        return $this->GrupoTelemarketer;
    }
    /**
     * Set GrupoTelemarketer value
     * @param int $grupoTelemarketer
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setGrupoTelemarketer($grupoTelemarketer = null)
    {
        // validation for constraint: int
        if (!is_null($grupoTelemarketer) && !(is_int($grupoTelemarketer) || ctype_digit($grupoTelemarketer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($grupoTelemarketer, true), gettype($grupoTelemarketer)), __LINE__);
        }
        $this->GrupoTelemarketer = $grupoTelemarketer;
        return $this;
    }
    /**
     * Get BarrioCerrado value
     * @return bool
     */
    public function getBarrioCerrado()
    {
        return $this->BarrioCerrado;
    }
    /**
     * Set BarrioCerrado value
     * @param bool $barrioCerrado
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setBarrioCerrado($barrioCerrado = null)
    {
        // validation for constraint: boolean
        if (!is_null($barrioCerrado) && !is_bool($barrioCerrado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($barrioCerrado, true), gettype($barrioCerrado)), __LINE__);
        }
        $this->BarrioCerrado = $barrioCerrado;
        return $this;
    }
    /**
     * Get Activo value
     * @return bool
     */
    public function getActivo()
    {
        return $this->Activo;
    }
    /**
     * Set Activo value
     * @param bool $activo
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setActivo($activo = null)
    {
        // validation for constraint: boolean
        if (!is_null($activo) && !is_bool($activo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($activo, true), gettype($activo)), __LINE__);
        }
        $this->Activo = $activo;
        return $this;
    }
    /**
     * Get CalleNormalizada value
     * @return bool
     */
    public function getCalleNormalizada()
    {
        return $this->CalleNormalizada;
    }
    /**
     * Set CalleNormalizada value
     * @param bool $calleNormalizada
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setCalleNormalizada($calleNormalizada = null)
    {
        // validation for constraint: boolean
        if (!is_null($calleNormalizada) && !is_bool($calleNormalizada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calleNormalizada, true), gettype($calleNormalizada)), __LINE__);
        }
        $this->CalleNormalizada = $calleNormalizada;
        return $this;
    }
    /**
     * Get IdentidadVerificada value
     * @return bool
     */
    public function getIdentidadVerificada()
    {
        return $this->IdentidadVerificada;
    }
    /**
     * Set IdentidadVerificada value
     * @param bool $identidadVerificada
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIdentidadVerificada($identidadVerificada = null)
    {
        // validation for constraint: boolean
        if (!is_null($identidadVerificada) && !is_bool($identidadVerificada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($identidadVerificada, true), gettype($identidadVerificada)), __LINE__);
        }
        $this->IdentidadVerificada = $identidadVerificada;
        return $this;
    }
    /**
     * Get CodigoCalle value
     * @return int
     */
    public function getCodigoCalle()
    {
        return $this->CodigoCalle;
    }
    /**
     * Set CodigoCalle value
     * @param int $codigoCalle
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setCodigoCalle($codigoCalle = null)
    {
        // validation for constraint: int
        if (!is_null($codigoCalle) && !(is_int($codigoCalle) || ctype_digit($codigoCalle))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($codigoCalle, true), gettype($codigoCalle)), __LINE__);
        }
        $this->CodigoCalle = $codigoCalle;
        return $this;
    }
    /**
     * Get IDTitulo value
     * @return int
     */
    public function getIDTitulo()
    {
        return $this->IDTitulo;
    }
    /**
     * Set IDTitulo value
     * @param int $iDTitulo
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDTitulo($iDTitulo = null)
    {
        // validation for constraint: int
        if (!is_null($iDTitulo) && !(is_int($iDTitulo) || ctype_digit($iDTitulo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDTitulo, true), gettype($iDTitulo)), __LINE__);
        }
        $this->IDTitulo = $iDTitulo;
        return $this;
    }
    /**
     * Get IDDomicilioComercial value
     * @return int
     */
    public function getIDDomicilioComercial()
    {
        return $this->IDDomicilioComercial;
    }
    /**
     * Set IDDomicilioComercial value
     * @param int $iDDomicilioComercial
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDDomicilioComercial($iDDomicilioComercial = null)
    {
        // validation for constraint: int
        if (!is_null($iDDomicilioComercial) && !(is_int($iDDomicilioComercial) || ctype_digit($iDDomicilioComercial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDDomicilioComercial, true), gettype($iDDomicilioComercial)), __LINE__);
        }
        $this->IDDomicilioComercial = $iDDomicilioComercial;
        return $this;
    }
    /**
     * Get AgenciaID value
     * @return int
     */
    public function getAgenciaID()
    {
        return $this->AgenciaID;
    }
    /**
     * Set AgenciaID value
     * @param int $agenciaID
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setAgenciaID($agenciaID = null)
    {
        // validation for constraint: int
        if (!is_null($agenciaID) && !(is_int($agenciaID) || ctype_digit($agenciaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agenciaID, true), gettype($agenciaID)), __LINE__);
        }
        $this->AgenciaID = $agenciaID;
        return $this;
    }
    /**
     * Get RecibeCorrespondencia value
     * @return bool
     */
    public function getRecibeCorrespondencia()
    {
        return $this->RecibeCorrespondencia;
    }
    /**
     * Set RecibeCorrespondencia value
     * @param bool $recibeCorrespondencia
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setRecibeCorrespondencia($recibeCorrespondencia = null)
    {
        // validation for constraint: boolean
        if (!is_null($recibeCorrespondencia) && !is_bool($recibeCorrespondencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recibeCorrespondencia, true), gettype($recibeCorrespondencia)), __LINE__);
        }
        $this->RecibeCorrespondencia = $recibeCorrespondencia;
        return $this;
    }
    /**
     * Get IDPersona value
     * @return string|null
     */
    public function getIDPersona()
    {
        return $this->IDPersona;
    }
    /**
     * Set IDPersona value
     * @param string $iDPersona
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDPersona($iDPersona = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersona) && !is_string($iDPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersona, true), gettype($iDPersona)), __LINE__);
        }
        $this->IDPersona = $iDPersona;
        return $this;
    }
    /**
     * Get Nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->Nombre;
    }
    /**
     * Set Nombre value
     * @param string $nombre
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->Nombre = $nombre;
        return $this;
    }
    /**
     * Get Apellido value
     * @return string|null
     */
    public function getApellido()
    {
        return $this->Apellido;
    }
    /**
     * Set Apellido value
     * @param string $apellido
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setApellido($apellido = null)
    {
        // validation for constraint: string
        if (!is_null($apellido) && !is_string($apellido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apellido, true), gettype($apellido)), __LINE__);
        }
        $this->Apellido = $apellido;
        return $this;
    }
    /**
     * Get Calle value
     * @return string|null
     */
    public function getCalle()
    {
        return $this->Calle;
    }
    /**
     * Set Calle value
     * @param string $calle
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setCalle($calle = null)
    {
        // validation for constraint: string
        if (!is_null($calle) && !is_string($calle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($calle, true), gettype($calle)), __LINE__);
        }
        $this->Calle = $calle;
        return $this;
    }
    /**
     * Get Numero value
     * @return string|null
     */
    public function getNumero()
    {
        return $this->Numero;
    }
    /**
     * Set Numero value
     * @param string $numero
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        $this->Numero = $numero;
        return $this;
    }
    /**
     * Get Piso value
     * @return string|null
     */
    public function getPiso()
    {
        return $this->Piso;
    }
    /**
     * Set Piso value
     * @param string $piso
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setPiso($piso = null)
    {
        // validation for constraint: string
        if (!is_null($piso) && !is_string($piso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($piso, true), gettype($piso)), __LINE__);
        }
        $this->Piso = $piso;
        return $this;
    }
    /**
     * Get DeptoOficina value
     * @return string|null
     */
    public function getDeptoOficina()
    {
        return $this->DeptoOficina;
    }
    /**
     * Set DeptoOficina value
     * @param string $deptoOficina
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setDeptoOficina($deptoOficina = null)
    {
        // validation for constraint: string
        if (!is_null($deptoOficina) && !is_string($deptoOficina)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deptoOficina, true), gettype($deptoOficina)), __LINE__);
        }
        $this->DeptoOficina = $deptoOficina;
        return $this;
    }
    /**
     * Get IDLocalidad value
     * @return string|null
     */
    public function getIDLocalidad()
    {
        return $this->IDLocalidad;
    }
    /**
     * Set IDLocalidad value
     * @param string $iDLocalidad
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDLocalidad($iDLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($iDLocalidad) && !is_string($iDLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDLocalidad, true), gettype($iDLocalidad)), __LINE__);
        }
        $this->IDLocalidad = $iDLocalidad;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get IDPais value
     * @return string|null
     */
    public function getIDPais()
    {
        return $this->IDPais;
    }
    /**
     * Set IDPais value
     * @param string $iDPais
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDPais($iDPais = null)
    {
        // validation for constraint: string
        if (!is_null($iDPais) && !is_string($iDPais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPais, true), gettype($iDPais)), __LINE__);
        }
        $this->IDPais = $iDPais;
        return $this;
    }
    /**
     * Get IDTipoDocumento value
     * @return string|null
     */
    public function getIDTipoDocumento()
    {
        return $this->IDTipoDocumento;
    }
    /**
     * Set IDTipoDocumento value
     * @param string $iDTipoDocumento
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDTipoDocumento($iDTipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoDocumento) && !is_string($iDTipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoDocumento, true), gettype($iDTipoDocumento)), __LINE__);
        }
        $this->IDTipoDocumento = $iDTipoDocumento;
        return $this;
    }
    /**
     * Get IDUEN value
     * @return string|null
     */
    public function getIDUEN()
    {
        return $this->IDUEN;
    }
    /**
     * Set IDUEN value
     * @param string $iDUEN
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDUEN($iDUEN = null)
    {
        // validation for constraint: string
        if (!is_null($iDUEN) && !is_string($iDUEN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDUEN, true), gettype($iDUEN)), __LINE__);
        }
        $this->IDUEN = $iDUEN;
        return $this;
    }
    /**
     * Get IDTipoPersona value
     * @return string|null
     */
    public function getIDTipoPersona()
    {
        return $this->IDTipoPersona;
    }
    /**
     * Set IDTipoPersona value
     * @param string $iDTipoPersona
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDTipoPersona($iDTipoPersona = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersona) && !is_string($iDTipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersona, true), gettype($iDTipoPersona)), __LINE__);
        }
        $this->IDTipoPersona = $iDTipoPersona;
        return $this;
    }
    /**
     * Get AclaracionDomicilio value
     * @return string|null
     */
    public function getAclaracionDomicilio()
    {
        return $this->AclaracionDomicilio;
    }
    /**
     * Set AclaracionDomicilio value
     * @param string $aclaracionDomicilio
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setAclaracionDomicilio($aclaracionDomicilio = null)
    {
        // validation for constraint: string
        if (!is_null($aclaracionDomicilio) && !is_string($aclaracionDomicilio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aclaracionDomicilio, true), gettype($aclaracionDomicilio)), __LINE__);
        }
        $this->AclaracionDomicilio = $aclaracionDomicilio;
        return $this;
    }
    /**
     * Get Telefono value
     * @return string|null
     */
    public function getTelefono()
    {
        return $this->Telefono;
    }
    /**
     * Set Telefono value
     * @param string $telefono
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setTelefono($telefono = null)
    {
        // validation for constraint: string
        if (!is_null($telefono) && !is_string($telefono)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefono, true), gettype($telefono)), __LINE__);
        }
        $this->Telefono = $telefono;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get IDSexo value
     * @return string|null
     */
    public function getIDSexo()
    {
        return $this->IDSexo;
    }
    /**
     * Set IDSexo value
     * @param string $iDSexo
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDSexo($iDSexo = null)
    {
        // validation for constraint: string
        if (!is_null($iDSexo) && !is_string($iDSexo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSexo, true), gettype($iDSexo)), __LINE__);
        }
        $this->IDSexo = $iDSexo;
        return $this;
    }
    /**
     * Get IDEstadoCivil value
     * @return string|null
     */
    public function getIDEstadoCivil()
    {
        return $this->IDEstadoCivil;
    }
    /**
     * Set IDEstadoCivil value
     * @param string $iDEstadoCivil
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDEstadoCivil($iDEstadoCivil = null)
    {
        // validation for constraint: string
        if (!is_null($iDEstadoCivil) && !is_string($iDEstadoCivil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDEstadoCivil, true), gettype($iDEstadoCivil)), __LINE__);
        }
        $this->IDEstadoCivil = $iDEstadoCivil;
        return $this;
    }
    /**
     * Get IDActividad value
     * @return string|null
     */
    public function getIDActividad()
    {
        return $this->IDActividad;
    }
    /**
     * Set IDActividad value
     * @param string $iDActividad
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDActividad($iDActividad = null)
    {
        // validation for constraint: string
        if (!is_null($iDActividad) && !is_string($iDActividad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDActividad, true), gettype($iDActividad)), __LINE__);
        }
        $this->IDActividad = $iDActividad;
        return $this;
    }
    /**
     * Get IDNacionalidad value
     * @return string|null
     */
    public function getIDNacionalidad()
    {
        return $this->IDNacionalidad;
    }
    /**
     * Set IDNacionalidad value
     * @param string $iDNacionalidad
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDNacionalidad($iDNacionalidad = null)
    {
        // validation for constraint: string
        if (!is_null($iDNacionalidad) && !is_string($iDNacionalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDNacionalidad, true), gettype($iDNacionalidad)), __LINE__);
        }
        $this->IDNacionalidad = $iDNacionalidad;
        return $this;
    }
    /**
     * Get Email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param string $email
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Get IDPersonaEmpresa value
     * @return string|null
     */
    public function getIDPersonaEmpresa()
    {
        return $this->IDPersonaEmpresa;
    }
    /**
     * Set IDPersonaEmpresa value
     * @param string $iDPersonaEmpresa
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDPersonaEmpresa($iDPersonaEmpresa = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaEmpresa) && !is_string($iDPersonaEmpresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaEmpresa, true), gettype($iDPersonaEmpresa)), __LINE__);
        }
        $this->IDPersonaEmpresa = $iDPersonaEmpresa;
        return $this;
    }
    /**
     * Get IDPersonaConyuge value
     * @return string|null
     */
    public function getIDPersonaConyuge()
    {
        return $this->IDPersonaConyuge;
    }
    /**
     * Set IDPersonaConyuge value
     * @param string $iDPersonaConyuge
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDPersonaConyuge($iDPersonaConyuge = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaConyuge) && !is_string($iDPersonaConyuge)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaConyuge, true), gettype($iDPersonaConyuge)), __LINE__);
        }
        $this->IDPersonaConyuge = $iDPersonaConyuge;
        return $this;
    }
    /**
     * Get NombreBanco value
     * @return string|null
     */
    public function getNombreBanco()
    {
        return $this->NombreBanco;
    }
    /**
     * Set NombreBanco value
     * @param string $nombreBanco
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setNombreBanco($nombreBanco = null)
    {
        // validation for constraint: string
        if (!is_null($nombreBanco) && !is_string($nombreBanco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreBanco, true), gettype($nombreBanco)), __LINE__);
        }
        $this->NombreBanco = $nombreBanco;
        return $this;
    }
    /**
     * Get NombreProvincia value
     * @return string|null
     */
    public function getNombreProvincia()
    {
        return $this->NombreProvincia;
    }
    /**
     * Set NombreProvincia value
     * @param string $nombreProvincia
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setNombreProvincia($nombreProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($nombreProvincia) && !is_string($nombreProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreProvincia, true), gettype($nombreProvincia)), __LINE__);
        }
        $this->NombreProvincia = $nombreProvincia;
        return $this;
    }
    /**
     * Get NombreLocalidad value
     * @return string|null
     */
    public function getNombreLocalidad()
    {
        return $this->NombreLocalidad;
    }
    /**
     * Set NombreLocalidad value
     * @param string $nombreLocalidad
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setNombreLocalidad($nombreLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($nombreLocalidad) && !is_string($nombreLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreLocalidad, true), gettype($nombreLocalidad)), __LINE__);
        }
        $this->NombreLocalidad = $nombreLocalidad;
        return $this;
    }
    /**
     * Get IDRiesgo value
     * @return string|null
     */
    public function getIDRiesgo()
    {
        return $this->IDRiesgo;
    }
    /**
     * Set IDRiesgo value
     * @param string $iDRiesgo
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setIDRiesgo($iDRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDRiesgo) && !is_string($iDRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRiesgo, true), gettype($iDRiesgo)), __LINE__);
        }
        $this->IDRiesgo = $iDRiesgo;
        return $this;
    }
    /**
     * Get UsuarioCreacionID value
     * @return string|null
     */
    public function getUsuarioCreacionID()
    {
        return $this->UsuarioCreacionID;
    }
    /**
     * Set UsuarioCreacionID value
     * @param string $usuarioCreacionID
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setUsuarioCreacionID($usuarioCreacionID = null)
    {
        // validation for constraint: string
        if (!is_null($usuarioCreacionID) && !is_string($usuarioCreacionID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuarioCreacionID, true), gettype($usuarioCreacionID)), __LINE__);
        }
        $this->UsuarioCreacionID = $usuarioCreacionID;
        return $this;
    }
    /**
     * Get PisoDptoAS400 value
     * @return string|null
     */
    public function getPisoDptoAS400()
    {
        return $this->PisoDptoAS400;
    }
    /**
     * Set PisoDptoAS400 value
     * @param string $pisoDptoAS400
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setPisoDptoAS400($pisoDptoAS400 = null)
    {
        // validation for constraint: string
        if (!is_null($pisoDptoAS400) && !is_string($pisoDptoAS400)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pisoDptoAS400, true), gettype($pisoDptoAS400)), __LINE__);
        }
        $this->PisoDptoAS400 = $pisoDptoAS400;
        return $this;
    }
    /**
     * Get Domicilio value
     * @return \StructType\EmisionMotorsSalidaPersonaDomicilio|null
     */
    public function getDomicilio()
    {
        return $this->Domicilio;
    }
    /**
     * Set Domicilio value
     * @param \StructType\EmisionMotorsSalidaPersonaDomicilio $domicilio
     * @return \StructType\EmisionMotorsSalidaPersona
     */
    public function setDomicilio(\StructType\EmisionMotorsSalidaPersonaDomicilio $domicilio = null)
    {
        $this->Domicilio = $domicilio;
        return $this;
    }
}
