<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalINEmisionRoboOrdenCostoCanal StructType
 * @subpackage Structs
 */
class DocCanalINEmisionRoboOrdenCostoCanal extends AbstractStructBase
{
    /**
     * The OrdenCostoCanalID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenCostoCanalID;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Valor;
    /**
     * The IDConcepto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDConcepto;
    /**
     * The Vigencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vigencia;
    /**
     * Constructor method for DocCanalINEmisionRoboOrdenCostoCanal
     * @uses DocCanalINEmisionRoboOrdenCostoCanal::setOrdenCostoCanalID()
     * @uses DocCanalINEmisionRoboOrdenCostoCanal::setValor()
     * @uses DocCanalINEmisionRoboOrdenCostoCanal::setIDConcepto()
     * @uses DocCanalINEmisionRoboOrdenCostoCanal::setVigencia()
     * @param int $ordenCostoCanalID
     * @param float $valor
     * @param string $iDConcepto
     * @param string $vigencia
     */
    public function __construct($ordenCostoCanalID = null, $valor = null, $iDConcepto = null, $vigencia = null)
    {
        $this
            ->setOrdenCostoCanalID($ordenCostoCanalID)
            ->setValor($valor)
            ->setIDConcepto($iDConcepto)
            ->setVigencia($vigencia);
    }
    /**
     * Get OrdenCostoCanalID value
     * @return int
     */
    public function getOrdenCostoCanalID()
    {
        return $this->OrdenCostoCanalID;
    }
    /**
     * Set OrdenCostoCanalID value
     * @param int $ordenCostoCanalID
     * @return \StructType\DocCanalINEmisionRoboOrdenCostoCanal
     */
    public function setOrdenCostoCanalID($ordenCostoCanalID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenCostoCanalID) && !(is_int($ordenCostoCanalID) || ctype_digit($ordenCostoCanalID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenCostoCanalID, true), gettype($ordenCostoCanalID)), __LINE__);
        }
        $this->OrdenCostoCanalID = $ordenCostoCanalID;
        return $this;
    }
    /**
     * Get Valor value
     * @return float
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\DocCanalINEmisionRoboOrdenCostoCanal
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get IDConcepto value
     * @return string|null
     */
    public function getIDConcepto()
    {
        return $this->IDConcepto;
    }
    /**
     * Set IDConcepto value
     * @param string $iDConcepto
     * @return \StructType\DocCanalINEmisionRoboOrdenCostoCanal
     */
    public function setIDConcepto($iDConcepto = null)
    {
        // validation for constraint: string
        if (!is_null($iDConcepto) && !is_string($iDConcepto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDConcepto, true), gettype($iDConcepto)), __LINE__);
        }
        $this->IDConcepto = $iDConcepto;
        return $this;
    }
    /**
     * Get Vigencia value
     * @return string|null
     */
    public function getVigencia()
    {
        return $this->Vigencia;
    }
    /**
     * Set Vigencia value
     * @param string $vigencia
     * @return \StructType\DocCanalINEmisionRoboOrdenCostoCanal
     */
    public function setVigencia($vigencia = null)
    {
        // validation for constraint: string
        if (!is_null($vigencia) && !is_string($vigencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vigencia, true), gettype($vigencia)), __LINE__);
        }
        $this->Vigencia = $vigencia;
        return $this;
    }
}
