<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cotizar ServiceType
 * @subpackage Services
 */
class Cotizar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CotizarAutomovil
     * Meta information extracted from the WSDL
     * - documentation: Realiza una cotización de motor. El último parámetro es un string XML que debe cumplir con el XSD ubicado en el método CotizarAutomovilInXsd. | Realiza una cotización de motor. El último parámetro es un string XML que debe
     * cumplir con el XSD ubicado en el método CotizarAutomovilInXsd. | Realiza una cotización de motor. El último parámetro es un string XML que debe cumplir con el XSD ubicado en el método CotizarAutomovilInXsd.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CotizarAutomovil $parameters
     * @return \StructType\CotizarAutomovilResponse|bool
     */
    public function CotizarAutomovil(\StructType\CotizarAutomovil $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizarAutomovil($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizarAutomovilStruct
     * Meta information extracted from the WSDL
     * - documentation: Realiza una cotización de motor. El último parámetro es un objeto que debe cumplir con el XSD ubicado en el método CotizarAutomovilInXsd.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CotizarAutomovilStruct $parameters
     * @return \StructType\CotizarAutomovilStructResponse|bool
     */
    public function CotizarAutomovilStruct(\StructType\CotizarAutomovilStruct $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizarAutomovilStruct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizarOrdenHogar
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Cotización de Orden Hogar.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CotizarOrdenHogar $parameters
     * @return \StructType\CotizarOrdenHogarResponse|bool
     */
    public function CotizarOrdenHogar(\StructType\CotizarOrdenHogar $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizarOrdenHogar($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizarOrdenRobo
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Cotización de Orden Robo.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CotizarOrdenRobo $parameters
     * @return \StructType\CotizarOrdenRoboResponse|bool
     */
    public function CotizarOrdenRobo(\StructType\CotizarOrdenRobo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizarOrdenRobo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named CotizarOrdenComercio
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Cotización de Orden Comercio.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CotizarOrdenComercio $parameters
     * @return \StructType\CotizarOrdenComercioResponse|bool
     */
    public function CotizarOrdenComercio(\StructType\CotizarOrdenComercio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->CotizarOrdenComercio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CotizarAutomovilResponse|\StructType\CotizarAutomovilStructResponse|\StructType\CotizarOrdenComercioResponse|\StructType\CotizarOrdenHogarResponse|\StructType\CotizarOrdenRoboResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
