<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfString ArrayType
 * @subpackage Arrays
 */
class ArrayOfString extends AbstractStructArrayBase
{
    /**
     * The Cobertura
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Cobertura;
    /**
     * Constructor method for ArrayOfString
     * @uses ArrayOfString::setCobertura()
     * @param string[] $cobertura
     */
    public function __construct(array $cobertura = array())
    {
        $this
            ->setCobertura($cobertura);
    }
    /**
     * Get Cobertura value
     * @return string[]|null
     */
    public function getCobertura()
    {
        return $this->Cobertura;
    }
    /**
     * This method is responsible for validating the values passed to the setCobertura method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCobertura method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoberturaForArrayConstraintsFromSetCobertura(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStringCoberturaItem) {
            // validation for constraint: itemType
            if (!is_string($arrayOfStringCoberturaItem)) {
                $invalidValues[] = is_object($arrayOfStringCoberturaItem) ? get_class($arrayOfStringCoberturaItem) : sprintf('%s(%s)', gettype($arrayOfStringCoberturaItem), var_export($arrayOfStringCoberturaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cobertura property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cobertura value
     * @throws \InvalidArgumentException
     * @param string[] $cobertura
     * @return \ArrayType\ArrayOfString
     */
    public function setCobertura(array $cobertura = array())
    {
        // validation for constraint: array
        if ('' !== ($coberturaArrayErrorMessage = self::validateCoberturaForArrayConstraintsFromSetCobertura($cobertura))) {
            throw new \InvalidArgumentException($coberturaArrayErrorMessage, __LINE__);
        }
        $this->Cobertura = $cobertura;
        return $this;
    }
    /**
     * Add item to Cobertura value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \ArrayType\ArrayOfString
     */
    public function addToCobertura($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Cobertura property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cobertura[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return string|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return string|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return string|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return string|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return string|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cobertura
     */
    public function getAttributeName()
    {
        return 'Cobertura';
    }
}
