<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tercero StructType
 * @subpackage Structs
 */
class Tercero extends AbstractStructBase
{
    /**
     * The EdadalFallecimiento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EdadalFallecimiento;
    /**
     * The CodigodelTercero
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigodelTercero;
    /**
     * The FechadeFallecimiento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FechadeFallecimiento;
    /**
     * The FechadeNacimiento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FechadeNacimiento;
    /**
     * The RoldelContacto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RoldelContacto;
    /**
     * The Nombre
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Nombre;
    /**
     * The Sexo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sexo;
    /**
     * The Apellido
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Apellido;
    /**
     * The EstadoCivil
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EstadoCivil;
    /**
     * The RelacionParentescoconelAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RelacionParentescoconelAsegurado;
    /**
     * The NrodeTelefonodelTrabajo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NrodeTelefonodelTrabajo;
    /**
     * The ExpedidoPor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpedidoPor;
    /**
     * The VencimientodelRegistro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $VencimientodelRegistro;
    /**
     * The CategoriadelRegistro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CategoriadelRegistro;
    /**
     * The RegistroNro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RegistroNro;
    /**
     * The NumeroDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroDocumento;
    /**
     * The TipoDocumento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoDocumento;
    /**
     * The PapelenelAccidente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PapelenelAccidente;
    /**
     * The Domicilio
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Domicilio[]
     */
    public $Domicilio;
    /**
     * The RolTercero
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RolTercero[]
     */
    public $RolTercero;
    /**
     * The PoseeLicenConducir
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PoseeLicenConducir;
    /**
     * The ConductorOcupacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConductorOcupacion;
    /**
     * Constructor method for Tercero
     * @uses Tercero::setEdadalFallecimiento()
     * @uses Tercero::setCodigodelTercero()
     * @uses Tercero::setFechadeFallecimiento()
     * @uses Tercero::setFechadeNacimiento()
     * @uses Tercero::setRoldelContacto()
     * @uses Tercero::setNombre()
     * @uses Tercero::setSexo()
     * @uses Tercero::setApellido()
     * @uses Tercero::setEstadoCivil()
     * @uses Tercero::setRelacionParentescoconelAsegurado()
     * @uses Tercero::setNrodeTelefonodelTrabajo()
     * @uses Tercero::setExpedidoPor()
     * @uses Tercero::setVencimientodelRegistro()
     * @uses Tercero::setCategoriadelRegistro()
     * @uses Tercero::setRegistroNro()
     * @uses Tercero::setNumeroDocumento()
     * @uses Tercero::setTipoDocumento()
     * @uses Tercero::setPapelenelAccidente()
     * @uses Tercero::setDomicilio()
     * @uses Tercero::setRolTercero()
     * @uses Tercero::setPoseeLicenConducir()
     * @uses Tercero::setConductorOcupacion()
     * @param int $edadalFallecimiento
     * @param string $codigodelTercero
     * @param string $fechadeFallecimiento
     * @param string $fechadeNacimiento
     * @param string $roldelContacto
     * @param string $nombre
     * @param string $sexo
     * @param string $apellido
     * @param string $estadoCivil
     * @param string $relacionParentescoconelAsegurado
     * @param string $nrodeTelefonodelTrabajo
     * @param string $expedidoPor
     * @param string $vencimientodelRegistro
     * @param string $categoriadelRegistro
     * @param string $registroNro
     * @param string $numeroDocumento
     * @param string $tipoDocumento
     * @param string $papelenelAccidente
     * @param \StructType\Domicilio[] $domicilio
     * @param \StructType\RolTercero[] $rolTercero
     * @param string $poseeLicenConducir
     * @param string $conductorOcupacion
     */
    public function __construct($edadalFallecimiento = null, $codigodelTercero = null, $fechadeFallecimiento = null, $fechadeNacimiento = null, $roldelContacto = null, $nombre = null, $sexo = null, $apellido = null, $estadoCivil = null, $relacionParentescoconelAsegurado = null, $nrodeTelefonodelTrabajo = null, $expedidoPor = null, $vencimientodelRegistro = null, $categoriadelRegistro = null, $registroNro = null, $numeroDocumento = null, $tipoDocumento = null, $papelenelAccidente = null, array $domicilio = array(), array $rolTercero = array(), $poseeLicenConducir = null, $conductorOcupacion = null)
    {
        $this
            ->setEdadalFallecimiento($edadalFallecimiento)
            ->setCodigodelTercero($codigodelTercero)
            ->setFechadeFallecimiento($fechadeFallecimiento)
            ->setFechadeNacimiento($fechadeNacimiento)
            ->setRoldelContacto($roldelContacto)
            ->setNombre($nombre)
            ->setSexo($sexo)
            ->setApellido($apellido)
            ->setEstadoCivil($estadoCivil)
            ->setRelacionParentescoconelAsegurado($relacionParentescoconelAsegurado)
            ->setNrodeTelefonodelTrabajo($nrodeTelefonodelTrabajo)
            ->setExpedidoPor($expedidoPor)
            ->setVencimientodelRegistro($vencimientodelRegistro)
            ->setCategoriadelRegistro($categoriadelRegistro)
            ->setRegistroNro($registroNro)
            ->setNumeroDocumento($numeroDocumento)
            ->setTipoDocumento($tipoDocumento)
            ->setPapelenelAccidente($papelenelAccidente)
            ->setDomicilio($domicilio)
            ->setRolTercero($rolTercero)
            ->setPoseeLicenConducir($poseeLicenConducir)
            ->setConductorOcupacion($conductorOcupacion);
    }
    /**
     * Get EdadalFallecimiento value
     * @return int
     */
    public function getEdadalFallecimiento()
    {
        return $this->EdadalFallecimiento;
    }
    /**
     * Set EdadalFallecimiento value
     * @param int $edadalFallecimiento
     * @return \StructType\Tercero
     */
    public function setEdadalFallecimiento($edadalFallecimiento = null)
    {
        // validation for constraint: int
        if (!is_null($edadalFallecimiento) && !(is_int($edadalFallecimiento) || ctype_digit($edadalFallecimiento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($edadalFallecimiento, true), gettype($edadalFallecimiento)), __LINE__);
        }
        $this->EdadalFallecimiento = $edadalFallecimiento;
        return $this;
    }
    /**
     * Get CodigodelTercero value
     * @return string|null
     */
    public function getCodigodelTercero()
    {
        return $this->CodigodelTercero;
    }
    /**
     * Set CodigodelTercero value
     * @param string $codigodelTercero
     * @return \StructType\Tercero
     */
    public function setCodigodelTercero($codigodelTercero = null)
    {
        // validation for constraint: string
        if (!is_null($codigodelTercero) && !is_string($codigodelTercero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigodelTercero, true), gettype($codigodelTercero)), __LINE__);
        }
        $this->CodigodelTercero = $codigodelTercero;
        return $this;
    }
    /**
     * Get FechadeFallecimiento value
     * @return string|null
     */
    public function getFechadeFallecimiento()
    {
        return $this->FechadeFallecimiento;
    }
    /**
     * Set FechadeFallecimiento value
     * @param string $fechadeFallecimiento
     * @return \StructType\Tercero
     */
    public function setFechadeFallecimiento($fechadeFallecimiento = null)
    {
        // validation for constraint: string
        if (!is_null($fechadeFallecimiento) && !is_string($fechadeFallecimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechadeFallecimiento, true), gettype($fechadeFallecimiento)), __LINE__);
        }
        $this->FechadeFallecimiento = $fechadeFallecimiento;
        return $this;
    }
    /**
     * Get FechadeNacimiento value
     * @return string|null
     */
    public function getFechadeNacimiento()
    {
        return $this->FechadeNacimiento;
    }
    /**
     * Set FechadeNacimiento value
     * @param string $fechadeNacimiento
     * @return \StructType\Tercero
     */
    public function setFechadeNacimiento($fechadeNacimiento = null)
    {
        // validation for constraint: string
        if (!is_null($fechadeNacimiento) && !is_string($fechadeNacimiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechadeNacimiento, true), gettype($fechadeNacimiento)), __LINE__);
        }
        $this->FechadeNacimiento = $fechadeNacimiento;
        return $this;
    }
    /**
     * Get RoldelContacto value
     * @return string|null
     */
    public function getRoldelContacto()
    {
        return $this->RoldelContacto;
    }
    /**
     * Set RoldelContacto value
     * @param string $roldelContacto
     * @return \StructType\Tercero
     */
    public function setRoldelContacto($roldelContacto = null)
    {
        // validation for constraint: string
        if (!is_null($roldelContacto) && !is_string($roldelContacto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($roldelContacto, true), gettype($roldelContacto)), __LINE__);
        }
        $this->RoldelContacto = $roldelContacto;
        return $this;
    }
    /**
     * Get Nombre value
     * @return string|null
     */
    public function getNombre()
    {
        return $this->Nombre;
    }
    /**
     * Set Nombre value
     * @param string $nombre
     * @return \StructType\Tercero
     */
    public function setNombre($nombre = null)
    {
        // validation for constraint: string
        if (!is_null($nombre) && !is_string($nombre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombre, true), gettype($nombre)), __LINE__);
        }
        $this->Nombre = $nombre;
        return $this;
    }
    /**
     * Get Sexo value
     * @return string|null
     */
    public function getSexo()
    {
        return $this->Sexo;
    }
    /**
     * Set Sexo value
     * @param string $sexo
     * @return \StructType\Tercero
     */
    public function setSexo($sexo = null)
    {
        // validation for constraint: string
        if (!is_null($sexo) && !is_string($sexo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sexo, true), gettype($sexo)), __LINE__);
        }
        $this->Sexo = $sexo;
        return $this;
    }
    /**
     * Get Apellido value
     * @return string|null
     */
    public function getApellido()
    {
        return $this->Apellido;
    }
    /**
     * Set Apellido value
     * @param string $apellido
     * @return \StructType\Tercero
     */
    public function setApellido($apellido = null)
    {
        // validation for constraint: string
        if (!is_null($apellido) && !is_string($apellido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($apellido, true), gettype($apellido)), __LINE__);
        }
        $this->Apellido = $apellido;
        return $this;
    }
    /**
     * Get EstadoCivil value
     * @return string|null
     */
    public function getEstadoCivil()
    {
        return $this->EstadoCivil;
    }
    /**
     * Set EstadoCivil value
     * @param string $estadoCivil
     * @return \StructType\Tercero
     */
    public function setEstadoCivil($estadoCivil = null)
    {
        // validation for constraint: string
        if (!is_null($estadoCivil) && !is_string($estadoCivil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estadoCivil, true), gettype($estadoCivil)), __LINE__);
        }
        $this->EstadoCivil = $estadoCivil;
        return $this;
    }
    /**
     * Get RelacionParentescoconelAsegurado value
     * @return string|null
     */
    public function getRelacionParentescoconelAsegurado()
    {
        return $this->RelacionParentescoconelAsegurado;
    }
    /**
     * Set RelacionParentescoconelAsegurado value
     * @param string $relacionParentescoconelAsegurado
     * @return \StructType\Tercero
     */
    public function setRelacionParentescoconelAsegurado($relacionParentescoconelAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($relacionParentescoconelAsegurado) && !is_string($relacionParentescoconelAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relacionParentescoconelAsegurado, true), gettype($relacionParentescoconelAsegurado)), __LINE__);
        }
        $this->RelacionParentescoconelAsegurado = $relacionParentescoconelAsegurado;
        return $this;
    }
    /**
     * Get NrodeTelefonodelTrabajo value
     * @return string|null
     */
    public function getNrodeTelefonodelTrabajo()
    {
        return $this->NrodeTelefonodelTrabajo;
    }
    /**
     * Set NrodeTelefonodelTrabajo value
     * @param string $nrodeTelefonodelTrabajo
     * @return \StructType\Tercero
     */
    public function setNrodeTelefonodelTrabajo($nrodeTelefonodelTrabajo = null)
    {
        // validation for constraint: string
        if (!is_null($nrodeTelefonodelTrabajo) && !is_string($nrodeTelefonodelTrabajo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nrodeTelefonodelTrabajo, true), gettype($nrodeTelefonodelTrabajo)), __LINE__);
        }
        $this->NrodeTelefonodelTrabajo = $nrodeTelefonodelTrabajo;
        return $this;
    }
    /**
     * Get ExpedidoPor value
     * @return string|null
     */
    public function getExpedidoPor()
    {
        return $this->ExpedidoPor;
    }
    /**
     * Set ExpedidoPor value
     * @param string $expedidoPor
     * @return \StructType\Tercero
     */
    public function setExpedidoPor($expedidoPor = null)
    {
        // validation for constraint: string
        if (!is_null($expedidoPor) && !is_string($expedidoPor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expedidoPor, true), gettype($expedidoPor)), __LINE__);
        }
        $this->ExpedidoPor = $expedidoPor;
        return $this;
    }
    /**
     * Get VencimientodelRegistro value
     * @return string|null
     */
    public function getVencimientodelRegistro()
    {
        return $this->VencimientodelRegistro;
    }
    /**
     * Set VencimientodelRegistro value
     * @param string $vencimientodelRegistro
     * @return \StructType\Tercero
     */
    public function setVencimientodelRegistro($vencimientodelRegistro = null)
    {
        // validation for constraint: string
        if (!is_null($vencimientodelRegistro) && !is_string($vencimientodelRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimientodelRegistro, true), gettype($vencimientodelRegistro)), __LINE__);
        }
        $this->VencimientodelRegistro = $vencimientodelRegistro;
        return $this;
    }
    /**
     * Get CategoriadelRegistro value
     * @return string|null
     */
    public function getCategoriadelRegistro()
    {
        return $this->CategoriadelRegistro;
    }
    /**
     * Set CategoriadelRegistro value
     * @param string $categoriadelRegistro
     * @return \StructType\Tercero
     */
    public function setCategoriadelRegistro($categoriadelRegistro = null)
    {
        // validation for constraint: string
        if (!is_null($categoriadelRegistro) && !is_string($categoriadelRegistro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoriadelRegistro, true), gettype($categoriadelRegistro)), __LINE__);
        }
        $this->CategoriadelRegistro = $categoriadelRegistro;
        return $this;
    }
    /**
     * Get RegistroNro value
     * @return string|null
     */
    public function getRegistroNro()
    {
        return $this->RegistroNro;
    }
    /**
     * Set RegistroNro value
     * @param string $registroNro
     * @return \StructType\Tercero
     */
    public function setRegistroNro($registroNro = null)
    {
        // validation for constraint: string
        if (!is_null($registroNro) && !is_string($registroNro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($registroNro, true), gettype($registroNro)), __LINE__);
        }
        $this->RegistroNro = $registroNro;
        return $this;
    }
    /**
     * Get NumeroDocumento value
     * @return string|null
     */
    public function getNumeroDocumento()
    {
        return $this->NumeroDocumento;
    }
    /**
     * Set NumeroDocumento value
     * @param string $numeroDocumento
     * @return \StructType\Tercero
     */
    public function setNumeroDocumento($numeroDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($numeroDocumento) && !is_string($numeroDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroDocumento, true), gettype($numeroDocumento)), __LINE__);
        }
        $this->NumeroDocumento = $numeroDocumento;
        return $this;
    }
    /**
     * Get TipoDocumento value
     * @return string|null
     */
    public function getTipoDocumento()
    {
        return $this->TipoDocumento;
    }
    /**
     * Set TipoDocumento value
     * @param string $tipoDocumento
     * @return \StructType\Tercero
     */
    public function setTipoDocumento($tipoDocumento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocumento) && !is_string($tipoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoDocumento, true), gettype($tipoDocumento)), __LINE__);
        }
        $this->TipoDocumento = $tipoDocumento;
        return $this;
    }
    /**
     * Get PapelenelAccidente value
     * @return string|null
     */
    public function getPapelenelAccidente()
    {
        return $this->PapelenelAccidente;
    }
    /**
     * Set PapelenelAccidente value
     * @param string $papelenelAccidente
     * @return \StructType\Tercero
     */
    public function setPapelenelAccidente($papelenelAccidente = null)
    {
        // validation for constraint: string
        if (!is_null($papelenelAccidente) && !is_string($papelenelAccidente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($papelenelAccidente, true), gettype($papelenelAccidente)), __LINE__);
        }
        $this->PapelenelAccidente = $papelenelAccidente;
        return $this;
    }
    /**
     * Get Domicilio value
     * @return \StructType\Domicilio[]|null
     */
    public function getDomicilio()
    {
        return $this->Domicilio;
    }
    /**
     * This method is responsible for validating the values passed to the setDomicilio method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDomicilio method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDomicilioForArrayConstraintsFromSetDomicilio(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $terceroDomicilioItem) {
            // validation for constraint: itemType
            if (!$terceroDomicilioItem instanceof \StructType\Domicilio) {
                $invalidValues[] = is_object($terceroDomicilioItem) ? get_class($terceroDomicilioItem) : sprintf('%s(%s)', gettype($terceroDomicilioItem), var_export($terceroDomicilioItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Domicilio property can only contain items of type \StructType\Domicilio, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Domicilio value
     * @throws \InvalidArgumentException
     * @param \StructType\Domicilio[] $domicilio
     * @return \StructType\Tercero
     */
    public function setDomicilio(array $domicilio = array())
    {
        // validation for constraint: array
        if ('' !== ($domicilioArrayErrorMessage = self::validateDomicilioForArrayConstraintsFromSetDomicilio($domicilio))) {
            throw new \InvalidArgumentException($domicilioArrayErrorMessage, __LINE__);
        }
        $this->Domicilio = $domicilio;
        return $this;
    }
    /**
     * Add item to Domicilio value
     * @throws \InvalidArgumentException
     * @param \StructType\Domicilio $item
     * @return \StructType\Tercero
     */
    public function addToDomicilio(\StructType\Domicilio $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Domicilio) {
            throw new \InvalidArgumentException(sprintf('The Domicilio property can only contain items of type \StructType\Domicilio, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Domicilio[] = $item;
        return $this;
    }
    /**
     * Get RolTercero value
     * @return \StructType\RolTercero[]|null
     */
    public function getRolTercero()
    {
        return $this->RolTercero;
    }
    /**
     * This method is responsible for validating the values passed to the setRolTercero method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRolTercero method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRolTerceroForArrayConstraintsFromSetRolTercero(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $terceroRolTerceroItem) {
            // validation for constraint: itemType
            if (!$terceroRolTerceroItem instanceof \StructType\RolTercero) {
                $invalidValues[] = is_object($terceroRolTerceroItem) ? get_class($terceroRolTerceroItem) : sprintf('%s(%s)', gettype($terceroRolTerceroItem), var_export($terceroRolTerceroItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RolTercero property can only contain items of type \StructType\RolTercero, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RolTercero value
     * @throws \InvalidArgumentException
     * @param \StructType\RolTercero[] $rolTercero
     * @return \StructType\Tercero
     */
    public function setRolTercero(array $rolTercero = array())
    {
        // validation for constraint: array
        if ('' !== ($rolTerceroArrayErrorMessage = self::validateRolTerceroForArrayConstraintsFromSetRolTercero($rolTercero))) {
            throw new \InvalidArgumentException($rolTerceroArrayErrorMessage, __LINE__);
        }
        $this->RolTercero = $rolTercero;
        return $this;
    }
    /**
     * Add item to RolTercero value
     * @throws \InvalidArgumentException
     * @param \StructType\RolTercero $item
     * @return \StructType\Tercero
     */
    public function addToRolTercero(\StructType\RolTercero $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RolTercero) {
            throw new \InvalidArgumentException(sprintf('The RolTercero property can only contain items of type \StructType\RolTercero, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RolTercero[] = $item;
        return $this;
    }
    /**
     * Get PoseeLicenConducir value
     * @return string|null
     */
    public function getPoseeLicenConducir()
    {
        return $this->PoseeLicenConducir;
    }
    /**
     * Set PoseeLicenConducir value
     * @param string $poseeLicenConducir
     * @return \StructType\Tercero
     */
    public function setPoseeLicenConducir($poseeLicenConducir = null)
    {
        // validation for constraint: string
        if (!is_null($poseeLicenConducir) && !is_string($poseeLicenConducir)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poseeLicenConducir, true), gettype($poseeLicenConducir)), __LINE__);
        }
        $this->PoseeLicenConducir = $poseeLicenConducir;
        return $this;
    }
    /**
     * Get ConductorOcupacion value
     * @return string|null
     */
    public function getConductorOcupacion()
    {
        return $this->ConductorOcupacion;
    }
    /**
     * Set ConductorOcupacion value
     * @param string $conductorOcupacion
     * @return \StructType\Tercero
     */
    public function setConductorOcupacion($conductorOcupacion = null)
    {
        // validation for constraint: string
        if (!is_null($conductorOcupacion) && !is_string($conductorOcupacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conductorOcupacion, true), gettype($conductorOcupacion)), __LINE__);
        }
        $this->ConductorOcupacion = $conductorOcupacion;
        return $this;
    }
}
