<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmisionMotorsSalidaItem StructType
 * @subpackage Structs
 */
class EmisionMotorsSalidaItem extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The Orden
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Orden;
    /**
     * The PaqueteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaqueteID;
    /**
     * The RequiereInspeccion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RequiereInspeccion;
    /**
     * The AniosSinSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AniosSinSiniestro;
    /**
     * The ActividadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ActividadID;
    /**
     * The ValorCuota
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ValorCuota;
    /**
     * The PremioMensual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PremioMensual;
    /**
     * The PremioAnual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $PremioAnual;
    /**
     * The Prima
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Prima;
    /**
     * The FechaNacAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaNacAsegurado;
    /**
     * The AsistenciaAprobID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AsistenciaAprobID;
    /**
     * The ValorVehiculoAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ValorVehiculoAprob;
    /**
     * The ValorVehiculo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorVehiculo;
    /**
     * The MesAnioFacturacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MesAnioFacturacion;
    /**
     * The Es0km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Es0km;
    /**
     * The EsExcepcionado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EsExcepcionado;
    /**
     * The Anio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Anio;
    /**
     * The TotalAccesorios
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalAccesorios;
    /**
     * The TotalCobertAdicionales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalCobertAdicionales;
    /**
     * The EdadAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EdadAsegurado;
    /**
     * The PaqueteIDAS400
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PaqueteIDAS400;
    /**
     * The ValorVehiculoAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $ValorVehiculoAMostrar;
    /**
     * The IDPersonaAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaAsegurado;
    /**
     * The IDPersonaAcreedor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaAcreedor;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The IDLocalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDLocalidad;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The AsistenciaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AsistenciaID;
    /**
     * The AsistenciaDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AsistenciaDescripcion;
    /**
     * The Provincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Provincia;
    /**
     * The Localidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Localidad;
    /**
     * The CodigoInfoauto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoInfoauto;
    /**
     * The IDTipoCombustibleAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoCombustibleAprob;
    /**
     * The IDProcedenciaAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProcedenciaAprob;
    /**
     * The IDTipoVehiculoAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoVehiculoAprob;
    /**
     * The IDAutoCaracteristicaAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDAutoCaracteristicaAprob;
    /**
     * The ModeloDescGenerico
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloDescGenerico;
    /**
     * The ModeloCodGenerico
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloCodGenerico;
    /**
     * The MarcaDescGenerico
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaDescGenerico;
    /**
     * The MarcaCodGenerico
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaCodGenerico;
    /**
     * The CodigoGenerico
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoGenerico;
    /**
     * The IDTipoCombustible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoCombustible;
    /**
     * The TipoCombustibleDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoCombustibleDescripcion;
    /**
     * The IDProcedencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProcedencia;
    /**
     * The ProcedenciaDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProcedenciaDescripcion;
    /**
     * The IDTipoVehiculo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoVehiculo;
    /**
     * The TipoVehiculoDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoVehiculoDescripcion;
    /**
     * The Chasis
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Chasis;
    /**
     * The Motor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Motor;
    /**
     * The PatenteNumeros
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatenteNumeros;
    /**
     * The PatenteLetras
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PatenteLetras;
    /**
     * The Patente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Patente;
    /**
     * The IDAutoCaracteristica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDAutoCaracteristica;
    /**
     * The ModeloDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloDescripcion;
    /**
     * The ModeloCodigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloCodigo;
    /**
     * The MarcaDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaDescripcion;
    /**
     * The MarcaCodigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaCodigo;
    /**
     * The PaqueteDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaqueteDescripcion;
    /**
     * The IDClausula
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDClausula;
    /**
     * The ClausulaDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ClausulaDescripcion;
    /**
     * The IDRastreoVehicular
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRastreoVehicular;
    /**
     * The RastreoVehicularDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $RastreoVehicularDescripcion;
    /**
     * The IDUso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDUso;
    /**
     * The UsoDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UsoDescripcion;
    /**
     * The IDZonaRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDZonaRiesgo;
    /**
     * The ZonaRiesgoDescripcion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ZonaRiesgoDescripcion;
    /**
     * The IDTipoPersonaAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersonaAsegurado;
    /**
     * The IDTipoCombustibleOriginal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoCombustibleOriginal;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The CondicionEmision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CondicionEmision;
    /**
     * The MarcaCodigoAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaCodigoAMostrar;
    /**
     * The MarcaDescripcionAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaDescripcionAMostrar;
    /**
     * The ModeloCodigoAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloCodigoAMostrar;
    /**
     * The ModeloDescripcionAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloDescripcionAMostrar;
    /**
     * The CodigoInfoautoAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoInfoautoAMostrar;
    /**
     * The AsistenciaDescripcionAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AsistenciaDescripcionAprob;
    /**
     * The AsistenciaDescripcionAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AsistenciaDescripcionAMostrar;
    /**
     * The ProcedenciaDescripcionAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProcedenciaDescripcionAprob;
    /**
     * The ProcedenciaDescripcionAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProcedenciaDescripcionAMostrar;
    /**
     * The TipoCombustibleDescripcionAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoCombustibleDescripcionAprob;
    /**
     * The TipoCombustibleDescripcionAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoCombustibleDescripcionAMostrar;
    /**
     * The TipoVehiculoDescripcionAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoVehiculoDescripcionAprob;
    /**
     * The TipoVehiculoDescripcionAMostrar
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoVehiculoDescripcionAMostrar;
    /**
     * The PerteneceDesglose
     * Meta information extracted from the WSDL
     * - default: false
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $PerteneceDesglose;
    /**
     * The Coberturas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEmisionMotorsSalidaItemCobertura
     */
    public $Coberturas;
    /**
     * The OrdenCostos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto
     */
    public $OrdenCostos;
    /**
     * Constructor method for EmisionMotorsSalidaItem
     * @uses EmisionMotorsSalidaItem::setItemID()
     * @uses EmisionMotorsSalidaItem::setOrdenID()
     * @uses EmisionMotorsSalidaItem::setOrden()
     * @uses EmisionMotorsSalidaItem::setPaqueteID()
     * @uses EmisionMotorsSalidaItem::setRequiereInspeccion()
     * @uses EmisionMotorsSalidaItem::setAniosSinSiniestro()
     * @uses EmisionMotorsSalidaItem::setActividadID()
     * @uses EmisionMotorsSalidaItem::setValorCuota()
     * @uses EmisionMotorsSalidaItem::setPremioMensual()
     * @uses EmisionMotorsSalidaItem::setPremioAnual()
     * @uses EmisionMotorsSalidaItem::setPrima()
     * @uses EmisionMotorsSalidaItem::setFechaNacAsegurado()
     * @uses EmisionMotorsSalidaItem::setAsistenciaAprobID()
     * @uses EmisionMotorsSalidaItem::setValorVehiculoAprob()
     * @uses EmisionMotorsSalidaItem::setValorVehiculo()
     * @uses EmisionMotorsSalidaItem::setMesAnioFacturacion()
     * @uses EmisionMotorsSalidaItem::setEs0km()
     * @uses EmisionMotorsSalidaItem::setEsExcepcionado()
     * @uses EmisionMotorsSalidaItem::setAnio()
     * @uses EmisionMotorsSalidaItem::setTotalAccesorios()
     * @uses EmisionMotorsSalidaItem::setTotalCobertAdicionales()
     * @uses EmisionMotorsSalidaItem::setEdadAsegurado()
     * @uses EmisionMotorsSalidaItem::setPaqueteIDAS400()
     * @uses EmisionMotorsSalidaItem::setValorVehiculoAMostrar()
     * @uses EmisionMotorsSalidaItem::setIDPersonaAsegurado()
     * @uses EmisionMotorsSalidaItem::setIDPersonaAcreedor()
     * @uses EmisionMotorsSalidaItem::setIDProvincia()
     * @uses EmisionMotorsSalidaItem::setIDLocalidad()
     * @uses EmisionMotorsSalidaItem::setCodigoPostal()
     * @uses EmisionMotorsSalidaItem::setAsistenciaID()
     * @uses EmisionMotorsSalidaItem::setAsistenciaDescripcion()
     * @uses EmisionMotorsSalidaItem::setProvincia()
     * @uses EmisionMotorsSalidaItem::setLocalidad()
     * @uses EmisionMotorsSalidaItem::setCodigoInfoauto()
     * @uses EmisionMotorsSalidaItem::setIDTipoCombustibleAprob()
     * @uses EmisionMotorsSalidaItem::setIDProcedenciaAprob()
     * @uses EmisionMotorsSalidaItem::setIDTipoVehiculoAprob()
     * @uses EmisionMotorsSalidaItem::setIDAutoCaracteristicaAprob()
     * @uses EmisionMotorsSalidaItem::setModeloDescGenerico()
     * @uses EmisionMotorsSalidaItem::setModeloCodGenerico()
     * @uses EmisionMotorsSalidaItem::setMarcaDescGenerico()
     * @uses EmisionMotorsSalidaItem::setMarcaCodGenerico()
     * @uses EmisionMotorsSalidaItem::setCodigoGenerico()
     * @uses EmisionMotorsSalidaItem::setIDTipoCombustible()
     * @uses EmisionMotorsSalidaItem::setTipoCombustibleDescripcion()
     * @uses EmisionMotorsSalidaItem::setIDProcedencia()
     * @uses EmisionMotorsSalidaItem::setProcedenciaDescripcion()
     * @uses EmisionMotorsSalidaItem::setIDTipoVehiculo()
     * @uses EmisionMotorsSalidaItem::setTipoVehiculoDescripcion()
     * @uses EmisionMotorsSalidaItem::setChasis()
     * @uses EmisionMotorsSalidaItem::setMotor()
     * @uses EmisionMotorsSalidaItem::setPatenteNumeros()
     * @uses EmisionMotorsSalidaItem::setPatenteLetras()
     * @uses EmisionMotorsSalidaItem::setPatente()
     * @uses EmisionMotorsSalidaItem::setIDAutoCaracteristica()
     * @uses EmisionMotorsSalidaItem::setModeloDescripcion()
     * @uses EmisionMotorsSalidaItem::setModeloCodigo()
     * @uses EmisionMotorsSalidaItem::setMarcaDescripcion()
     * @uses EmisionMotorsSalidaItem::setMarcaCodigo()
     * @uses EmisionMotorsSalidaItem::setPaqueteDescripcion()
     * @uses EmisionMotorsSalidaItem::setIDClausula()
     * @uses EmisionMotorsSalidaItem::setClausulaDescripcion()
     * @uses EmisionMotorsSalidaItem::setIDRastreoVehicular()
     * @uses EmisionMotorsSalidaItem::setRastreoVehicularDescripcion()
     * @uses EmisionMotorsSalidaItem::setIDUso()
     * @uses EmisionMotorsSalidaItem::setUsoDescripcion()
     * @uses EmisionMotorsSalidaItem::setIDZonaRiesgo()
     * @uses EmisionMotorsSalidaItem::setZonaRiesgoDescripcion()
     * @uses EmisionMotorsSalidaItem::setIDTipoPersonaAsegurado()
     * @uses EmisionMotorsSalidaItem::setIDTipoCombustibleOriginal()
     * @uses EmisionMotorsSalidaItem::setIDCondicionIVA()
     * @uses EmisionMotorsSalidaItem::setCondicionEmision()
     * @uses EmisionMotorsSalidaItem::setMarcaCodigoAMostrar()
     * @uses EmisionMotorsSalidaItem::setMarcaDescripcionAMostrar()
     * @uses EmisionMotorsSalidaItem::setModeloCodigoAMostrar()
     * @uses EmisionMotorsSalidaItem::setModeloDescripcionAMostrar()
     * @uses EmisionMotorsSalidaItem::setCodigoInfoautoAMostrar()
     * @uses EmisionMotorsSalidaItem::setAsistenciaDescripcionAprob()
     * @uses EmisionMotorsSalidaItem::setAsistenciaDescripcionAMostrar()
     * @uses EmisionMotorsSalidaItem::setProcedenciaDescripcionAprob()
     * @uses EmisionMotorsSalidaItem::setProcedenciaDescripcionAMostrar()
     * @uses EmisionMotorsSalidaItem::setTipoCombustibleDescripcionAprob()
     * @uses EmisionMotorsSalidaItem::setTipoCombustibleDescripcionAMostrar()
     * @uses EmisionMotorsSalidaItem::setTipoVehiculoDescripcionAprob()
     * @uses EmisionMotorsSalidaItem::setTipoVehiculoDescripcionAMostrar()
     * @uses EmisionMotorsSalidaItem::setPerteneceDesglose()
     * @uses EmisionMotorsSalidaItem::setCoberturas()
     * @uses EmisionMotorsSalidaItem::setOrdenCostos()
     * @param int $itemID
     * @param int $ordenID
     * @param int $orden
     * @param int $paqueteID
     * @param bool $requiereInspeccion
     * @param int $aniosSinSiniestro
     * @param int $actividadID
     * @param float $valorCuota
     * @param float $premioMensual
     * @param float $premioAnual
     * @param float $prima
     * @param string $fechaNacAsegurado
     * @param int $asistenciaAprobID
     * @param float $valorVehiculoAprob
     * @param float $valorVehiculo
     * @param string $mesAnioFacturacion
     * @param bool $es0km
     * @param bool $esExcepcionado
     * @param int $anio
     * @param float $totalAccesorios
     * @param float $totalCobertAdicionales
     * @param int $edadAsegurado
     * @param int $paqueteIDAS400
     * @param float $valorVehiculoAMostrar
     * @param string $iDPersonaAsegurado
     * @param string $iDPersonaAcreedor
     * @param string $iDProvincia
     * @param string $iDLocalidad
     * @param string $codigoPostal
     * @param string $asistenciaID
     * @param string $asistenciaDescripcion
     * @param string $provincia
     * @param string $localidad
     * @param string $codigoInfoauto
     * @param string $iDTipoCombustibleAprob
     * @param string $iDProcedenciaAprob
     * @param string $iDTipoVehiculoAprob
     * @param string $iDAutoCaracteristicaAprob
     * @param string $modeloDescGenerico
     * @param string $modeloCodGenerico
     * @param string $marcaDescGenerico
     * @param string $marcaCodGenerico
     * @param string $codigoGenerico
     * @param string $iDTipoCombustible
     * @param string $tipoCombustibleDescripcion
     * @param string $iDProcedencia
     * @param string $procedenciaDescripcion
     * @param string $iDTipoVehiculo
     * @param string $tipoVehiculoDescripcion
     * @param string $chasis
     * @param string $motor
     * @param string $patenteNumeros
     * @param string $patenteLetras
     * @param string $patente
     * @param string $iDAutoCaracteristica
     * @param string $modeloDescripcion
     * @param string $modeloCodigo
     * @param string $marcaDescripcion
     * @param string $marcaCodigo
     * @param string $paqueteDescripcion
     * @param string $iDClausula
     * @param string $clausulaDescripcion
     * @param string $iDRastreoVehicular
     * @param string $rastreoVehicularDescripcion
     * @param string $iDUso
     * @param string $usoDescripcion
     * @param string $iDZonaRiesgo
     * @param string $zonaRiesgoDescripcion
     * @param string $iDTipoPersonaAsegurado
     * @param string $iDTipoCombustibleOriginal
     * @param string $iDCondicionIVA
     * @param string $condicionEmision
     * @param string $marcaCodigoAMostrar
     * @param string $marcaDescripcionAMostrar
     * @param string $modeloCodigoAMostrar
     * @param string $modeloDescripcionAMostrar
     * @param string $codigoInfoautoAMostrar
     * @param string $asistenciaDescripcionAprob
     * @param string $asistenciaDescripcionAMostrar
     * @param string $procedenciaDescripcionAprob
     * @param string $procedenciaDescripcionAMostrar
     * @param string $tipoCombustibleDescripcionAprob
     * @param string $tipoCombustibleDescripcionAMostrar
     * @param string $tipoVehiculoDescripcionAprob
     * @param string $tipoVehiculoDescripcionAMostrar
     * @param bool $perteneceDesglose
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaItemCobertura $coberturas
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos
     */
    public function __construct($itemID = null, $ordenID = null, $orden = null, $paqueteID = null, $requiereInspeccion = null, $aniosSinSiniestro = null, $actividadID = null, $valorCuota = null, $premioMensual = null, $premioAnual = null, $prima = null, $fechaNacAsegurado = null, $asistenciaAprobID = null, $valorVehiculoAprob = null, $valorVehiculo = null, $mesAnioFacturacion = null, $es0km = null, $esExcepcionado = null, $anio = null, $totalAccesorios = null, $totalCobertAdicionales = null, $edadAsegurado = null, $paqueteIDAS400 = null, $valorVehiculoAMostrar = null, $iDPersonaAsegurado = null, $iDPersonaAcreedor = null, $iDProvincia = null, $iDLocalidad = null, $codigoPostal = null, $asistenciaID = null, $asistenciaDescripcion = null, $provincia = null, $localidad = null, $codigoInfoauto = null, $iDTipoCombustibleAprob = null, $iDProcedenciaAprob = null, $iDTipoVehiculoAprob = null, $iDAutoCaracteristicaAprob = null, $modeloDescGenerico = null, $modeloCodGenerico = null, $marcaDescGenerico = null, $marcaCodGenerico = null, $codigoGenerico = null, $iDTipoCombustible = null, $tipoCombustibleDescripcion = null, $iDProcedencia = null, $procedenciaDescripcion = null, $iDTipoVehiculo = null, $tipoVehiculoDescripcion = null, $chasis = null, $motor = null, $patenteNumeros = null, $patenteLetras = null, $patente = null, $iDAutoCaracteristica = null, $modeloDescripcion = null, $modeloCodigo = null, $marcaDescripcion = null, $marcaCodigo = null, $paqueteDescripcion = null, $iDClausula = null, $clausulaDescripcion = null, $iDRastreoVehicular = null, $rastreoVehicularDescripcion = null, $iDUso = null, $usoDescripcion = null, $iDZonaRiesgo = null, $zonaRiesgoDescripcion = null, $iDTipoPersonaAsegurado = null, $iDTipoCombustibleOriginal = null, $iDCondicionIVA = null, $condicionEmision = null, $marcaCodigoAMostrar = null, $marcaDescripcionAMostrar = null, $modeloCodigoAMostrar = null, $modeloDescripcionAMostrar = null, $codigoInfoautoAMostrar = null, $asistenciaDescripcionAprob = null, $asistenciaDescripcionAMostrar = null, $procedenciaDescripcionAprob = null, $procedenciaDescripcionAMostrar = null, $tipoCombustibleDescripcionAprob = null, $tipoCombustibleDescripcionAMostrar = null, $tipoVehiculoDescripcionAprob = null, $tipoVehiculoDescripcionAMostrar = null, $perteneceDesglose = false, \ArrayType\ArrayOfEmisionMotorsSalidaItemCobertura $coberturas = null, \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos = null)
    {
        $this
            ->setItemID($itemID)
            ->setOrdenID($ordenID)
            ->setOrden($orden)
            ->setPaqueteID($paqueteID)
            ->setRequiereInspeccion($requiereInspeccion)
            ->setAniosSinSiniestro($aniosSinSiniestro)
            ->setActividadID($actividadID)
            ->setValorCuota($valorCuota)
            ->setPremioMensual($premioMensual)
            ->setPremioAnual($premioAnual)
            ->setPrima($prima)
            ->setFechaNacAsegurado($fechaNacAsegurado)
            ->setAsistenciaAprobID($asistenciaAprobID)
            ->setValorVehiculoAprob($valorVehiculoAprob)
            ->setValorVehiculo($valorVehiculo)
            ->setMesAnioFacturacion($mesAnioFacturacion)
            ->setEs0km($es0km)
            ->setEsExcepcionado($esExcepcionado)
            ->setAnio($anio)
            ->setTotalAccesorios($totalAccesorios)
            ->setTotalCobertAdicionales($totalCobertAdicionales)
            ->setEdadAsegurado($edadAsegurado)
            ->setPaqueteIDAS400($paqueteIDAS400)
            ->setValorVehiculoAMostrar($valorVehiculoAMostrar)
            ->setIDPersonaAsegurado($iDPersonaAsegurado)
            ->setIDPersonaAcreedor($iDPersonaAcreedor)
            ->setIDProvincia($iDProvincia)
            ->setIDLocalidad($iDLocalidad)
            ->setCodigoPostal($codigoPostal)
            ->setAsistenciaID($asistenciaID)
            ->setAsistenciaDescripcion($asistenciaDescripcion)
            ->setProvincia($provincia)
            ->setLocalidad($localidad)
            ->setCodigoInfoauto($codigoInfoauto)
            ->setIDTipoCombustibleAprob($iDTipoCombustibleAprob)
            ->setIDProcedenciaAprob($iDProcedenciaAprob)
            ->setIDTipoVehiculoAprob($iDTipoVehiculoAprob)
            ->setIDAutoCaracteristicaAprob($iDAutoCaracteristicaAprob)
            ->setModeloDescGenerico($modeloDescGenerico)
            ->setModeloCodGenerico($modeloCodGenerico)
            ->setMarcaDescGenerico($marcaDescGenerico)
            ->setMarcaCodGenerico($marcaCodGenerico)
            ->setCodigoGenerico($codigoGenerico)
            ->setIDTipoCombustible($iDTipoCombustible)
            ->setTipoCombustibleDescripcion($tipoCombustibleDescripcion)
            ->setIDProcedencia($iDProcedencia)
            ->setProcedenciaDescripcion($procedenciaDescripcion)
            ->setIDTipoVehiculo($iDTipoVehiculo)
            ->setTipoVehiculoDescripcion($tipoVehiculoDescripcion)
            ->setChasis($chasis)
            ->setMotor($motor)
            ->setPatenteNumeros($patenteNumeros)
            ->setPatenteLetras($patenteLetras)
            ->setPatente($patente)
            ->setIDAutoCaracteristica($iDAutoCaracteristica)
            ->setModeloDescripcion($modeloDescripcion)
            ->setModeloCodigo($modeloCodigo)
            ->setMarcaDescripcion($marcaDescripcion)
            ->setMarcaCodigo($marcaCodigo)
            ->setPaqueteDescripcion($paqueteDescripcion)
            ->setIDClausula($iDClausula)
            ->setClausulaDescripcion($clausulaDescripcion)
            ->setIDRastreoVehicular($iDRastreoVehicular)
            ->setRastreoVehicularDescripcion($rastreoVehicularDescripcion)
            ->setIDUso($iDUso)
            ->setUsoDescripcion($usoDescripcion)
            ->setIDZonaRiesgo($iDZonaRiesgo)
            ->setZonaRiesgoDescripcion($zonaRiesgoDescripcion)
            ->setIDTipoPersonaAsegurado($iDTipoPersonaAsegurado)
            ->setIDTipoCombustibleOriginal($iDTipoCombustibleOriginal)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setCondicionEmision($condicionEmision)
            ->setMarcaCodigoAMostrar($marcaCodigoAMostrar)
            ->setMarcaDescripcionAMostrar($marcaDescripcionAMostrar)
            ->setModeloCodigoAMostrar($modeloCodigoAMostrar)
            ->setModeloDescripcionAMostrar($modeloDescripcionAMostrar)
            ->setCodigoInfoautoAMostrar($codigoInfoautoAMostrar)
            ->setAsistenciaDescripcionAprob($asistenciaDescripcionAprob)
            ->setAsistenciaDescripcionAMostrar($asistenciaDescripcionAMostrar)
            ->setProcedenciaDescripcionAprob($procedenciaDescripcionAprob)
            ->setProcedenciaDescripcionAMostrar($procedenciaDescripcionAMostrar)
            ->setTipoCombustibleDescripcionAprob($tipoCombustibleDescripcionAprob)
            ->setTipoCombustibleDescripcionAMostrar($tipoCombustibleDescripcionAMostrar)
            ->setTipoVehiculoDescripcionAprob($tipoVehiculoDescripcionAprob)
            ->setTipoVehiculoDescripcionAMostrar($tipoVehiculoDescripcionAMostrar)
            ->setPerteneceDesglose($perteneceDesglose)
            ->setCoberturas($coberturas)
            ->setOrdenCostos($ordenCostos);
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get Orden value
     * @return int
     */
    public function getOrden()
    {
        return $this->Orden;
    }
    /**
     * Set Orden value
     * @param int $orden
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setOrden($orden = null)
    {
        // validation for constraint: int
        if (!is_null($orden) && !(is_int($orden) || ctype_digit($orden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orden, true), gettype($orden)), __LINE__);
        }
        $this->Orden = $orden;
        return $this;
    }
    /**
     * Get PaqueteID value
     * @return int
     */
    public function getPaqueteID()
    {
        return $this->PaqueteID;
    }
    /**
     * Set PaqueteID value
     * @param int $paqueteID
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPaqueteID($paqueteID = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteID) && !(is_int($paqueteID) || ctype_digit($paqueteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteID, true), gettype($paqueteID)), __LINE__);
        }
        $this->PaqueteID = $paqueteID;
        return $this;
    }
    /**
     * Get RequiereInspeccion value
     * @return bool
     */
    public function getRequiereInspeccion()
    {
        return $this->RequiereInspeccion;
    }
    /**
     * Set RequiereInspeccion value
     * @param bool $requiereInspeccion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setRequiereInspeccion($requiereInspeccion = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiereInspeccion) && !is_bool($requiereInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiereInspeccion, true), gettype($requiereInspeccion)), __LINE__);
        }
        $this->RequiereInspeccion = $requiereInspeccion;
        return $this;
    }
    /**
     * Get AniosSinSiniestro value
     * @return int
     */
    public function getAniosSinSiniestro()
    {
        return $this->AniosSinSiniestro;
    }
    /**
     * Set AniosSinSiniestro value
     * @param int $aniosSinSiniestro
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setAniosSinSiniestro($aniosSinSiniestro = null)
    {
        // validation for constraint: int
        if (!is_null($aniosSinSiniestro) && !(is_int($aniosSinSiniestro) || ctype_digit($aniosSinSiniestro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aniosSinSiniestro, true), gettype($aniosSinSiniestro)), __LINE__);
        }
        $this->AniosSinSiniestro = $aniosSinSiniestro;
        return $this;
    }
    /**
     * Get ActividadID value
     * @return int
     */
    public function getActividadID()
    {
        return $this->ActividadID;
    }
    /**
     * Set ActividadID value
     * @param int $actividadID
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setActividadID($actividadID = null)
    {
        // validation for constraint: int
        if (!is_null($actividadID) && !(is_int($actividadID) || ctype_digit($actividadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actividadID, true), gettype($actividadID)), __LINE__);
        }
        $this->ActividadID = $actividadID;
        return $this;
    }
    /**
     * Get ValorCuota value
     * @return float
     */
    public function getValorCuota()
    {
        return $this->ValorCuota;
    }
    /**
     * Set ValorCuota value
     * @param float $valorCuota
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setValorCuota($valorCuota = null)
    {
        // validation for constraint: float
        if (!is_null($valorCuota) && !(is_float($valorCuota) || is_numeric($valorCuota))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorCuota, true), gettype($valorCuota)), __LINE__);
        }
        $this->ValorCuota = $valorCuota;
        return $this;
    }
    /**
     * Get PremioMensual value
     * @return float
     */
    public function getPremioMensual()
    {
        return $this->PremioMensual;
    }
    /**
     * Set PremioMensual value
     * @param float $premioMensual
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPremioMensual($premioMensual = null)
    {
        // validation for constraint: float
        if (!is_null($premioMensual) && !(is_float($premioMensual) || is_numeric($premioMensual))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premioMensual, true), gettype($premioMensual)), __LINE__);
        }
        $this->PremioMensual = $premioMensual;
        return $this;
    }
    /**
     * Get PremioAnual value
     * @return float
     */
    public function getPremioAnual()
    {
        return $this->PremioAnual;
    }
    /**
     * Set PremioAnual value
     * @param float $premioAnual
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPremioAnual($premioAnual = null)
    {
        // validation for constraint: float
        if (!is_null($premioAnual) && !(is_float($premioAnual) || is_numeric($premioAnual))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($premioAnual, true), gettype($premioAnual)), __LINE__);
        }
        $this->PremioAnual = $premioAnual;
        return $this;
    }
    /**
     * Get Prima value
     * @return float
     */
    public function getPrima()
    {
        return $this->Prima;
    }
    /**
     * Set Prima value
     * @param float $prima
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPrima($prima = null)
    {
        // validation for constraint: float
        if (!is_null($prima) && !(is_float($prima) || is_numeric($prima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prima, true), gettype($prima)), __LINE__);
        }
        $this->Prima = $prima;
        return $this;
    }
    /**
     * Get FechaNacAsegurado value
     * @return string
     */
    public function getFechaNacAsegurado()
    {
        return $this->FechaNacAsegurado;
    }
    /**
     * Set FechaNacAsegurado value
     * @param string $fechaNacAsegurado
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setFechaNacAsegurado($fechaNacAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($fechaNacAsegurado) && !is_string($fechaNacAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaNacAsegurado, true), gettype($fechaNacAsegurado)), __LINE__);
        }
        $this->FechaNacAsegurado = $fechaNacAsegurado;
        return $this;
    }
    /**
     * Get AsistenciaAprobID value
     * @return int
     */
    public function getAsistenciaAprobID()
    {
        return $this->AsistenciaAprobID;
    }
    /**
     * Set AsistenciaAprobID value
     * @param int $asistenciaAprobID
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setAsistenciaAprobID($asistenciaAprobID = null)
    {
        // validation for constraint: int
        if (!is_null($asistenciaAprobID) && !(is_int($asistenciaAprobID) || ctype_digit($asistenciaAprobID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asistenciaAprobID, true), gettype($asistenciaAprobID)), __LINE__);
        }
        $this->AsistenciaAprobID = $asistenciaAprobID;
        return $this;
    }
    /**
     * Get ValorVehiculoAprob value
     * @return float
     */
    public function getValorVehiculoAprob()
    {
        return $this->ValorVehiculoAprob;
    }
    /**
     * Set ValorVehiculoAprob value
     * @param float $valorVehiculoAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setValorVehiculoAprob($valorVehiculoAprob = null)
    {
        // validation for constraint: float
        if (!is_null($valorVehiculoAprob) && !(is_float($valorVehiculoAprob) || is_numeric($valorVehiculoAprob))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorVehiculoAprob, true), gettype($valorVehiculoAprob)), __LINE__);
        }
        $this->ValorVehiculoAprob = $valorVehiculoAprob;
        return $this;
    }
    /**
     * Get ValorVehiculo value
     * @return float
     */
    public function getValorVehiculo()
    {
        return $this->ValorVehiculo;
    }
    /**
     * Set ValorVehiculo value
     * @param float $valorVehiculo
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setValorVehiculo($valorVehiculo = null)
    {
        // validation for constraint: float
        if (!is_null($valorVehiculo) && !(is_float($valorVehiculo) || is_numeric($valorVehiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorVehiculo, true), gettype($valorVehiculo)), __LINE__);
        }
        $this->ValorVehiculo = $valorVehiculo;
        return $this;
    }
    /**
     * Get MesAnioFacturacion value
     * @return string
     */
    public function getMesAnioFacturacion()
    {
        return $this->MesAnioFacturacion;
    }
    /**
     * Set MesAnioFacturacion value
     * @param string $mesAnioFacturacion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMesAnioFacturacion($mesAnioFacturacion = null)
    {
        // validation for constraint: string
        if (!is_null($mesAnioFacturacion) && !is_string($mesAnioFacturacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mesAnioFacturacion, true), gettype($mesAnioFacturacion)), __LINE__);
        }
        $this->MesAnioFacturacion = $mesAnioFacturacion;
        return $this;
    }
    /**
     * Get Es0km value
     * @return bool
     */
    public function getEs0km()
    {
        return $this->Es0km;
    }
    /**
     * Set Es0km value
     * @param bool $es0km
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setEs0km($es0km = null)
    {
        // validation for constraint: boolean
        if (!is_null($es0km) && !is_bool($es0km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($es0km, true), gettype($es0km)), __LINE__);
        }
        $this->Es0km = $es0km;
        return $this;
    }
    /**
     * Get EsExcepcionado value
     * @return bool
     */
    public function getEsExcepcionado()
    {
        return $this->EsExcepcionado;
    }
    /**
     * Set EsExcepcionado value
     * @param bool $esExcepcionado
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setEsExcepcionado($esExcepcionado = null)
    {
        // validation for constraint: boolean
        if (!is_null($esExcepcionado) && !is_bool($esExcepcionado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esExcepcionado, true), gettype($esExcepcionado)), __LINE__);
        }
        $this->EsExcepcionado = $esExcepcionado;
        return $this;
    }
    /**
     * Get Anio value
     * @return int
     */
    public function getAnio()
    {
        return $this->Anio;
    }
    /**
     * Set Anio value
     * @param int $anio
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setAnio($anio = null)
    {
        // validation for constraint: int
        if (!is_null($anio) && !(is_int($anio) || ctype_digit($anio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anio, true), gettype($anio)), __LINE__);
        }
        $this->Anio = $anio;
        return $this;
    }
    /**
     * Get TotalAccesorios value
     * @return float
     */
    public function getTotalAccesorios()
    {
        return $this->TotalAccesorios;
    }
    /**
     * Set TotalAccesorios value
     * @param float $totalAccesorios
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTotalAccesorios($totalAccesorios = null)
    {
        // validation for constraint: float
        if (!is_null($totalAccesorios) && !(is_float($totalAccesorios) || is_numeric($totalAccesorios))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAccesorios, true), gettype($totalAccesorios)), __LINE__);
        }
        $this->TotalAccesorios = $totalAccesorios;
        return $this;
    }
    /**
     * Get TotalCobertAdicionales value
     * @return float
     */
    public function getTotalCobertAdicionales()
    {
        return $this->TotalCobertAdicionales;
    }
    /**
     * Set TotalCobertAdicionales value
     * @param float $totalCobertAdicionales
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTotalCobertAdicionales($totalCobertAdicionales = null)
    {
        // validation for constraint: float
        if (!is_null($totalCobertAdicionales) && !(is_float($totalCobertAdicionales) || is_numeric($totalCobertAdicionales))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCobertAdicionales, true), gettype($totalCobertAdicionales)), __LINE__);
        }
        $this->TotalCobertAdicionales = $totalCobertAdicionales;
        return $this;
    }
    /**
     * Get EdadAsegurado value
     * @return int
     */
    public function getEdadAsegurado()
    {
        return $this->EdadAsegurado;
    }
    /**
     * Set EdadAsegurado value
     * @param int $edadAsegurado
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setEdadAsegurado($edadAsegurado = null)
    {
        // validation for constraint: int
        if (!is_null($edadAsegurado) && !(is_int($edadAsegurado) || ctype_digit($edadAsegurado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($edadAsegurado, true), gettype($edadAsegurado)), __LINE__);
        }
        $this->EdadAsegurado = $edadAsegurado;
        return $this;
    }
    /**
     * Get PaqueteIDAS400 value
     * @return int
     */
    public function getPaqueteIDAS400()
    {
        return $this->PaqueteIDAS400;
    }
    /**
     * Set PaqueteIDAS400 value
     * @param int $paqueteIDAS400
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPaqueteIDAS400($paqueteIDAS400 = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteIDAS400) && !(is_int($paqueteIDAS400) || ctype_digit($paqueteIDAS400))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteIDAS400, true), gettype($paqueteIDAS400)), __LINE__);
        }
        $this->PaqueteIDAS400 = $paqueteIDAS400;
        return $this;
    }
    /**
     * Get ValorVehiculoAMostrar value
     * @return float
     */
    public function getValorVehiculoAMostrar()
    {
        return $this->ValorVehiculoAMostrar;
    }
    /**
     * Set ValorVehiculoAMostrar value
     * @param float $valorVehiculoAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setValorVehiculoAMostrar($valorVehiculoAMostrar = null)
    {
        // validation for constraint: float
        if (!is_null($valorVehiculoAMostrar) && !(is_float($valorVehiculoAMostrar) || is_numeric($valorVehiculoAMostrar))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorVehiculoAMostrar, true), gettype($valorVehiculoAMostrar)), __LINE__);
        }
        $this->ValorVehiculoAMostrar = $valorVehiculoAMostrar;
        return $this;
    }
    /**
     * Get IDPersonaAsegurado value
     * @return string|null
     */
    public function getIDPersonaAsegurado()
    {
        return $this->IDPersonaAsegurado;
    }
    /**
     * Set IDPersonaAsegurado value
     * @param string $iDPersonaAsegurado
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDPersonaAsegurado($iDPersonaAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaAsegurado) && !is_string($iDPersonaAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaAsegurado, true), gettype($iDPersonaAsegurado)), __LINE__);
        }
        $this->IDPersonaAsegurado = $iDPersonaAsegurado;
        return $this;
    }
    /**
     * Get IDPersonaAcreedor value
     * @return string|null
     */
    public function getIDPersonaAcreedor()
    {
        return $this->IDPersonaAcreedor;
    }
    /**
     * Set IDPersonaAcreedor value
     * @param string $iDPersonaAcreedor
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDPersonaAcreedor($iDPersonaAcreedor = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaAcreedor) && !is_string($iDPersonaAcreedor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaAcreedor, true), gettype($iDPersonaAcreedor)), __LINE__);
        }
        $this->IDPersonaAcreedor = $iDPersonaAcreedor;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get IDLocalidad value
     * @return string|null
     */
    public function getIDLocalidad()
    {
        return $this->IDLocalidad;
    }
    /**
     * Set IDLocalidad value
     * @param string $iDLocalidad
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDLocalidad($iDLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($iDLocalidad) && !is_string($iDLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDLocalidad, true), gettype($iDLocalidad)), __LINE__);
        }
        $this->IDLocalidad = $iDLocalidad;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get AsistenciaID value
     * @return string|null
     */
    public function getAsistenciaID()
    {
        return $this->AsistenciaID;
    }
    /**
     * Set AsistenciaID value
     * @param string $asistenciaID
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setAsistenciaID($asistenciaID = null)
    {
        // validation for constraint: string
        if (!is_null($asistenciaID) && !is_string($asistenciaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asistenciaID, true), gettype($asistenciaID)), __LINE__);
        }
        $this->AsistenciaID = $asistenciaID;
        return $this;
    }
    /**
     * Get AsistenciaDescripcion value
     * @return string|null
     */
    public function getAsistenciaDescripcion()
    {
        return $this->AsistenciaDescripcion;
    }
    /**
     * Set AsistenciaDescripcion value
     * @param string $asistenciaDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setAsistenciaDescripcion($asistenciaDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($asistenciaDescripcion) && !is_string($asistenciaDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asistenciaDescripcion, true), gettype($asistenciaDescripcion)), __LINE__);
        }
        $this->AsistenciaDescripcion = $asistenciaDescripcion;
        return $this;
    }
    /**
     * Get Provincia value
     * @return string|null
     */
    public function getProvincia()
    {
        return $this->Provincia;
    }
    /**
     * Set Provincia value
     * @param string $provincia
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setProvincia($provincia = null)
    {
        // validation for constraint: string
        if (!is_null($provincia) && !is_string($provincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($provincia, true), gettype($provincia)), __LINE__);
        }
        $this->Provincia = $provincia;
        return $this;
    }
    /**
     * Get Localidad value
     * @return string|null
     */
    public function getLocalidad()
    {
        return $this->Localidad;
    }
    /**
     * Set Localidad value
     * @param string $localidad
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setLocalidad($localidad = null)
    {
        // validation for constraint: string
        if (!is_null($localidad) && !is_string($localidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($localidad, true), gettype($localidad)), __LINE__);
        }
        $this->Localidad = $localidad;
        return $this;
    }
    /**
     * Get CodigoInfoauto value
     * @return string|null
     */
    public function getCodigoInfoauto()
    {
        return $this->CodigoInfoauto;
    }
    /**
     * Set CodigoInfoauto value
     * @param string $codigoInfoauto
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setCodigoInfoauto($codigoInfoauto = null)
    {
        // validation for constraint: string
        if (!is_null($codigoInfoauto) && !is_string($codigoInfoauto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoInfoauto, true), gettype($codigoInfoauto)), __LINE__);
        }
        $this->CodigoInfoauto = $codigoInfoauto;
        return $this;
    }
    /**
     * Get IDTipoCombustibleAprob value
     * @return string|null
     */
    public function getIDTipoCombustibleAprob()
    {
        return $this->IDTipoCombustibleAprob;
    }
    /**
     * Set IDTipoCombustibleAprob value
     * @param string $iDTipoCombustibleAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDTipoCombustibleAprob($iDTipoCombustibleAprob = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoCombustibleAprob) && !is_string($iDTipoCombustibleAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoCombustibleAprob, true), gettype($iDTipoCombustibleAprob)), __LINE__);
        }
        $this->IDTipoCombustibleAprob = $iDTipoCombustibleAprob;
        return $this;
    }
    /**
     * Get IDProcedenciaAprob value
     * @return string|null
     */
    public function getIDProcedenciaAprob()
    {
        return $this->IDProcedenciaAprob;
    }
    /**
     * Set IDProcedenciaAprob value
     * @param string $iDProcedenciaAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDProcedenciaAprob($iDProcedenciaAprob = null)
    {
        // validation for constraint: string
        if (!is_null($iDProcedenciaAprob) && !is_string($iDProcedenciaAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProcedenciaAprob, true), gettype($iDProcedenciaAprob)), __LINE__);
        }
        $this->IDProcedenciaAprob = $iDProcedenciaAprob;
        return $this;
    }
    /**
     * Get IDTipoVehiculoAprob value
     * @return string|null
     */
    public function getIDTipoVehiculoAprob()
    {
        return $this->IDTipoVehiculoAprob;
    }
    /**
     * Set IDTipoVehiculoAprob value
     * @param string $iDTipoVehiculoAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDTipoVehiculoAprob($iDTipoVehiculoAprob = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoVehiculoAprob) && !is_string($iDTipoVehiculoAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoVehiculoAprob, true), gettype($iDTipoVehiculoAprob)), __LINE__);
        }
        $this->IDTipoVehiculoAprob = $iDTipoVehiculoAprob;
        return $this;
    }
    /**
     * Get IDAutoCaracteristicaAprob value
     * @return string|null
     */
    public function getIDAutoCaracteristicaAprob()
    {
        return $this->IDAutoCaracteristicaAprob;
    }
    /**
     * Set IDAutoCaracteristicaAprob value
     * @param string $iDAutoCaracteristicaAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDAutoCaracteristicaAprob($iDAutoCaracteristicaAprob = null)
    {
        // validation for constraint: string
        if (!is_null($iDAutoCaracteristicaAprob) && !is_string($iDAutoCaracteristicaAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDAutoCaracteristicaAprob, true), gettype($iDAutoCaracteristicaAprob)), __LINE__);
        }
        $this->IDAutoCaracteristicaAprob = $iDAutoCaracteristicaAprob;
        return $this;
    }
    /**
     * Get ModeloDescGenerico value
     * @return string|null
     */
    public function getModeloDescGenerico()
    {
        return $this->ModeloDescGenerico;
    }
    /**
     * Set ModeloDescGenerico value
     * @param string $modeloDescGenerico
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setModeloDescGenerico($modeloDescGenerico = null)
    {
        // validation for constraint: string
        if (!is_null($modeloDescGenerico) && !is_string($modeloDescGenerico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloDescGenerico, true), gettype($modeloDescGenerico)), __LINE__);
        }
        $this->ModeloDescGenerico = $modeloDescGenerico;
        return $this;
    }
    /**
     * Get ModeloCodGenerico value
     * @return string|null
     */
    public function getModeloCodGenerico()
    {
        return $this->ModeloCodGenerico;
    }
    /**
     * Set ModeloCodGenerico value
     * @param string $modeloCodGenerico
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setModeloCodGenerico($modeloCodGenerico = null)
    {
        // validation for constraint: string
        if (!is_null($modeloCodGenerico) && !is_string($modeloCodGenerico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloCodGenerico, true), gettype($modeloCodGenerico)), __LINE__);
        }
        $this->ModeloCodGenerico = $modeloCodGenerico;
        return $this;
    }
    /**
     * Get MarcaDescGenerico value
     * @return string|null
     */
    public function getMarcaDescGenerico()
    {
        return $this->MarcaDescGenerico;
    }
    /**
     * Set MarcaDescGenerico value
     * @param string $marcaDescGenerico
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMarcaDescGenerico($marcaDescGenerico = null)
    {
        // validation for constraint: string
        if (!is_null($marcaDescGenerico) && !is_string($marcaDescGenerico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaDescGenerico, true), gettype($marcaDescGenerico)), __LINE__);
        }
        $this->MarcaDescGenerico = $marcaDescGenerico;
        return $this;
    }
    /**
     * Get MarcaCodGenerico value
     * @return string|null
     */
    public function getMarcaCodGenerico()
    {
        return $this->MarcaCodGenerico;
    }
    /**
     * Set MarcaCodGenerico value
     * @param string $marcaCodGenerico
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMarcaCodGenerico($marcaCodGenerico = null)
    {
        // validation for constraint: string
        if (!is_null($marcaCodGenerico) && !is_string($marcaCodGenerico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaCodGenerico, true), gettype($marcaCodGenerico)), __LINE__);
        }
        $this->MarcaCodGenerico = $marcaCodGenerico;
        return $this;
    }
    /**
     * Get CodigoGenerico value
     * @return string|null
     */
    public function getCodigoGenerico()
    {
        return $this->CodigoGenerico;
    }
    /**
     * Set CodigoGenerico value
     * @param string $codigoGenerico
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setCodigoGenerico($codigoGenerico = null)
    {
        // validation for constraint: string
        if (!is_null($codigoGenerico) && !is_string($codigoGenerico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoGenerico, true), gettype($codigoGenerico)), __LINE__);
        }
        $this->CodigoGenerico = $codigoGenerico;
        return $this;
    }
    /**
     * Get IDTipoCombustible value
     * @return string|null
     */
    public function getIDTipoCombustible()
    {
        return $this->IDTipoCombustible;
    }
    /**
     * Set IDTipoCombustible value
     * @param string $iDTipoCombustible
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDTipoCombustible($iDTipoCombustible = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoCombustible) && !is_string($iDTipoCombustible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoCombustible, true), gettype($iDTipoCombustible)), __LINE__);
        }
        $this->IDTipoCombustible = $iDTipoCombustible;
        return $this;
    }
    /**
     * Get TipoCombustibleDescripcion value
     * @return string|null
     */
    public function getTipoCombustibleDescripcion()
    {
        return $this->TipoCombustibleDescripcion;
    }
    /**
     * Set TipoCombustibleDescripcion value
     * @param string $tipoCombustibleDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTipoCombustibleDescripcion($tipoCombustibleDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCombustibleDescripcion) && !is_string($tipoCombustibleDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoCombustibleDescripcion, true), gettype($tipoCombustibleDescripcion)), __LINE__);
        }
        $this->TipoCombustibleDescripcion = $tipoCombustibleDescripcion;
        return $this;
    }
    /**
     * Get IDProcedencia value
     * @return string|null
     */
    public function getIDProcedencia()
    {
        return $this->IDProcedencia;
    }
    /**
     * Set IDProcedencia value
     * @param string $iDProcedencia
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDProcedencia($iDProcedencia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProcedencia) && !is_string($iDProcedencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProcedencia, true), gettype($iDProcedencia)), __LINE__);
        }
        $this->IDProcedencia = $iDProcedencia;
        return $this;
    }
    /**
     * Get ProcedenciaDescripcion value
     * @return string|null
     */
    public function getProcedenciaDescripcion()
    {
        return $this->ProcedenciaDescripcion;
    }
    /**
     * Set ProcedenciaDescripcion value
     * @param string $procedenciaDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setProcedenciaDescripcion($procedenciaDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($procedenciaDescripcion) && !is_string($procedenciaDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedenciaDescripcion, true), gettype($procedenciaDescripcion)), __LINE__);
        }
        $this->ProcedenciaDescripcion = $procedenciaDescripcion;
        return $this;
    }
    /**
     * Get IDTipoVehiculo value
     * @return string|null
     */
    public function getIDTipoVehiculo()
    {
        return $this->IDTipoVehiculo;
    }
    /**
     * Set IDTipoVehiculo value
     * @param string $iDTipoVehiculo
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDTipoVehiculo($iDTipoVehiculo = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoVehiculo) && !is_string($iDTipoVehiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoVehiculo, true), gettype($iDTipoVehiculo)), __LINE__);
        }
        $this->IDTipoVehiculo = $iDTipoVehiculo;
        return $this;
    }
    /**
     * Get TipoVehiculoDescripcion value
     * @return string|null
     */
    public function getTipoVehiculoDescripcion()
    {
        return $this->TipoVehiculoDescripcion;
    }
    /**
     * Set TipoVehiculoDescripcion value
     * @param string $tipoVehiculoDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTipoVehiculoDescripcion($tipoVehiculoDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($tipoVehiculoDescripcion) && !is_string($tipoVehiculoDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoVehiculoDescripcion, true), gettype($tipoVehiculoDescripcion)), __LINE__);
        }
        $this->TipoVehiculoDescripcion = $tipoVehiculoDescripcion;
        return $this;
    }
    /**
     * Get Chasis value
     * @return string|null
     */
    public function getChasis()
    {
        return $this->Chasis;
    }
    /**
     * Set Chasis value
     * @param string $chasis
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setChasis($chasis = null)
    {
        // validation for constraint: string
        if (!is_null($chasis) && !is_string($chasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chasis, true), gettype($chasis)), __LINE__);
        }
        $this->Chasis = $chasis;
        return $this;
    }
    /**
     * Get Motor value
     * @return string|null
     */
    public function getMotor()
    {
        return $this->Motor;
    }
    /**
     * Set Motor value
     * @param string $motor
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMotor($motor = null)
    {
        // validation for constraint: string
        if (!is_null($motor) && !is_string($motor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motor, true), gettype($motor)), __LINE__);
        }
        $this->Motor = $motor;
        return $this;
    }
    /**
     * Get PatenteNumeros value
     * @return string|null
     */
    public function getPatenteNumeros()
    {
        return $this->PatenteNumeros;
    }
    /**
     * Set PatenteNumeros value
     * @param string $patenteNumeros
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPatenteNumeros($patenteNumeros = null)
    {
        // validation for constraint: string
        if (!is_null($patenteNumeros) && !is_string($patenteNumeros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patenteNumeros, true), gettype($patenteNumeros)), __LINE__);
        }
        $this->PatenteNumeros = $patenteNumeros;
        return $this;
    }
    /**
     * Get PatenteLetras value
     * @return string|null
     */
    public function getPatenteLetras()
    {
        return $this->PatenteLetras;
    }
    /**
     * Set PatenteLetras value
     * @param string $patenteLetras
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPatenteLetras($patenteLetras = null)
    {
        // validation for constraint: string
        if (!is_null($patenteLetras) && !is_string($patenteLetras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patenteLetras, true), gettype($patenteLetras)), __LINE__);
        }
        $this->PatenteLetras = $patenteLetras;
        return $this;
    }
    /**
     * Get Patente value
     * @return string|null
     */
    public function getPatente()
    {
        return $this->Patente;
    }
    /**
     * Set Patente value
     * @param string $patente
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPatente($patente = null)
    {
        // validation for constraint: string
        if (!is_null($patente) && !is_string($patente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patente, true), gettype($patente)), __LINE__);
        }
        $this->Patente = $patente;
        return $this;
    }
    /**
     * Get IDAutoCaracteristica value
     * @return string|null
     */
    public function getIDAutoCaracteristica()
    {
        return $this->IDAutoCaracteristica;
    }
    /**
     * Set IDAutoCaracteristica value
     * @param string $iDAutoCaracteristica
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDAutoCaracteristica($iDAutoCaracteristica = null)
    {
        // validation for constraint: string
        if (!is_null($iDAutoCaracteristica) && !is_string($iDAutoCaracteristica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDAutoCaracteristica, true), gettype($iDAutoCaracteristica)), __LINE__);
        }
        $this->IDAutoCaracteristica = $iDAutoCaracteristica;
        return $this;
    }
    /**
     * Get ModeloDescripcion value
     * @return string|null
     */
    public function getModeloDescripcion()
    {
        return $this->ModeloDescripcion;
    }
    /**
     * Set ModeloDescripcion value
     * @param string $modeloDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setModeloDescripcion($modeloDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($modeloDescripcion) && !is_string($modeloDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloDescripcion, true), gettype($modeloDescripcion)), __LINE__);
        }
        $this->ModeloDescripcion = $modeloDescripcion;
        return $this;
    }
    /**
     * Get ModeloCodigo value
     * @return string|null
     */
    public function getModeloCodigo()
    {
        return $this->ModeloCodigo;
    }
    /**
     * Set ModeloCodigo value
     * @param string $modeloCodigo
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setModeloCodigo($modeloCodigo = null)
    {
        // validation for constraint: string
        if (!is_null($modeloCodigo) && !is_string($modeloCodigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloCodigo, true), gettype($modeloCodigo)), __LINE__);
        }
        $this->ModeloCodigo = $modeloCodigo;
        return $this;
    }
    /**
     * Get MarcaDescripcion value
     * @return string|null
     */
    public function getMarcaDescripcion()
    {
        return $this->MarcaDescripcion;
    }
    /**
     * Set MarcaDescripcion value
     * @param string $marcaDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMarcaDescripcion($marcaDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($marcaDescripcion) && !is_string($marcaDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaDescripcion, true), gettype($marcaDescripcion)), __LINE__);
        }
        $this->MarcaDescripcion = $marcaDescripcion;
        return $this;
    }
    /**
     * Get MarcaCodigo value
     * @return string|null
     */
    public function getMarcaCodigo()
    {
        return $this->MarcaCodigo;
    }
    /**
     * Set MarcaCodigo value
     * @param string $marcaCodigo
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMarcaCodigo($marcaCodigo = null)
    {
        // validation for constraint: string
        if (!is_null($marcaCodigo) && !is_string($marcaCodigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaCodigo, true), gettype($marcaCodigo)), __LINE__);
        }
        $this->MarcaCodigo = $marcaCodigo;
        return $this;
    }
    /**
     * Get PaqueteDescripcion value
     * @return string|null
     */
    public function getPaqueteDescripcion()
    {
        return $this->PaqueteDescripcion;
    }
    /**
     * Set PaqueteDescripcion value
     * @param string $paqueteDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPaqueteDescripcion($paqueteDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($paqueteDescripcion) && !is_string($paqueteDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paqueteDescripcion, true), gettype($paqueteDescripcion)), __LINE__);
        }
        $this->PaqueteDescripcion = $paqueteDescripcion;
        return $this;
    }
    /**
     * Get IDClausula value
     * @return string|null
     */
    public function getIDClausula()
    {
        return $this->IDClausula;
    }
    /**
     * Set IDClausula value
     * @param string $iDClausula
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDClausula($iDClausula = null)
    {
        // validation for constraint: string
        if (!is_null($iDClausula) && !is_string($iDClausula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDClausula, true), gettype($iDClausula)), __LINE__);
        }
        $this->IDClausula = $iDClausula;
        return $this;
    }
    /**
     * Get ClausulaDescripcion value
     * @return string|null
     */
    public function getClausulaDescripcion()
    {
        return $this->ClausulaDescripcion;
    }
    /**
     * Set ClausulaDescripcion value
     * @param string $clausulaDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setClausulaDescripcion($clausulaDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($clausulaDescripcion) && !is_string($clausulaDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clausulaDescripcion, true), gettype($clausulaDescripcion)), __LINE__);
        }
        $this->ClausulaDescripcion = $clausulaDescripcion;
        return $this;
    }
    /**
     * Get IDRastreoVehicular value
     * @return string|null
     */
    public function getIDRastreoVehicular()
    {
        return $this->IDRastreoVehicular;
    }
    /**
     * Set IDRastreoVehicular value
     * @param string $iDRastreoVehicular
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDRastreoVehicular($iDRastreoVehicular = null)
    {
        // validation for constraint: string
        if (!is_null($iDRastreoVehicular) && !is_string($iDRastreoVehicular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRastreoVehicular, true), gettype($iDRastreoVehicular)), __LINE__);
        }
        $this->IDRastreoVehicular = $iDRastreoVehicular;
        return $this;
    }
    /**
     * Get RastreoVehicularDescripcion value
     * @return string|null
     */
    public function getRastreoVehicularDescripcion()
    {
        return $this->RastreoVehicularDescripcion;
    }
    /**
     * Set RastreoVehicularDescripcion value
     * @param string $rastreoVehicularDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setRastreoVehicularDescripcion($rastreoVehicularDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($rastreoVehicularDescripcion) && !is_string($rastreoVehicularDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rastreoVehicularDescripcion, true), gettype($rastreoVehicularDescripcion)), __LINE__);
        }
        $this->RastreoVehicularDescripcion = $rastreoVehicularDescripcion;
        return $this;
    }
    /**
     * Get IDUso value
     * @return string|null
     */
    public function getIDUso()
    {
        return $this->IDUso;
    }
    /**
     * Set IDUso value
     * @param string $iDUso
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDUso($iDUso = null)
    {
        // validation for constraint: string
        if (!is_null($iDUso) && !is_string($iDUso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDUso, true), gettype($iDUso)), __LINE__);
        }
        $this->IDUso = $iDUso;
        return $this;
    }
    /**
     * Get UsoDescripcion value
     * @return string|null
     */
    public function getUsoDescripcion()
    {
        return $this->UsoDescripcion;
    }
    /**
     * Set UsoDescripcion value
     * @param string $usoDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setUsoDescripcion($usoDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($usoDescripcion) && !is_string($usoDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usoDescripcion, true), gettype($usoDescripcion)), __LINE__);
        }
        $this->UsoDescripcion = $usoDescripcion;
        return $this;
    }
    /**
     * Get IDZonaRiesgo value
     * @return string|null
     */
    public function getIDZonaRiesgo()
    {
        return $this->IDZonaRiesgo;
    }
    /**
     * Set IDZonaRiesgo value
     * @param string $iDZonaRiesgo
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDZonaRiesgo($iDZonaRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDZonaRiesgo) && !is_string($iDZonaRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDZonaRiesgo, true), gettype($iDZonaRiesgo)), __LINE__);
        }
        $this->IDZonaRiesgo = $iDZonaRiesgo;
        return $this;
    }
    /**
     * Get ZonaRiesgoDescripcion value
     * @return string|null
     */
    public function getZonaRiesgoDescripcion()
    {
        return $this->ZonaRiesgoDescripcion;
    }
    /**
     * Set ZonaRiesgoDescripcion value
     * @param string $zonaRiesgoDescripcion
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setZonaRiesgoDescripcion($zonaRiesgoDescripcion = null)
    {
        // validation for constraint: string
        if (!is_null($zonaRiesgoDescripcion) && !is_string($zonaRiesgoDescripcion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zonaRiesgoDescripcion, true), gettype($zonaRiesgoDescripcion)), __LINE__);
        }
        $this->ZonaRiesgoDescripcion = $zonaRiesgoDescripcion;
        return $this;
    }
    /**
     * Get IDTipoPersonaAsegurado value
     * @return string|null
     */
    public function getIDTipoPersonaAsegurado()
    {
        return $this->IDTipoPersonaAsegurado;
    }
    /**
     * Set IDTipoPersonaAsegurado value
     * @param string $iDTipoPersonaAsegurado
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDTipoPersonaAsegurado($iDTipoPersonaAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersonaAsegurado) && !is_string($iDTipoPersonaAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersonaAsegurado, true), gettype($iDTipoPersonaAsegurado)), __LINE__);
        }
        $this->IDTipoPersonaAsegurado = $iDTipoPersonaAsegurado;
        return $this;
    }
    /**
     * Get IDTipoCombustibleOriginal value
     * @return string|null
     */
    public function getIDTipoCombustibleOriginal()
    {
        return $this->IDTipoCombustibleOriginal;
    }
    /**
     * Set IDTipoCombustibleOriginal value
     * @param string $iDTipoCombustibleOriginal
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDTipoCombustibleOriginal($iDTipoCombustibleOriginal = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoCombustibleOriginal) && !is_string($iDTipoCombustibleOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoCombustibleOriginal, true), gettype($iDTipoCombustibleOriginal)), __LINE__);
        }
        $this->IDTipoCombustibleOriginal = $iDTipoCombustibleOriginal;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get CondicionEmision value
     * @return string|null
     */
    public function getCondicionEmision()
    {
        return $this->CondicionEmision;
    }
    /**
     * Set CondicionEmision value
     * @param string $condicionEmision
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setCondicionEmision($condicionEmision = null)
    {
        // validation for constraint: string
        if (!is_null($condicionEmision) && !is_string($condicionEmision)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($condicionEmision, true), gettype($condicionEmision)), __LINE__);
        }
        $this->CondicionEmision = $condicionEmision;
        return $this;
    }
    /**
     * Get MarcaCodigoAMostrar value
     * @return string|null
     */
    public function getMarcaCodigoAMostrar()
    {
        return $this->MarcaCodigoAMostrar;
    }
    /**
     * Set MarcaCodigoAMostrar value
     * @param string $marcaCodigoAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMarcaCodigoAMostrar($marcaCodigoAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($marcaCodigoAMostrar) && !is_string($marcaCodigoAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaCodigoAMostrar, true), gettype($marcaCodigoAMostrar)), __LINE__);
        }
        $this->MarcaCodigoAMostrar = $marcaCodigoAMostrar;
        return $this;
    }
    /**
     * Get MarcaDescripcionAMostrar value
     * @return string|null
     */
    public function getMarcaDescripcionAMostrar()
    {
        return $this->MarcaDescripcionAMostrar;
    }
    /**
     * Set MarcaDescripcionAMostrar value
     * @param string $marcaDescripcionAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setMarcaDescripcionAMostrar($marcaDescripcionAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($marcaDescripcionAMostrar) && !is_string($marcaDescripcionAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaDescripcionAMostrar, true), gettype($marcaDescripcionAMostrar)), __LINE__);
        }
        $this->MarcaDescripcionAMostrar = $marcaDescripcionAMostrar;
        return $this;
    }
    /**
     * Get ModeloCodigoAMostrar value
     * @return string|null
     */
    public function getModeloCodigoAMostrar()
    {
        return $this->ModeloCodigoAMostrar;
    }
    /**
     * Set ModeloCodigoAMostrar value
     * @param string $modeloCodigoAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setModeloCodigoAMostrar($modeloCodigoAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($modeloCodigoAMostrar) && !is_string($modeloCodigoAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloCodigoAMostrar, true), gettype($modeloCodigoAMostrar)), __LINE__);
        }
        $this->ModeloCodigoAMostrar = $modeloCodigoAMostrar;
        return $this;
    }
    /**
     * Get ModeloDescripcionAMostrar value
     * @return string|null
     */
    public function getModeloDescripcionAMostrar()
    {
        return $this->ModeloDescripcionAMostrar;
    }
    /**
     * Set ModeloDescripcionAMostrar value
     * @param string $modeloDescripcionAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setModeloDescripcionAMostrar($modeloDescripcionAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($modeloDescripcionAMostrar) && !is_string($modeloDescripcionAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloDescripcionAMostrar, true), gettype($modeloDescripcionAMostrar)), __LINE__);
        }
        $this->ModeloDescripcionAMostrar = $modeloDescripcionAMostrar;
        return $this;
    }
    /**
     * Get CodigoInfoautoAMostrar value
     * @return string|null
     */
    public function getCodigoInfoautoAMostrar()
    {
        return $this->CodigoInfoautoAMostrar;
    }
    /**
     * Set CodigoInfoautoAMostrar value
     * @param string $codigoInfoautoAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setCodigoInfoautoAMostrar($codigoInfoautoAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($codigoInfoautoAMostrar) && !is_string($codigoInfoautoAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoInfoautoAMostrar, true), gettype($codigoInfoautoAMostrar)), __LINE__);
        }
        $this->CodigoInfoautoAMostrar = $codigoInfoautoAMostrar;
        return $this;
    }
    /**
     * Get AsistenciaDescripcionAprob value
     * @return string|null
     */
    public function getAsistenciaDescripcionAprob()
    {
        return $this->AsistenciaDescripcionAprob;
    }
    /**
     * Set AsistenciaDescripcionAprob value
     * @param string $asistenciaDescripcionAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setAsistenciaDescripcionAprob($asistenciaDescripcionAprob = null)
    {
        // validation for constraint: string
        if (!is_null($asistenciaDescripcionAprob) && !is_string($asistenciaDescripcionAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asistenciaDescripcionAprob, true), gettype($asistenciaDescripcionAprob)), __LINE__);
        }
        $this->AsistenciaDescripcionAprob = $asistenciaDescripcionAprob;
        return $this;
    }
    /**
     * Get AsistenciaDescripcionAMostrar value
     * @return string|null
     */
    public function getAsistenciaDescripcionAMostrar()
    {
        return $this->AsistenciaDescripcionAMostrar;
    }
    /**
     * Set AsistenciaDescripcionAMostrar value
     * @param string $asistenciaDescripcionAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setAsistenciaDescripcionAMostrar($asistenciaDescripcionAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($asistenciaDescripcionAMostrar) && !is_string($asistenciaDescripcionAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asistenciaDescripcionAMostrar, true), gettype($asistenciaDescripcionAMostrar)), __LINE__);
        }
        $this->AsistenciaDescripcionAMostrar = $asistenciaDescripcionAMostrar;
        return $this;
    }
    /**
     * Get ProcedenciaDescripcionAprob value
     * @return string|null
     */
    public function getProcedenciaDescripcionAprob()
    {
        return $this->ProcedenciaDescripcionAprob;
    }
    /**
     * Set ProcedenciaDescripcionAprob value
     * @param string $procedenciaDescripcionAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setProcedenciaDescripcionAprob($procedenciaDescripcionAprob = null)
    {
        // validation for constraint: string
        if (!is_null($procedenciaDescripcionAprob) && !is_string($procedenciaDescripcionAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedenciaDescripcionAprob, true), gettype($procedenciaDescripcionAprob)), __LINE__);
        }
        $this->ProcedenciaDescripcionAprob = $procedenciaDescripcionAprob;
        return $this;
    }
    /**
     * Get ProcedenciaDescripcionAMostrar value
     * @return string|null
     */
    public function getProcedenciaDescripcionAMostrar()
    {
        return $this->ProcedenciaDescripcionAMostrar;
    }
    /**
     * Set ProcedenciaDescripcionAMostrar value
     * @param string $procedenciaDescripcionAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setProcedenciaDescripcionAMostrar($procedenciaDescripcionAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($procedenciaDescripcionAMostrar) && !is_string($procedenciaDescripcionAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($procedenciaDescripcionAMostrar, true), gettype($procedenciaDescripcionAMostrar)), __LINE__);
        }
        $this->ProcedenciaDescripcionAMostrar = $procedenciaDescripcionAMostrar;
        return $this;
    }
    /**
     * Get TipoCombustibleDescripcionAprob value
     * @return string|null
     */
    public function getTipoCombustibleDescripcionAprob()
    {
        return $this->TipoCombustibleDescripcionAprob;
    }
    /**
     * Set TipoCombustibleDescripcionAprob value
     * @param string $tipoCombustibleDescripcionAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTipoCombustibleDescripcionAprob($tipoCombustibleDescripcionAprob = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCombustibleDescripcionAprob) && !is_string($tipoCombustibleDescripcionAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoCombustibleDescripcionAprob, true), gettype($tipoCombustibleDescripcionAprob)), __LINE__);
        }
        $this->TipoCombustibleDescripcionAprob = $tipoCombustibleDescripcionAprob;
        return $this;
    }
    /**
     * Get TipoCombustibleDescripcionAMostrar value
     * @return string|null
     */
    public function getTipoCombustibleDescripcionAMostrar()
    {
        return $this->TipoCombustibleDescripcionAMostrar;
    }
    /**
     * Set TipoCombustibleDescripcionAMostrar value
     * @param string $tipoCombustibleDescripcionAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTipoCombustibleDescripcionAMostrar($tipoCombustibleDescripcionAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCombustibleDescripcionAMostrar) && !is_string($tipoCombustibleDescripcionAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoCombustibleDescripcionAMostrar, true), gettype($tipoCombustibleDescripcionAMostrar)), __LINE__);
        }
        $this->TipoCombustibleDescripcionAMostrar = $tipoCombustibleDescripcionAMostrar;
        return $this;
    }
    /**
     * Get TipoVehiculoDescripcionAprob value
     * @return string|null
     */
    public function getTipoVehiculoDescripcionAprob()
    {
        return $this->TipoVehiculoDescripcionAprob;
    }
    /**
     * Set TipoVehiculoDescripcionAprob value
     * @param string $tipoVehiculoDescripcionAprob
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTipoVehiculoDescripcionAprob($tipoVehiculoDescripcionAprob = null)
    {
        // validation for constraint: string
        if (!is_null($tipoVehiculoDescripcionAprob) && !is_string($tipoVehiculoDescripcionAprob)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoVehiculoDescripcionAprob, true), gettype($tipoVehiculoDescripcionAprob)), __LINE__);
        }
        $this->TipoVehiculoDescripcionAprob = $tipoVehiculoDescripcionAprob;
        return $this;
    }
    /**
     * Get TipoVehiculoDescripcionAMostrar value
     * @return string|null
     */
    public function getTipoVehiculoDescripcionAMostrar()
    {
        return $this->TipoVehiculoDescripcionAMostrar;
    }
    /**
     * Set TipoVehiculoDescripcionAMostrar value
     * @param string $tipoVehiculoDescripcionAMostrar
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setTipoVehiculoDescripcionAMostrar($tipoVehiculoDescripcionAMostrar = null)
    {
        // validation for constraint: string
        if (!is_null($tipoVehiculoDescripcionAMostrar) && !is_string($tipoVehiculoDescripcionAMostrar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoVehiculoDescripcionAMostrar, true), gettype($tipoVehiculoDescripcionAMostrar)), __LINE__);
        }
        $this->TipoVehiculoDescripcionAMostrar = $tipoVehiculoDescripcionAMostrar;
        return $this;
    }
    /**
     * Get PerteneceDesglose value
     * @return bool|null
     */
    public function getPerteneceDesglose()
    {
        return $this->PerteneceDesglose;
    }
    /**
     * Set PerteneceDesglose value
     * @param bool $perteneceDesglose
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setPerteneceDesglose($perteneceDesglose = false)
    {
        // validation for constraint: boolean
        if (!is_null($perteneceDesglose) && !is_bool($perteneceDesglose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($perteneceDesglose, true), gettype($perteneceDesglose)), __LINE__);
        }
        $this->PerteneceDesglose = $perteneceDesglose;
        return $this;
    }
    /**
     * Get Coberturas value
     * @return \ArrayType\ArrayOfEmisionMotorsSalidaItemCobertura|null
     */
    public function getCoberturas()
    {
        return $this->Coberturas;
    }
    /**
     * Set Coberturas value
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaItemCobertura $coberturas
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setCoberturas(\ArrayType\ArrayOfEmisionMotorsSalidaItemCobertura $coberturas = null)
    {
        $this->Coberturas = $coberturas;
        return $this;
    }
    /**
     * Get OrdenCostos value
     * @return \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto|null
     */
    public function getOrdenCostos()
    {
        return $this->OrdenCostos;
    }
    /**
     * Set OrdenCostos value
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos
     * @return \StructType\EmisionMotorsSalidaItem
     */
    public function setOrdenCostos(\ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos = null)
    {
        $this->OrdenCostos = $ordenCostos;
        return $this;
    }
}
