<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalOUTConsultaPresupuestoItem StructType
 * @subpackage Structs
 */
class DocCanalOUTConsultaPresupuestoItem extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The Orden
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Orden;
    /**
     * The PaqueteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PaqueteID;
    /**
     * The RequiereInspeccion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RequiereInspeccion;
    /**
     * The AniosSinSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AniosSinSiniestro;
    /**
     * The FechaNacAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $FechaNacAsegurado;
    /**
     * The ValorVehiculo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $ValorVehiculo;
    /**
     * The MesAnioFacturacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $MesAnioFacturacion;
    /**
     * The Es0km
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $Es0km;
    /**
     * The Anio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Anio;
    /**
     * The TotalAccesorios
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalAccesorios;
    /**
     * The TotalCobertAdicionales
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $TotalCobertAdicionales;
    /**
     * The EdadAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $EdadAsegurado;
    /**
     * The PaqueteIDAS400
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PaqueteIDAS400;
    /**
     * The IDPersonaAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaAsegurado;
    /**
     * The IDPersonaAcreedor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaAcreedor;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The IDLocalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDLocalidad;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The AsistenciaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AsistenciaID;
    /**
     * The CodigoInfoauto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoInfoauto;
    /**
     * The IDTipoCombustible
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoCombustible;
    /**
     * The IDProcedencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProcedencia;
    /**
     * The IDTipoVehiculo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoVehiculo;
    /**
     * The Chasis
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Chasis;
    /**
     * The Motor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Motor;
    /**
     * The Patente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Patente;
    /**
     * The IDAutoCaracteristica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDAutoCaracteristica;
    /**
     * The ModeloCodigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ModeloCodigo;
    /**
     * The MarcaCodigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarcaCodigo;
    /**
     * The IDClausula
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDClausula;
    /**
     * The IDRastreoVehicular
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRastreoVehicular;
    /**
     * The IDUso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDUso;
    /**
     * The IDZonaRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDZonaRiesgo;
    /**
     * The IDTipoPersonaAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersonaAsegurado;
    /**
     * The IDTipoCombustibleOriginal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoCombustibleOriginal;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The Coberturas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoItemCobertura
     */
    public $Coberturas;
    /**
     * The OrdenCostos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoOrdenCosto
     */
    public $OrdenCostos;
    /**
     * The ExcepcionItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoMotorExcepcionItem
     */
    public $ExcepcionItem;
    /**
     * Constructor method for DocCanalOUTConsultaPresupuestoItem
     * @uses DocCanalOUTConsultaPresupuestoItem::setItemID()
     * @uses DocCanalOUTConsultaPresupuestoItem::setOrdenID()
     * @uses DocCanalOUTConsultaPresupuestoItem::setOrden()
     * @uses DocCanalOUTConsultaPresupuestoItem::setPaqueteID()
     * @uses DocCanalOUTConsultaPresupuestoItem::setRequiereInspeccion()
     * @uses DocCanalOUTConsultaPresupuestoItem::setAniosSinSiniestro()
     * @uses DocCanalOUTConsultaPresupuestoItem::setFechaNacAsegurado()
     * @uses DocCanalOUTConsultaPresupuestoItem::setValorVehiculo()
     * @uses DocCanalOUTConsultaPresupuestoItem::setMesAnioFacturacion()
     * @uses DocCanalOUTConsultaPresupuestoItem::setEs0km()
     * @uses DocCanalOUTConsultaPresupuestoItem::setAnio()
     * @uses DocCanalOUTConsultaPresupuestoItem::setTotalAccesorios()
     * @uses DocCanalOUTConsultaPresupuestoItem::setTotalCobertAdicionales()
     * @uses DocCanalOUTConsultaPresupuestoItem::setEdadAsegurado()
     * @uses DocCanalOUTConsultaPresupuestoItem::setPaqueteIDAS400()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDPersonaAsegurado()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDPersonaAcreedor()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDProvincia()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDLocalidad()
     * @uses DocCanalOUTConsultaPresupuestoItem::setCodigoPostal()
     * @uses DocCanalOUTConsultaPresupuestoItem::setAsistenciaID()
     * @uses DocCanalOUTConsultaPresupuestoItem::setCodigoInfoauto()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDTipoCombustible()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDProcedencia()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDTipoVehiculo()
     * @uses DocCanalOUTConsultaPresupuestoItem::setChasis()
     * @uses DocCanalOUTConsultaPresupuestoItem::setMotor()
     * @uses DocCanalOUTConsultaPresupuestoItem::setPatente()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDAutoCaracteristica()
     * @uses DocCanalOUTConsultaPresupuestoItem::setModeloCodigo()
     * @uses DocCanalOUTConsultaPresupuestoItem::setMarcaCodigo()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDClausula()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDRastreoVehicular()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDUso()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDZonaRiesgo()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDTipoPersonaAsegurado()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDTipoCombustibleOriginal()
     * @uses DocCanalOUTConsultaPresupuestoItem::setIDCondicionIVA()
     * @uses DocCanalOUTConsultaPresupuestoItem::setCoberturas()
     * @uses DocCanalOUTConsultaPresupuestoItem::setOrdenCostos()
     * @uses DocCanalOUTConsultaPresupuestoItem::setExcepcionItem()
     * @param int $itemID
     * @param int $ordenID
     * @param int $orden
     * @param int $paqueteID
     * @param bool $requiereInspeccion
     * @param int $aniosSinSiniestro
     * @param string $fechaNacAsegurado
     * @param float $valorVehiculo
     * @param string $mesAnioFacturacion
     * @param bool $es0km
     * @param int $anio
     * @param float $totalAccesorios
     * @param float $totalCobertAdicionales
     * @param int $edadAsegurado
     * @param int $paqueteIDAS400
     * @param string $iDPersonaAsegurado
     * @param string $iDPersonaAcreedor
     * @param string $iDProvincia
     * @param string $iDLocalidad
     * @param string $codigoPostal
     * @param string $asistenciaID
     * @param string $codigoInfoauto
     * @param string $iDTipoCombustible
     * @param string $iDProcedencia
     * @param string $iDTipoVehiculo
     * @param string $chasis
     * @param string $motor
     * @param string $patente
     * @param string $iDAutoCaracteristica
     * @param string $modeloCodigo
     * @param string $marcaCodigo
     * @param string $iDClausula
     * @param string $iDRastreoVehicular
     * @param string $iDUso
     * @param string $iDZonaRiesgo
     * @param string $iDTipoPersonaAsegurado
     * @param string $iDTipoCombustibleOriginal
     * @param string $iDCondicionIVA
     * @param \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoItemCobertura $coberturas
     * @param \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoOrdenCosto $ordenCostos
     * @param \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoMotorExcepcionItem $excepcionItem
     */
    public function __construct($itemID = null, $ordenID = null, $orden = null, $paqueteID = null, $requiereInspeccion = null, $aniosSinSiniestro = null, $fechaNacAsegurado = null, $valorVehiculo = null, $mesAnioFacturacion = null, $es0km = null, $anio = null, $totalAccesorios = null, $totalCobertAdicionales = null, $edadAsegurado = null, $paqueteIDAS400 = null, $iDPersonaAsegurado = null, $iDPersonaAcreedor = null, $iDProvincia = null, $iDLocalidad = null, $codigoPostal = null, $asistenciaID = null, $codigoInfoauto = null, $iDTipoCombustible = null, $iDProcedencia = null, $iDTipoVehiculo = null, $chasis = null, $motor = null, $patente = null, $iDAutoCaracteristica = null, $modeloCodigo = null, $marcaCodigo = null, $iDClausula = null, $iDRastreoVehicular = null, $iDUso = null, $iDZonaRiesgo = null, $iDTipoPersonaAsegurado = null, $iDTipoCombustibleOriginal = null, $iDCondicionIVA = null, \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoItemCobertura $coberturas = null, \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoOrdenCosto $ordenCostos = null, \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoMotorExcepcionItem $excepcionItem = null)
    {
        $this
            ->setItemID($itemID)
            ->setOrdenID($ordenID)
            ->setOrden($orden)
            ->setPaqueteID($paqueteID)
            ->setRequiereInspeccion($requiereInspeccion)
            ->setAniosSinSiniestro($aniosSinSiniestro)
            ->setFechaNacAsegurado($fechaNacAsegurado)
            ->setValorVehiculo($valorVehiculo)
            ->setMesAnioFacturacion($mesAnioFacturacion)
            ->setEs0km($es0km)
            ->setAnio($anio)
            ->setTotalAccesorios($totalAccesorios)
            ->setTotalCobertAdicionales($totalCobertAdicionales)
            ->setEdadAsegurado($edadAsegurado)
            ->setPaqueteIDAS400($paqueteIDAS400)
            ->setIDPersonaAsegurado($iDPersonaAsegurado)
            ->setIDPersonaAcreedor($iDPersonaAcreedor)
            ->setIDProvincia($iDProvincia)
            ->setIDLocalidad($iDLocalidad)
            ->setCodigoPostal($codigoPostal)
            ->setAsistenciaID($asistenciaID)
            ->setCodigoInfoauto($codigoInfoauto)
            ->setIDTipoCombustible($iDTipoCombustible)
            ->setIDProcedencia($iDProcedencia)
            ->setIDTipoVehiculo($iDTipoVehiculo)
            ->setChasis($chasis)
            ->setMotor($motor)
            ->setPatente($patente)
            ->setIDAutoCaracteristica($iDAutoCaracteristica)
            ->setModeloCodigo($modeloCodigo)
            ->setMarcaCodigo($marcaCodigo)
            ->setIDClausula($iDClausula)
            ->setIDRastreoVehicular($iDRastreoVehicular)
            ->setIDUso($iDUso)
            ->setIDZonaRiesgo($iDZonaRiesgo)
            ->setIDTipoPersonaAsegurado($iDTipoPersonaAsegurado)
            ->setIDTipoCombustibleOriginal($iDTipoCombustibleOriginal)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setCoberturas($coberturas)
            ->setOrdenCostos($ordenCostos)
            ->setExcepcionItem($excepcionItem);
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get Orden value
     * @return int
     */
    public function getOrden()
    {
        return $this->Orden;
    }
    /**
     * Set Orden value
     * @param int $orden
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setOrden($orden = null)
    {
        // validation for constraint: int
        if (!is_null($orden) && !(is_int($orden) || ctype_digit($orden))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orden, true), gettype($orden)), __LINE__);
        }
        $this->Orden = $orden;
        return $this;
    }
    /**
     * Get PaqueteID value
     * @return int
     */
    public function getPaqueteID()
    {
        return $this->PaqueteID;
    }
    /**
     * Set PaqueteID value
     * @param int $paqueteID
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setPaqueteID($paqueteID = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteID) && !(is_int($paqueteID) || ctype_digit($paqueteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteID, true), gettype($paqueteID)), __LINE__);
        }
        $this->PaqueteID = $paqueteID;
        return $this;
    }
    /**
     * Get RequiereInspeccion value
     * @return bool
     */
    public function getRequiereInspeccion()
    {
        return $this->RequiereInspeccion;
    }
    /**
     * Set RequiereInspeccion value
     * @param bool $requiereInspeccion
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setRequiereInspeccion($requiereInspeccion = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiereInspeccion) && !is_bool($requiereInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiereInspeccion, true), gettype($requiereInspeccion)), __LINE__);
        }
        $this->RequiereInspeccion = $requiereInspeccion;
        return $this;
    }
    /**
     * Get AniosSinSiniestro value
     * @return int
     */
    public function getAniosSinSiniestro()
    {
        return $this->AniosSinSiniestro;
    }
    /**
     * Set AniosSinSiniestro value
     * @param int $aniosSinSiniestro
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setAniosSinSiniestro($aniosSinSiniestro = null)
    {
        // validation for constraint: int
        if (!is_null($aniosSinSiniestro) && !(is_int($aniosSinSiniestro) || ctype_digit($aniosSinSiniestro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aniosSinSiniestro, true), gettype($aniosSinSiniestro)), __LINE__);
        }
        $this->AniosSinSiniestro = $aniosSinSiniestro;
        return $this;
    }
    /**
     * Get FechaNacAsegurado value
     * @return string
     */
    public function getFechaNacAsegurado()
    {
        return $this->FechaNacAsegurado;
    }
    /**
     * Set FechaNacAsegurado value
     * @param string $fechaNacAsegurado
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setFechaNacAsegurado($fechaNacAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($fechaNacAsegurado) && !is_string($fechaNacAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaNacAsegurado, true), gettype($fechaNacAsegurado)), __LINE__);
        }
        $this->FechaNacAsegurado = $fechaNacAsegurado;
        return $this;
    }
    /**
     * Get ValorVehiculo value
     * @return float
     */
    public function getValorVehiculo()
    {
        return $this->ValorVehiculo;
    }
    /**
     * Set ValorVehiculo value
     * @param float $valorVehiculo
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setValorVehiculo($valorVehiculo = null)
    {
        // validation for constraint: float
        if (!is_null($valorVehiculo) && !(is_float($valorVehiculo) || is_numeric($valorVehiculo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorVehiculo, true), gettype($valorVehiculo)), __LINE__);
        }
        $this->ValorVehiculo = $valorVehiculo;
        return $this;
    }
    /**
     * Get MesAnioFacturacion value
     * @return string
     */
    public function getMesAnioFacturacion()
    {
        return $this->MesAnioFacturacion;
    }
    /**
     * Set MesAnioFacturacion value
     * @param string $mesAnioFacturacion
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setMesAnioFacturacion($mesAnioFacturacion = null)
    {
        // validation for constraint: string
        if (!is_null($mesAnioFacturacion) && !is_string($mesAnioFacturacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mesAnioFacturacion, true), gettype($mesAnioFacturacion)), __LINE__);
        }
        $this->MesAnioFacturacion = $mesAnioFacturacion;
        return $this;
    }
    /**
     * Get Es0km value
     * @return bool
     */
    public function getEs0km()
    {
        return $this->Es0km;
    }
    /**
     * Set Es0km value
     * @param bool $es0km
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setEs0km($es0km = null)
    {
        // validation for constraint: boolean
        if (!is_null($es0km) && !is_bool($es0km)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($es0km, true), gettype($es0km)), __LINE__);
        }
        $this->Es0km = $es0km;
        return $this;
    }
    /**
     * Get Anio value
     * @return int
     */
    public function getAnio()
    {
        return $this->Anio;
    }
    /**
     * Set Anio value
     * @param int $anio
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setAnio($anio = null)
    {
        // validation for constraint: int
        if (!is_null($anio) && !(is_int($anio) || ctype_digit($anio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anio, true), gettype($anio)), __LINE__);
        }
        $this->Anio = $anio;
        return $this;
    }
    /**
     * Get TotalAccesorios value
     * @return float
     */
    public function getTotalAccesorios()
    {
        return $this->TotalAccesorios;
    }
    /**
     * Set TotalAccesorios value
     * @param float $totalAccesorios
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setTotalAccesorios($totalAccesorios = null)
    {
        // validation for constraint: float
        if (!is_null($totalAccesorios) && !(is_float($totalAccesorios) || is_numeric($totalAccesorios))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalAccesorios, true), gettype($totalAccesorios)), __LINE__);
        }
        $this->TotalAccesorios = $totalAccesorios;
        return $this;
    }
    /**
     * Get TotalCobertAdicionales value
     * @return float
     */
    public function getTotalCobertAdicionales()
    {
        return $this->TotalCobertAdicionales;
    }
    /**
     * Set TotalCobertAdicionales value
     * @param float $totalCobertAdicionales
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setTotalCobertAdicionales($totalCobertAdicionales = null)
    {
        // validation for constraint: float
        if (!is_null($totalCobertAdicionales) && !(is_float($totalCobertAdicionales) || is_numeric($totalCobertAdicionales))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalCobertAdicionales, true), gettype($totalCobertAdicionales)), __LINE__);
        }
        $this->TotalCobertAdicionales = $totalCobertAdicionales;
        return $this;
    }
    /**
     * Get EdadAsegurado value
     * @return int
     */
    public function getEdadAsegurado()
    {
        return $this->EdadAsegurado;
    }
    /**
     * Set EdadAsegurado value
     * @param int $edadAsegurado
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setEdadAsegurado($edadAsegurado = null)
    {
        // validation for constraint: int
        if (!is_null($edadAsegurado) && !(is_int($edadAsegurado) || ctype_digit($edadAsegurado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($edadAsegurado, true), gettype($edadAsegurado)), __LINE__);
        }
        $this->EdadAsegurado = $edadAsegurado;
        return $this;
    }
    /**
     * Get PaqueteIDAS400 value
     * @return int
     */
    public function getPaqueteIDAS400()
    {
        return $this->PaqueteIDAS400;
    }
    /**
     * Set PaqueteIDAS400 value
     * @param int $paqueteIDAS400
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setPaqueteIDAS400($paqueteIDAS400 = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteIDAS400) && !(is_int($paqueteIDAS400) || ctype_digit($paqueteIDAS400))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteIDAS400, true), gettype($paqueteIDAS400)), __LINE__);
        }
        $this->PaqueteIDAS400 = $paqueteIDAS400;
        return $this;
    }
    /**
     * Get IDPersonaAsegurado value
     * @return string|null
     */
    public function getIDPersonaAsegurado()
    {
        return $this->IDPersonaAsegurado;
    }
    /**
     * Set IDPersonaAsegurado value
     * @param string $iDPersonaAsegurado
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDPersonaAsegurado($iDPersonaAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaAsegurado) && !is_string($iDPersonaAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaAsegurado, true), gettype($iDPersonaAsegurado)), __LINE__);
        }
        $this->IDPersonaAsegurado = $iDPersonaAsegurado;
        return $this;
    }
    /**
     * Get IDPersonaAcreedor value
     * @return string|null
     */
    public function getIDPersonaAcreedor()
    {
        return $this->IDPersonaAcreedor;
    }
    /**
     * Set IDPersonaAcreedor value
     * @param string $iDPersonaAcreedor
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDPersonaAcreedor($iDPersonaAcreedor = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaAcreedor) && !is_string($iDPersonaAcreedor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaAcreedor, true), gettype($iDPersonaAcreedor)), __LINE__);
        }
        $this->IDPersonaAcreedor = $iDPersonaAcreedor;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get IDLocalidad value
     * @return string|null
     */
    public function getIDLocalidad()
    {
        return $this->IDLocalidad;
    }
    /**
     * Set IDLocalidad value
     * @param string $iDLocalidad
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDLocalidad($iDLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($iDLocalidad) && !is_string($iDLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDLocalidad, true), gettype($iDLocalidad)), __LINE__);
        }
        $this->IDLocalidad = $iDLocalidad;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get AsistenciaID value
     * @return string|null
     */
    public function getAsistenciaID()
    {
        return $this->AsistenciaID;
    }
    /**
     * Set AsistenciaID value
     * @param string $asistenciaID
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setAsistenciaID($asistenciaID = null)
    {
        // validation for constraint: string
        if (!is_null($asistenciaID) && !is_string($asistenciaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($asistenciaID, true), gettype($asistenciaID)), __LINE__);
        }
        $this->AsistenciaID = $asistenciaID;
        return $this;
    }
    /**
     * Get CodigoInfoauto value
     * @return string|null
     */
    public function getCodigoInfoauto()
    {
        return $this->CodigoInfoauto;
    }
    /**
     * Set CodigoInfoauto value
     * @param string $codigoInfoauto
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setCodigoInfoauto($codigoInfoauto = null)
    {
        // validation for constraint: string
        if (!is_null($codigoInfoauto) && !is_string($codigoInfoauto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoInfoauto, true), gettype($codigoInfoauto)), __LINE__);
        }
        $this->CodigoInfoauto = $codigoInfoauto;
        return $this;
    }
    /**
     * Get IDTipoCombustible value
     * @return string|null
     */
    public function getIDTipoCombustible()
    {
        return $this->IDTipoCombustible;
    }
    /**
     * Set IDTipoCombustible value
     * @param string $iDTipoCombustible
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDTipoCombustible($iDTipoCombustible = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoCombustible) && !is_string($iDTipoCombustible)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoCombustible, true), gettype($iDTipoCombustible)), __LINE__);
        }
        $this->IDTipoCombustible = $iDTipoCombustible;
        return $this;
    }
    /**
     * Get IDProcedencia value
     * @return string|null
     */
    public function getIDProcedencia()
    {
        return $this->IDProcedencia;
    }
    /**
     * Set IDProcedencia value
     * @param string $iDProcedencia
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDProcedencia($iDProcedencia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProcedencia) && !is_string($iDProcedencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProcedencia, true), gettype($iDProcedencia)), __LINE__);
        }
        $this->IDProcedencia = $iDProcedencia;
        return $this;
    }
    /**
     * Get IDTipoVehiculo value
     * @return string|null
     */
    public function getIDTipoVehiculo()
    {
        return $this->IDTipoVehiculo;
    }
    /**
     * Set IDTipoVehiculo value
     * @param string $iDTipoVehiculo
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDTipoVehiculo($iDTipoVehiculo = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoVehiculo) && !is_string($iDTipoVehiculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoVehiculo, true), gettype($iDTipoVehiculo)), __LINE__);
        }
        $this->IDTipoVehiculo = $iDTipoVehiculo;
        return $this;
    }
    /**
     * Get Chasis value
     * @return string|null
     */
    public function getChasis()
    {
        return $this->Chasis;
    }
    /**
     * Set Chasis value
     * @param string $chasis
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setChasis($chasis = null)
    {
        // validation for constraint: string
        if (!is_null($chasis) && !is_string($chasis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chasis, true), gettype($chasis)), __LINE__);
        }
        $this->Chasis = $chasis;
        return $this;
    }
    /**
     * Get Motor value
     * @return string|null
     */
    public function getMotor()
    {
        return $this->Motor;
    }
    /**
     * Set Motor value
     * @param string $motor
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setMotor($motor = null)
    {
        // validation for constraint: string
        if (!is_null($motor) && !is_string($motor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motor, true), gettype($motor)), __LINE__);
        }
        $this->Motor = $motor;
        return $this;
    }
    /**
     * Get Patente value
     * @return string|null
     */
    public function getPatente()
    {
        return $this->Patente;
    }
    /**
     * Set Patente value
     * @param string $patente
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setPatente($patente = null)
    {
        // validation for constraint: string
        if (!is_null($patente) && !is_string($patente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($patente, true), gettype($patente)), __LINE__);
        }
        $this->Patente = $patente;
        return $this;
    }
    /**
     * Get IDAutoCaracteristica value
     * @return string|null
     */
    public function getIDAutoCaracteristica()
    {
        return $this->IDAutoCaracteristica;
    }
    /**
     * Set IDAutoCaracteristica value
     * @param string $iDAutoCaracteristica
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDAutoCaracteristica($iDAutoCaracteristica = null)
    {
        // validation for constraint: string
        if (!is_null($iDAutoCaracteristica) && !is_string($iDAutoCaracteristica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDAutoCaracteristica, true), gettype($iDAutoCaracteristica)), __LINE__);
        }
        $this->IDAutoCaracteristica = $iDAutoCaracteristica;
        return $this;
    }
    /**
     * Get ModeloCodigo value
     * @return string|null
     */
    public function getModeloCodigo()
    {
        return $this->ModeloCodigo;
    }
    /**
     * Set ModeloCodigo value
     * @param string $modeloCodigo
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setModeloCodigo($modeloCodigo = null)
    {
        // validation for constraint: string
        if (!is_null($modeloCodigo) && !is_string($modeloCodigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modeloCodigo, true), gettype($modeloCodigo)), __LINE__);
        }
        $this->ModeloCodigo = $modeloCodigo;
        return $this;
    }
    /**
     * Get MarcaCodigo value
     * @return string|null
     */
    public function getMarcaCodigo()
    {
        return $this->MarcaCodigo;
    }
    /**
     * Set MarcaCodigo value
     * @param string $marcaCodigo
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setMarcaCodigo($marcaCodigo = null)
    {
        // validation for constraint: string
        if (!is_null($marcaCodigo) && !is_string($marcaCodigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($marcaCodigo, true), gettype($marcaCodigo)), __LINE__);
        }
        $this->MarcaCodigo = $marcaCodigo;
        return $this;
    }
    /**
     * Get IDClausula value
     * @return string|null
     */
    public function getIDClausula()
    {
        return $this->IDClausula;
    }
    /**
     * Set IDClausula value
     * @param string $iDClausula
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDClausula($iDClausula = null)
    {
        // validation for constraint: string
        if (!is_null($iDClausula) && !is_string($iDClausula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDClausula, true), gettype($iDClausula)), __LINE__);
        }
        $this->IDClausula = $iDClausula;
        return $this;
    }
    /**
     * Get IDRastreoVehicular value
     * @return string|null
     */
    public function getIDRastreoVehicular()
    {
        return $this->IDRastreoVehicular;
    }
    /**
     * Set IDRastreoVehicular value
     * @param string $iDRastreoVehicular
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDRastreoVehicular($iDRastreoVehicular = null)
    {
        // validation for constraint: string
        if (!is_null($iDRastreoVehicular) && !is_string($iDRastreoVehicular)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRastreoVehicular, true), gettype($iDRastreoVehicular)), __LINE__);
        }
        $this->IDRastreoVehicular = $iDRastreoVehicular;
        return $this;
    }
    /**
     * Get IDUso value
     * @return string|null
     */
    public function getIDUso()
    {
        return $this->IDUso;
    }
    /**
     * Set IDUso value
     * @param string $iDUso
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDUso($iDUso = null)
    {
        // validation for constraint: string
        if (!is_null($iDUso) && !is_string($iDUso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDUso, true), gettype($iDUso)), __LINE__);
        }
        $this->IDUso = $iDUso;
        return $this;
    }
    /**
     * Get IDZonaRiesgo value
     * @return string|null
     */
    public function getIDZonaRiesgo()
    {
        return $this->IDZonaRiesgo;
    }
    /**
     * Set IDZonaRiesgo value
     * @param string $iDZonaRiesgo
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDZonaRiesgo($iDZonaRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDZonaRiesgo) && !is_string($iDZonaRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDZonaRiesgo, true), gettype($iDZonaRiesgo)), __LINE__);
        }
        $this->IDZonaRiesgo = $iDZonaRiesgo;
        return $this;
    }
    /**
     * Get IDTipoPersonaAsegurado value
     * @return string|null
     */
    public function getIDTipoPersonaAsegurado()
    {
        return $this->IDTipoPersonaAsegurado;
    }
    /**
     * Set IDTipoPersonaAsegurado value
     * @param string $iDTipoPersonaAsegurado
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDTipoPersonaAsegurado($iDTipoPersonaAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersonaAsegurado) && !is_string($iDTipoPersonaAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersonaAsegurado, true), gettype($iDTipoPersonaAsegurado)), __LINE__);
        }
        $this->IDTipoPersonaAsegurado = $iDTipoPersonaAsegurado;
        return $this;
    }
    /**
     * Get IDTipoCombustibleOriginal value
     * @return string|null
     */
    public function getIDTipoCombustibleOriginal()
    {
        return $this->IDTipoCombustibleOriginal;
    }
    /**
     * Set IDTipoCombustibleOriginal value
     * @param string $iDTipoCombustibleOriginal
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDTipoCombustibleOriginal($iDTipoCombustibleOriginal = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoCombustibleOriginal) && !is_string($iDTipoCombustibleOriginal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoCombustibleOriginal, true), gettype($iDTipoCombustibleOriginal)), __LINE__);
        }
        $this->IDTipoCombustibleOriginal = $iDTipoCombustibleOriginal;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get Coberturas value
     * @return \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoItemCobertura|null
     */
    public function getCoberturas()
    {
        return $this->Coberturas;
    }
    /**
     * Set Coberturas value
     * @param \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoItemCobertura $coberturas
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setCoberturas(\ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoItemCobertura $coberturas = null)
    {
        $this->Coberturas = $coberturas;
        return $this;
    }
    /**
     * Get OrdenCostos value
     * @return \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoOrdenCosto|null
     */
    public function getOrdenCostos()
    {
        return $this->OrdenCostos;
    }
    /**
     * Set OrdenCostos value
     * @param \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoOrdenCosto $ordenCostos
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setOrdenCostos(\ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoOrdenCosto $ordenCostos = null)
    {
        $this->OrdenCostos = $ordenCostos;
        return $this;
    }
    /**
     * Get ExcepcionItem value
     * @return \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoMotorExcepcionItem|null
     */
    public function getExcepcionItem()
    {
        return $this->ExcepcionItem;
    }
    /**
     * Set ExcepcionItem value
     * @param \ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoMotorExcepcionItem $excepcionItem
     * @return \StructType\DocCanalOUTConsultaPresupuestoItem
     */
    public function setExcepcionItem(\ArrayType\ArrayOfDocCanalOUTConsultaPresupuestoMotorExcepcionItem $excepcionItem = null)
    {
        $this->ExcepcionItem = $excepcionItem;
        return $this;
    }
}
