<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocCanalINCotizacionComercioItem StructType
 * @subpackage Structs
 */
class DocCanalINCotizacionComercioItem extends AbstractStructBase
{
    /**
     * The ItemID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ItemID;
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The AsistenciaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AsistenciaID;
    /**
     * The PaqueteID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PaqueteID;
    /**
     * The ActividadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $ActividadID;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The IDLocalidad
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDLocalidad;
    /**
     * The CodigoPostal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CodigoPostal;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The TipoScoringValores
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINCotizacionComercioItemTiposcoringvalor
     */
    public $TipoScoringValores;
    /**
     * The Coberturas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfDocCanalINCotizacionComercioItemCobertura
     */
    public $Coberturas;
    /**
     * Constructor method for DocCanalINCotizacionComercioItem
     * @uses DocCanalINCotizacionComercioItem::setItemID()
     * @uses DocCanalINCotizacionComercioItem::setOrdenID()
     * @uses DocCanalINCotizacionComercioItem::setAsistenciaID()
     * @uses DocCanalINCotizacionComercioItem::setPaqueteID()
     * @uses DocCanalINCotizacionComercioItem::setActividadID()
     * @uses DocCanalINCotizacionComercioItem::setIDProvincia()
     * @uses DocCanalINCotizacionComercioItem::setIDLocalidad()
     * @uses DocCanalINCotizacionComercioItem::setCodigoPostal()
     * @uses DocCanalINCotizacionComercioItem::setIDCondicionIVA()
     * @uses DocCanalINCotizacionComercioItem::setTipoScoringValores()
     * @uses DocCanalINCotizacionComercioItem::setCoberturas()
     * @param int $itemID
     * @param int $ordenID
     * @param int $asistenciaID
     * @param int $paqueteID
     * @param int $actividadID
     * @param string $iDProvincia
     * @param string $iDLocalidad
     * @param string $codigoPostal
     * @param string $iDCondicionIVA
     * @param \ArrayType\ArrayOfDocCanalINCotizacionComercioItemTiposcoringvalor $tipoScoringValores
     * @param \ArrayType\ArrayOfDocCanalINCotizacionComercioItemCobertura $coberturas
     */
    public function __construct($itemID = null, $ordenID = null, $asistenciaID = null, $paqueteID = null, $actividadID = null, $iDProvincia = null, $iDLocalidad = null, $codigoPostal = null, $iDCondicionIVA = null, \ArrayType\ArrayOfDocCanalINCotizacionComercioItemTiposcoringvalor $tipoScoringValores = null, \ArrayType\ArrayOfDocCanalINCotizacionComercioItemCobertura $coberturas = null)
    {
        $this
            ->setItemID($itemID)
            ->setOrdenID($ordenID)
            ->setAsistenciaID($asistenciaID)
            ->setPaqueteID($paqueteID)
            ->setActividadID($actividadID)
            ->setIDProvincia($iDProvincia)
            ->setIDLocalidad($iDLocalidad)
            ->setCodigoPostal($codigoPostal)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setTipoScoringValores($tipoScoringValores)
            ->setCoberturas($coberturas);
    }
    /**
     * Get ItemID value
     * @return int
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param int $itemID
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: int
        if (!is_null($itemID) && !(is_int($itemID) || ctype_digit($itemID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemID, true), gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get AsistenciaID value
     * @return int
     */
    public function getAsistenciaID()
    {
        return $this->AsistenciaID;
    }
    /**
     * Set AsistenciaID value
     * @param int $asistenciaID
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setAsistenciaID($asistenciaID = null)
    {
        // validation for constraint: int
        if (!is_null($asistenciaID) && !(is_int($asistenciaID) || ctype_digit($asistenciaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($asistenciaID, true), gettype($asistenciaID)), __LINE__);
        }
        $this->AsistenciaID = $asistenciaID;
        return $this;
    }
    /**
     * Get PaqueteID value
     * @return int
     */
    public function getPaqueteID()
    {
        return $this->PaqueteID;
    }
    /**
     * Set PaqueteID value
     * @param int $paqueteID
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setPaqueteID($paqueteID = null)
    {
        // validation for constraint: int
        if (!is_null($paqueteID) && !(is_int($paqueteID) || ctype_digit($paqueteID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($paqueteID, true), gettype($paqueteID)), __LINE__);
        }
        $this->PaqueteID = $paqueteID;
        return $this;
    }
    /**
     * Get ActividadID value
     * @return int
     */
    public function getActividadID()
    {
        return $this->ActividadID;
    }
    /**
     * Set ActividadID value
     * @param int $actividadID
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setActividadID($actividadID = null)
    {
        // validation for constraint: int
        if (!is_null($actividadID) && !(is_int($actividadID) || ctype_digit($actividadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($actividadID, true), gettype($actividadID)), __LINE__);
        }
        $this->ActividadID = $actividadID;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get IDLocalidad value
     * @return string|null
     */
    public function getIDLocalidad()
    {
        return $this->IDLocalidad;
    }
    /**
     * Set IDLocalidad value
     * @param string $iDLocalidad
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setIDLocalidad($iDLocalidad = null)
    {
        // validation for constraint: string
        if (!is_null($iDLocalidad) && !is_string($iDLocalidad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDLocalidad, true), gettype($iDLocalidad)), __LINE__);
        }
        $this->IDLocalidad = $iDLocalidad;
        return $this;
    }
    /**
     * Get CodigoPostal value
     * @return string|null
     */
    public function getCodigoPostal()
    {
        return $this->CodigoPostal;
    }
    /**
     * Set CodigoPostal value
     * @param string $codigoPostal
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setCodigoPostal($codigoPostal = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPostal) && !is_string($codigoPostal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPostal, true), gettype($codigoPostal)), __LINE__);
        }
        $this->CodigoPostal = $codigoPostal;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get TipoScoringValores value
     * @return \ArrayType\ArrayOfDocCanalINCotizacionComercioItemTiposcoringvalor|null
     */
    public function getTipoScoringValores()
    {
        return $this->TipoScoringValores;
    }
    /**
     * Set TipoScoringValores value
     * @param \ArrayType\ArrayOfDocCanalINCotizacionComercioItemTiposcoringvalor $tipoScoringValores
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setTipoScoringValores(\ArrayType\ArrayOfDocCanalINCotizacionComercioItemTiposcoringvalor $tipoScoringValores = null)
    {
        $this->TipoScoringValores = $tipoScoringValores;
        return $this;
    }
    /**
     * Get Coberturas value
     * @return \ArrayType\ArrayOfDocCanalINCotizacionComercioItemCobertura|null
     */
    public function getCoberturas()
    {
        return $this->Coberturas;
    }
    /**
     * Set Coberturas value
     * @param \ArrayType\ArrayOfDocCanalINCotizacionComercioItemCobertura $coberturas
     * @return \StructType\DocCanalINCotizacionComercioItem
     */
    public function setCoberturas(\ArrayType\ArrayOfDocCanalINCotizacionComercioItemCobertura $coberturas = null)
    {
        $this->Coberturas = $coberturas;
        return $this;
    }
}
