<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DatosDocumentacion StructType
 * @subpackage Structs
 */
class DatosDocumentacion extends AbstractStructBase
{
    /**
     * The Tipo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tipo;
    /**
     * The NroEndoso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $NroEndoso;
    /**
     * The Copia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $Copia;
    /**
     * The TipoDeEndoso
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var string
     */
    public $TipoDeEndoso;
    /**
     * The DocLink
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocLink;
    /**
     * Constructor method for DatosDocumentacion
     * @uses DatosDocumentacion::setTipo()
     * @uses DatosDocumentacion::setNroEndoso()
     * @uses DatosDocumentacion::setCopia()
     * @uses DatosDocumentacion::setTipoDeEndoso()
     * @uses DatosDocumentacion::setDocLink()
     * @param string $tipo
     * @param int $nroEndoso
     * @param string $copia
     * @param string $tipoDeEndoso
     * @param string $docLink
     */
    public function __construct($tipo = null, $nroEndoso = null, $copia = null, $tipoDeEndoso = null, $docLink = null)
    {
        $this
            ->setTipo($tipo)
            ->setNroEndoso($nroEndoso)
            ->setCopia($copia)
            ->setTipoDeEndoso($tipoDeEndoso)
            ->setDocLink($docLink);
    }
    /**
     * Get Tipo value
     * @return string
     */
    public function getTipo()
    {
        return $this->Tipo;
    }
    /**
     * Set Tipo value
     * @uses \EnumType\TipoDeDocumento::valueIsValid()
     * @uses \EnumType\TipoDeDocumento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipo
     * @return \StructType\DatosDocumentacion
     */
    public function setTipo($tipo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoDeDocumento::valueIsValid($tipo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoDeDocumento', is_array($tipo) ? implode(', ', $tipo) : var_export($tipo, true), implode(', ', \EnumType\TipoDeDocumento::getValidValues())), __LINE__);
        }
        $this->Tipo = $tipo;
        return $this;
    }
    /**
     * Get NroEndoso value
     * @return int
     */
    public function getNroEndoso()
    {
        return $this->NroEndoso;
    }
    /**
     * Set NroEndoso value
     * @param int $nroEndoso
     * @return \StructType\DatosDocumentacion
     */
    public function setNroEndoso($nroEndoso = null)
    {
        // validation for constraint: int
        if (!is_null($nroEndoso) && !(is_int($nroEndoso) || ctype_digit($nroEndoso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nroEndoso, true), gettype($nroEndoso)), __LINE__);
        }
        $this->NroEndoso = $nroEndoso;
        return $this;
    }
    /**
     * Get Copia value
     * @return string
     */
    public function getCopia()
    {
        return $this->Copia;
    }
    /**
     * Set Copia value
     * @uses \EnumType\Copia::valueIsValid()
     * @uses \EnumType\Copia::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $copia
     * @return \StructType\DatosDocumentacion
     */
    public function setCopia($copia = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Copia::valueIsValid($copia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Copia', is_array($copia) ? implode(', ', $copia) : var_export($copia, true), implode(', ', \EnumType\Copia::getValidValues())), __LINE__);
        }
        $this->Copia = $copia;
        return $this;
    }
    /**
     * Get TipoDeEndoso value
     * @return string
     */
    public function getTipoDeEndoso()
    {
        return $this->TipoDeEndoso;
    }
    /**
     * Set TipoDeEndoso value
     * @uses \EnumType\TipoEndoso::valueIsValid()
     * @uses \EnumType\TipoEndoso::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoDeEndoso
     * @return \StructType\DatosDocumentacion
     */
    public function setTipoDeEndoso($tipoDeEndoso = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoEndoso::valueIsValid($tipoDeEndoso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoEndoso', is_array($tipoDeEndoso) ? implode(', ', $tipoDeEndoso) : var_export($tipoDeEndoso, true), implode(', ', \EnumType\TipoEndoso::getValidValues())), __LINE__);
        }
        $this->TipoDeEndoso = $tipoDeEndoso;
        return $this;
    }
    /**
     * Get DocLink value
     * @return string|null
     */
    public function getDocLink()
    {
        return $this->DocLink;
    }
    /**
     * Set DocLink value
     * @param string $docLink
     * @return \StructType\DatosDocumentacion
     */
    public function setDocLink($docLink = null)
    {
        // validation for constraint: string
        if (!is_null($docLink) && !is_string($docLink)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($docLink, true), gettype($docLink)), __LINE__);
        }
        $this->DocLink = $docLink;
        return $this;
    }
}
