<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Emision ServiceType
 * @subpackage Services
 */
class Emision extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EmisionOrden
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Emision de Orden. | Realiza una Emision de Orden. | Realiza una Emision de Orden.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmisionOrden $parameters
     * @return \StructType\EmisionOrdenResponse|bool
     */
    public function EmisionOrden(\StructType\EmisionOrden $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmisionOrden($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EmisionOrdenStruct
     * Meta information extracted from the WSDL
     * - documentation: Realiza una Emision de Orden.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EmisionOrdenStruct $parameters
     * @return \StructType\EmisionOrdenStructResponse|bool
     */
    public function EmisionOrdenStruct(\StructType\EmisionOrdenStruct $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->EmisionOrdenStruct($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EmisionOrdenResponse|\StructType\EmisionOrdenStructResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
