<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Deudores ServiceType
 * @subpackage Services
 */
class Deudores extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DeudoresPorPremio
     * Meta information extracted from the WSDL
     * - documentation: Devuelve Informe de Deudores por premio. | Devuelve Informe de Deudores por premio. | Devuelve Informe de Deudores por premio.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DeudoresPorPremio $parameters
     * @return \StructType\DeudoresPorPremioResponse|bool
     */
    public function DeudoresPorPremio(\StructType\DeudoresPorPremio $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->DeudoresPorPremio($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DeudoresPorPremioResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
