<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Consultar ServiceType
 * @subpackage Services
 */
class Consultar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ConsultarPresupuesto
     * Meta information extracted from the WSDL
     * - documentation: Realiza la Consulta de Presupuestos. Para todos canales | Realiza la Consulta de Presupuestos. Para todos canales | Realiza la Consulta de Presupuestos. Para todos canales
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ConsultarPresupuesto $parameters
     * @return \StructType\ConsultarPresupuestoResponse|bool
     */
    public function ConsultarPresupuesto(\StructType\ConsultarPresupuesto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ConsultarPresupuesto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ConsultarPresupuestoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
