<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeudoresPorPremio StructType
 * @subpackage Structs
 */
class DeudoresPorPremio extends AbstractStructBase
{
    /**
     * The InsSubArea
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $InsSubArea;
    /**
     * The pUsuario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUsuario;
    /**
     * The pPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPassword;
    /**
     * The pUsuarioAec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUsuarioAec;
    /**
     * The pPasswordAec
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPasswordAec;
    /**
     * The Familia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Familia;
    /**
     * The pIdTransaccionExterno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pIdTransaccionExterno;
    /**
     * Constructor method for DeudoresPorPremio
     * @uses DeudoresPorPremio::setInsSubArea()
     * @uses DeudoresPorPremio::setPUsuario()
     * @uses DeudoresPorPremio::setPPassword()
     * @uses DeudoresPorPremio::setPUsuarioAec()
     * @uses DeudoresPorPremio::setPPasswordAec()
     * @uses DeudoresPorPremio::setFamilia()
     * @uses DeudoresPorPremio::setPIdTransaccionExterno()
     * @param string $insSubArea
     * @param string $pUsuario
     * @param string $pPassword
     * @param string $pUsuarioAec
     * @param string $pPasswordAec
     * @param string $familia
     * @param string $pIdTransaccionExterno
     */
    public function __construct($insSubArea = null, $pUsuario = null, $pPassword = null, $pUsuarioAec = null, $pPasswordAec = null, $familia = null, $pIdTransaccionExterno = null)
    {
        $this
            ->setInsSubArea($insSubArea)
            ->setPUsuario($pUsuario)
            ->setPPassword($pPassword)
            ->setPUsuarioAec($pUsuarioAec)
            ->setPPasswordAec($pPasswordAec)
            ->setFamilia($familia)
            ->setPIdTransaccionExterno($pIdTransaccionExterno);
    }
    /**
     * Get InsSubArea value
     * @return string
     */
    public function getInsSubArea()
    {
        return $this->InsSubArea;
    }
    /**
     * Set InsSubArea value
     * @uses \EnumType\InsSubAreaEnum::valueIsValid()
     * @uses \EnumType\InsSubAreaEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insSubArea
     * @return \StructType\DeudoresPorPremio
     */
    public function setInsSubArea($insSubArea = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsSubAreaEnum::valueIsValid($insSubArea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\InsSubAreaEnum', is_array($insSubArea) ? implode(', ', $insSubArea) : var_export($insSubArea, true), implode(', ', \EnumType\InsSubAreaEnum::getValidValues())), __LINE__);
        }
        $this->InsSubArea = $insSubArea;
        return $this;
    }
    /**
     * Get pUsuario value
     * @return string|null
     */
    public function getPUsuario()
    {
        return $this->pUsuario;
    }
    /**
     * Set pUsuario value
     * @param string $pUsuario
     * @return \StructType\DeudoresPorPremio
     */
    public function setPUsuario($pUsuario = null)
    {
        // validation for constraint: string
        if (!is_null($pUsuario) && !is_string($pUsuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUsuario, true), gettype($pUsuario)), __LINE__);
        }
        $this->pUsuario = $pUsuario;
        return $this;
    }
    /**
     * Get pPassword value
     * @return string|null
     */
    public function getPPassword()
    {
        return $this->pPassword;
    }
    /**
     * Set pPassword value
     * @param string $pPassword
     * @return \StructType\DeudoresPorPremio
     */
    public function setPPassword($pPassword = null)
    {
        // validation for constraint: string
        if (!is_null($pPassword) && !is_string($pPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pPassword, true), gettype($pPassword)), __LINE__);
        }
        $this->pPassword = $pPassword;
        return $this;
    }
    /**
     * Get pUsuarioAec value
     * @return string|null
     */
    public function getPUsuarioAec()
    {
        return $this->pUsuarioAec;
    }
    /**
     * Set pUsuarioAec value
     * @param string $pUsuarioAec
     * @return \StructType\DeudoresPorPremio
     */
    public function setPUsuarioAec($pUsuarioAec = null)
    {
        // validation for constraint: string
        if (!is_null($pUsuarioAec) && !is_string($pUsuarioAec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUsuarioAec, true), gettype($pUsuarioAec)), __LINE__);
        }
        $this->pUsuarioAec = $pUsuarioAec;
        return $this;
    }
    /**
     * Get pPasswordAec value
     * @return string|null
     */
    public function getPPasswordAec()
    {
        return $this->pPasswordAec;
    }
    /**
     * Set pPasswordAec value
     * @param string $pPasswordAec
     * @return \StructType\DeudoresPorPremio
     */
    public function setPPasswordAec($pPasswordAec = null)
    {
        // validation for constraint: string
        if (!is_null($pPasswordAec) && !is_string($pPasswordAec)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pPasswordAec, true), gettype($pPasswordAec)), __LINE__);
        }
        $this->pPasswordAec = $pPasswordAec;
        return $this;
    }
    /**
     * Get Familia value
     * @return string|null
     */
    public function getFamilia()
    {
        return $this->Familia;
    }
    /**
     * Set Familia value
     * @param string $familia
     * @return \StructType\DeudoresPorPremio
     */
    public function setFamilia($familia = null)
    {
        // validation for constraint: string
        if (!is_null($familia) && !is_string($familia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familia, true), gettype($familia)), __LINE__);
        }
        $this->Familia = $familia;
        return $this;
    }
    /**
     * Get pIdTransaccionExterno value
     * @return string|null
     */
    public function getPIdTransaccionExterno()
    {
        return $this->pIdTransaccionExterno;
    }
    /**
     * Set pIdTransaccionExterno value
     * @param string $pIdTransaccionExterno
     * @return \StructType\DeudoresPorPremio
     */
    public function setPIdTransaccionExterno($pIdTransaccionExterno = null)
    {
        // validation for constraint: string
        if (!is_null($pIdTransaccionExterno) && !is_string($pIdTransaccionExterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pIdTransaccionExterno, true), gettype($pIdTransaccionExterno)), __LINE__);
        }
        $this->pIdTransaccionExterno = $pIdTransaccionExterno;
        return $this;
    }
}
