<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarPresupuesto StructType
 * @subpackage Structs
 */
class ConsultarPresupuesto extends AbstractStructBase
{
    /**
     * The pPresupuesto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $pPresupuesto;
    /**
     * The pUsuario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUsuario;
    /**
     * The pPassword
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPassword;
    /**
     * The pUsuarioAEC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pUsuarioAEC;
    /**
     * The pPasswordAEC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPasswordAEC;
    /**
     * The pPrefijo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pPrefijo;
    /**
     * The pidTransacccionExterno
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pidTransacccionExterno;
    /**
     * The UserHostAddress
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserHostAddress;
    /**
     * Constructor method for ConsultarPresupuesto
     * @uses ConsultarPresupuesto::setPPresupuesto()
     * @uses ConsultarPresupuesto::setPUsuario()
     * @uses ConsultarPresupuesto::setPPassword()
     * @uses ConsultarPresupuesto::setPUsuarioAEC()
     * @uses ConsultarPresupuesto::setPPasswordAEC()
     * @uses ConsultarPresupuesto::setPPrefijo()
     * @uses ConsultarPresupuesto::setPidTransacccionExterno()
     * @uses ConsultarPresupuesto::setUserHostAddress()
     * @param int $pPresupuesto
     * @param string $pUsuario
     * @param string $pPassword
     * @param string $pUsuarioAEC
     * @param string $pPasswordAEC
     * @param string $pPrefijo
     * @param string $pidTransacccionExterno
     * @param string $userHostAddress
     */
    public function __construct($pPresupuesto = null, $pUsuario = null, $pPassword = null, $pUsuarioAEC = null, $pPasswordAEC = null, $pPrefijo = null, $pidTransacccionExterno = null, $userHostAddress = null)
    {
        $this
            ->setPPresupuesto($pPresupuesto)
            ->setPUsuario($pUsuario)
            ->setPPassword($pPassword)
            ->setPUsuarioAEC($pUsuarioAEC)
            ->setPPasswordAEC($pPasswordAEC)
            ->setPPrefijo($pPrefijo)
            ->setPidTransacccionExterno($pidTransacccionExterno)
            ->setUserHostAddress($userHostAddress);
    }
    /**
     * Get pPresupuesto value
     * @return int
     */
    public function getPPresupuesto()
    {
        return $this->pPresupuesto;
    }
    /**
     * Set pPresupuesto value
     * @param int $pPresupuesto
     * @return \StructType\ConsultarPresupuesto
     */
    public function setPPresupuesto($pPresupuesto = null)
    {
        // validation for constraint: int
        if (!is_null($pPresupuesto) && !(is_int($pPresupuesto) || ctype_digit($pPresupuesto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pPresupuesto, true), gettype($pPresupuesto)), __LINE__);
        }
        $this->pPresupuesto = $pPresupuesto;
        return $this;
    }
    /**
     * Get pUsuario value
     * @return string|null
     */
    public function getPUsuario()
    {
        return $this->pUsuario;
    }
    /**
     * Set pUsuario value
     * @param string $pUsuario
     * @return \StructType\ConsultarPresupuesto
     */
    public function setPUsuario($pUsuario = null)
    {
        // validation for constraint: string
        if (!is_null($pUsuario) && !is_string($pUsuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUsuario, true), gettype($pUsuario)), __LINE__);
        }
        $this->pUsuario = $pUsuario;
        return $this;
    }
    /**
     * Get pPassword value
     * @return string|null
     */
    public function getPPassword()
    {
        return $this->pPassword;
    }
    /**
     * Set pPassword value
     * @param string $pPassword
     * @return \StructType\ConsultarPresupuesto
     */
    public function setPPassword($pPassword = null)
    {
        // validation for constraint: string
        if (!is_null($pPassword) && !is_string($pPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pPassword, true), gettype($pPassword)), __LINE__);
        }
        $this->pPassword = $pPassword;
        return $this;
    }
    /**
     * Get pUsuarioAEC value
     * @return string|null
     */
    public function getPUsuarioAEC()
    {
        return $this->pUsuarioAEC;
    }
    /**
     * Set pUsuarioAEC value
     * @param string $pUsuarioAEC
     * @return \StructType\ConsultarPresupuesto
     */
    public function setPUsuarioAEC($pUsuarioAEC = null)
    {
        // validation for constraint: string
        if (!is_null($pUsuarioAEC) && !is_string($pUsuarioAEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pUsuarioAEC, true), gettype($pUsuarioAEC)), __LINE__);
        }
        $this->pUsuarioAEC = $pUsuarioAEC;
        return $this;
    }
    /**
     * Get pPasswordAEC value
     * @return string|null
     */
    public function getPPasswordAEC()
    {
        return $this->pPasswordAEC;
    }
    /**
     * Set pPasswordAEC value
     * @param string $pPasswordAEC
     * @return \StructType\ConsultarPresupuesto
     */
    public function setPPasswordAEC($pPasswordAEC = null)
    {
        // validation for constraint: string
        if (!is_null($pPasswordAEC) && !is_string($pPasswordAEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pPasswordAEC, true), gettype($pPasswordAEC)), __LINE__);
        }
        $this->pPasswordAEC = $pPasswordAEC;
        return $this;
    }
    /**
     * Get pPrefijo value
     * @return string|null
     */
    public function getPPrefijo()
    {
        return $this->pPrefijo;
    }
    /**
     * Set pPrefijo value
     * @param string $pPrefijo
     * @return \StructType\ConsultarPresupuesto
     */
    public function setPPrefijo($pPrefijo = null)
    {
        // validation for constraint: string
        if (!is_null($pPrefijo) && !is_string($pPrefijo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pPrefijo, true), gettype($pPrefijo)), __LINE__);
        }
        $this->pPrefijo = $pPrefijo;
        return $this;
    }
    /**
     * Get pidTransacccionExterno value
     * @return string|null
     */
    public function getPidTransacccionExterno()
    {
        return $this->pidTransacccionExterno;
    }
    /**
     * Set pidTransacccionExterno value
     * @param string $pidTransacccionExterno
     * @return \StructType\ConsultarPresupuesto
     */
    public function setPidTransacccionExterno($pidTransacccionExterno = null)
    {
        // validation for constraint: string
        if (!is_null($pidTransacccionExterno) && !is_string($pidTransacccionExterno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pidTransacccionExterno, true), gettype($pidTransacccionExterno)), __LINE__);
        }
        $this->pidTransacccionExterno = $pidTransacccionExterno;
        return $this;
    }
    /**
     * Get UserHostAddress value
     * @return string|null
     */
    public function getUserHostAddress()
    {
        return $this->UserHostAddress;
    }
    /**
     * Set UserHostAddress value
     * @param string $userHostAddress
     * @return \StructType\ConsultarPresupuesto
     */
    public function setUserHostAddress($userHostAddress = null)
    {
        // validation for constraint: string
        if (!is_null($userHostAddress) && !is_string($userHostAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userHostAddress, true), gettype($userHostAddress)), __LINE__);
        }
        $this->UserHostAddress = $userHostAddress;
        return $this;
    }
}
