<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmisionMotorsSalidaOrden StructType
 * @subpackage Structs
 */
class EmisionMotorsSalidaOrden extends AbstractStructBase
{
    /**
     * The OrdenID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $OrdenID;
    /**
     * The FamiliaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $FamiliaID;
    /**
     * The SociedadID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SociedadID;
    /**
     * The PlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $PlanID;
    /**
     * The EsRenovacion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EsRenovacion;
    /**
     * The PorcPGP
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PorcPGP;
    /**
     * The PorcRecargoFinanciero
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PorcRecargoFinanciero;
    /**
     * The Comision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $Comision;
    /**
     * The BonificacionComercial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionComercial;
    /**
     * The BonificacionComision
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BonificacionComision;
    /**
     * The BonificacionViacobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionViacobro;
    /**
     * The FechaVigenciaDesde
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaDesde;
    /**
     * The FechaVigenciaHasta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaVigenciaHasta;
    /**
     * The CantidadDias
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CantidadDias;
    /**
     * The CantidadCuotas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CantidadCuotas;
    /**
     * The PorcDistribucionProductor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PorcDistribucionProductor;
    /**
     * The PorcDistribucionOrganizador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $PorcDistribucionOrganizador;
    /**
     * The DistribucionComisionOrganizador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistribucionComisionOrganizador;
    /**
     * The DistribucionComisionProductor
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $DistribucionComisionProductor;
    /**
     * The EstadoID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $EstadoID;
    /**
     * The FechaEstado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FechaEstado;
    /**
     * The Fecha
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Fecha;
    /**
     * The RequiereInspeccion
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $RequiereInspeccion;
    /**
     * The GrupoTelemarketerID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $GrupoTelemarketerID;
    /**
     * The AniosSinSiniestro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $AniosSinSiniestro;
    /**
     * The TieneAgrupamiento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TieneAgrupamiento;
    /**
     * The CUIT
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $CUIT;
    /**
     * The AjusteSuma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $AjusteSuma;
    /**
     * The EsEspecial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $EsEspecial;
    /**
     * The BonficacionComercialMaxima
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var float
     */
    public $BonficacionComercialMaxima;
    /**
     * The BonificacionComercialAprob
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $BonificacionComercialAprob;
    /**
     * The CompaniaID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $CompaniaID;
    /**
     * The RecibePolizaElectronica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RecibePolizaElectronica;
    /**
     * The RecibeDocumentacionElectronica
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var bool
     */
    public $RecibeDocumentacionElectronica;
    /**
     * The Propuesta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Propuesta;
    /**
     * The Poliza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $Poliza;
    /**
     * The PolizaUnificada
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - nillable: true
     * @var int
     */
    public $PolizaUnificada;
    /**
     * The IDRiesgo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDRiesgo;
    /**
     * The IDTipoPoliza
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPoliza;
    /**
     * The IDTipoPersona
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDTipoPersona;
    /**
     * The IDCondicionIVA
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDCondicionIVA;
    /**
     * The NroPolizaAnterior
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NroPolizaAnterior;
    /**
     * The IDPersonaAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaAsegurado;
    /**
     * The IDPersonaTomador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPersonaTomador;
    /**
     * The IDViaCobro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDViaCobro;
    /**
     * The IDInstitucionFinanciera
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDInstitucionFinanciera;
    /**
     * The IDPlanPago
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDPlanPago;
    /**
     * The IDMoneda
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDMoneda;
    /**
     * The IDProducto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProducto;
    /**
     * The IDSegmento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDSegmento;
    /**
     * The NumeroTarjeta
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroTarjeta;
    /**
     * The PrefijoPresupuesto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PrefijoPresupuesto;
    /**
     * The NumeroPresupuesto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroPresupuesto;
    /**
     * The NroPresupuestoAS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NroPresupuestoAS;
    /**
     * The NumeroPolizaAS
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NumeroPolizaAS;
    /**
     * The IDUsuario
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDUsuario;
    /**
     * The IDProvincia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IDProvincia;
    /**
     * The TipoPlanID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TipoPlanID;
    /**
     * The NombreAsegurado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreAsegurado;
    /**
     * The NombreTomador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NombreTomador;
    /**
     * The Mail
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Mail;
    /**
     * The CantItem
     * Meta information extracted from the WSDL
     * - default: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $CantItem;
    /**
     * The IDBeneficio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IDBeneficio;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEmisionMotorsSalidaItem
     */
    public $Items;
    /**
     * The OrdenCostos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto
     */
    public $OrdenCostos;
    /**
     * Constructor method for EmisionMotorsSalidaOrden
     * @uses EmisionMotorsSalidaOrden::setOrdenID()
     * @uses EmisionMotorsSalidaOrden::setFamiliaID()
     * @uses EmisionMotorsSalidaOrden::setSociedadID()
     * @uses EmisionMotorsSalidaOrden::setPlanID()
     * @uses EmisionMotorsSalidaOrden::setEsRenovacion()
     * @uses EmisionMotorsSalidaOrden::setPorcPGP()
     * @uses EmisionMotorsSalidaOrden::setPorcRecargoFinanciero()
     * @uses EmisionMotorsSalidaOrden::setComision()
     * @uses EmisionMotorsSalidaOrden::setBonificacionComercial()
     * @uses EmisionMotorsSalidaOrden::setBonificacionComision()
     * @uses EmisionMotorsSalidaOrden::setBonificacionViacobro()
     * @uses EmisionMotorsSalidaOrden::setFechaVigenciaDesde()
     * @uses EmisionMotorsSalidaOrden::setFechaVigenciaHasta()
     * @uses EmisionMotorsSalidaOrden::setCantidadDias()
     * @uses EmisionMotorsSalidaOrden::setCantidadCuotas()
     * @uses EmisionMotorsSalidaOrden::setPorcDistribucionProductor()
     * @uses EmisionMotorsSalidaOrden::setPorcDistribucionOrganizador()
     * @uses EmisionMotorsSalidaOrden::setDistribucionComisionOrganizador()
     * @uses EmisionMotorsSalidaOrden::setDistribucionComisionProductor()
     * @uses EmisionMotorsSalidaOrden::setEstadoID()
     * @uses EmisionMotorsSalidaOrden::setFechaEstado()
     * @uses EmisionMotorsSalidaOrden::setFecha()
     * @uses EmisionMotorsSalidaOrden::setRequiereInspeccion()
     * @uses EmisionMotorsSalidaOrden::setGrupoTelemarketerID()
     * @uses EmisionMotorsSalidaOrden::setAniosSinSiniestro()
     * @uses EmisionMotorsSalidaOrden::setTieneAgrupamiento()
     * @uses EmisionMotorsSalidaOrden::setCUIT()
     * @uses EmisionMotorsSalidaOrden::setAjusteSuma()
     * @uses EmisionMotorsSalidaOrden::setEsEspecial()
     * @uses EmisionMotorsSalidaOrden::setBonficacionComercialMaxima()
     * @uses EmisionMotorsSalidaOrden::setBonificacionComercialAprob()
     * @uses EmisionMotorsSalidaOrden::setCompaniaID()
     * @uses EmisionMotorsSalidaOrden::setRecibePolizaElectronica()
     * @uses EmisionMotorsSalidaOrden::setRecibeDocumentacionElectronica()
     * @uses EmisionMotorsSalidaOrden::setPropuesta()
     * @uses EmisionMotorsSalidaOrden::setPoliza()
     * @uses EmisionMotorsSalidaOrden::setPolizaUnificada()
     * @uses EmisionMotorsSalidaOrden::setIDRiesgo()
     * @uses EmisionMotorsSalidaOrden::setIDTipoPoliza()
     * @uses EmisionMotorsSalidaOrden::setIDTipoPersona()
     * @uses EmisionMotorsSalidaOrden::setIDCondicionIVA()
     * @uses EmisionMotorsSalidaOrden::setNroPolizaAnterior()
     * @uses EmisionMotorsSalidaOrden::setIDPersonaAsegurado()
     * @uses EmisionMotorsSalidaOrden::setIDPersonaTomador()
     * @uses EmisionMotorsSalidaOrden::setIDViaCobro()
     * @uses EmisionMotorsSalidaOrden::setIDInstitucionFinanciera()
     * @uses EmisionMotorsSalidaOrden::setIDPlanPago()
     * @uses EmisionMotorsSalidaOrden::setIDMoneda()
     * @uses EmisionMotorsSalidaOrden::setIDProducto()
     * @uses EmisionMotorsSalidaOrden::setIDSegmento()
     * @uses EmisionMotorsSalidaOrden::setNumeroTarjeta()
     * @uses EmisionMotorsSalidaOrden::setPrefijoPresupuesto()
     * @uses EmisionMotorsSalidaOrden::setNumeroPresupuesto()
     * @uses EmisionMotorsSalidaOrden::setNroPresupuestoAS()
     * @uses EmisionMotorsSalidaOrden::setNumeroPolizaAS()
     * @uses EmisionMotorsSalidaOrden::setIDUsuario()
     * @uses EmisionMotorsSalidaOrden::setIDProvincia()
     * @uses EmisionMotorsSalidaOrden::setTipoPlanID()
     * @uses EmisionMotorsSalidaOrden::setNombreAsegurado()
     * @uses EmisionMotorsSalidaOrden::setNombreTomador()
     * @uses EmisionMotorsSalidaOrden::setMail()
     * @uses EmisionMotorsSalidaOrden::setCantItem()
     * @uses EmisionMotorsSalidaOrden::setIDBeneficio()
     * @uses EmisionMotorsSalidaOrden::setItems()
     * @uses EmisionMotorsSalidaOrden::setOrdenCostos()
     * @param int $ordenID
     * @param int $familiaID
     * @param int $sociedadID
     * @param int $planID
     * @param bool $esRenovacion
     * @param float $porcPGP
     * @param float $porcRecargoFinanciero
     * @param float $comision
     * @param float $bonificacionComercial
     * @param float $bonificacionComision
     * @param float $bonificacionViacobro
     * @param string $fechaVigenciaDesde
     * @param string $fechaVigenciaHasta
     * @param int $cantidadDias
     * @param int $cantidadCuotas
     * @param float $porcDistribucionProductor
     * @param float $porcDistribucionOrganizador
     * @param float $distribucionComisionOrganizador
     * @param float $distribucionComisionProductor
     * @param int $estadoID
     * @param string $fechaEstado
     * @param string $fecha
     * @param bool $requiereInspeccion
     * @param int $grupoTelemarketerID
     * @param int $aniosSinSiniestro
     * @param bool $tieneAgrupamiento
     * @param float $cUIT
     * @param int $ajusteSuma
     * @param bool $esEspecial
     * @param float $bonficacionComercialMaxima
     * @param float $bonificacionComercialAprob
     * @param int $companiaID
     * @param bool $recibePolizaElectronica
     * @param bool $recibeDocumentacionElectronica
     * @param int $propuesta
     * @param int $poliza
     * @param int $polizaUnificada
     * @param string $iDRiesgo
     * @param string $iDTipoPoliza
     * @param string $iDTipoPersona
     * @param string $iDCondicionIVA
     * @param string $nroPolizaAnterior
     * @param string $iDPersonaAsegurado
     * @param string $iDPersonaTomador
     * @param string $iDViaCobro
     * @param string $iDInstitucionFinanciera
     * @param string $iDPlanPago
     * @param string $iDMoneda
     * @param string $iDProducto
     * @param string $iDSegmento
     * @param string $numeroTarjeta
     * @param string $prefijoPresupuesto
     * @param string $numeroPresupuesto
     * @param string $nroPresupuestoAS
     * @param string $numeroPolizaAS
     * @param string $iDUsuario
     * @param string $iDProvincia
     * @param string $tipoPlanID
     * @param string $nombreAsegurado
     * @param string $nombreTomador
     * @param string $mail
     * @param int $cantItem
     * @param int $iDBeneficio
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaItem $items
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos
     */
    public function __construct($ordenID = null, $familiaID = null, $sociedadID = null, $planID = null, $esRenovacion = null, $porcPGP = null, $porcRecargoFinanciero = null, $comision = null, $bonificacionComercial = null, $bonificacionComision = null, $bonificacionViacobro = null, $fechaVigenciaDesde = null, $fechaVigenciaHasta = null, $cantidadDias = null, $cantidadCuotas = null, $porcDistribucionProductor = null, $porcDistribucionOrganizador = null, $distribucionComisionOrganizador = null, $distribucionComisionProductor = null, $estadoID = null, $fechaEstado = null, $fecha = null, $requiereInspeccion = null, $grupoTelemarketerID = null, $aniosSinSiniestro = null, $tieneAgrupamiento = null, $cUIT = null, $ajusteSuma = null, $esEspecial = null, $bonficacionComercialMaxima = null, $bonificacionComercialAprob = null, $companiaID = null, $recibePolizaElectronica = null, $recibeDocumentacionElectronica = null, $propuesta = null, $poliza = null, $polizaUnificada = null, $iDRiesgo = null, $iDTipoPoliza = null, $iDTipoPersona = null, $iDCondicionIVA = null, $nroPolizaAnterior = null, $iDPersonaAsegurado = null, $iDPersonaTomador = null, $iDViaCobro = null, $iDInstitucionFinanciera = null, $iDPlanPago = null, $iDMoneda = null, $iDProducto = null, $iDSegmento = null, $numeroTarjeta = null, $prefijoPresupuesto = null, $numeroPresupuesto = null, $nroPresupuestoAS = null, $numeroPolizaAS = null, $iDUsuario = null, $iDProvincia = null, $tipoPlanID = null, $nombreAsegurado = null, $nombreTomador = null, $mail = null, $cantItem = 0, $iDBeneficio = null, \ArrayType\ArrayOfEmisionMotorsSalidaItem $items = null, \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos = null)
    {
        $this
            ->setOrdenID($ordenID)
            ->setFamiliaID($familiaID)
            ->setSociedadID($sociedadID)
            ->setPlanID($planID)
            ->setEsRenovacion($esRenovacion)
            ->setPorcPGP($porcPGP)
            ->setPorcRecargoFinanciero($porcRecargoFinanciero)
            ->setComision($comision)
            ->setBonificacionComercial($bonificacionComercial)
            ->setBonificacionComision($bonificacionComision)
            ->setBonificacionViacobro($bonificacionViacobro)
            ->setFechaVigenciaDesde($fechaVigenciaDesde)
            ->setFechaVigenciaHasta($fechaVigenciaHasta)
            ->setCantidadDias($cantidadDias)
            ->setCantidadCuotas($cantidadCuotas)
            ->setPorcDistribucionProductor($porcDistribucionProductor)
            ->setPorcDistribucionOrganizador($porcDistribucionOrganizador)
            ->setDistribucionComisionOrganizador($distribucionComisionOrganizador)
            ->setDistribucionComisionProductor($distribucionComisionProductor)
            ->setEstadoID($estadoID)
            ->setFechaEstado($fechaEstado)
            ->setFecha($fecha)
            ->setRequiereInspeccion($requiereInspeccion)
            ->setGrupoTelemarketerID($grupoTelemarketerID)
            ->setAniosSinSiniestro($aniosSinSiniestro)
            ->setTieneAgrupamiento($tieneAgrupamiento)
            ->setCUIT($cUIT)
            ->setAjusteSuma($ajusteSuma)
            ->setEsEspecial($esEspecial)
            ->setBonficacionComercialMaxima($bonficacionComercialMaxima)
            ->setBonificacionComercialAprob($bonificacionComercialAprob)
            ->setCompaniaID($companiaID)
            ->setRecibePolizaElectronica($recibePolizaElectronica)
            ->setRecibeDocumentacionElectronica($recibeDocumentacionElectronica)
            ->setPropuesta($propuesta)
            ->setPoliza($poliza)
            ->setPolizaUnificada($polizaUnificada)
            ->setIDRiesgo($iDRiesgo)
            ->setIDTipoPoliza($iDTipoPoliza)
            ->setIDTipoPersona($iDTipoPersona)
            ->setIDCondicionIVA($iDCondicionIVA)
            ->setNroPolizaAnterior($nroPolizaAnterior)
            ->setIDPersonaAsegurado($iDPersonaAsegurado)
            ->setIDPersonaTomador($iDPersonaTomador)
            ->setIDViaCobro($iDViaCobro)
            ->setIDInstitucionFinanciera($iDInstitucionFinanciera)
            ->setIDPlanPago($iDPlanPago)
            ->setIDMoneda($iDMoneda)
            ->setIDProducto($iDProducto)
            ->setIDSegmento($iDSegmento)
            ->setNumeroTarjeta($numeroTarjeta)
            ->setPrefijoPresupuesto($prefijoPresupuesto)
            ->setNumeroPresupuesto($numeroPresupuesto)
            ->setNroPresupuestoAS($nroPresupuestoAS)
            ->setNumeroPolizaAS($numeroPolizaAS)
            ->setIDUsuario($iDUsuario)
            ->setIDProvincia($iDProvincia)
            ->setTipoPlanID($tipoPlanID)
            ->setNombreAsegurado($nombreAsegurado)
            ->setNombreTomador($nombreTomador)
            ->setMail($mail)
            ->setCantItem($cantItem)
            ->setIDBeneficio($iDBeneficio)
            ->setItems($items)
            ->setOrdenCostos($ordenCostos);
    }
    /**
     * Get OrdenID value
     * @return int
     */
    public function getOrdenID()
    {
        return $this->OrdenID;
    }
    /**
     * Set OrdenID value
     * @param int $ordenID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setOrdenID($ordenID = null)
    {
        // validation for constraint: int
        if (!is_null($ordenID) && !(is_int($ordenID) || ctype_digit($ordenID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordenID, true), gettype($ordenID)), __LINE__);
        }
        $this->OrdenID = $ordenID;
        return $this;
    }
    /**
     * Get FamiliaID value
     * @return int
     */
    public function getFamiliaID()
    {
        return $this->FamiliaID;
    }
    /**
     * Set FamiliaID value
     * @param int $familiaID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setFamiliaID($familiaID = null)
    {
        // validation for constraint: int
        if (!is_null($familiaID) && !(is_int($familiaID) || ctype_digit($familiaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($familiaID, true), gettype($familiaID)), __LINE__);
        }
        $this->FamiliaID = $familiaID;
        return $this;
    }
    /**
     * Get SociedadID value
     * @return int
     */
    public function getSociedadID()
    {
        return $this->SociedadID;
    }
    /**
     * Set SociedadID value
     * @param int $sociedadID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setSociedadID($sociedadID = null)
    {
        // validation for constraint: int
        if (!is_null($sociedadID) && !(is_int($sociedadID) || ctype_digit($sociedadID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sociedadID, true), gettype($sociedadID)), __LINE__);
        }
        $this->SociedadID = $sociedadID;
        return $this;
    }
    /**
     * Get PlanID value
     * @return int
     */
    public function getPlanID()
    {
        return $this->PlanID;
    }
    /**
     * Set PlanID value
     * @param int $planID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPlanID($planID = null)
    {
        // validation for constraint: int
        if (!is_null($planID) && !(is_int($planID) || ctype_digit($planID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($planID, true), gettype($planID)), __LINE__);
        }
        $this->PlanID = $planID;
        return $this;
    }
    /**
     * Get EsRenovacion value
     * @return bool
     */
    public function getEsRenovacion()
    {
        return $this->EsRenovacion;
    }
    /**
     * Set EsRenovacion value
     * @param bool $esRenovacion
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setEsRenovacion($esRenovacion = null)
    {
        // validation for constraint: boolean
        if (!is_null($esRenovacion) && !is_bool($esRenovacion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esRenovacion, true), gettype($esRenovacion)), __LINE__);
        }
        $this->EsRenovacion = $esRenovacion;
        return $this;
    }
    /**
     * Get PorcPGP value
     * @return float
     */
    public function getPorcPGP()
    {
        return $this->PorcPGP;
    }
    /**
     * Set PorcPGP value
     * @param float $porcPGP
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPorcPGP($porcPGP = null)
    {
        // validation for constraint: float
        if (!is_null($porcPGP) && !(is_float($porcPGP) || is_numeric($porcPGP))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($porcPGP, true), gettype($porcPGP)), __LINE__);
        }
        $this->PorcPGP = $porcPGP;
        return $this;
    }
    /**
     * Get PorcRecargoFinanciero value
     * @return float
     */
    public function getPorcRecargoFinanciero()
    {
        return $this->PorcRecargoFinanciero;
    }
    /**
     * Set PorcRecargoFinanciero value
     * @param float $porcRecargoFinanciero
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPorcRecargoFinanciero($porcRecargoFinanciero = null)
    {
        // validation for constraint: float
        if (!is_null($porcRecargoFinanciero) && !(is_float($porcRecargoFinanciero) || is_numeric($porcRecargoFinanciero))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($porcRecargoFinanciero, true), gettype($porcRecargoFinanciero)), __LINE__);
        }
        $this->PorcRecargoFinanciero = $porcRecargoFinanciero;
        return $this;
    }
    /**
     * Get Comision value
     * @return float
     */
    public function getComision()
    {
        return $this->Comision;
    }
    /**
     * Set Comision value
     * @param float $comision
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setComision($comision = null)
    {
        // validation for constraint: float
        if (!is_null($comision) && !(is_float($comision) || is_numeric($comision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($comision, true), gettype($comision)), __LINE__);
        }
        $this->Comision = $comision;
        return $this;
    }
    /**
     * Get BonificacionComercial value
     * @return float
     */
    public function getBonificacionComercial()
    {
        return $this->BonificacionComercial;
    }
    /**
     * Set BonificacionComercial value
     * @param float $bonificacionComercial
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setBonificacionComercial($bonificacionComercial = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComercial) && !(is_float($bonificacionComercial) || is_numeric($bonificacionComercial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComercial, true), gettype($bonificacionComercial)), __LINE__);
        }
        $this->BonificacionComercial = $bonificacionComercial;
        return $this;
    }
    /**
     * Get BonificacionComision value
     * @return float
     */
    public function getBonificacionComision()
    {
        return $this->BonificacionComision;
    }
    /**
     * Set BonificacionComision value
     * @param float $bonificacionComision
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setBonificacionComision($bonificacionComision = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComision) && !(is_float($bonificacionComision) || is_numeric($bonificacionComision))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComision, true), gettype($bonificacionComision)), __LINE__);
        }
        $this->BonificacionComision = $bonificacionComision;
        return $this;
    }
    /**
     * Get BonificacionViacobro value
     * @return float
     */
    public function getBonificacionViacobro()
    {
        return $this->BonificacionViacobro;
    }
    /**
     * Set BonificacionViacobro value
     * @param float $bonificacionViacobro
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setBonificacionViacobro($bonificacionViacobro = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionViacobro) && !(is_float($bonificacionViacobro) || is_numeric($bonificacionViacobro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionViacobro, true), gettype($bonificacionViacobro)), __LINE__);
        }
        $this->BonificacionViacobro = $bonificacionViacobro;
        return $this;
    }
    /**
     * Get FechaVigenciaDesde value
     * @return string
     */
    public function getFechaVigenciaDesde()
    {
        return $this->FechaVigenciaDesde;
    }
    /**
     * Set FechaVigenciaDesde value
     * @param string $fechaVigenciaDesde
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setFechaVigenciaDesde($fechaVigenciaDesde = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaDesde) && !is_string($fechaVigenciaDesde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaDesde, true), gettype($fechaVigenciaDesde)), __LINE__);
        }
        $this->FechaVigenciaDesde = $fechaVigenciaDesde;
        return $this;
    }
    /**
     * Get FechaVigenciaHasta value
     * @return string
     */
    public function getFechaVigenciaHasta()
    {
        return $this->FechaVigenciaHasta;
    }
    /**
     * Set FechaVigenciaHasta value
     * @param string $fechaVigenciaHasta
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setFechaVigenciaHasta($fechaVigenciaHasta = null)
    {
        // validation for constraint: string
        if (!is_null($fechaVigenciaHasta) && !is_string($fechaVigenciaHasta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaVigenciaHasta, true), gettype($fechaVigenciaHasta)), __LINE__);
        }
        $this->FechaVigenciaHasta = $fechaVigenciaHasta;
        return $this;
    }
    /**
     * Get CantidadDias value
     * @return int
     */
    public function getCantidadDias()
    {
        return $this->CantidadDias;
    }
    /**
     * Set CantidadDias value
     * @param int $cantidadDias
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setCantidadDias($cantidadDias = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadDias) && !(is_int($cantidadDias) || ctype_digit($cantidadDias))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadDias, true), gettype($cantidadDias)), __LINE__);
        }
        $this->CantidadDias = $cantidadDias;
        return $this;
    }
    /**
     * Get CantidadCuotas value
     * @return int
     */
    public function getCantidadCuotas()
    {
        return $this->CantidadCuotas;
    }
    /**
     * Set CantidadCuotas value
     * @param int $cantidadCuotas
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setCantidadCuotas($cantidadCuotas = null)
    {
        // validation for constraint: int
        if (!is_null($cantidadCuotas) && !(is_int($cantidadCuotas) || ctype_digit($cantidadCuotas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantidadCuotas, true), gettype($cantidadCuotas)), __LINE__);
        }
        $this->CantidadCuotas = $cantidadCuotas;
        return $this;
    }
    /**
     * Get PorcDistribucionProductor value
     * @return float
     */
    public function getPorcDistribucionProductor()
    {
        return $this->PorcDistribucionProductor;
    }
    /**
     * Set PorcDistribucionProductor value
     * @param float $porcDistribucionProductor
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPorcDistribucionProductor($porcDistribucionProductor = null)
    {
        // validation for constraint: float
        if (!is_null($porcDistribucionProductor) && !(is_float($porcDistribucionProductor) || is_numeric($porcDistribucionProductor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($porcDistribucionProductor, true), gettype($porcDistribucionProductor)), __LINE__);
        }
        $this->PorcDistribucionProductor = $porcDistribucionProductor;
        return $this;
    }
    /**
     * Get PorcDistribucionOrganizador value
     * @return float
     */
    public function getPorcDistribucionOrganizador()
    {
        return $this->PorcDistribucionOrganizador;
    }
    /**
     * Set PorcDistribucionOrganizador value
     * @param float $porcDistribucionOrganizador
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPorcDistribucionOrganizador($porcDistribucionOrganizador = null)
    {
        // validation for constraint: float
        if (!is_null($porcDistribucionOrganizador) && !(is_float($porcDistribucionOrganizador) || is_numeric($porcDistribucionOrganizador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($porcDistribucionOrganizador, true), gettype($porcDistribucionOrganizador)), __LINE__);
        }
        $this->PorcDistribucionOrganizador = $porcDistribucionOrganizador;
        return $this;
    }
    /**
     * Get DistribucionComisionOrganizador value
     * @return float
     */
    public function getDistribucionComisionOrganizador()
    {
        return $this->DistribucionComisionOrganizador;
    }
    /**
     * Set DistribucionComisionOrganizador value
     * @param float $distribucionComisionOrganizador
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setDistribucionComisionOrganizador($distribucionComisionOrganizador = null)
    {
        // validation for constraint: float
        if (!is_null($distribucionComisionOrganizador) && !(is_float($distribucionComisionOrganizador) || is_numeric($distribucionComisionOrganizador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distribucionComisionOrganizador, true), gettype($distribucionComisionOrganizador)), __LINE__);
        }
        $this->DistribucionComisionOrganizador = $distribucionComisionOrganizador;
        return $this;
    }
    /**
     * Get DistribucionComisionProductor value
     * @return float
     */
    public function getDistribucionComisionProductor()
    {
        return $this->DistribucionComisionProductor;
    }
    /**
     * Set DistribucionComisionProductor value
     * @param float $distribucionComisionProductor
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setDistribucionComisionProductor($distribucionComisionProductor = null)
    {
        // validation for constraint: float
        if (!is_null($distribucionComisionProductor) && !(is_float($distribucionComisionProductor) || is_numeric($distribucionComisionProductor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($distribucionComisionProductor, true), gettype($distribucionComisionProductor)), __LINE__);
        }
        $this->DistribucionComisionProductor = $distribucionComisionProductor;
        return $this;
    }
    /**
     * Get EstadoID value
     * @return int
     */
    public function getEstadoID()
    {
        return $this->EstadoID;
    }
    /**
     * Set EstadoID value
     * @param int $estadoID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setEstadoID($estadoID = null)
    {
        // validation for constraint: int
        if (!is_null($estadoID) && !(is_int($estadoID) || ctype_digit($estadoID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($estadoID, true), gettype($estadoID)), __LINE__);
        }
        $this->EstadoID = $estadoID;
        return $this;
    }
    /**
     * Get FechaEstado value
     * @return string
     */
    public function getFechaEstado()
    {
        return $this->FechaEstado;
    }
    /**
     * Set FechaEstado value
     * @param string $fechaEstado
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setFechaEstado($fechaEstado = null)
    {
        // validation for constraint: string
        if (!is_null($fechaEstado) && !is_string($fechaEstado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fechaEstado, true), gettype($fechaEstado)), __LINE__);
        }
        $this->FechaEstado = $fechaEstado;
        return $this;
    }
    /**
     * Get Fecha value
     * @return string
     */
    public function getFecha()
    {
        return $this->Fecha;
    }
    /**
     * Set Fecha value
     * @param string $fecha
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setFecha($fecha = null)
    {
        // validation for constraint: string
        if (!is_null($fecha) && !is_string($fecha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fecha, true), gettype($fecha)), __LINE__);
        }
        $this->Fecha = $fecha;
        return $this;
    }
    /**
     * Get RequiereInspeccion value
     * @return bool
     */
    public function getRequiereInspeccion()
    {
        return $this->RequiereInspeccion;
    }
    /**
     * Set RequiereInspeccion value
     * @param bool $requiereInspeccion
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setRequiereInspeccion($requiereInspeccion = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiereInspeccion) && !is_bool($requiereInspeccion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiereInspeccion, true), gettype($requiereInspeccion)), __LINE__);
        }
        $this->RequiereInspeccion = $requiereInspeccion;
        return $this;
    }
    /**
     * Get GrupoTelemarketerID value
     * @return int
     */
    public function getGrupoTelemarketerID()
    {
        return $this->GrupoTelemarketerID;
    }
    /**
     * Set GrupoTelemarketerID value
     * @param int $grupoTelemarketerID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setGrupoTelemarketerID($grupoTelemarketerID = null)
    {
        // validation for constraint: int
        if (!is_null($grupoTelemarketerID) && !(is_int($grupoTelemarketerID) || ctype_digit($grupoTelemarketerID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($grupoTelemarketerID, true), gettype($grupoTelemarketerID)), __LINE__);
        }
        $this->GrupoTelemarketerID = $grupoTelemarketerID;
        return $this;
    }
    /**
     * Get AniosSinSiniestro value
     * @return int
     */
    public function getAniosSinSiniestro()
    {
        return $this->AniosSinSiniestro;
    }
    /**
     * Set AniosSinSiniestro value
     * @param int $aniosSinSiniestro
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setAniosSinSiniestro($aniosSinSiniestro = null)
    {
        // validation for constraint: int
        if (!is_null($aniosSinSiniestro) && !(is_int($aniosSinSiniestro) || ctype_digit($aniosSinSiniestro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aniosSinSiniestro, true), gettype($aniosSinSiniestro)), __LINE__);
        }
        $this->AniosSinSiniestro = $aniosSinSiniestro;
        return $this;
    }
    /**
     * Get TieneAgrupamiento value
     * @return bool
     */
    public function getTieneAgrupamiento()
    {
        return $this->TieneAgrupamiento;
    }
    /**
     * Set TieneAgrupamiento value
     * @param bool $tieneAgrupamiento
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setTieneAgrupamiento($tieneAgrupamiento = null)
    {
        // validation for constraint: boolean
        if (!is_null($tieneAgrupamiento) && !is_bool($tieneAgrupamiento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tieneAgrupamiento, true), gettype($tieneAgrupamiento)), __LINE__);
        }
        $this->TieneAgrupamiento = $tieneAgrupamiento;
        return $this;
    }
    /**
     * Get CUIT value
     * @return float
     */
    public function getCUIT()
    {
        return $this->CUIT;
    }
    /**
     * Set CUIT value
     * @param float $cUIT
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setCUIT($cUIT = null)
    {
        // validation for constraint: float
        if (!is_null($cUIT) && !(is_float($cUIT) || is_numeric($cUIT))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cUIT, true), gettype($cUIT)), __LINE__);
        }
        $this->CUIT = $cUIT;
        return $this;
    }
    /**
     * Get AjusteSuma value
     * @return int
     */
    public function getAjusteSuma()
    {
        return $this->AjusteSuma;
    }
    /**
     * Set AjusteSuma value
     * @param int $ajusteSuma
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setAjusteSuma($ajusteSuma = null)
    {
        // validation for constraint: int
        if (!is_null($ajusteSuma) && !(is_int($ajusteSuma) || ctype_digit($ajusteSuma))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ajusteSuma, true), gettype($ajusteSuma)), __LINE__);
        }
        $this->AjusteSuma = $ajusteSuma;
        return $this;
    }
    /**
     * Get EsEspecial value
     * @return bool
     */
    public function getEsEspecial()
    {
        return $this->EsEspecial;
    }
    /**
     * Set EsEspecial value
     * @param bool $esEspecial
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setEsEspecial($esEspecial = null)
    {
        // validation for constraint: boolean
        if (!is_null($esEspecial) && !is_bool($esEspecial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($esEspecial, true), gettype($esEspecial)), __LINE__);
        }
        $this->EsEspecial = $esEspecial;
        return $this;
    }
    /**
     * Get BonficacionComercialMaxima value
     * @return float
     */
    public function getBonficacionComercialMaxima()
    {
        return $this->BonficacionComercialMaxima;
    }
    /**
     * Set BonficacionComercialMaxima value
     * @param float $bonficacionComercialMaxima
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setBonficacionComercialMaxima($bonficacionComercialMaxima = null)
    {
        // validation for constraint: float
        if (!is_null($bonficacionComercialMaxima) && !(is_float($bonficacionComercialMaxima) || is_numeric($bonficacionComercialMaxima))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonficacionComercialMaxima, true), gettype($bonficacionComercialMaxima)), __LINE__);
        }
        $this->BonficacionComercialMaxima = $bonficacionComercialMaxima;
        return $this;
    }
    /**
     * Get BonificacionComercialAprob value
     * @return float
     */
    public function getBonificacionComercialAprob()
    {
        return $this->BonificacionComercialAprob;
    }
    /**
     * Set BonificacionComercialAprob value
     * @param float $bonificacionComercialAprob
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setBonificacionComercialAprob($bonificacionComercialAprob = null)
    {
        // validation for constraint: float
        if (!is_null($bonificacionComercialAprob) && !(is_float($bonificacionComercialAprob) || is_numeric($bonificacionComercialAprob))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($bonificacionComercialAprob, true), gettype($bonificacionComercialAprob)), __LINE__);
        }
        $this->BonificacionComercialAprob = $bonificacionComercialAprob;
        return $this;
    }
    /**
     * Get CompaniaID value
     * @return int
     */
    public function getCompaniaID()
    {
        return $this->CompaniaID;
    }
    /**
     * Set CompaniaID value
     * @param int $companiaID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setCompaniaID($companiaID = null)
    {
        // validation for constraint: int
        if (!is_null($companiaID) && !(is_int($companiaID) || ctype_digit($companiaID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($companiaID, true), gettype($companiaID)), __LINE__);
        }
        $this->CompaniaID = $companiaID;
        return $this;
    }
    /**
     * Get RecibePolizaElectronica value
     * @return bool
     */
    public function getRecibePolizaElectronica()
    {
        return $this->RecibePolizaElectronica;
    }
    /**
     * Set RecibePolizaElectronica value
     * @param bool $recibePolizaElectronica
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setRecibePolizaElectronica($recibePolizaElectronica = null)
    {
        // validation for constraint: boolean
        if (!is_null($recibePolizaElectronica) && !is_bool($recibePolizaElectronica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recibePolizaElectronica, true), gettype($recibePolizaElectronica)), __LINE__);
        }
        $this->RecibePolizaElectronica = $recibePolizaElectronica;
        return $this;
    }
    /**
     * Get RecibeDocumentacionElectronica value
     * @return bool
     */
    public function getRecibeDocumentacionElectronica()
    {
        return $this->RecibeDocumentacionElectronica;
    }
    /**
     * Set RecibeDocumentacionElectronica value
     * @param bool $recibeDocumentacionElectronica
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setRecibeDocumentacionElectronica($recibeDocumentacionElectronica = null)
    {
        // validation for constraint: boolean
        if (!is_null($recibeDocumentacionElectronica) && !is_bool($recibeDocumentacionElectronica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recibeDocumentacionElectronica, true), gettype($recibeDocumentacionElectronica)), __LINE__);
        }
        $this->RecibeDocumentacionElectronica = $recibeDocumentacionElectronica;
        return $this;
    }
    /**
     * Get Propuesta value
     * @return int
     */
    public function getPropuesta()
    {
        return $this->Propuesta;
    }
    /**
     * Set Propuesta value
     * @param int $propuesta
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPropuesta($propuesta = null)
    {
        // validation for constraint: int
        if (!is_null($propuesta) && !(is_int($propuesta) || ctype_digit($propuesta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($propuesta, true), gettype($propuesta)), __LINE__);
        }
        $this->Propuesta = $propuesta;
        return $this;
    }
    /**
     * Get Poliza value
     * @return int
     */
    public function getPoliza()
    {
        return $this->Poliza;
    }
    /**
     * Set Poliza value
     * @param int $poliza
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPoliza($poliza = null)
    {
        // validation for constraint: int
        if (!is_null($poliza) && !(is_int($poliza) || ctype_digit($poliza))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($poliza, true), gettype($poliza)), __LINE__);
        }
        $this->Poliza = $poliza;
        return $this;
    }
    /**
     * Get PolizaUnificada value
     * @return int
     */
    public function getPolizaUnificada()
    {
        return $this->PolizaUnificada;
    }
    /**
     * Set PolizaUnificada value
     * @param int $polizaUnificada
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPolizaUnificada($polizaUnificada = null)
    {
        // validation for constraint: int
        if (!is_null($polizaUnificada) && !(is_int($polizaUnificada) || ctype_digit($polizaUnificada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($polizaUnificada, true), gettype($polizaUnificada)), __LINE__);
        }
        $this->PolizaUnificada = $polizaUnificada;
        return $this;
    }
    /**
     * Get IDRiesgo value
     * @return string|null
     */
    public function getIDRiesgo()
    {
        return $this->IDRiesgo;
    }
    /**
     * Set IDRiesgo value
     * @param string $iDRiesgo
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDRiesgo($iDRiesgo = null)
    {
        // validation for constraint: string
        if (!is_null($iDRiesgo) && !is_string($iDRiesgo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDRiesgo, true), gettype($iDRiesgo)), __LINE__);
        }
        $this->IDRiesgo = $iDRiesgo;
        return $this;
    }
    /**
     * Get IDTipoPoliza value
     * @return string|null
     */
    public function getIDTipoPoliza()
    {
        return $this->IDTipoPoliza;
    }
    /**
     * Set IDTipoPoliza value
     * @param string $iDTipoPoliza
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDTipoPoliza($iDTipoPoliza = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPoliza) && !is_string($iDTipoPoliza)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPoliza, true), gettype($iDTipoPoliza)), __LINE__);
        }
        $this->IDTipoPoliza = $iDTipoPoliza;
        return $this;
    }
    /**
     * Get IDTipoPersona value
     * @return string|null
     */
    public function getIDTipoPersona()
    {
        return $this->IDTipoPersona;
    }
    /**
     * Set IDTipoPersona value
     * @param string $iDTipoPersona
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDTipoPersona($iDTipoPersona = null)
    {
        // validation for constraint: string
        if (!is_null($iDTipoPersona) && !is_string($iDTipoPersona)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDTipoPersona, true), gettype($iDTipoPersona)), __LINE__);
        }
        $this->IDTipoPersona = $iDTipoPersona;
        return $this;
    }
    /**
     * Get IDCondicionIVA value
     * @return string|null
     */
    public function getIDCondicionIVA()
    {
        return $this->IDCondicionIVA;
    }
    /**
     * Set IDCondicionIVA value
     * @param string $iDCondicionIVA
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDCondicionIVA($iDCondicionIVA = null)
    {
        // validation for constraint: string
        if (!is_null($iDCondicionIVA) && !is_string($iDCondicionIVA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDCondicionIVA, true), gettype($iDCondicionIVA)), __LINE__);
        }
        $this->IDCondicionIVA = $iDCondicionIVA;
        return $this;
    }
    /**
     * Get NroPolizaAnterior value
     * @return string|null
     */
    public function getNroPolizaAnterior()
    {
        return $this->NroPolizaAnterior;
    }
    /**
     * Set NroPolizaAnterior value
     * @param string $nroPolizaAnterior
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setNroPolizaAnterior($nroPolizaAnterior = null)
    {
        // validation for constraint: string
        if (!is_null($nroPolizaAnterior) && !is_string($nroPolizaAnterior)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nroPolizaAnterior, true), gettype($nroPolizaAnterior)), __LINE__);
        }
        $this->NroPolizaAnterior = $nroPolizaAnterior;
        return $this;
    }
    /**
     * Get IDPersonaAsegurado value
     * @return string|null
     */
    public function getIDPersonaAsegurado()
    {
        return $this->IDPersonaAsegurado;
    }
    /**
     * Set IDPersonaAsegurado value
     * @param string $iDPersonaAsegurado
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDPersonaAsegurado($iDPersonaAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaAsegurado) && !is_string($iDPersonaAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaAsegurado, true), gettype($iDPersonaAsegurado)), __LINE__);
        }
        $this->IDPersonaAsegurado = $iDPersonaAsegurado;
        return $this;
    }
    /**
     * Get IDPersonaTomador value
     * @return string|null
     */
    public function getIDPersonaTomador()
    {
        return $this->IDPersonaTomador;
    }
    /**
     * Set IDPersonaTomador value
     * @param string $iDPersonaTomador
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDPersonaTomador($iDPersonaTomador = null)
    {
        // validation for constraint: string
        if (!is_null($iDPersonaTomador) && !is_string($iDPersonaTomador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPersonaTomador, true), gettype($iDPersonaTomador)), __LINE__);
        }
        $this->IDPersonaTomador = $iDPersonaTomador;
        return $this;
    }
    /**
     * Get IDViaCobro value
     * @return string|null
     */
    public function getIDViaCobro()
    {
        return $this->IDViaCobro;
    }
    /**
     * Set IDViaCobro value
     * @param string $iDViaCobro
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDViaCobro($iDViaCobro = null)
    {
        // validation for constraint: string
        if (!is_null($iDViaCobro) && !is_string($iDViaCobro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDViaCobro, true), gettype($iDViaCobro)), __LINE__);
        }
        $this->IDViaCobro = $iDViaCobro;
        return $this;
    }
    /**
     * Get IDInstitucionFinanciera value
     * @return string|null
     */
    public function getIDInstitucionFinanciera()
    {
        return $this->IDInstitucionFinanciera;
    }
    /**
     * Set IDInstitucionFinanciera value
     * @param string $iDInstitucionFinanciera
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDInstitucionFinanciera($iDInstitucionFinanciera = null)
    {
        // validation for constraint: string
        if (!is_null($iDInstitucionFinanciera) && !is_string($iDInstitucionFinanciera)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDInstitucionFinanciera, true), gettype($iDInstitucionFinanciera)), __LINE__);
        }
        $this->IDInstitucionFinanciera = $iDInstitucionFinanciera;
        return $this;
    }
    /**
     * Get IDPlanPago value
     * @return string|null
     */
    public function getIDPlanPago()
    {
        return $this->IDPlanPago;
    }
    /**
     * Set IDPlanPago value
     * @param string $iDPlanPago
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDPlanPago($iDPlanPago = null)
    {
        // validation for constraint: string
        if (!is_null($iDPlanPago) && !is_string($iDPlanPago)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDPlanPago, true), gettype($iDPlanPago)), __LINE__);
        }
        $this->IDPlanPago = $iDPlanPago;
        return $this;
    }
    /**
     * Get IDMoneda value
     * @return string|null
     */
    public function getIDMoneda()
    {
        return $this->IDMoneda;
    }
    /**
     * Set IDMoneda value
     * @param string $iDMoneda
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDMoneda($iDMoneda = null)
    {
        // validation for constraint: string
        if (!is_null($iDMoneda) && !is_string($iDMoneda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDMoneda, true), gettype($iDMoneda)), __LINE__);
        }
        $this->IDMoneda = $iDMoneda;
        return $this;
    }
    /**
     * Get IDProducto value
     * @return string|null
     */
    public function getIDProducto()
    {
        return $this->IDProducto;
    }
    /**
     * Set IDProducto value
     * @param string $iDProducto
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDProducto($iDProducto = null)
    {
        // validation for constraint: string
        if (!is_null($iDProducto) && !is_string($iDProducto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProducto, true), gettype($iDProducto)), __LINE__);
        }
        $this->IDProducto = $iDProducto;
        return $this;
    }
    /**
     * Get IDSegmento value
     * @return string|null
     */
    public function getIDSegmento()
    {
        return $this->IDSegmento;
    }
    /**
     * Set IDSegmento value
     * @param string $iDSegmento
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDSegmento($iDSegmento = null)
    {
        // validation for constraint: string
        if (!is_null($iDSegmento) && !is_string($iDSegmento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDSegmento, true), gettype($iDSegmento)), __LINE__);
        }
        $this->IDSegmento = $iDSegmento;
        return $this;
    }
    /**
     * Get NumeroTarjeta value
     * @return string|null
     */
    public function getNumeroTarjeta()
    {
        return $this->NumeroTarjeta;
    }
    /**
     * Set NumeroTarjeta value
     * @param string $numeroTarjeta
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setNumeroTarjeta($numeroTarjeta = null)
    {
        // validation for constraint: string
        if (!is_null($numeroTarjeta) && !is_string($numeroTarjeta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroTarjeta, true), gettype($numeroTarjeta)), __LINE__);
        }
        $this->NumeroTarjeta = $numeroTarjeta;
        return $this;
    }
    /**
     * Get PrefijoPresupuesto value
     * @return string|null
     */
    public function getPrefijoPresupuesto()
    {
        return $this->PrefijoPresupuesto;
    }
    /**
     * Set PrefijoPresupuesto value
     * @param string $prefijoPresupuesto
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setPrefijoPresupuesto($prefijoPresupuesto = null)
    {
        // validation for constraint: string
        if (!is_null($prefijoPresupuesto) && !is_string($prefijoPresupuesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefijoPresupuesto, true), gettype($prefijoPresupuesto)), __LINE__);
        }
        $this->PrefijoPresupuesto = $prefijoPresupuesto;
        return $this;
    }
    /**
     * Get NumeroPresupuesto value
     * @return string|null
     */
    public function getNumeroPresupuesto()
    {
        return $this->NumeroPresupuesto;
    }
    /**
     * Set NumeroPresupuesto value
     * @param string $numeroPresupuesto
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setNumeroPresupuesto($numeroPresupuesto = null)
    {
        // validation for constraint: string
        if (!is_null($numeroPresupuesto) && !is_string($numeroPresupuesto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroPresupuesto, true), gettype($numeroPresupuesto)), __LINE__);
        }
        $this->NumeroPresupuesto = $numeroPresupuesto;
        return $this;
    }
    /**
     * Get NroPresupuestoAS value
     * @return string|null
     */
    public function getNroPresupuestoAS()
    {
        return $this->NroPresupuestoAS;
    }
    /**
     * Set NroPresupuestoAS value
     * @param string $nroPresupuestoAS
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setNroPresupuestoAS($nroPresupuestoAS = null)
    {
        // validation for constraint: string
        if (!is_null($nroPresupuestoAS) && !is_string($nroPresupuestoAS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nroPresupuestoAS, true), gettype($nroPresupuestoAS)), __LINE__);
        }
        $this->NroPresupuestoAS = $nroPresupuestoAS;
        return $this;
    }
    /**
     * Get NumeroPolizaAS value
     * @return string|null
     */
    public function getNumeroPolizaAS()
    {
        return $this->NumeroPolizaAS;
    }
    /**
     * Set NumeroPolizaAS value
     * @param string $numeroPolizaAS
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setNumeroPolizaAS($numeroPolizaAS = null)
    {
        // validation for constraint: string
        if (!is_null($numeroPolizaAS) && !is_string($numeroPolizaAS)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroPolizaAS, true), gettype($numeroPolizaAS)), __LINE__);
        }
        $this->NumeroPolizaAS = $numeroPolizaAS;
        return $this;
    }
    /**
     * Get IDUsuario value
     * @return string|null
     */
    public function getIDUsuario()
    {
        return $this->IDUsuario;
    }
    /**
     * Set IDUsuario value
     * @param string $iDUsuario
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDUsuario($iDUsuario = null)
    {
        // validation for constraint: string
        if (!is_null($iDUsuario) && !is_string($iDUsuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDUsuario, true), gettype($iDUsuario)), __LINE__);
        }
        $this->IDUsuario = $iDUsuario;
        return $this;
    }
    /**
     * Get IDProvincia value
     * @return string|null
     */
    public function getIDProvincia()
    {
        return $this->IDProvincia;
    }
    /**
     * Set IDProvincia value
     * @param string $iDProvincia
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDProvincia($iDProvincia = null)
    {
        // validation for constraint: string
        if (!is_null($iDProvincia) && !is_string($iDProvincia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iDProvincia, true), gettype($iDProvincia)), __LINE__);
        }
        $this->IDProvincia = $iDProvincia;
        return $this;
    }
    /**
     * Get TipoPlanID value
     * @return string|null
     */
    public function getTipoPlanID()
    {
        return $this->TipoPlanID;
    }
    /**
     * Set TipoPlanID value
     * @param string $tipoPlanID
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setTipoPlanID($tipoPlanID = null)
    {
        // validation for constraint: string
        if (!is_null($tipoPlanID) && !is_string($tipoPlanID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoPlanID, true), gettype($tipoPlanID)), __LINE__);
        }
        $this->TipoPlanID = $tipoPlanID;
        return $this;
    }
    /**
     * Get NombreAsegurado value
     * @return string|null
     */
    public function getNombreAsegurado()
    {
        return $this->NombreAsegurado;
    }
    /**
     * Set NombreAsegurado value
     * @param string $nombreAsegurado
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setNombreAsegurado($nombreAsegurado = null)
    {
        // validation for constraint: string
        if (!is_null($nombreAsegurado) && !is_string($nombreAsegurado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreAsegurado, true), gettype($nombreAsegurado)), __LINE__);
        }
        $this->NombreAsegurado = $nombreAsegurado;
        return $this;
    }
    /**
     * Get NombreTomador value
     * @return string|null
     */
    public function getNombreTomador()
    {
        return $this->NombreTomador;
    }
    /**
     * Set NombreTomador value
     * @param string $nombreTomador
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setNombreTomador($nombreTomador = null)
    {
        // validation for constraint: string
        if (!is_null($nombreTomador) && !is_string($nombreTomador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nombreTomador, true), gettype($nombreTomador)), __LINE__);
        }
        $this->NombreTomador = $nombreTomador;
        return $this;
    }
    /**
     * Get Mail value
     * @return string|null
     */
    public function getMail()
    {
        return $this->Mail;
    }
    /**
     * Set Mail value
     * @param string $mail
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setMail($mail = null)
    {
        // validation for constraint: string
        if (!is_null($mail) && !is_string($mail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mail, true), gettype($mail)), __LINE__);
        }
        $this->Mail = $mail;
        return $this;
    }
    /**
     * Get CantItem value
     * @return int|null
     */
    public function getCantItem()
    {
        return $this->CantItem;
    }
    /**
     * Set CantItem value
     * @param int $cantItem
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setCantItem($cantItem = 0)
    {
        // validation for constraint: int
        if (!is_null($cantItem) && !(is_int($cantItem) || ctype_digit($cantItem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cantItem, true), gettype($cantItem)), __LINE__);
        }
        $this->CantItem = $cantItem;
        return $this;
    }
    /**
     * Get IDBeneficio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIDBeneficio()
    {
        return isset($this->IDBeneficio) ? $this->IDBeneficio : null;
    }
    /**
     * Set IDBeneficio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $iDBeneficio
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setIDBeneficio($iDBeneficio = null)
    {
        // validation for constraint: int
        if (!is_null($iDBeneficio) && !(is_int($iDBeneficio) || ctype_digit($iDBeneficio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iDBeneficio, true), gettype($iDBeneficio)), __LINE__);
        }
        if (is_null($iDBeneficio) || (is_array($iDBeneficio) && empty($iDBeneficio))) {
            unset($this->IDBeneficio);
        } else {
            $this->IDBeneficio = $iDBeneficio;
        }
        return $this;
    }
    /**
     * Get Items value
     * @return \ArrayType\ArrayOfEmisionMotorsSalidaItem|null
     */
    public function getItems()
    {
        return $this->Items;
    }
    /**
     * Set Items value
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaItem $items
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setItems(\ArrayType\ArrayOfEmisionMotorsSalidaItem $items = null)
    {
        $this->Items = $items;
        return $this;
    }
    /**
     * Get OrdenCostos value
     * @return \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto|null
     */
    public function getOrdenCostos()
    {
        return $this->OrdenCostos;
    }
    /**
     * Set OrdenCostos value
     * @param \ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos
     * @return \StructType\EmisionMotorsSalidaOrden
     */
    public function setOrdenCostos(\ArrayType\ArrayOfEmisionMotorsSalidaOrdenCosto $ordenCostos = null)
    {
        $this->OrdenCostos = $ordenCostos;
        return $this;
    }
}
